/*
 * Decompiled with CFR 0.152.
 */
package kd.fi.v2.fah.formplugin.mapping;

import java.time.LocalDate;
import java.time.LocalDateTime;
import java.time.ZoneId;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Date;
import java.util.EventObject;
import java.util.HashMap;
import java.util.HashSet;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import kd.bos.bill.BillShowParameter;
import kd.bos.bill.OperationStatus;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.entity.DynamicObjectCollection;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.dataentity.serialization.SerializationUtils;
import kd.bos.db.DBRoute;
import kd.bos.db.tx.TX;
import kd.bos.db.tx.TXHandle;
import kd.bos.entity.EntryType;
import kd.bos.entity.MainEntityType;
import kd.bos.entity.datamodel.IDataModel;
import kd.bos.entity.datamodel.events.GetEntityTypeEventArgs;
import kd.bos.entity.datamodel.events.PropertyChangedArgs;
import kd.bos.exception.ErrorCode;
import kd.bos.exception.KDException;
import kd.bos.form.ConfirmCallBackListener;
import kd.bos.form.IFormView;
import kd.bos.form.MessageBoxOptions;
import kd.bos.form.MessageBoxResult;
import kd.bos.form.control.Control;
import kd.bos.form.control.EntryGrid;
import kd.bos.form.control.events.ClickListener;
import kd.bos.form.control.events.RowClickEventListener;
import kd.bos.form.events.AfterDoOperationEventArgs;
import kd.bos.form.events.BeforeDoOperationEventArgs;
import kd.bos.form.events.MessageBoxClosedEvent;
import kd.bos.form.events.OnGetControlArgs;
import kd.bos.form.field.BasedataEdit;
import kd.bos.form.field.events.BeforeF7SelectEvent;
import kd.bos.form.field.events.BeforeF7SelectListener;
import kd.bos.form.operate.AbstractOperate;
import kd.bos.form.plugin.AbstractFormPlugin;
import kd.bos.list.ListShowParameter;
import kd.bos.orm.query.QFilter;
import kd.bos.orm.sequence.SequenceReader;
import kd.bos.servicehelper.BusinessDataServiceHelper;
import kd.bos.servicehelper.QueryServiceHelper;
import kd.bos.servicehelper.operation.DeleteServiceHelper;
import kd.bos.servicehelper.operation.SaveServiceHelper;
import kd.bos.servicehelper.user.UserServiceHelper;
import kd.fi.v2.fah.constant.FahMappingConstant;
import kd.fi.v2.fah.constant.enums.DataValueTypeEnum;
import kd.fi.v2.fah.element.BaseDataElement;
import kd.fi.v2.fah.element.BooleanElement;
import kd.fi.v2.fah.element.DateElement;
import kd.fi.v2.fah.element.Element;
import kd.fi.v2.fah.element.EntryElement;
import kd.fi.v2.fah.element.TextElement;
import kd.fi.v2.fah.utils.FahMappingUtils;
import kd.fi.v2.fah.utils.LicenseUtil;
import kd.fi.v2.fah.utils.StringUtils;

public class FahDataValSetEdit
extends AbstractFormPlugin
implements BeforeF7SelectListener,
ClickListener,
RowClickEventListener {
    private static final String ISINIT = "is_Init";
    private static final String ENTRYENTITY = "entryentity";

    public void initialize() {
        List<Element> elementList;
        super.initialize();
        this.getView().addCustomControls(new String[]{ENTRYENTITY});
        if (!StringUtils.isEmpty((String)this.getPageCache().get(ISINIT))) {
            return;
        }
        this.getPageCache().put(ISINIT, "true");
        if (this.isEdit()) {
            Object id = !StringUtils.isEmpty((Object)((BillShowParameter)this.getView().getFormShowParameter()).getPkId()) ? ((BillShowParameter)this.getView().getFormShowParameter()).getPkId() : (Long)this.getModel().getValue("id");
            DynamicObject valset = BusinessDataServiceHelper.loadSingle((String)"fah_valueset_type", (String)"struc.entryentity", (QFilter[])new QFilter[]{new QFilter("id", "=", id)});
            DynamicObjectCollection fields = valset.getDynamicObjectCollection("struc.entryentity");
            elementList = this.getElementList(fields);
        } else {
            elementList = this.getElementList(null);
        }
        this.cacheEntryElement(elementList);
    }

    public void afterCreateNewData(EventObject e) {
        super.afterCreateNewData(e);
        this.build();
    }

    private boolean isEdit() {
        return OperationStatus.EDIT.equals((Object)this.getView().getFormShowParameter().getStatus());
    }

    public void afterBindData(EventObject e) {
        super.afterBindData(e);
        this.build();
        if (this.isEdit()) {
            DynamicObject[] valueSets;
            if (this.getModel().getValue("struc") != null) {
                this.getView().setEnable(Boolean.valueOf(false), new String[]{"struc"});
            }
            if (!StringUtils.isEmpty((String)this.getPageCache().get("tableCloumns"))) {
                LinkedList tableCloumns = (LinkedList)SerializationUtils.deSerializeFromBase64((String)this.getPageCache().get("tableCloumns"));
                valueSets = BusinessDataServiceHelper.load((String)"fah_flex_valueset", (String)("number,name,description,dseq,enable,effectdate,expiredate," + String.join((CharSequence)",", tableCloumns)), (QFilter[])new QFilter[]{new QFilter("valuesettypeid", "=", this.getModel().getValue("id"))}, (String)"dseq");
            } else {
                valueSets = BusinessDataServiceHelper.load((String)"fah_flex_valueset", (String)"number,name,description,dseq,effectdate,expiredate,enable", (QFilter[])new QFilter[]{new QFilter("valuesettypeid", "=", this.getModel().getValue("id"))}, (String)"dseq");
            }
            if (valueSets.length == 0) {
                return;
            }
            LinkedList<Integer> seqList = new LinkedList<Integer>();
            this.getModel().batchCreateNewEntryRow(ENTRYENTITY, valueSets.length);
            int i = 0;
            List fieldNumberList = this.getPageCache().get("fieldNumberList") == null ? Collections.emptyList() : (List)SerializationUtils.deSerializeFromBase64((String)this.getPageCache().get("fieldNumberList"));
            HashMap flexFieldNumMap = this.getPageCache().get("flexFieldNumMap") == null ? new HashMap() : (HashMap)SerializationUtils.deSerializeFromBase64((String)this.getPageCache().get("flexFieldNumMap"));
            HashMap fahValueSetMap = new HashMap();
            HashMap<Long, HashMap> fahValueSetNumberToId = new HashMap<Long, HashMap>();
            if (!StringUtils.isEmpty((String)this.getPageCache().get("fahValueSetMap"))) {
                fahValueSetMap = (HashMap)SerializationUtils.deSerializeFromBase64((String)this.getPageCache().get("fahValueSetMap"));
                for (DynamicObject dynamicObject : valueSets) {
                    for (Map.Entry entry : fahValueSetMap.entrySet()) {
                        fahValueSetNumberToId.computeIfAbsent((Long)entry.getValue(), v -> new HashMap()).put(dynamicObject.getString((String)flexFieldNumMap.get(entry.getKey())), 0L);
                    }
                }
                QFilter qFilter = new QFilter("id", "!=", null);
                boolean isFirst = true;
                for (Map.Entry entry : fahValueSetNumberToId.entrySet()) {
                    QFilter qFilterEntry = new QFilter("valuesettypeid", "=", entry.getKey()).and(new QFilter("number", "in", ((HashMap)entry.getValue()).keySet()));
                    if (isFirst) {
                        qFilter.and(qFilterEntry);
                    } else {
                        qFilter.or(qFilterEntry);
                    }
                    isFirst = false;
                }
                DynamicObjectCollection fahValueSets = QueryServiceHelper.query((String)"fah_flex_valueset", (String)"valuesettypeid,id,number", (QFilter[])new QFilter[]{qFilter});
                for (DynamicObject fahValueSet : fahValueSets) {
                    fahValueSetNumberToId.computeIfAbsent(fahValueSet.getLong("valuesettypeid"), v -> new HashMap()).put(fahValueSet.getString("number"), fahValueSet.getLong("id"));
                }
            }
            for (DynamicObject dynamicObject : valueSets) {
                this.getModel().setValue("number_en", dynamicObject.get("number"), i);
                this.getView().setEnable(Boolean.valueOf(false), i, new String[]{"number_en"});
                this.getModel().setValue("name_en", dynamicObject.get("name"), i);
                this.getModel().setValue("description_en", dynamicObject.get("description"), i);
                this.getModel().setValue("enable_en", dynamicObject.get("enable"), i);
                this.getModel().setValue("effectdate", (Object)FahMappingUtils.dateIsEquals((Date)dynamicObject.getDate("effectdate"), (boolean)true), i);
                this.getModel().setValue("expiredate", (Object)FahMappingUtils.dateIsEquals((Date)dynamicObject.getDate("expiredate"), (boolean)false), i);
                for (String fieldNumber : fieldNumberList) {
                    String value = dynamicObject.getString((String)flexFieldNumMap.get(fieldNumber));
                    if (fieldNumber.startsWith("valueset")) {
                        this.getModel().setValue(fieldNumber, ((HashMap)fahValueSetNumberToId.get(fahValueSetMap.get(fieldNumber))).get(value), i);
                        continue;
                    }
                    this.getModel().setValue(fieldNumber, (Object)value, i);
                }
                seqList.add(i);
                ++i;
            }
            this.getPageCache().put("seqList", SerializationUtils.serializeToBase64(seqList));
            this.getView().updateView(ENTRYENTITY);
            this.getModel().setDataChanged(false);
        }
    }

    public void getEntityType(GetEntityTypeEventArgs e) {
        MainEntityType newMainType;
        MainEntityType oldMainType = e.getOriginalEntityType();
        try {
            newMainType = (MainEntityType)oldMainType.clone();
        }
        catch (CloneNotSupportedException var5) {
            throw new KDException((Throwable)var5, new ErrorCode("LoadCustomControlMetasSample", var5.getMessage()), new Object[0]);
        }
        EntryType entryType = (EntryType)newMainType.getAllEntities().get(ENTRYENTITY);
        this.getEntryElement().registerEntryProp(entryType);
        e.setNewEntityType(newMainType);
    }

    public void confirmCallBack(MessageBoxClosedEvent evt) {
        super.confirmCallBack(evt);
        if ("restoreentry".equals(evt.getCallBackId()) && !StringUtils.isEmpty((String)this.getPageCache().get("entryList")) && evt.getResult() == MessageBoxResult.No) {
            LinkedList entryList = (LinkedList)SerializationUtils.deSerializeFromBase64((String)this.getPageCache().get("entryList"));
            IDataModel model = this.getModel();
            int i = 0;
            for (HashMap entry : entryList) {
                model.createNewEntryRow(ENTRYENTITY);
                model.setValue("number_en", entry.get("number_en"), i);
                model.setValue("name_en", entry.get("name_en"), i);
                model.setValue("description_en", entry.get("description_en"), i);
                model.setValue("effectdate", entry.get("effectdate"), i);
                model.setValue("expiredate", entry.get("expiredate"), i);
                model.setValue("enable_en", entry.get("enable_en"), i);
                ++i;
            }
        }
    }

    public void onGetControl(OnGetControlArgs e) {
        EntryElement entryElement = this.getEntryElement();
        ArrayList<EntryElement> items = new ArrayList<EntryElement>(entryElement.getItems());
        items.add(entryElement);
        Optional<Element> first = items.stream().filter(x -> x.getName().equals(e.getKey())).findFirst();
        if (first.isPresent()) {
            Element element = first.get();
            Control control = element.getControl(this.getView());
            e.setControl(control);
        }
    }

    public void propertyChanged(PropertyChangedArgs e) {
        super.propertyChanged(e);
        String propertyName = e.getProperty().getName();
        Object newValue = e.getChangeSet()[0].getNewValue();
        Object oldValue = e.getChangeSet()[0].getOldValue();
        if ("struc".equals(propertyName) && newValue != oldValue) {
            List<Element> elementList;
            LinkedList entryList = new LinkedList();
            for (DynamicObject entry : this.getModel().getEntryEntity(ENTRYENTITY)) {
                HashMap<String, Object> row = new HashMap<String, Object>();
                row.put("number_en", entry.getString("number_en"));
                row.put("name_en", entry.getString("name_en"));
                row.put("description_en", entry.getString("description_en"));
                row.put("effectdate", entry.getDate("effectdate"));
                row.put("expiredate", entry.getDate("expiredate"));
                row.put("enable_en", entry.getBoolean("enable_en"));
                entryList.add(row);
            }
            if (entryList.size() > 0) {
                this.getPageCache().put("entryList", SerializationUtils.serializeToBase64(entryList));
            } else {
                this.getPageCache().put("entryList", null);
            }
            this.clearEntryData();
            if (newValue == null) {
                elementList = this.getElementList(null);
            } else {
                this.getView().addCustomControls(new String[]{ENTRYENTITY});
                DynamicObjectCollection fields = ((DynamicObject)newValue).getDynamicObjectCollection(ENTRYENTITY);
                elementList = this.getElementList(fields);
            }
            this.cacheEntryElement(elementList);
            this.build();
            if (entryList.size() > 0) {
                this.getView().showConfirm(ResManager.loadKDString((String)"\u5df2\u5207\u6362\u503c\u96c6\u5f39\u6027\u57df\u5b57\u6bb5\uff0c\u662f\u5426\u9700\u8981\u6e05\u7a7a\u5df2\u7ef4\u62a4\u597d\u7684\u503c\u7f16\u7801\u3001\u503c\u540d\u79f0\u7b49\u4fe1\u606f\uff1f", (String)"FahDataValSetEdit_0", (String)"fi-ai-formplugin", (Object[])new Object[0]), MessageBoxOptions.YesNo, new ConfirmCallBackListener("restoreentry"));
            }
        }
    }

    public void registerListener(EventObject e) {
        super.registerListener(e);
        if (!StringUtils.isEmpty((String)this.getPageCache().get("fahValueSetMap"))) {
            BasedataEdit basedataEdit;
            HashMap fahValueSetMap = (HashMap)SerializationUtils.deSerializeFromBase64((String)this.getPageCache().get("fahValueSetMap"));
            String selKey = ((EntryGrid)this.getView().getControl(ENTRYENTITY)).getEntryState().getFocusField();
            if (!StringUtils.isEmpty((String)selKey) && fahValueSetMap.get(selKey) != null && (basedataEdit = (BasedataEdit)this.getView().getControl(selKey)) != null) {
                basedataEdit.addBeforeF7SelectListener((BeforeF7SelectListener)this);
            }
        }
        ((BasedataEdit)this.getView().getControl("struc")).addBeforeF7SelectListener((BeforeF7SelectListener)this);
    }

    private List<Element> getElementList(DynamicObjectCollection collection) {
        ArrayList<Element> result = new ArrayList<Element>();
        result.add((Element)new TextElement("number_en", ResManager.loadKDString((String)"\u503c\u7f16\u7801", (String)"FahDataValSetEdit_1", (String)"fi-ai-formplugin", (Object[])new Object[0]), ENTRYENTITY, true, 150));
        result.add((Element)new TextElement("name_en", ResManager.loadKDString((String)"\u503c\u540d\u79f0", (String)"FahDataValSetEdit_2", (String)"fi-ai-formplugin", (Object[])new Object[0]), ENTRYENTITY, true, 150));
        if (collection == null) {
            result.add((Element)new TextElement("description_en", ResManager.loadKDString((String)"\u63cf\u8ff0", (String)"FahDataValSetEdit_3", (String)"fi-ai-formplugin", (Object[])new Object[0]), ENTRYENTITY));
            result.add((Element)new DateElement("effectdate", ResManager.loadKDString((String)"\u5f00\u59cb\u65e5\u671f", (String)"FahDataValSetEdit_4", (String)"fi-ai-formplugin", (Object[])new Object[0]), ENTRYENTITY));
            result.add((Element)new DateElement("expiredate", ResManager.loadKDString((String)"\u7ed3\u675f\u65e5\u671f", (String)"FahDataValSetEdit_5", (String)"fi-ai-formplugin", (Object[])new Object[0]), ENTRYENTITY));
            result.add((Element)new BooleanElement("enable_en", ResManager.loadKDString((String)"\u542f\u7528", (String)"FahDataValSetEdit_6", (String)"fi-ai-formplugin", (Object[])new Object[0]), ENTRYENTITY));
            return result;
        }
        LinkedList<String> fieldNumberList = new LinkedList<String>();
        HashMap assistMap = new HashMap(4);
        HashMap<String, Long> fahValueSetMap = new HashMap<String, Long>(4);
        LinkedList<String> tableCloumns = new LinkedList<String>();
        HashMap<String, String> flexFieldNumMap = new HashMap<String, String>();
        int seq = 1;
        for (DynamicObject field : collection) {
            String fieldName = field.getString("attname");
            Long refTypeId = field.getLong("reftypeid");
            String flexFieldNum = field.getString("flexfieldnum");
            DataValueTypeEnum type = DataValueTypeEnum.getEnum((String)field.getString("attdatatype"));
            switch (type) {
                case String: {
                    String metaFieldNumber = "string_" + seq;
                    result.add((Element)new TextElement(metaFieldNumber, fieldName, ENTRYENTITY));
                    fieldNumberList.add(metaFieldNumber);
                    flexFieldNumMap.put(metaFieldNumber, flexFieldNum);
                    break;
                }
                case FahValueSet: {
                    String metaFieldNumber = "valueset_" + seq;
                    result.add((Element)new BaseDataElement(metaFieldNumber, fieldName, "fah_flex_valueset", ENTRYENTITY));
                    fieldNumberList.add(metaFieldNumber);
                    fahValueSetMap.put(metaFieldNumber, refTypeId);
                    flexFieldNumMap.put(metaFieldNumber, flexFieldNum);
                }
            }
            tableCloumns.add(flexFieldNum);
            ++seq;
        }
        result.add((Element)new TextElement("description_en", ResManager.loadKDString((String)"\u63cf\u8ff0", (String)"FahDataValSetEdit_3", (String)"fi-ai-formplugin", (Object[])new Object[0]), ENTRYENTITY));
        result.add((Element)new DateElement("effectdate", ResManager.loadKDString((String)"\u5f00\u59cb\u65e5\u671f", (String)"FahDataValSetEdit_4", (String)"fi-ai-formplugin", (Object[])new Object[0]), ENTRYENTITY));
        result.add((Element)new DateElement("expiredate", ResManager.loadKDString((String)"\u7ed3\u675f\u65e5\u671f", (String)"FahDataValSetEdit_5", (String)"fi-ai-formplugin", (Object[])new Object[0]), ENTRYENTITY));
        result.add((Element)new BooleanElement("enable_en", ResManager.loadKDString((String)"\u542f\u7528", (String)"FahDataValSetEdit_6", (String)"fi-ai-formplugin", (Object[])new Object[0]), ENTRYENTITY));
        this.getPageCache().put("tableCloumns", SerializationUtils.serializeToBase64(tableCloumns));
        this.getPageCache().put("fieldNumberList", SerializationUtils.serializeToBase64(fieldNumberList));
        this.getPageCache().put("assistMap", SerializationUtils.serializeToBase64(assistMap));
        this.getPageCache().put("fahValueSetMap", SerializationUtils.serializeToBase64(fahValueSetMap));
        this.getPageCache().put("flexFieldNumMap", SerializationUtils.serializeToBase64(flexFieldNumMap));
        return result;
    }

    private EntryElement cacheEntryElement(List<Element> elementList) {
        EntryElement entryElement = new EntryElement(ENTRYENTITY, true);
        entryElement.setItems(elementList);
        this.putCache("entryentity_element", SerializationUtils.serializeToBase64((Object)entryElement));
        return entryElement;
    }

    public void build() {
        this.getEntryElement().build(this.getView());
    }

    private EntryElement getEntryElement() {
        String elements = this.getCache("entryentity_element");
        if (elements == null) {
            ArrayList<Element> elementList = new ArrayList<Element>();
            return this.cacheEntryElement(elementList);
        }
        return (EntryElement)SerializationUtils.deSerializeFromBase64((String)elements);
    }

    private void putCache(String key, String value) {
        this.getPageCache().put(key, value);
    }

    private String getCache(String key) {
        return this.getPageCache().get(key);
    }

    private void clearEntryData() {
        IDataModel model = this.getModel();
        DynamicObjectCollection entryEntity = model.getEntryEntity(ENTRYENTITY);
        int rowCount = entryEntity.getRowCount();
        int[] rows = new int[rowCount];
        model.deleteEntryRows(ENTRYENTITY, rows);
    }

    public void beforeF7Select(BeforeF7SelectEvent evt) {
        String fieldKey = evt.getProperty().getName();
        if ("struc".equals(fieldKey)) {
            ListShowParameter list = (ListShowParameter)evt.getFormShowParameter();
            List qFilters = list.getListFilterParameter().getQFilters();
            DynamicObjectCollection dynamicObjects = QueryServiceHelper.query((String)"fah_valueset_type", (String)"struc", (QFilter[])new QFilter[]{new QFilter("id", "!=", null)});
            HashSet idSet = new HashSet();
            dynamicObjects.stream().forEach(v -> idSet.add(v.getLong("struc")));
            QFilter qFilter = new QFilter("id", "not in", idSet);
            qFilters.add(qFilter);
        } else {
            HashMap fahValueSetMap = (HashMap)SerializationUtils.deSerializeFromBase64((String)this.getPageCache().get("fahValueSetMap"));
            if (fahValueSetMap.get(fieldKey) != null) {
                ListShowParameter list = (ListShowParameter)evt.getFormShowParameter();
                List qFilters = list.getListFilterParameter().getQFilters();
                QFilter qFilter = new QFilter("valuesettypeid.id", "=", fahValueSetMap.get(fieldKey));
                qFilter.and(new QFilter("enable", "=", (Object)"1"));
                LocalDateTime now = LocalDate.now().atTime(0, 0, 0, 0);
                Date currentDate = Date.from(now.atZone(ZoneId.systemDefault()).toInstant());
                QFilter effectDateFilter = new QFilter("effectdate", "is null", null).or(new QFilter("effectdate", "<=", (Object)currentDate));
                QFilter expireDateFilter = new QFilter("expiredate", "is null", null).or(new QFilter("expiredate", ">=", (Object)currentDate));
                qFilters.add(qFilter.and(effectDateFilter.and(expireDateFilter)));
            }
        }
    }

    public void beforeDoOperation(BeforeDoOperationEventArgs args) {
        super.beforeDoOperation(args);
        String key = ((AbstractOperate)args.getSource()).getOperateKey();
        if ("savedonothing".equals(key)) {
            LicenseUtil.checkFahLicenseWithTips((IFormView)this.getView());
            if (FahMappingUtils.isNumberRepeat((String)"fah_valueset_type", (String)((String)this.getModel().getValue("number")), (Object)this.getModel().getValue("id"))) {
                this.getView().showTipNotification(ResManager.loadKDString((String)"\u7f16\u7801\u5df2\u5b58\u5728\uff0c\u8bf7\u91cd\u65b0\u8f93\u5165\u3002", (String)"FahDataValSetEdit_7", (String)"fi-ai-formplugin", (Object[])new Object[0]));
                args.setCancel(true);
                return;
            }
        } else if ("deleteentry".equals(key) && this.isEdit()) {
            EntryGrid entryGrid = (EntryGrid)this.getView().getControl(ENTRYENTITY);
            int[] selectRows = entryGrid.getSelectRows();
            if (!StringUtils.isEmpty((String)this.getPageCache().get("seqList"))) {
                LinkedList seqList = (LinkedList)SerializationUtils.deSerializeFromBase64((String)this.getPageCache().get("seqList"));
                LinkedList<String> messageSeq = new LinkedList<String>();
                LinkedList<Integer> needDeleteRows = new LinkedList<Integer>();
                int[] nArray = selectRows;
                int n = nArray.length;
                for (int i = 0; i < n; ++i) {
                    Integer seq = nArray[i];
                    if (seqList.contains(seq)) {
                        messageSeq.add(String.valueOf(seq + 1));
                        continue;
                    }
                    needDeleteRows.add(seq);
                }
                if (!messageSeq.isEmpty()) {
                    this.getView().showTipNotification(String.format(ResManager.loadKDString((String)"\u7b2c\u201c%1$s\u201d\u884c\u5df2\u4fdd\u5b58\uff0c\u4e0d\u80fd\u5220\u9664\u3002", (String)"FahDataValSetEdit_8", (String)"fi-ai-formplugin", (Object[])new Object[0]), String.join((CharSequence)",", messageSeq)));
                    int[] rows = new int[needDeleteRows.size()];
                    for (int i = 0; i < needDeleteRows.size(); ++i) {
                        rows[i] = (Integer)needDeleteRows.get(i);
                    }
                    this.getModel().deleteEntryRows(ENTRYENTITY, rows);
                    args.setCancel(true);
                }
            }
        }
    }

    public void afterDoOperation(AfterDoOperationEventArgs args) {
        super.afterDoOperation(args);
        if ("savedonothing".equals(args.getOperateKey()) && args.getOperationResult().isSuccess()) {
            Long id;
            try (TXHandle handle = TX.requiresNew((String)"FahDataValSetEdit.save");){
                try {
                    id = this.save();
                }
                catch (Exception e) {
                    handle.markRollback();
                    throw e;
                }
            }
            if (id != null && id != 0L) {
                DynamicObjectCollection entrys;
                this.getModel().setDataChanged(false);
                this.getModel().setValue("id", (Object)id);
                this.getView().getFormShowParameter().setStatus(OperationStatus.EDIT);
                this.getView().cacheFormShowParameter();
                if (this.getModel().getValue("struc") != null) {
                    this.getView().setEnable(Boolean.valueOf(false), new String[]{"struc"});
                }
                if (!(entrys = this.getModel().getEntryEntity(ENTRYENTITY)).isEmpty()) {
                    LinkedList<Integer> seqList = new LinkedList<Integer>();
                    int size = entrys.size();
                    for (int i = 0; i < size; ++i) {
                        this.getView().setEnable(Boolean.valueOf(false), i, new String[]{"number_en"});
                        seqList.add(i);
                    }
                    this.getPageCache().put("seqList", SerializationUtils.serializeToBase64(seqList));
                }
            }
        }
    }

    private Long save() {
        DynamicObject head;
        Long parentId;
        if (this.isEdit()) {
            DeleteServiceHelper.delete((String)"fah_flex_valueset", (QFilter[])new QFilter[]{new QFilter("valuesettypeid", "=", this.getModel().getValue("id"))});
        }
        Date now = new Date();
        if (this.isEdit()) {
            parentId = (Long)this.getModel().getValue("id");
            head = BusinessDataServiceHelper.loadSingle((Object)parentId, (String)"fah_valueset_type");
        } else {
            head = BusinessDataServiceHelper.newDynamicObject((String)"fah_valueset_type");
            SequenceReader sReader = new SequenceReader(new DBRoute("ai"));
            Long[] sequences = (Long[])sReader.getSequences((Object[])new Long[1], "fah_valueset_type", 1);
            parentId = sequences[0];
            head.set("id", (Object)parentId);
            head.set("creator", (Object)UserServiceHelper.getCurrentUserId());
            head.set("createtime", (Object)now);
        }
        head.set("name", this.getModel().getValue("name"));
        head.set("number", this.getModel().getValue("number"));
        head.set("description", this.getModel().getValue("description"));
        head.set("modifier", (Object)UserServiceHelper.getCurrentUserId());
        head.set("modifytime", (Object)now);
        head.set("struc", this.getModel().getValue("struc"));
        head.set("enable", this.getModel().getValue("enable"));
        SaveServiceHelper.save((DynamicObject[])new DynamicObject[]{head});
        LinkedList<DynamicObject> valueSetList = new LinkedList<DynamicObject>();
        DynamicObjectCollection rows = (DynamicObjectCollection)this.getModel().getValue(ENTRYENTITY);
        List fieldNumberList = this.getPageCache().get("fieldNumberList") == null ? Collections.emptyList() : (List)SerializationUtils.deSerializeFromBase64((String)this.getPageCache().get("fieldNumberList"));
        HashMap flexFieldNumMap = this.getPageCache().get("flexFieldNumMap") == null ? new HashMap() : (HashMap)SerializationUtils.deSerializeFromBase64((String)this.getPageCache().get("flexFieldNumMap"));
        for (DynamicObject row : rows) {
            DynamicObject entry = BusinessDataServiceHelper.newDynamicObject((String)"fah_flex_valueset");
            entry.set("number", (Object)row.getString("number_en"));
            entry.set("name", (Object)row.getString("name_en"));
            entry.set("description", (Object)row.getString("description_en"));
            entry.set("enable", (Object)row.getString("enable_en"));
            entry.set("dseq", (Object)(row.getInt("seq") - 1));
            entry.set("valuesettypeid", (Object)parentId);
            Date effectDate = row.getDate("effectDate") == null ? FahMappingConstant.effectDate : row.getDate("effectDate");
            Date expireDate = row.getDate("expireDate") == null ? FahMappingConstant.expireDate : row.getDate("expireDate");
            entry.set("effectdate", (Object)effectDate);
            entry.set("expiredate", (Object)expireDate);
            if (this.getModel().getValue("struc") != null) {
                for (String fieldNumber : fieldNumberList) {
                    Object value = row.get(fieldNumber);
                    if (value instanceof String) {
                        entry.set((String)flexFieldNumMap.get(fieldNumber), (Object)row.getString(fieldNumber));
                        continue;
                    }
                    if (!(value instanceof DynamicObject)) continue;
                    entry.set((String)flexFieldNumMap.get(fieldNumber), (Object)row.getDynamicObject(fieldNumber).getString("number"));
                }
            }
            valueSetList.add(entry);
        }
        SaveServiceHelper.save((DynamicObject[])valueSetList.toArray(new DynamicObject[0]));
        return parentId;
    }
}

