/*
 * Decompiled with CFR 0.152.
 */
package kd.fi.v2.fah.formplugin.mapping;

import java.io.InputStream;
import java.util.ArrayList;
import java.util.EventObject;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.entity.EntityMetadataCache;
import kd.bos.entity.datamodel.ListSelectedRow;
import kd.bos.entity.datamodel.ListSelectedRowCollection;
import kd.bos.exception.KDBizException;
import kd.bos.fileservice.FileService;
import kd.bos.fileservice.FileServiceFactory;
import kd.bos.form.FormShowParameter;
import kd.bos.form.IFormView;
import kd.bos.form.ShowType;
import kd.bos.form.control.Toolbar;
import kd.bos.form.control.events.ItemClickEvent;
import kd.bos.form.control.events.UploadEvent;
import kd.bos.form.control.events.UploadListener;
import kd.bos.form.events.BeforeDoOperationEventArgs;
import kd.bos.form.operate.AbstractOperate;
import kd.bos.list.BillList;
import kd.bos.list.ListShowParameter;
import kd.bos.list.plugin.AbstractTreeListPlugin;
import kd.bos.mvc.list.ListView;
import kd.bos.permission.api.HasPermOrgResult;
import kd.bos.servicehelper.permission.PermissionServiceHelper;
import kd.fi.ai.util.ContextUtil;
import kd.fi.v2.fah.constant.enums.ImportLogStatusEnum;
import kd.fi.v2.fah.dao.FahImportLogDao;
import kd.fi.v2.fah.util.FahFlexExportUtil;
import kd.fi.v2.fah.util.FahUploadDataValUtil;
import kd.fi.v2.fah.utils.LicenseUtil;
import org.apache.poi.hssf.usermodel.HSSFWorkbook;
import org.apache.poi.ss.usermodel.Workbook;
import org.apache.poi.xssf.usermodel.XSSFWorkbook;

public class FahDataValSetList
extends AbstractTreeListPlugin
implements UploadListener {
    private static final String DOWNLOAD_TEMPLATE = "downloadtemplate";
    private static final String EXPORT = "export";
    private static final String BTN_VIEW_IMPORTLOG = "btnviewimportlog";

    public void afterCreateNewData(EventObject e) {
        super.afterCreateNewData(e);
        LicenseUtil.checkFahLicenseWithTips((IFormView)this.getView());
    }

    public void registerListener(EventObject e) {
        super.registerListener(e);
        Toolbar toolbarAp = (Toolbar)this.getControl("toolbarap");
        toolbarAp.addUploadListener((UploadListener)this);
    }

    public void upload(UploadEvent evt) {
        HasPermOrgResult result = PermissionServiceHelper.getAllPermOrgs((Long)ContextUtil.getUserId(), (String)"2FMS=8GUFGGN", (String)"fah_valueset_type", (String)"4730fc9f000003ae");
        if (null == result || !result.hasAllOrgPerm() && result.getHasPermOrgs().isEmpty()) {
            String billName = EntityMetadataCache.getDataEntityType((String)"fah_valueset_type").getDisplayName().toString();
            String msg = String.format(ResManager.loadKDString((String)"\u65e0\u201c%1$s\u201d\u7684\u201c\u5bfc\u5165\u201d\u6743\u9650\uff0c\u8bf7\u8054\u7cfb\u7ba1\u7406\u5458\u3002", (String)"FahDataValSetList_0", (String)"fi-ai-formplugin", (Object[])new Object[0]), billName);
            this.getView().showErrorNotification(msg);
            evt.setCancel(true);
            return;
        }
        Object[] urls = evt.getUrls();
        if (urls.length > 0) {
            String url = (String)urls[0];
            FileService service = FileServiceFactory.getAttachmentFileService();
            HSSFWorkbook wb = null;
            try {
                InputStream is = service.getInputStream(url);
                String extStr = url.substring(url.lastIndexOf("."));
                if (".xls".equals(extStr)) {
                    wb = new HSSFWorkbook(is);
                } else if (".xlsx".equals(extStr)) {
                    wb = new XSSFWorkbook(is);
                }
            }
            catch (Exception e) {
                throw new KDBizException(String.format(ResManager.loadKDString((String)"\u6570\u636e\u503c\u96c6\u5bfc\u5165Excel\u6570\u636e\u5931\u8d25 \uff1a%s", (String)"FahDataValSetList_1", (String)"fi-ai-formplugin", (Object[])new Object[0]), e.getMessage()));
            }
            if (wb == null) {
                throw new KDBizException(ResManager.loadKDString((String)"\u6587\u4ef6\u683c\u5f0f\u9519\u8bef\uff0c\u5fc5\u987b\u4e3axls\u6216xlsx\u6587\u4ef6\u3002", (String)"FahDataValSetList_2", (String)"fi-ai-formplugin", (Object[])new Object[0]));
            }
            Long batchId = FahImportLogDao.genGlobalLongId();
            FahUploadDataValUtil.uploadDataVal((String)((ListView)this.getView()).getBillFormId(), (Workbook)wb, (Long)batchId);
            String status = FahImportLogDao.queryImportLog((Long)batchId);
            if (ImportLogStatusEnum.SUCCEED.getCode().equals(status)) {
                this.getView().showSuccessNotification(ResManager.loadKDString((String)"\u5bfc\u5165\u6210\u529f\u3002", (String)"FahDataValSetList_3", (String)"fi-ai-formplugin", (Object[])new Object[0]));
            } else if (ImportLogStatusEnum.PROCESSING.getCode().equals(status)) {
                this.getView().showTipNotification(ResManager.loadKDString((String)"\u5bfc\u5165\u5904\u7406\u4e2d\uff0c\u8bf7\u7a0d\u540e\u67e5\u770b\u3002", (String)"FahDataValSetList_4", (String)"fi-ai-formplugin", (Object[])new Object[0]));
            } else {
                this.getView().showErrorNotification(ResManager.loadKDString((String)"\u5bfc\u5165\u5931\u8d25\uff0c\u8bf7\u67e5\u770b\u5bfc\u5165\u65e5\u5fd7\u3002", (String)"FahDataValSetList_5", (String)"fi-ai-formplugin", (Object[])new Object[0]));
            }
        }
    }

    public void beforeDoOperation(BeforeDoOperationEventArgs args) {
        AbstractOperate op = (AbstractOperate)args.getSource();
        String operateKey = op.getOperateKey();
        IFormView view = this.getView();
        BillList billList = (BillList)view.getControl("billlistap");
        ListSelectedRowCollection rows = billList.getSelectedRows();
        if (EXPORT.equals(operateKey) || DOWNLOAD_TEMPLATE.equals(operateKey)) {
            if (rows.size() > 1) {
                view.showTipNotification(ResManager.loadKDString((String)"\u4ec5\u652f\u6301\u9009\u62e9\u4e00\u6761\u6570\u636e\u6267\u884c\u3002", (String)"FahDataValSetList_6", (String)"fi-ai-formplugin", (Object[])new Object[0]));
                args.setCancel(true);
                return;
            }
            Long id = (Long)rows.get(0).getPrimaryKeyValue();
            String url = FahFlexExportUtil.export((Long)id, (String)((ListView)this.getView()).getBillFormId(), (boolean)EXPORT.equals(operateKey));
            this.getView().download(url);
        }
    }

    public void itemClick(ItemClickEvent evt) {
        String itemKey = evt.getItemKey();
        IFormView view = this.getView();
        BillList billList = (BillList)view.getControl("billlistap");
        ListSelectedRowCollection rows = billList.getSelectedRows();
        if (BTN_VIEW_IMPORTLOG.equals(itemKey)) {
            ListShowParameter param = new ListShowParameter();
            param.setBillFormId("fah_flex_importlog");
            param.getOpenStyle().setShowType(ShowType.MainNewTabPage);
            param.setCustomParam("sourcetype", (Object)((ListView)this.getView()).getBillFormId());
            if (rows != null && !rows.isEmpty()) {
                ArrayList<Long> dataTypeIds = new ArrayList<Long>(rows.size());
                for (ListSelectedRow row : rows) {
                    if (!(row.getPrimaryKeyValue() instanceof Long)) continue;
                    dataTypeIds.add((Long)row.getPrimaryKeyValue());
                }
                param.setCustomParam("datatypeid", dataTypeIds);
            }
            this.getView().showForm((FormShowParameter)param);
        }
    }
}

