/*
 * Decompiled with CFR 0.152.
 */
package kd.fi.v2.fah.formplugin.mapping;

import java.util.ArrayList;
import java.util.Date;
import java.util.EventObject;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import kd.bos.algo.DataSet;
import kd.bos.algo.Row;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.entity.DynamicObjectCollection;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.dataentity.serialization.SerializationUtils;
import kd.bos.db.DB;
import kd.bos.db.DBRoute;
import kd.bos.db.SqlBuilder;
import kd.bos.entity.EntryType;
import kd.bos.entity.MainEntityType;
import kd.bos.entity.datamodel.events.GetEntityTypeEventArgs;
import kd.bos.exception.ErrorCode;
import kd.bos.exception.KDException;
import kd.bos.form.control.Control;
import kd.bos.form.events.OnGetControlArgs;
import kd.bos.form.plugin.AbstractFormPlugin;
import kd.bos.orm.query.QFilter;
import kd.bos.servicehelper.BusinessDataServiceHelper;
import kd.bos.servicehelper.QueryServiceHelper;
import kd.fi.v2.fah.constant.FAHCommonConstant;
import kd.fi.v2.fah.constant.enums.DataValueTypeEnum;
import kd.fi.v2.fah.element.AccountElement;
import kd.fi.v2.fah.element.BaseDataElement;
import kd.fi.v2.fah.element.ComboElement;
import kd.fi.v2.fah.element.DateElement;
import kd.fi.v2.fah.element.DateTimeElement;
import kd.fi.v2.fah.element.Element;
import kd.fi.v2.fah.element.EntryElement;
import kd.fi.v2.fah.element.TextElement;
import kd.fi.v2.fah.utils.FahMappingUtils;
import kd.fi.v2.fah.utils.StringUtils;

public class FahValMapChangeLog
extends AbstractFormPlugin {
    private static final String ENTRYENTITY = "entryentity";

    public void initialize() {
        super.initialize();
        this.getView().addCustomControls(new String[]{ENTRYENTITY});
        DynamicObjectCollection fields = QueryServiceHelper.query((String)"fah_flex_struc", (String)"dseq,attnum,attname,attdatatype,refentity,fieldusagetype,reftypeid,reffieldnum,flexfieldnum", (QFilter[])new QFilter[]{new QFilter("parentid", "=", (Object)Long.parseLong((String)this.getView().getFormShowParameter().getCustomParam("strucid")))}, (String)"fieldusagetype desc,dseq asc");
        LinkedList<Element> elementList = this.getElementList(fields);
        this.cacheEntryElement(elementList);
    }

    public void afterBindData(EventObject e) {
        super.afterBindData(e);
        this.entryBuild();
        this.getView().updateView(ENTRYENTITY);
        HashMap[] flexFieldNum = (HashMap[])SerializationUtils.fromJsonString((String)this.getPageCache().get("flexFieldNumMap"), HashMap[].class);
        try (DataSet mapVals = this.queryMapVal((Long)this.getView().getFormShowParameter().getCustomParam("typeid"), 1L);){
            try (DataSet mapValsNew = mapVals.copy();){
                Iterator iterator = mapVals.iterator();
                List<Map> valueMapList = this.getValueMapList(iterator);
                Iterator iteratorNew = mapValsNew.iterator();
                int i = 0;
                HashMap fahValueSetMap = (HashMap)SerializationUtils.deSerializeFromBase64((String)this.getPageCache().get("fahValueSetMap"));
                this.getModel().beginInit();
                while (iteratorNew.hasNext()) {
                    Long valueTypeId;
                    long cloumnId;
                    Object cloumnValue;
                    String cloumnNumber;
                    this.getModel().createNewEntryRow(ENTRYENTITY);
                    Row mapVal = (Row)iteratorNew.next();
                    int serialNumber = mapVal.getInteger("serialnumber");
                    this.getModel().setValue("effectdate", (Object)FahMappingUtils.dateIsEquals((Date)mapVal.getDate("effectdate"), (boolean)true), i);
                    this.getModel().setValue("expiredate", (Object)FahMappingUtils.dateIsEquals((Date)mapVal.getDate("expiredate"), (boolean)false), i);
                    this.getModel().setValue("serialnumber", (Object)serialNumber, i);
                    this.getModel().setValue("user", (Object)mapVal.getLong("modifierid"), i);
                    this.getModel().setValue("eorg", (Object)mapVal.getLong("fownorgid"), i);
                    this.getModel().setValue("date", (Object)mapVal.getDate("modifytime"), i);
                    this.getModel().setValue("changetype", (Object)mapVal.getString("fchangetype"), i);
                    this.getModel().setValue("createtime", (Object)mapVal.getString("fcreatetime"), i);
                    this.getModel().setValue("createuser", (Object)mapVal.getString("fcreatorid"), i);
                    Map accountMap = valueMapList.get(0);
                    Map cashFlowItemMap = valueMapList.get(1);
                    Map valueSetMap = valueMapList.get(2);
                    for (Map.Entry entrySet : flexFieldNum[0].entrySet()) {
                        cloumnNumber = (String)entrySet.getKey();
                        cloumnValue = mapVal.get("mapvalout." + (String)entrySet.getValue());
                        cloumnId = 0L;
                        if (cloumnNumber.startsWith("valueset_") && !StringUtils.isEmpty((Object)cloumnValue)) {
                            valueTypeId = (Long)fahValueSetMap.get(cloumnNumber);
                            if (!valueSetMap.isEmpty() && valueSetMap.get(valueTypeId) != null && ((HashMap)valueSetMap.get(valueTypeId)).get(cloumnValue) != null) {
                                cloumnId = (Long)((HashMap)valueSetMap.get(valueTypeId)).get(cloumnValue);
                            }
                        } else if (cloumnNumber.startsWith("accounttable_") && !StringUtils.isEmpty((Object)cloumnValue)) {
                            if (!accountMap.isEmpty() && accountMap.get(cloumnValue) != null) {
                                cloumnId = (Long)accountMap.get(cloumnValue);
                            }
                        } else if (cloumnNumber.startsWith("cashflow_") && !StringUtils.isEmpty((Object)cloumnValue) && !cashFlowItemMap.isEmpty() && cashFlowItemMap.get(cloumnValue) != null) {
                            cloumnId = (Long)cashFlowItemMap.get(cloumnValue);
                        }
                        if (cloumnId != 0L) {
                            this.getModel().setValue(cloumnNumber, (Object)cloumnId, i);
                            continue;
                        }
                        this.getModel().setValue(cloumnNumber, cloumnValue, i);
                    }
                    for (Map.Entry entrySet : flexFieldNum[1].entrySet()) {
                        cloumnNumber = (String)entrySet.getKey();
                        cloumnValue = mapVal.get("mapvalin." + (String)entrySet.getValue());
                        if (StringUtils.isEmpty((Object)cloumnValue)) continue;
                        cloumnId = 0L;
                        if (cloumnNumber.startsWith("valueset_") && !StringUtils.isEmpty((Object)cloumnValue)) {
                            valueTypeId = (Long)fahValueSetMap.get(cloumnNumber);
                            if (!valueSetMap.isEmpty() && valueSetMap.get(valueTypeId) != null && ((HashMap)valueSetMap.get(valueTypeId)).get(cloumnValue) != null) {
                                cloumnId = (Long)((HashMap)valueSetMap.get(valueTypeId)).get(cloumnValue);
                            }
                        } else if (cloumnNumber.startsWith("accounttable_") && !StringUtils.isEmpty((Object)cloumnValue)) {
                            if (!cashFlowItemMap.isEmpty() && cashFlowItemMap.get(cloumnValue) != null) {
                                cloumnId = (Long)cashFlowItemMap.get(cloumnValue);
                            }
                        } else if (cloumnNumber.startsWith("cashflow_") && !StringUtils.isEmpty((Object)cloumnValue) && !accountMap.isEmpty() && accountMap.get(cloumnValue) != null) {
                            cloumnId = (Long)accountMap.get(cloumnValue);
                        }
                        if (cloumnId != 0L) {
                            this.getModel().setValue(cloumnNumber, (Object)cloumnId, i);
                            continue;
                        }
                        this.getModel().setValue(cloumnNumber, cloumnValue, i);
                    }
                    ++i;
                }
            }
            this.getModel().endInit();
            this.getView().updateView(ENTRYENTITY);
        }
    }

    private List<Map> getValueMapList(Iterator<Row> iterator) {
        ArrayList<Map> valueMapList = new ArrayList<Map>(3);
        HashSet<String> accountSet = new HashSet<String>();
        HashSet<String> cashFlowItemSet = new HashSet<String>();
        QFilter valueSetqFilter = null;
        HashMap[] flexFieldNum = (HashMap[])SerializationUtils.fromJsonString((String)this.getPageCache().get("flexFieldNumMap"), HashMap[].class);
        HashMap fahValueSetMap = (HashMap)SerializationUtils.deSerializeFromBase64((String)this.getPageCache().get("fahValueSetMap"));
        while (iterator.hasNext()) {
            Object cloumnValue;
            String cloumnNumber;
            Row mapVal = iterator.next();
            for (Map.Entry entrySet : flexFieldNum[0].entrySet()) {
                cloumnNumber = (String)entrySet.getKey();
                cloumnValue = mapVal.get("mapvalout." + (String)entrySet.getValue());
                if (cloumnNumber.startsWith("valueset_") && !StringUtils.isEmpty((Object)cloumnValue)) {
                    if (valueSetqFilter == null) {
                        valueSetqFilter = new QFilter("number", "=", cloumnValue).and(new QFilter("valuesettypeid.id", "=", fahValueSetMap.get(cloumnNumber)));
                        continue;
                    }
                    valueSetqFilter.or(new QFilter("number", "=", cloumnValue).and(new QFilter("valuesettypeid.id", "=", fahValueSetMap.get(cloumnNumber))));
                    continue;
                }
                if (cloumnNumber.startsWith("accounttable_") && !StringUtils.isEmpty((Object)cloumnValue)) {
                    accountSet.add((String)cloumnValue);
                    continue;
                }
                if (!cloumnNumber.startsWith("cashflow_") || StringUtils.isEmpty((Object)cloumnValue)) continue;
                cashFlowItemSet.add((String)cloumnValue);
            }
            for (Map.Entry entrySet : flexFieldNum[1].entrySet()) {
                cloumnNumber = (String)entrySet.getKey();
                cloumnValue = mapVal.get("mapvalin." + (String)entrySet.getValue());
                if (cloumnNumber.startsWith("valueset_") && !StringUtils.isEmpty((Object)cloumnValue)) {
                    if (valueSetqFilter == null) {
                        valueSetqFilter = new QFilter("number", "=", cloumnValue).and(new QFilter("valuesettypeid.id", "=", fahValueSetMap.get(cloumnNumber)));
                        continue;
                    }
                    valueSetqFilter.or(new QFilter("number", "=", cloumnValue).and(new QFilter("valuesettypeid.id", "=", fahValueSetMap.get(cloumnNumber))));
                    continue;
                }
                if (cloumnNumber.startsWith("accounttable_") && !StringUtils.isEmpty((Object)cloumnValue)) {
                    accountSet.add((String)cloumnValue);
                    continue;
                }
                if (!cloumnNumber.startsWith("cashflow_") || StringUtils.isEmpty((Object)cloumnValue)) continue;
                cashFlowItemSet.add((String)cloumnValue);
            }
        }
        HashMap<String, Long> accountMap = new HashMap<String, Long>();
        HashMap<String, Long> cashFlowItemMap = new HashMap<String, Long>();
        HashMap<Long, HashMap> valueSetMap = new HashMap<Long, HashMap>();
        if (!accountSet.isEmpty()) {
            DynamicObjectCollection accounts = QueryServiceHelper.query((String)"bd_accountview", (String)"number,id", (QFilter[])new QFilter[]{new QFilter("number", "in", accountSet)});
            for (DynamicObject account : accounts) {
                accountMap.put(account.getString("number"), account.getLong("id"));
            }
        }
        if (!cashFlowItemSet.isEmpty()) {
            DynamicObjectCollection cashFlowItems = QueryServiceHelper.query((String)"gl_cashflowitem", (String)"number,id", (QFilter[])new QFilter[]{new QFilter("number", "in", cashFlowItemSet)});
            for (DynamicObject cashFlowItem : cashFlowItems) {
                cashFlowItemMap.put(cashFlowItem.getString("number"), cashFlowItem.getLong("id"));
            }
        }
        if (valueSetqFilter != null) {
            DynamicObjectCollection valueSets = QueryServiceHelper.query((String)"fah_flex_valueset", (String)"valuesettypeid,number,id", (QFilter[])new QFilter[]{valueSetqFilter});
            for (DynamicObject valueSet : valueSets) {
                valueSetMap.computeIfAbsent(valueSet.getLong("valuesettypeid"), v -> new HashMap()).put(valueSet.getString("number"), valueSet.getLong("id"));
            }
        }
        valueMapList.add(accountMap);
        valueMapList.add(cashFlowItemMap);
        valueMapList.add(valueSetMap);
        return valueMapList;
    }

    public DataSet queryMapVal(Long mapTypeId, Long groupId) {
        HashMap[] flexFieldNum = (HashMap[])SerializationUtils.fromJsonString((String)this.getPageCache().get("flexFieldNumMap"), HashMap[].class);
        SqlBuilder sql = new SqlBuilder();
        sql.append("SELECT mapvalin.fmodifytime modifytime,mapvalin.fcreatetime fcreatetime,mapvalin.fcreatorid fcreatorid,mapvalin.fchangetype fchangetype,mapvalout.fmodifierid modifierid,mapvalout.fownorgid fownorgid,mapvalin.feffectdate effectdate,mapvalin.fstatus status,mapvalin.fexpiredate expiredate,mapvalin.fenable enable_en,mapvalin.fserialnumber serialnumber ", new Object[0]);
        for (Map.Entry entrySet : flexFieldNum[0].entrySet()) {
            sql.append(", mapvalout." + (String)entrySet.getValue(), new Object[0]).append("\"mapvalout." + (String)entrySet.getValue() + "\"", new Object[0]);
        }
        for (Map.Entry entrySet : flexFieldNum[1].entrySet()) {
            sql.append(", mapvalin." + (String)entrySet.getValue(), new Object[0]).append("\"mapvalin." + (String)entrySet.getValue() + "\"", new Object[0]);
        }
        sql.append("FROM t_fah_flex_mapval_his mapvalin,t_fah_flex_mapval_his mapvalout", new Object[0]).append("WHERE mapvalin.fmaptypeid = ? ", new Object[]{mapTypeId}).append("AND mapvalout.fmaptypeid = ?", new Object[]{mapTypeId}).append("AND mapvalin.fserialnumber = mapvalout.fserialnumber AND mapvalout.fmapvaluetype ='0' AND mapvalin.fmapvaluetype ='1' AND mapvalin.fgroupid = mapvalout.fgroupid and mapvalin.fmodifytime = mapvalout.fmodifytime", new Object[0]);
        sql.append("order by mapvalin.fmodifytime desc", new Object[0]);
        return DB.queryDataSet((String)"FahValMapEdit", (DBRoute)FAHCommonConstant.AI, (SqlBuilder)sql);
    }

    public void getEntityType(GetEntityTypeEventArgs e) {
        MainEntityType newMainType;
        MainEntityType oldMainType = e.getOriginalEntityType();
        try {
            newMainType = (MainEntityType)oldMainType.clone();
        }
        catch (CloneNotSupportedException var5) {
            throw new KDException((Throwable)var5, new ErrorCode("LoadCustomControlMetasSample", var5.getMessage()), new Object[0]);
        }
        EntryType entryType = (EntryType)newMainType.getAllEntities().get(ENTRYENTITY);
        this.getEntryElement().registerEntryProp(entryType);
        e.setNewEntityType(newMainType);
    }

    public void onGetControl(OnGetControlArgs e) {
        EntryElement entryElement = this.getEntryElement();
        ArrayList<EntryElement> items = new ArrayList<EntryElement>(entryElement.getItems());
        items.add(entryElement);
        Optional<Element> first = items.stream().filter(x -> x.getName().equals(e.getKey())).findFirst();
        Control control = null;
        if (first.isPresent()) {
            Element element = first.get();
            control = element.getControl(this.getView());
            e.setControl(control);
        }
    }

    private LinkedList<Element> getElementList(DynamicObjectCollection collection) {
        LinkedList<Element> entryElementList = new LinkedList<Element>();
        entryElementList.add((Element)new BaseDataElement("createuser", ResManager.loadKDString((String)"\u521b\u5efa\u4eba", (String)"FahValMapChangeLog_7", (String)"fi-ai-formplugin", (Object[])new Object[0]), "bos_user", ENTRYENTITY));
        entryElementList.add((Element)new DateTimeElement("createtime", ResManager.loadKDString((String)"\u521b\u5efa\u65f6\u95f4", (String)"FahValMapChangeLog_8", (String)"fi-ai-formplugin", (Object[])new Object[0]), ENTRYENTITY));
        entryElementList.add((Element)new ComboElement("changetype", ResManager.loadKDString((String)"\u53d8\u52a8\u7c7b\u578b", (String)"FahValMapChangeLog_0", (String)"fi-ai-formplugin", (Object[])new Object[0]), ENTRYENTITY, "fah_flex_mapval", "changetype", false));
        entryElementList.add((Element)new BaseDataElement("user", ResManager.loadKDString((String)"\u64cd\u4f5c\u4eba", (String)"FahValMapChangeLog_1", (String)"fi-ai-formplugin", (Object[])new Object[0]), "bos_user", ENTRYENTITY));
        entryElementList.add((Element)new DateTimeElement("date", ResManager.loadKDString((String)"\u64cd\u4f5c\u65f6\u95f4", (String)"FahValMapChangeLog_2", (String)"fi-ai-formplugin", (Object[])new Object[0]), ENTRYENTITY));
        entryElementList.add((Element)new TextElement("serialnumber", ResManager.loadKDString((String)"\u6d41\u6c34\u53f7", (String)"FahValMapChangeLog_3", (String)"fi-ai-formplugin", (Object[])new Object[0]), ENTRYENTITY));
        entryElementList.add((Element)new BaseDataElement("eorg", ResManager.loadKDString((String)"\u9002\u7528\u7ec4\u7ec7", (String)"FahValMapChangeLog_4", (String)"fi-ai-formplugin", (Object[])new Object[0]), "bos_org", ENTRYENTITY, false, false));
        HashMap<Integer, LinkedList> fieldNumberMap = new HashMap<Integer, LinkedList>(2);
        HashMap<String, Long> assistMap = new HashMap<String, Long>(4);
        HashMap<String, Long> accountMap = new HashMap<String, Long>(4);
        HashMap<String, Long> fahValueSetMap = new HashMap<String, Long>(4);
        HashMap[] flexFieldNumMap = new HashMap[]{new HashMap(), new HashMap()};
        HashSet<String> controlSet = new HashSet<String>();
        for (DynamicObject field : collection) {
            String flexfieldnum = field.getString("flexfieldnum");
            String fieldNumber = field.getString("attnum").toLowerCase();
            String fieldName = field.getString("attname");
            String refEntity = field.getString("refentity");
            Long reftypeid = field.getLong("reftypeid");
            String attdatatype = field.getString("attdatatype");
            DataValueTypeEnum type = DataValueTypeEnum.getEnum((String)attdatatype);
            String flexFieldType = field.getString("fieldusagetype");
            switch (type) {
                case String: {
                    TextElement textElement = new TextElement(fieldNumber, fieldName, ENTRYENTITY);
                    textElement.setFlexFieldType(flexFieldType);
                    entryElementList.add((Element)textElement);
                    controlSet.add(fieldNumber);
                    break;
                }
                case BaseProp: {
                    BaseDataElement baseDataElement = new BaseDataElement("basedata_" + fieldNumber, fieldName, refEntity, ENTRYENTITY);
                    baseDataElement.setFlexFieldType(flexFieldType);
                    entryElementList.add((Element)baseDataElement);
                    fieldNumber = "basedata_" + fieldNumber;
                    controlSet.add(fieldNumber);
                    break;
                }
                case AssistProp: {
                    BaseDataElement baseDataElement = new BaseDataElement("assistant_" + fieldNumber, fieldName, "bos_assistantdata_detail", ENTRYENTITY);
                    baseDataElement.setFlexFieldType(flexFieldType);
                    entryElementList.add((Element)baseDataElement);
                    fieldNumber = "assistant_" + fieldNumber;
                    assistMap.put(fieldNumber, reftypeid);
                    controlSet.add(fieldNumber);
                    break;
                }
                case FahValueSet: {
                    BaseDataElement baseDataElement = new BaseDataElement("valueset_" + fieldNumber, fieldName, "fah_flex_valueset", ENTRYENTITY);
                    baseDataElement.setFlexFieldType(flexFieldType);
                    entryElementList.add((Element)baseDataElement);
                    fieldNumber = "valueset_" + fieldNumber;
                    fahValueSetMap.put(fieldNumber, reftypeid);
                    controlSet.add(fieldNumber);
                    break;
                }
                case Kingdee_AccountTable: {
                    AccountElement accountElement = new AccountElement("accounttable_" + fieldNumber, fieldName, "bd_accountview", ENTRYENTITY);
                    accountElement.setFlexFieldType(flexFieldType);
                    entryElementList.add((Element)accountElement);
                    fieldNumber = "accounttable_" + fieldNumber;
                    accountMap.put(fieldNumber, reftypeid);
                    controlSet.add(fieldNumber);
                    break;
                }
                case Kingdee_AcctAssistDim: {
                    BaseDataElement baseDataElement;
                    DynamicObject temp = BusinessDataServiceHelper.loadSingle((String)"bd_asstacttype", (String)"valuetype,valuesource,assistanttype", (QFilter[])new QFilter[]{new QFilter("id", "=", (Object)reftypeid)});
                    if (temp != null && "1".equals(temp.getString("valuetype"))) {
                        baseDataElement = new BaseDataElement("acctassistdim_" + fieldNumber, fieldName, temp.getString("valuesource_id"), ENTRYENTITY);
                        baseDataElement.setFlexFieldType(flexFieldType);
                        entryElementList.add((Element)baseDataElement);
                        fieldNumber = "acctassistdim_" + fieldNumber;
                    } else {
                        if (temp == null || !"2".equals(temp.getString("valuetype"))) break;
                        baseDataElement = new BaseDataElement("acctassistdim_" + fieldNumber, fieldName, "bos_assistantdata_detail", ENTRYENTITY);
                        baseDataElement.setFlexFieldType(flexFieldType);
                        entryElementList.add((Element)baseDataElement);
                        fieldNumber = "acctassistdim_" + fieldNumber;
                        assistMap.put(fieldNumber, temp.getLong("assistanttype_id"));
                    }
                    controlSet.add(fieldNumber);
                    break;
                }
                case Kingdee_CashFlow: {
                    BaseDataElement baseDataElement = new BaseDataElement("cashflow_" + fieldNumber, fieldName, "gl_cashflowitem", ENTRYENTITY);
                    baseDataElement.setFlexFieldType(flexFieldType);
                    entryElementList.add((Element)baseDataElement);
                    fieldNumber = "cashflow_" + fieldNumber;
                    controlSet.add(fieldNumber);
                    break;
                }
                case Kingdee_BillDropDownList: {
                    String refFieldNum = field.getString("reffieldnum");
                    ComboElement comboElement = new ComboElement("billdropdownlist_" + fieldNumber, fieldName, ENTRYENTITY, refEntity, refFieldNum, false);
                    comboElement.setFlexFieldType(flexFieldType);
                    entryElementList.add((Element)comboElement);
                    fieldNumber = "billdropdownlist_" + fieldNumber;
                    controlSet.add(fieldNumber);
                }
            }
            fieldNumberMap.computeIfAbsent(field.getInt("fieldusagetype"), v -> new LinkedList()).add(new Object[]{fieldNumber, type});
            flexFieldNumMap[field.getInt("fieldusagetype")].put(fieldNumber, flexfieldnum);
        }
        entryElementList.add((Element)new DateElement("effectdate", ResManager.loadKDString((String)"\u5f00\u59cb\u65e5\u671f", (String)"FahValMapChangeLog_5", (String)"fi-ai-formplugin", (Object[])new Object[0]), ENTRYENTITY));
        entryElementList.add((Element)new DateElement("expiredate", ResManager.loadKDString((String)"\u7ed3\u675f\u65e5\u671f", (String)"FahValMapChangeLog_6", (String)"fi-ai-formplugin", (Object[])new Object[0]), ENTRYENTITY));
        this.getPageCache().put("assistMap", SerializationUtils.serializeToBase64(assistMap));
        this.getPageCache().put("accountMap", SerializationUtils.serializeToBase64(accountMap));
        this.getPageCache().put("controlSet", SerializationUtils.toJsonString(controlSet));
        this.getPageCache().put("fahValueSetMap", SerializationUtils.serializeToBase64(fahValueSetMap));
        this.getPageCache().put("flexFieldNumMap", SerializationUtils.toJsonString((Object)flexFieldNumMap));
        this.getPageCache().put("fieldNumberMap", SerializationUtils.serializeToBase64(fieldNumberMap));
        return entryElementList;
    }

    private EntryElement cacheEntryElement(LinkedList<Element> elementList) {
        EntryElement entryElement = new EntryElement(ENTRYENTITY, true, false);
        entryElement.setItems(elementList);
        this.getPageCache().put("entryentity_element", SerializationUtils.serializeToBase64((Object)entryElement));
        return entryElement;
    }

    public void entryBuild() {
        this.getEntryElement().build(this.getView());
    }

    private EntryElement getEntryElement() {
        String elements = this.getPageCache().get("entryentity_element");
        if (elements == null) {
            LinkedList<Element> elementList = new LinkedList<Element>();
            return this.cacheEntryElement(elementList);
        }
        return (EntryElement)SerializationUtils.deSerializeFromBase64((String)elements);
    }
}

