/*
 * Decompiled with CFR 0.152.
 */
package kd.fi.v2.fah.formplugin.mapping;

import java.time.LocalDate;
import java.time.LocalDateTime;
import java.time.ZoneId;
import java.util.Date;
import java.util.HashMap;
import java.util.List;
import kd.bos.dataentity.serialization.SerializationUtils;
import kd.bos.form.IFormView;
import kd.bos.form.IPageCache;
import kd.bos.form.control.EntryGrid;
import kd.bos.form.field.BasedataEdit;
import kd.bos.form.field.events.BeforeF7SelectEvent;
import kd.bos.form.field.events.BeforeF7SelectListener;
import kd.bos.list.ListShowParameter;
import kd.bos.orm.query.QFilter;
import kd.fi.v2.fah.dao.sys.SysBasePropDataDaoImpl;
import kd.fi.v2.fah.utils.StringUtils;

public class FahValMapFilterUtil {
    public static void registerListener(IFormView view, IPageCache pageCache, BeforeF7SelectListener beforeF7SelectListener) {
        EntryGrid entryGrid = (EntryGrid)view.getControl("entryentity");
        if (pageCache.get("assistMap") != null && pageCache.get("accountMap") != null && pageCache.get("fahValueSetMap") != null) {
            BasedataEdit basedataEdit;
            HashMap assistMap = (HashMap)SerializationUtils.deSerializeFromBase64((String)pageCache.get("assistMap"));
            HashMap accountMap = (HashMap)SerializationUtils.deSerializeFromBase64((String)pageCache.get("accountMap"));
            HashMap fahValueSetMap = (HashMap)SerializationUtils.deSerializeFromBase64((String)pageCache.get("fahValueSetMap"));
            HashMap basedataForF7Map = (HashMap)SerializationUtils.deSerializeFromBase64((String)pageCache.get("basedataForF7Map"));
            String selKey = entryGrid.getEntryState().getFocusField();
            if (!StringUtils.isEmpty((String)selKey) && (assistMap.get(selKey) != null || accountMap.get(selKey) != null || fahValueSetMap.get(selKey) != null || basedataForF7Map.get(selKey) != null || selKey.startsWith("cashflow_")) && (basedataEdit = (BasedataEdit)view.getControl(selKey)) != null) {
                basedataEdit.addBeforeF7SelectListener(beforeF7SelectListener);
            }
        }
    }

    public static void beforeF7Select(BeforeF7SelectEvent evt, Long orgID, IPageCache pageCache, boolean isForOrgFilter) {
        String basedataTypeId;
        ListShowParameter list = (ListShowParameter)evt.getFormShowParameter();
        List qFilters = list.getListFilterParameter().getQFilters();
        String fieldKey = evt.getProperty().getName();
        HashMap assistMap = (HashMap)SerializationUtils.deSerializeFromBase64((String)pageCache.get("assistMap"));
        HashMap accountMap = (HashMap)SerializationUtils.deSerializeFromBase64((String)pageCache.get("accountMap"));
        HashMap fahValueSetMap = (HashMap)SerializationUtils.deSerializeFromBase64((String)pageCache.get("fahValueSetMap"));
        HashMap basedataForF7Map = (HashMap)SerializationUtils.deSerializeFromBase64((String)pageCache.get("basedataForF7Map"));
        if (!qFilters.isEmpty()) {
            qFilters.removeIf(v -> v.getProperty().contains("inner join"));
        }
        if (null != (basedataTypeId = (String)basedataForF7Map.get(fieldKey)) && isForOrgFilter) {
            QFilter baseDataFilter = SysBasePropDataDaoImpl.getBaseDataFilter((String)basedataTypeId, (Long)orgID);
            if (null != baseDataFilter) {
                qFilters.add(baseDataFilter);
            }
            return;
        }
        Long assistId = (Long)assistMap.get(fieldKey);
        if (assistId != null) {
            list.setFormId("bos_listf7");
            list.setShowFilter(false);
            QFilter qFilter = new QFilter("group.id", "=", (Object)assistId);
            qFilters.add(qFilter);
            if (isForOrgFilter) {
                QFilter assistantDataFilter = SysBasePropDataDaoImpl.getAssistantDataFilter((Long)assistId, (Long)orgID);
                qFilters.add(assistantDataFilter);
            }
            return;
        }
        Object accountTableId = accountMap.get(fieldKey);
        if (accountTableId != null) {
            QFilter baseDataFilter;
            QFilter qFilter = new QFilter("accounttable.id", "=", accountTableId);
            qFilters.add(qFilter);
            if (isForOrgFilter && null != (baseDataFilter = SysBasePropDataDaoImpl.getBaseDataFilter((String)"bd_accountview", (Long)orgID))) {
                qFilters.add(baseDataFilter);
            }
            return;
        }
        if (fieldKey.startsWith("cashflow_") && isForOrgFilter) {
            QFilter baseDataFilter = SysBasePropDataDaoImpl.getBaseDataFilter((String)"gl_cashflowitem", (Long)orgID);
            if (null != baseDataFilter) {
                qFilters.add(baseDataFilter);
            }
            return;
        }
        Object fahValueSetId = fahValueSetMap.get(fieldKey);
        if (fahValueSetId != null) {
            QFilter qFilter = new QFilter("valuesettypeid.id", "=", fahValueSetId);
            qFilter.and(new QFilter("enable", "=", (Object)"1"));
            LocalDateTime now = LocalDate.now().atTime(0, 0, 0, 0);
            Date currentDate = Date.from(now.atZone(ZoneId.systemDefault()).toInstant());
            QFilter effectDateFilter = new QFilter("effectdate", "is null", null).or(new QFilter("effectdate", "<=", (Object)currentDate));
            QFilter expireDateFilter = new QFilter("expiredate", "is null", null).or(new QFilter("expiredate", ">=", (Object)currentDate));
            qFilters.add(qFilter.and(effectDateFilter.and(expireDateFilter)));
        }
    }
}

