/*
 * Decompiled with CFR 0.152.
 */
package kd.fi.v2.fah.formplugin.mapping;

import com.alibaba.fastjson.JSON;
import java.io.InputStream;
import java.util.EventObject;
import java.util.HashMap;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.ext.fi.thread.TaskType;
import kd.bos.ext.fi.thread.ThreadService;
import kd.bos.fileservice.FileService;
import kd.bos.fileservice.FileServiceFactory;
import kd.bos.form.control.Label;
import kd.bos.form.control.ProgressBar;
import kd.bos.form.control.events.ProgressEvent;
import kd.bos.form.control.events.ProgresssListener;
import kd.bos.form.events.BeforeClosedEvent;
import kd.bos.form.plugin.AbstractFormPlugin;
import kd.bos.logging.Log;
import kd.bos.logging.LogFactory;
import kd.fi.v2.fah.constant.enums.ImportLogStatusEnum;
import kd.fi.v2.fah.dao.FahImportLogDao;
import kd.fi.v2.fah.task.FahTaskStatus;
import kd.fi.v2.fah.task.FahTaskStatusPushService;
import kd.fi.v2.fah.util.FahUploadDataValUtil;
import kd.fi.v2.fah.utils.StringUtils;
import org.apache.poi.hssf.usermodel.HSSFWorkbook;
import org.apache.poi.ss.usermodel.Workbook;
import org.apache.poi.xssf.usermodel.XSSFWorkbook;

public class FahValmapImportProgress
extends AbstractFormPlugin
implements ProgresssListener {
    private static final Log logger = LogFactory.getLog(FahValmapImportProgress.class);
    private static final String MSG = "msg";
    private static final String ERR_MSG = "errMsg";
    private static final int PROGRESS_VAL = 10;

    public void initialize() {
        super.initialize();
        ProgressBar bar = this.getProgressBar();
        bar.addProgressListener((ProgresssListener)this);
    }

    public void onProgress(ProgressEvent progressEvent) {
        Long taskId = (Long)this.getView().getFormShowParameter().getCustomParam("taskId");
        FahTaskStatusPushService service = FahValmapImportProgress.getTaskStatusPushService(taskId);
        FahTaskStatus taskStatus = service.getStatus();
        int pct = null == taskStatus ? 0 : taskStatus.getPercent();
        Label progress = (Label)this.getControl("progress");
        Label status = (Label)this.getControl("taskstatus");
        if (taskStatus != null && StringUtils.isNotEmpty((String)taskStatus.getMsg())) {
            status.setText(JSON.parseObject((String)taskStatus.getMsg()).getString(MSG));
            String percent = this.getPageCache().get("percent");
            if (StringUtils.isEmpty((String)percent)) {
                this.getPageCache().put("percent", String.valueOf(10));
            } else if (Integer.parseInt(percent) < 100) {
                int newProgress = Integer.parseInt(percent) + 10;
                if (pct < Integer.parseInt(percent)) {
                    pct = Integer.parseInt(percent);
                }
                if (pct < 100 && newProgress < 100) {
                    pct = newProgress;
                    this.getPageCache().put("percent", Integer.toString(newProgress));
                }
            }
        }
        if (pct >= 100) {
            String finish = this.getPageCache().get("finish");
            if (Boolean.TRUE.toString().equals(finish)) {
                this.getView().close();
            } else {
                pct = 99;
                this.getPageCache().put("finish", Boolean.TRUE.toString());
            }
        }
        progress.setText(pct + "%");
        progressEvent.setProgress(pct);
    }

    private static FahTaskStatusPushService getTaskStatusPushService(Long taskId) {
        return new FahTaskStatusPushService("FahDataValMapImportTask", taskId);
    }

    public void afterBindData(EventObject e) {
        super.afterBindData(e);
        ProgressBar bar = this.getProgressBar();
        bar.start();
        Long taskId = (Long)this.getView().getFormShowParameter().getCustomParam("taskId");
        ThreadService.execute(() -> this.executeTask(taskId), (TaskType)TaskType.FAH_MASTER_DATA_VALIDATE);
    }

    private void executeTask(Long taskId) {
        FahTaskStatusPushService f = FahValmapImportProgress.getTaskStatusPushService(taskId);
        HashMap<String, String> msgMap = new HashMap<String, String>(8);
        msgMap.put("taskId", taskId.toString());
        msgMap.put(MSG, ResManager.loadKDString((String)"\u4efb\u52a1\u6267\u884c\u4e2d\u3002", (String)"FahValmapImportProgress_0", (String)"fi-ai-formplugin", (Object[])new Object[0]));
        msgMap.put("pageId", this.getView().getPageId());
        f.updateStatus(10, JSON.toJSONString(msgMap));
        String url = (String)this.getView().getFormShowParameter().getCustomParam("url");
        FileService service = FileServiceFactory.getAttachmentFileService();
        InputStream is = service.getInputStream(url);
        HSSFWorkbook wb = null;
        try {
            String extStr = url.substring(url.lastIndexOf("."));
            if (".xls".equals(extStr)) {
                wb = new HSSFWorkbook(is);
            } else if (".xlsx".equals(extStr)) {
                wb = new XSSFWorkbook(is);
            }
            FahUploadDataValUtil.uploadDataVal((String)((String)this.getView().getFormShowParameter().getCustomParam("billFormId")), (Workbook)wb, (Long)taskId);
        }
        catch (Exception e) {
            msgMap.put(ERR_MSG, String.format(ResManager.loadKDString((String)"\u5bfc\u5165\u5931\u8d25\uff0c%s", (String)"FahValmapImportProgress_2", (String)"fi-ai-formplugin", (Object[])new Object[0]), e.getMessage()));
            logger.error((Throwable)e);
        }
        String endMsg = ResManager.loadKDString((String)"\u4efb\u52a1\u6267\u884c\u7ed3\u675f\u3002", (String)"FahValmapImportProgress_1", (String)"fi-ai-formplugin", (Object[])new Object[0]);
        msgMap.put(MSG, endMsg);
        f.updateStatus(100, JSON.toJSONString(msgMap));
    }

    public void beforeClosed(BeforeClosedEvent e) {
        super.beforeClosed(e);
        HashMap<String, Object> returnData = new HashMap<String, Object>(2);
        Long taskId = (Long)this.getView().getFormShowParameter().getCustomParam("taskId");
        String status = FahImportLogDao.queryImportLog((Long)taskId);
        boolean success = ImportLogStatusEnum.SUCCEED.getCode().equals(status);
        returnData.put("success", success);
        FahTaskStatus taskStatus = FahValmapImportProgress.getTaskStatusPushService(taskId).getStatus();
        if (null != taskStatus && StringUtils.isNotEmpty((String)taskStatus.getMsg())) {
            returnData.put(MSG, JSON.parseObject((String)taskStatus.getMsg()).getString(MSG));
            returnData.put(ERR_MSG, JSON.parseObject((String)taskStatus.getMsg()).getString(ERR_MSG));
        }
        this.getView().returnDataToParent(returnData);
        ProgressBar bar = this.getProgressBar();
        bar.stop();
    }

    private ProgressBar getProgressBar() {
        return (ProgressBar)this.getControl("progressbarap");
    }
}

