/*
 * Decompiled with CFR 0.152.
 */
package kd.fi.ai.upgradeservice;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.stream.Collectors;
import kd.bos.algo.DataSet;
import kd.bos.algo.Row;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.db.DB;
import kd.bos.db.DBRoute;
import kd.bos.logging.Log;
import kd.bos.logging.LogFactory;
import kd.bos.orm.query.QFilter;
import kd.bos.service.upgrade.IUpgradeService;
import kd.bos.service.upgrade.UpgradeResult;
import kd.bos.servicehelper.BusinessDataServiceHelper;
import kd.bos.servicehelper.DBServiceHelper;
import kd.bos.util.ExceptionUtils;

public class AccountMapFactEntityUpgradeService
implements IUpgradeService {
    private static final Log log = LogFactory.getLog((String)"kd.fi.ai.upgradeservice.AccountMapFactEntityUpgradeService");
    private static final String algoKey = "kd.fi.ai.upgradeservice.AccountMapFactEntityUpgradeService";

    public UpgradeResult beforeExecuteSqlWithResult(String ver, String iteration, String dbKey, String sqlFileName) {
        UpgradeResult result = new UpgradeResult();
        try {
            this.updateData();
            result.setSuccess(true);
            log.info("UPGRADE_AccountMapType_SUCCESS");
        }
        catch (Exception e) {
            result.setSuccess(false);
            log.info("UPGRADE_AccountMapType_ERROR");
            result.setErrorInfo("UPGRADE_AccountMapType_ERROR" + ExceptionUtils.getExceptionStackTraceMessage((Exception)e));
        }
        return result;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void updateData() {
        DynamicObject[] load = BusinessDataServiceHelper.load((String)"bos_importtemplate", (String)"id", (QFilter[])new QFilter("bizobject", "=", (Object)"ai_accountmaptype").toArray());
        List<Long> ids = Arrays.asList(load).stream().map(v -> v.getLong("id")).collect(Collectors.toList());
        String presql = "select fid from T_BAS_IMPORTTEMPLATEENTRY where fid in (select fid from T_BAS_IMPORTTEMPLATE where fbizobject = 'ai_accountmaptype') and ffieldkey = 'factorimport'";
        try (DataSet qd = DB.queryDataSet((String)algoKey, (DBRoute)DBRoute.of((String)"sys"), (String)presql);){
            Iterator it = qd.iterator();
            while (it.hasNext()) {
                ids.remove(((Row)it.next()).getLong("fid"));
            }
        }
        HashSet<String> cc = new HashSet<String>(10);
        cc.add("factornumber1");
        cc.add("factorvalue1");
        cc.add("factornumber2");
        cc.add("factorvalue2");
        cc.add("factornumber3");
        cc.add("factorvalue3");
        cc.add("factornumber4");
        cc.add("factorvalue4");
        cc.add("factornumber5");
        cc.add("factorvalue5");
        this.preData(ids, new ArrayList<String>(cc));
        String sql = "select fentryid,ffieldkey,fisimport from T_BAS_IMPORTTEMPLATEENTRY where fid in (select fid from T_BAS_IMPORTTEMPLATE where fbizobject = 'ai_accountmaptype')";
        ArrayList<Object[]> params = new ArrayList<Object[]>();
        try (DataSet queryDataSet = DB.queryDataSet((String)algoKey, (DBRoute)DBRoute.of((String)"sys"), (String)sql);){
            for (Row next : queryDataSet) {
                if (!cc.contains(next.get("ffieldkey")) || next.getBoolean("fisimport").booleanValue()) continue;
                params.add(new Object[]{next.getLong("fentryid")});
            }
        }
        if (!params.isEmpty()) {
            String updataSql = "update T_BAS_IMPORTTEMPLATEENTRY set fisimport = '1' where fentryid = ?";
            DB.executeBatch((DBRoute)DBRoute.of((String)"sys"), (String)updataSql, params);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void preData(List<Long> ids, List<String> cc) {
        if (ids.isEmpty()) {
            return;
        }
        for (Long id : ids) {
            Long fparentId = 0L;
            String sql = "select fentryid from T_BAS_IMPORTTEMPLATEENTRY where ffieldkey = 'ai_accountmaptype' and fid = ?";
            try (DataSet qq = this.getQueryData(sql, new Object[]{id});){
                Iterator iterator = qq.iterator();
                if (iterator.hasNext()) {
                    fparentId = ((Row)iterator.next()).getLong("fentryid");
                }
            }
            long[] idsss = DBServiceHelper.genLongIds((String)"T_BAS_IMPORTTEMPLATEENTRY", (int)11);
            sql = "INSERT INTO T_BAS_IMPORTTEMPLATEENTRY(FID, FENTRYID, FPARENTENTRYID, FSEQ, FFIELDKEY, FFIELDNAME, FMUSTINPUT, FDESCRIPTION, FISIMPORT, FISFIELD, FIMPORTPROP, FEXPORTPROP)VALUES (?, ?, ?,  '67', 'factorimport' , ' ', '0', ' ', '1', '1', ' ', ' ')";
            this.setExcete(sql, new Object[]{id, idsss[0], fparentId});
            ArrayList<Object[]> params = new ArrayList<Object[]>(cc.size());
            int i = 1;
            for (String c : cc) {
                params.add(new Object[]{id, idsss[i], idsss[0], 67 + i, c});
                ++i;
            }
            if (params.isEmpty()) continue;
            String presql = "INSERT INTO T_BAS_IMPORTTEMPLATEENTRY(FID, FENTRYID, FPARENTENTRYID, FSEQ, FFIELDKEY, FFIELDNAME, FMUSTINPUT, FDESCRIPTION, FISIMPORT, FISFIELD, FIMPORTPROP, FEXPORTPROP) VALUES (?, ?, ?,  ?, ? , ' ', '0', ' ', '1', '1', ' ', ' ')";
            this.setExceteBat(presql, params);
        }
    }

    private DataSet getQueryData(String sql, Object[] params) {
        return DB.queryDataSet((String)algoKey, (DBRoute)DBRoute.of((String)"sys"), (String)sql, (Object[])params);
    }

    private void setExcete(String sql, Object[] params) {
        DB.execute((DBRoute)DBRoute.of((String)"sys"), (String)sql, (Object[])params);
    }

    private void setExceteBat(String sql, List<Object[]> params) {
        DB.executeBatch((DBRoute)DBRoute.of((String)"sys"), (String)sql, params);
    }
}

