/*
 * Decompiled with CFR 0.152.
 */
package kd.fi.ai.upgradeservice;

import java.sql.Date;
import java.util.ArrayList;
import java.util.Calendar;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Set;
import kd.bos.algo.DataSet;
import kd.bos.algo.Row;
import kd.bos.dataentity.utils.StringUtils;
import kd.bos.db.DB;
import kd.bos.db.DBRoute;
import kd.bos.db.SqlBuilder;
import kd.bos.ext.fi.ai.DapBuildVoucherCommonUtil;
import kd.bos.logging.Log;
import kd.bos.logging.LogFactory;
import kd.bos.service.upgrade.IUpgradeService;
import kd.bos.service.upgrade.UpgradeResult;
import kd.bos.servicehelper.QueryServiceHelper;
import kd.bos.util.ExceptionUtils;

public class AiWhiteBillDateUpgradeService
implements IUpgradeService {
    private static final Log logger = LogFactory.getLog((String)"kd.fi.ai.upgradeservice.AiWhiteBillDateUpgradeService");
    private static final String algoKey = "kd.fi.ai.upgradeservice.AiWhiteBillDateUpgradeService";

    public UpgradeResult beforeExecuteSqlWithResult(String ver, String iteration, String dbKey, String sqlFileName) {
        UpgradeResult result = new UpgradeResult();
        try {
            this.updateData();
            result.setSuccess(true);
            logger.info("UPGRADE_VCHTEMPLATE_SUCCESS");
        }
        catch (Exception e) {
            result.setSuccess(false);
            logger.info("UPGRADE_VCHTEMPLATE_ERROR");
            result.setErrorInfo("UPGRADE_VCHTEMPLATE_ERROR" + ExceptionUtils.getExceptionStackTraceMessage((Exception)e));
        }
        return result;
    }

    private void updateData() {
        HashSet<String> sourcebillCol = new HashSet<String>();
        String sql = "select distinct fsourcebill from t_ai_vchtemplate";
        DataSet queryDataSet = DB.queryDataSet((String)algoKey, (DBRoute)DBRoute.of((String)"fi"), (String)sql);
        Object object = null;
        try {
            Iterator iterator = queryDataSet.iterator();
            while (iterator.hasNext()) {
                String sourcebill = ((Row)iterator.next()).getString("fsourcebill");
                if (!this.getDistributeHasDapWBill(sourcebill).booleanValue()) continue;
                sourcebillCol.add(sourcebill);
            }
        }
        catch (Throwable iterator) {
            object = iterator;
            throw iterator;
        }
        finally {
            if (queryDataSet != null) {
                if (object != null) {
                    try {
                        queryDataSet.close();
                    }
                    catch (Throwable iterator) {
                        ((Throwable)object).addSuppressed(iterator);
                    }
                } else {
                    queryDataSet.close();
                }
            }
        }
        logger.info("--DAP--UpdateData:sourcebillCol:" + sourcebillCol);
        for (String billtype : sourcebillCol) {
            this.clearWhiteBill(billtype);
        }
        for (String billtype : sourcebillCol) {
            this.updateReoper(billtype);
        }
        String sql_one = "update t_ai_daptracker set freoper = 'audit' where freoper = ' '";
        DB.execute((DBRoute)DBRoute.of((String)"fi"), (String)sql_one);
        for (String billtype : sourcebillCol) {
            this.clearHasDaptrackerData(billtype);
        }
    }

    private void clearHasDaptrackerData(String billtype) {
        String tableName = DapBuildVoucherCommonUtil.getWriteTableName((String)billtype);
        String dbRouteKey = DapBuildVoucherCommonUtil.getDBRouteKey((String)billtype);
        ArrayList<Long> sidCol = new ArrayList<Long>();
        String sql = "select fsourcebillid from " + tableName + " where foper = 'audit'";
        try (DataSet queryDataSet = DB.queryDataSet((String)algoKey, (DBRoute)DBRoute.of((String)dbRouteKey), (String)sql);){
            Iterator iterator = queryDataSet.iterator();
            while (iterator.hasNext()) {
                Long sid = ((Row)iterator.next()).getLong("fsourcebillid");
                sidCol.add(sid);
            }
        }
        if (sidCol.isEmpty()) {
            return;
        }
        HashSet<Long> need_del = new HashSet<Long>();
        List splitbatch = DapBuildVoucherCommonUtil.splitbatch(sidCol, (int)10000);
        for (List sids : splitbatch) {
            this.queryOper(need_del, sids);
        }
        if (!need_del.isEmpty()) {
            List splitSet = kd.fi.ai.util.DapBuildVoucherCommonUtil.splitSet(need_del, (int)2000);
            for (Set ids : splitSet) {
                ArrayList<Object[]> params = new ArrayList<Object[]>(ids.size());
                for (Long id : ids) {
                    params.add(new Object[]{id});
                }
                String sql_d = "delete from " + tableName + " where fsourcebillid = ?";
                this.exceteSql(DBRoute.of((String)dbRouteKey), sql_d, params);
            }
        }
    }

    private void queryOper(Set<Long> need_del, List<Object> sids) {
        SqlBuilder sbf_w = new SqlBuilder();
        sbf_w.append("select fsourcebillid from t_ai_daptracker where freoper = 'audit' and ", new Object[0]).appendIn("fsourcebillid", sids);
        try (DataSet queryDataSet = DB.queryDataSet((String)algoKey, (DBRoute)DBRoute.of((String)"fi"), (SqlBuilder)sbf_w);){
            Iterator iterator = queryDataSet.iterator();
            while (iterator.hasNext()) {
                Long sid = ((Row)iterator.next()).getLong("fsourcebillid");
                need_del.add(sid);
            }
        }
    }

    private void updateReoper(String billtype) {
        String tableName = DapBuildVoucherCommonUtil.getWriteTableName((String)billtype);
        String dbRouteKey = DapBuildVoucherCommonUtil.getDBRouteKey((String)billtype);
        String sql = "update " + tableName + " set foper = 'audit' where foper = ' '";
        DB.execute((DBRoute)DBRoute.of((String)dbRouteKey), (String)sql);
    }

    private void clearWhiteBill(String billtype) {
        String tableName = DapBuildVoucherCommonUtil.getWriteTableName((String)billtype);
        String dbRouteKey = DapBuildVoucherCommonUtil.getDBRouteKey((String)billtype);
        Calendar calender = Calendar.getInstance();
        calender.add(2, -3);
        Date datatime = new Date(calender.getTimeInMillis());
        String sql = "delete from " + tableName + " where fcreatetime <= ?";
        DB.execute((DBRoute)DBRoute.of((String)dbRouteKey), (String)sql, (Object[])new Object[]{datatime});
    }

    private void exceteSql(DBRoute route, String sql, List<Object[]> params) {
        DB.executeBatch((DBRoute)route, (String)sql, params);
    }

    private Boolean getDistributeHasDapWBill(String billtype) {
        if (StringUtils.isBlank((CharSequence)billtype)) {
            return false;
        }
        boolean exists = QueryServiceHelper.exists((String)"bos_entityobject", (Object)billtype);
        if (exists) {
            boolean exitsTable = DB.exitsTable((DBRoute)DBRoute.of((String)DapBuildVoucherCommonUtil.getDBRouteKey((String)billtype)), (String)DapBuildVoucherCommonUtil.getWriteTableName((String)billtype));
            return exitsTable;
        }
        return false;
    }
}

