/*
 * Decompiled with CFR 0.152.
 */
package kd.fi.ai.upgradeservice;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Map;
import java.util.Set;
import kd.bos.algo.DataSet;
import kd.bos.algo.Row;
import kd.bos.dataentity.utils.StringUtils;
import kd.bos.db.DB;
import kd.bos.db.DBRoute;
import kd.bos.db.SqlBuilder;
import kd.bos.entity.MainEntityType;
import kd.bos.entity.plugin.support.util.CollectionUtils;
import kd.bos.logging.Log;
import kd.bos.logging.LogFactory;
import kd.bos.service.upgrade.IUpgradeService;
import kd.bos.service.upgrade.UpgradeResult;
import kd.bos.servicehelper.DBServiceHelper;
import kd.bos.servicehelper.MetadataServiceHelper;
import kd.bos.util.ExceptionUtils;

public class BaseDataFieldUpgradeService
implements IUpgradeService {
    private static final Log log = LogFactory.getLog((String)"kd.fi.ai.upgradeservice.BaseDataMappingUpgradeService");
    private static final String ALGOKEY = "kd.fi.ai.upgradeservice.BaseDataMappingUpgradeService";
    private static final String AI = "ai";
    private static final String T_AI_BASEFIELDMAPENTRY = "t_ai_basefieldmapentry";
    private static final String SELECTSQL = "select a.fid,a.fsourcebasedata,b.fentryid,b.fsrcdatamapping from t_ai_basedatamapping a left join t_ai_basedatamappingentry b on (a.fid = b.fid ) where a.ffactorvalue = ' '";
    private static final String UPDATESQL = "update t_ai_basedatamapping set ffactorvalue = ?, ffactorname = ?, ffactorvalue_base = ? where fid = ?";
    private static final String UPDATEENTRYSQL = "update t_ai_basedatamappingentry set fsrcdatamapping0 = ?, fbdinfoimport = ? where fentryid = ?";
    private static final String INSERT_FIELD_SQL = "insert into t_ai_basefieldmapentry(fid,fentryid,fseq,fdatatype,fentityid ,ffieldname,ffieldkey) values(?,?,?,?,?,?,?)";
    private static final String SELECT_FIELDS = "fid,fnumber";
    private static final char COMMON = ':';

    public UpgradeResult beforeExecuteSqlWithResult(String ver, String iteration, String dbKey, String sqlFileName) {
        UpgradeResult result = new UpgradeResult();
        try {
            this.updateData();
            result.setSuccess(true);
            log.info("upgrade_baseDataFieldMapping_success");
        }
        catch (Exception e) {
            result.setSuccess(false);
            log.info("upgrade_baseDataFieldMapping_error:{}", (Object)ExceptionUtils.getExceptionStackTraceMessage((Exception)e));
            result.setErrorInfo("upgrade_baseDataFieldMapping_error\uff1a" + ExceptionUtils.getExceptionStackTraceMessage((Exception)e));
        }
        return result;
    }

    public void updateData() {
        HashMap<Long, String> entityNameMap = new HashMap<Long, String>(16);
        HashMap<Long, Map> entryIdMap = new HashMap<Long, Map>(16);
        try (DataSet qd = DB.queryDataSet((String)ALGOKEY, (DBRoute)DBRoute.of((String)AI), (String)SELECTSQL);){
            for (Row row : qd) {
                Long fid = row.getLong("fid");
                String sourcebasedata = row.getString("fsourcebasedata");
                if (StringUtils.isBlank((CharSequence)sourcebasedata)) continue;
                entityNameMap.putIfAbsent(fid, sourcebasedata);
                Map fentryIdMap = entryIdMap.computeIfAbsent(fid, K -> new HashMap());
                Long entryId = row.getLong("fentryid");
                if (null == entryId || 0L == entryId) continue;
                fentryIdMap.put(entryId, row.getLong("fsrcdatamapping"));
            }
        }
        for (Map.Entry entry : entryIdMap.entrySet()) {
            Long fid = (Long)entry.getKey();
            String entityNumber = (String)entityNameMap.get(fid);
            Map fentryIdMap = (Map)entry.getValue();
            if (fentryIdMap.isEmpty()) {
                this.insertBaseData(fid, entityNumber, null, null);
                continue;
            }
            HashSet<Long> souceIdSet = new HashSet<Long>(fentryIdMap.size());
            fentryIdMap.forEach((k, v) -> souceIdSet.add((Long)v));
            Map<Long, String> numberMap = this.getBaseNumberMap(entityNumber, souceIdSet);
            this.insertBaseData(fid, entityNumber, fentryIdMap, numberMap);
        }
    }

    public void insertBaseData(Long fid, String entityNumber, Map<Long, Long> fentryIdMap, Map<Long, String> numberMap) {
        String baseDataName = " ";
        try {
            MainEntityType dataEntityType = MetadataServiceHelper.getDataEntityType((String)entityNumber);
            baseDataName = dataEntityType.getDisplayName().toString();
        }
        catch (Exception e) {
            log.info("{} in BaseDataFieldUpgradeService not exist ", (Object)entityNumber);
            baseDataName = entityNumber;
        }
        if (null == fentryIdMap || null == numberMap) {
            this.insertField(fid, entityNumber, baseDataName);
            this.updateHead(fid, entityNumber, baseDataName);
            return;
        }
        this.insertField(fid, entityNumber, baseDataName);
        this.updateHead(fid, entityNumber, baseDataName);
        this.updateEntry(fid, entityNumber, fentryIdMap, numberMap);
    }

    private void updateEntry(Long fid, String entityNumber, Map<Long, Long> fentryIdMap, Map<Long, String> numberMap) {
        ArrayList<Object[]> paramList = new ArrayList<Object[]>(fentryIdMap.size());
        Long souceId = 0L;
        StringBuilder builder = null;
        for (Map.Entry<Long, Long> entry : fentryIdMap.entrySet()) {
            souceId = entry.getValue();
            builder = new StringBuilder();
            String number = StringUtils.isNotBlank((CharSequence)numberMap.get(souceId)) ? numberMap.get(souceId) : "";
            builder.append(entityNumber).append(':').append(number);
            Object[] params = new Object[]{souceId, builder.toString(), entry.getKey()};
            paramList.add(params);
        }
        if (!CollectionUtils.isEmpty(paramList)) {
            DB.executeBatch((DBRoute)DBRoute.of((String)AI), (String)UPDATEENTRYSQL, paramList);
        }
    }

    private void updateHead(Long fid, String entityNumber, String baseDataName) {
        Object[] params = new Object[]{entityNumber, baseDataName, entityNumber, fid};
        DB.execute((DBRoute)DBRoute.of((String)AI), (String)UPDATESQL, (Object[])params);
    }

    private void insertField(Long fid, String entityNumber, String baseDataName) {
        long[] entiesIds = DBServiceHelper.genLongIds((String)T_AI_BASEFIELDMAPENTRY, (int)1);
        Object[] params = new Object[]{fid, entiesIds[0], 0, 0, entityNumber, baseDataName, "srcdatamapping0"};
        DB.execute((DBRoute)DBRoute.of((String)AI), (String)INSERT_FIELD_SQL, (Object[])params);
    }

    public Map<Long, String> getBaseNumberMap(String entityNumber, Set<Long> souceIdSet) {
        HashMap<Long, String> map = new HashMap<Long, String>();
        MainEntityType dataEntityType = MetadataServiceHelper.getDataEntityType((String)entityNumber);
        String alias = dataEntityType.getAlias();
        String dbRouteKey = dataEntityType.getDBRouteKey();
        SqlBuilder sqlBuilder = new SqlBuilder();
        sqlBuilder.append("SELECT ", new Object[0]).append(SELECT_FIELDS, new Object[0]).append(" FROM ", new Object[0]).append(alias, new Object[0]).append(" WHERE ", new Object[0]).appendIn("FID", new ArrayList<Long>(souceIdSet));
        try (DataSet qd = DB.queryDataSet((String)ALGOKEY, (DBRoute)DBRoute.of((String)dbRouteKey), (SqlBuilder)sqlBuilder);){
            for (Row row : qd) {
                map.put(row.getLong("fid"), row.getString("fnumber"));
            }
        }
        return map;
    }
}

