/*
 * Decompiled with CFR 0.152.
 */
package kd.fi.ai.upgradeservice;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import kd.bos.algo.DataSet;
import kd.bos.algo.Row;
import kd.bos.db.DB;
import kd.bos.db.DBRoute;
import kd.bos.db.tx.TX;
import kd.bos.db.tx.TXHandle;
import kd.bos.logging.Log;
import kd.bos.logging.LogFactory;
import kd.bos.service.upgrade.IUpgradeService;
import kd.bos.service.upgrade.UpgradeResult;
import kd.bos.servicehelper.DBServiceHelper;
import kd.bos.util.ExceptionUtils;

public class BaseDataMappingUpgradeService
implements IUpgradeService {
    private static final Log log = LogFactory.getLog((String)"kd.fi.ai.upgradeservice.BaseDataMappingUpgradeService");
    private static final String ALGOKEY = "kd.fi.ai.upgradeservice.BaseDataMappingUpgradeService";
    private static final String SYS = "sys";
    private static final String T_BAS_IMPORTTEMPLATEENTRY = "T_BAS_IMPORTTEMPLATEENTRY";
    private static final String PRESQL = "select fid,fentryid,ffieldkey from T_BAS_IMPORTTEMPLATEENTRY where fid in (select fid from T_BAS_IMPORTTEMPLATE where fbizobject = 'ai_basedatamapping') and ffieldkey in ('ai_basedatamapping','basedataimport','entryentity') ";
    private static final String UPDATESQL = "update T_BAS_IMPORTTEMPLATEENTRY set fisimport = '0', fmustinput = '0' where fid = ? and ffieldkey in ('entryentity.id','srcdatamapping','sourcebasedata','type','useorg','mappingplugin','modifytime') ";
    private static final String INSERT_ENTRY_SQL = "INSERT INTO T_BAS_IMPORTTEMPLATEENTRY(FID, FENTRYID, FPARENTENTRYID, FSEQ, FFIELDKEY, FFIELDNAME, FMUSTINPUT, FDESCRIPTION, FISIMPORT, FISFIELD, FIMPORTPROP, FEXPORTPROP) VALUES (?, ?, ?,  ?, ? , ' ', ?, ' ', ?, ?, ' ', ' ') ";

    public UpgradeResult beforeExecuteSqlWithResult(String ver, String iteration, String dbKey, String sqlFileName) {
        UpgradeResult result = new UpgradeResult();
        try {
            this.updateData();
            result.setSuccess(true);
            log.info("upgrade_baseDataMapping_success");
        }
        catch (Exception e) {
            result.setSuccess(false);
            log.info("upgrade_baseDataMapping_error:{}", (Object)ExceptionUtils.getExceptionStackTraceMessage((Exception)e));
            result.setErrorInfo("upgrade_baseDataMapping_error\uff1a" + ExceptionUtils.getExceptionStackTraceMessage((Exception)e));
        }
        return result;
    }

    public void updateData() {
        HashMap<Long, Long> idsMap = new HashMap<Long, Long>(16);
        HashMap<Long, Long> entrysMap = new HashMap<Long, Long>(16);
        try (DataSet qd = DB.queryDataSet((String)ALGOKEY, (DBRoute)DBRoute.of((String)SYS), (String)PRESQL);){
            for (Row row : qd) {
                if ("basedataimport".equals(row.getString("ffieldkey"))) {
                    log.info("basedataimport already exists, return");
                    return;
                }
                if ("entryentity".equals(row.getString("ffieldkey"))) {
                    entrysMap.put(row.getLong("fid"), row.getLong("fentryid"));
                    continue;
                }
                idsMap.put(row.getLong("fid"), row.getLong("fentryid"));
            }
        }
        if (idsMap.isEmpty()) {
            return;
        }
        LinkedList<String> columns = new LinkedList<String>();
        columns.add("destdatanumber0");
        columns.add("destdatavalue0");
        for (int i = 0; i < 10; ++i) {
            columns.add("sourcenumber" + i);
            columns.add("sourcevalue" + i);
        }
        this.insertPreData(idsMap, columns, entrysMap);
    }

    private void insertPreData(Map<Long, Long> idsMap, List<String> columns, Map<Long, Long> entrysMap) {
        for (Map.Entry<Long, Long> map : idsMap.entrySet()) {
            TXHandle txHandle = TX.requiresNew();
            Throwable throwable = null;
            try {
                Long id = map.getKey();
                Long fparentId = map.getValue();
                int size = columns.size() + 4;
                long[] entiesIds = DBServiceHelper.genLongIds((String)T_BAS_IMPORTTEMPLATEENTRY, (int)size);
                ArrayList<Object[]> params = new ArrayList<Object[]>(size);
                this.setUpdateExcete(id);
                params.add(new Object[]{id, entiesIds[0], fparentId, 30, "factorvalue", "1", "1", "1"});
                params.add(new Object[]{id, entiesIds[1], fparentId, 31, "factorname", "1", "1", "1"});
                params.add(new Object[]{id, entiesIds[2], entrysMap.get(id), 32, "bdinfoimport", "0", "1", "1"});
                params.add(new Object[]{id, entiesIds[3], fparentId, 33, "basedataimport", "0", "0", "0"});
                int i = 4;
                for (String column : columns) {
                    params.add(new Object[]{id, entiesIds[i], entiesIds[3], 33 + i, column, "0", "1", "1"});
                    ++i;
                }
                if (params.isEmpty()) continue;
                this.setExceteBat(INSERT_ENTRY_SQL, params);
            }
            catch (Throwable throwable2) {
                throwable = throwable2;
                throw throwable2;
            }
            finally {
                if (txHandle == null) continue;
                if (throwable != null) {
                    try {
                        txHandle.close();
                    }
                    catch (Throwable throwable3) {
                        throwable.addSuppressed(throwable3);
                    }
                    continue;
                }
                txHandle.close();
            }
        }
    }

    private void setUpdateExcete(Long id) {
        DB.execute((DBRoute)DBRoute.of((String)SYS), (String)UPDATESQL, (Object[])new Object[]{id});
    }

    private void setExceteBat(String sql, List<Object[]> params) {
        DB.executeBatch((DBRoute)DBRoute.of((String)SYS), (String)sql, params);
    }
}

