/*
 * Decompiled with CFR 0.152.
 */
package kd.fi.ai.upgradeservice;

import java.util.ArrayList;
import java.util.HashSet;
import java.util.Iterator;
import kd.bos.algo.DataSet;
import kd.bos.algo.Row;
import kd.bos.db.DB;
import kd.bos.db.DBRoute;
import kd.bos.logging.Log;
import kd.bos.logging.LogFactory;
import kd.bos.service.upgrade.IUpgradeService;
import kd.bos.service.upgrade.UpgradeResult;
import kd.bos.util.ExceptionUtils;
import kd.fi.ai.dap.DapWriteAndBlackOpSetUtil;

public class DapWriteBillUpgradeService
implements IUpgradeService {
    private static final Log log = LogFactory.getLog((String)"kd.fi.ai.upgradeservice.DapWriteBillUpgradeService");
    private static final String algoKey = "kd.fi.ai.upgradeservice.DapWriteBillUpgradeService";

    public UpgradeResult beforeExecuteSqlWithResult(String ver, String iteration, String dbKey, String sqlFileName) {
        UpgradeResult result = new UpgradeResult();
        try {
            this.updateData();
            result.setSuccess(true);
            log.info("UPGRADE_VCHTEMPLATE_SUCCESS");
        }
        catch (Exception e) {
            result.setSuccess(false);
            log.info("UPGRADE_VCHTEMPLATE_ERROR");
            result.setErrorInfo("UPGRADE_VCHTEMPLATE_ERROR" + ExceptionUtils.getExceptionStackTraceMessage((Exception)e));
        }
        return result;
    }

    private void updateData() {
        ArrayList<String> billtypes = new ArrayList<String>(16);
        String sql = "select distinct fbillentity from t_ai_dapconfig where fisdap = '1'";
        try (DataSet queryDataSet = DB.queryDataSet((String)algoKey, (DBRoute)DBRoute.of((String)"fi"), (String)sql);){
            for (Row row : queryDataSet) {
                String billtype = row.getString("fbillentity");
                billtypes.add(billtype);
            }
        }
        billtypes.stream().forEach(v -> DapWriteAndBlackOpSetUtil.registerDapWriteAndBlackOpService((Boolean)true, (String)v));
        ArrayList<String> billtypesbat = new ArrayList<String>(16);
        String sql0 = "select distinct fbusiness from t_gl_businesstask ";
        try (DataSet queryDataSet = DB.queryDataSet((String)algoKey, (DBRoute)DBRoute.of((String)"fi"), (String)sql0);){
            Iterator iterator = queryDataSet.iterator();
            HashSet billTypeSet = new HashSet(billtypes);
            while (iterator.hasNext()) {
                Row row = (Row)iterator.next();
                String billtype = row.getString("fbusiness");
                if (billTypeSet.contains(billtype)) continue;
                billtypesbat.add(billtype);
            }
        }
        billtypesbat.stream().forEach(v -> DapWriteAndBlackOpSetUtil.createDapTableToBill((String)v));
    }
}

