/*
 * Decompiled with CFR 0.152.
 */
package kd.fi.ai.upgradeservice;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.Map;
import kd.bos.algo.DataSet;
import kd.bos.algo.Row;
import kd.bos.dataentity.utils.StringUtils;
import kd.bos.db.DB;
import kd.bos.db.DBRoute;
import kd.bos.logging.Log;
import kd.bos.logging.LogFactory;
import kd.bos.service.upgrade.IUpgradeService;
import kd.bos.service.upgrade.UpgradeResult;
import kd.bos.util.ExceptionUtils;

public class DeleteMultiDapConfigUpgradeService
implements IUpgradeService {
    private static final Log log = LogFactory.getLog((String)DeleteMultiDapConfigUpgradeService.class.getName());
    private static final String algoKey = "kd.fi.ai.upgradeservice.DeleteMultiDapConfigUpgradeService";

    public UpgradeResult beforeExecuteSqlWithResult(String ver, String iteration, String dbKey, String sqlFileName) {
        UpgradeResult result = new UpgradeResult();
        try {
            this.deleteData();
            result.setSuccess(true);
            log.info("UPGRADE_VCHTEMPLATE_SUCCESS");
        }
        catch (Exception e) {
            result.setSuccess(false);
            log.info("UPGRADE_VCHTEMPLATE_ERROR");
            result.setErrorInfo("UPGRADE_VCHTEMPLATE_ERROR" + ExceptionUtils.getExceptionStackTraceMessage((Exception)e));
        }
        return result;
    }

    private void deleteData() {
        String sql = "select fid as id,fbillentity as billtype,fwritebackplugin as wp from t_ai_dapconfig where fbillentity != 'ai_eventclass' order by fbillentity";
        ArrayList<Long[]> params = new ArrayList<Long[]>(16);
        HashMap checkDataCol = new HashMap();
        HashMap<String, String> cc = new HashMap<String, String>(3);
        try (DataSet queryDataSet = DB.queryDataSet((String)algoKey, (DBRoute)DBRoute.of((String)"fi"), (String)sql);){
            for (Row next : queryDataSet) {
                Object id = next.get("id");
                Object billtype = next.get("billtype");
                Object wp = next.get("wp");
                if (checkDataCol.containsKey(billtype)) {
                    Map map = (Map)checkDataCol.get(billtype);
                    String wpc = (String)map.get("wp");
                    if (StringUtils.isBlank((CharSequence)wpc) && StringUtils.isNotBlank((Object)wp)) {
                        params.add(new Long[]{Long.parseLong((String)map.get("id"))});
                        cc.clear();
                        cc.put("id", id.toString());
                        cc.put("billtype", billtype.toString());
                        cc.put("wp", wp != null ? wp.toString() : "");
                        checkDataCol.put(billtype.toString(), cc);
                        continue;
                    }
                    params.add(new Long[]{Long.parseLong(id.toString())});
                    continue;
                }
                cc.clear();
                cc.put("id", id.toString());
                cc.put("billtype", billtype.toString());
                cc.put("wp", wp != null ? wp.toString() : "");
                checkDataCol.put(billtype.toString(), cc);
            }
        }
        if (!params.isEmpty()) {
            String delSql = "delete from t_ai_dapconfig where fid = ?";
            DB.executeBatch((DBRoute)DBRoute.of((String)"fi"), (String)delSql, params);
        }
    }
}

