/*
 * Decompiled with CFR 0.152.
 */
package kd.fi.ai.upgradeservice;

import java.util.ArrayList;
import java.util.Calendar;
import java.util.Date;
import java.util.GregorianCalendar;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import kd.bos.algo.DataSet;
import kd.bos.algo.Row;
import kd.bos.db.DB;
import kd.bos.db.DBRoute;
import kd.bos.db.SqlBuilder;
import kd.bos.logging.Log;
import kd.bos.logging.LogFactory;
import kd.bos.orm.query.QFilter;
import kd.bos.service.upgrade.IUpgradeService;
import kd.bos.service.upgrade.UpgradeResult;
import kd.bos.servicehelper.QueryServiceHelper;
import kd.bos.util.ExceptionUtils;
import kd.fi.ai.event.AiEventUtil;
import kd.fi.ai.util.DapBuildVoucherCommonUtil;
import kd.fi.v2.fah.constant.enums.AppVersionEnum;
import kd.fi.v2.fah.dao.datamodel.DataModelDaoImpl;

public class FahExtHistDataUpgradeService
implements IUpgradeService {
    private static final Log log = LogFactory.getLog(FahExtHistDataUpgradeService.class);
    private static final String algoKey = "kd.fi.ai.upgradeservice.FahExtHistDataUpgradeService";

    public UpgradeResult beforeExecuteSqlWithResult(String ver, String iteration, String dbKey, String sqlFileName) {
        UpgradeResult result = new UpgradeResult();
        result.setSuccess(true);
        try {
            GregorianCalendar calendar = new GregorianCalendar();
            calendar.setTime(new Date());
            ((Calendar)calendar).add(2, -3);
            SqlBuilder sqlBuilder = new SqlBuilder();
            sqlBuilder.append("select count(1) as idCount from t_ai_event where fcreatetime >= ?", new Object[]{calendar.getTime()});
            Integer idCount = (Integer)DB.query((DBRoute)DBRoute.of((String)"ai"), (SqlBuilder)sqlBuilder, resultSet -> {
                if (resultSet.next()) {
                    return resultSet.getInt("idCount");
                }
                return 0;
            });
            if (idCount > 100000) {
                log.info("FahExtHistDataUpgradeService: size of AI_EVENT(EXT_DATA) history data is too large, size: " + idCount);
                return result;
            }
            sqlBuilder = new SqlBuilder();
            sqlBuilder.append("select e.fid id, ec.fnumber eventclassnum, ec.fappversion appversion from t_ai_event e inner join t_ai_eventclass ec on e.feventclass = ec.fid where e.fcreatetime >= ?", new Object[]{calendar.getTime()});
            HashMap<String, List> groupByBillType = new HashMap<String, List>(8);
            DataSet events = DB.queryDataSet((String)algoKey, (DBRoute)DBRoute.of((String)"ai"), (SqlBuilder)sqlBuilder);
            Object object = null;
            try {
                for (Row event : events) {
                    long id = event.getLong("id");
                    String appVersion = event.getString("appversion");
                    String billType = DataModelDaoImpl.getMetaEntityNumber((String)event.getString("eventclassnum"));
                    if (!String.valueOf(AppVersionEnum.NEW_APP.getCode()).equals(appVersion)) {
                        billType = "ai_event";
                    }
                    groupByBillType.computeIfAbsent(billType, k -> new ArrayList(8)).add(id);
                }
            }
            catch (Throwable throwable) {
                object = throwable;
                throw throwable;
            }
            finally {
                if (events != null) {
                    if (object != null) {
                        try {
                            events.close();
                        }
                        catch (Throwable throwable) {
                            ((Throwable)object).addSuppressed(throwable);
                        }
                    } else {
                        events.close();
                    }
                }
            }
            HashSet<Long> hasVchIds = new HashSet<Long>();
            for (Map.Entry entry : groupByBillType.entrySet()) {
                List ids = (List)entry.getValue();
                QFilter billTypeNumFilter = new QFilter("billtype.number", "=", entry.getKey());
                if (ids.size() > 1998) {
                    List partition = DapBuildVoucherCommonUtil.splitbatch((List)ids, (int)999);
                    for (List prtIds : partition) {
                        QFilter srcBillIdFilter = new QFilter("sourcebillid", "in", (Object)prtIds);
                        DataSet rows = QueryServiceHelper.queryDataSet((String)algoKey, (String)"ai_daptracker", (String)"voucherid,sourcebillid", (QFilter[])new QFilter[]{billTypeNumFilter, srcBillIdFilter}, null);
                        Throwable throwable = null;
                        try {
                            for (Row row : rows) {
                                if (row.getLong("voucherid") == 0L) continue;
                                hasVchIds.add(row.getLong("sourcebillid"));
                            }
                        }
                        catch (Throwable throwable2) {
                            throwable = throwable2;
                            throw throwable2;
                        }
                        finally {
                            if (rows == null) continue;
                            if (throwable != null) {
                                try {
                                    rows.close();
                                }
                                catch (Throwable throwable3) {
                                    throwable.addSuppressed(throwable3);
                                }
                                continue;
                            }
                            rows.close();
                        }
                    }
                    continue;
                }
                QFilter srcBillIdFilter = new QFilter("sourcebillid", "in", (Object)ids);
                DataSet rows = QueryServiceHelper.queryDataSet((String)algoKey, (String)"ai_daptracker", (String)"voucherid,sourcebillid", (QFilter[])new QFilter[]{billTypeNumFilter, srcBillIdFilter}, null);
                Throwable throwable = null;
                try {
                    for (Row row : rows) {
                        if (row.getLong("voucherid") == 0L) continue;
                        hasVchIds.add(row.getLong("sourcebillid"));
                    }
                }
                catch (Throwable throwable4) {
                    throwable = throwable4;
                    throw throwable4;
                }
                finally {
                    if (rows == null) continue;
                    if (throwable != null) {
                        try {
                            rows.close();
                        }
                        catch (Throwable throwable5) {
                            throwable.addSuppressed(throwable5);
                        }
                        continue;
                    }
                    rows.close();
                }
            }
            if (hasVchIds.isEmpty()) {
                log.info("FahExtHistDataUpgradeService: There is  no data to upgrade in AI_EVENT(EXT_DATA) history data");
                return result;
            }
            AiEventUtil.updateHasVoucher(new ArrayList(hasVchIds), (boolean)true);
            log.info("FahExtHistDataUpgradeService: AI_EVENT(EXT_DATA) history data upgraded success");
        }
        catch (Exception e) {
            result.setSuccess(false);
            log.info("FahExtHistDataUpgradeService: AI_EVENT(EXT_DATA) history data upgraded error");
            result.setErrorInfo(ExceptionUtils.getExceptionStackTraceMessage((Exception)e));
        }
        return result;
    }
}

