/*
 * Decompiled with CFR 0.152.
 */
package kd.fi.ai.upgradeservice;

import java.io.BufferedInputStream;
import java.io.BufferedReader;
import java.io.FileInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.text.ParseException;
import java.text.SimpleDateFormat;
import java.util.ArrayList;
import java.util.Date;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.zip.ZipEntry;
import java.util.zip.ZipInputStream;
import kd.bos.algo.DataSet;
import kd.bos.algo.Row;
import kd.bos.dataentity.OperateOption;
import kd.bos.dataentity.TypesContainer;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.entity.DynamicObjectCollection;
import kd.bos.dataentity.entity.ILocaleString;
import kd.bos.dataentity.entity.ILocaleValue;
import kd.bos.dataentity.entity.LocaleString;
import kd.bos.dataentity.metadata.IDataEntityProperty;
import kd.bos.dataentity.metadata.clr.DataEntityPropertyCollection;
import kd.bos.dataentity.metadata.dynamicobject.DynamicLocaleProperty;
import kd.bos.db.DB;
import kd.bos.db.DBRoute;
import kd.bos.db.SqlBuilder;
import kd.bos.entity.property.MulBasedataProp;
import kd.bos.entity.property.MuliLangTextProp;
import kd.bos.logging.Log;
import kd.bos.logging.LogFactory;
import kd.bos.orm.ORM;
import kd.bos.orm.query.QFilter;
import kd.bos.service.upgrade.IUpgradeService;
import kd.bos.service.upgrade.UpgradeResult;
import kd.bos.servicehelper.BusinessDataServiceHelper;
import kd.bos.servicehelper.QueryServiceHelper;
import kd.bos.servicehelper.operation.OperationServiceHelper;
import kd.bos.util.ExceptionUtils;
import kd.fi.ai.VCHTemplate;
import kd.fi.ai.convert.VchTemplateConvertHelper;
import kd.fi.ai.util.DapFileUtil;
import kd.fi.ai.util.VchTemplateUtils;

public class PreAiDataUpgradeService
implements IUpgradeService {
    private static final Log log = LogFactory.getLog((String)"kd.fi.ai.upgradeservice.PreAiDataUpgradeService");
    private static final String fileName = "fi-ai-predata-xingkongqijianban.sql";
    private static final String fileName_vch = "fi-ai-predata-vchtemplate.zip";
    private Set<String> notNeedImport = new HashSet<String>(65);
    private List<String> needChangeDateAndCreator = new ArrayList<String>(65);

    public UpgradeResult beforeExecuteSqlWithResult(String ver, String iteration, String dbKey, String sqlFileName) {
        UpgradeResult result = new UpgradeResult();
        try {
            this.preData();
            result.setSuccess(true);
            log.info("UPGRADE_VCHTEMPLATE_SUCCESS");
        }
        catch (Exception e) {
            result.setSuccess(false);
            log.info("UPGRADE_VCHTEMPLATE_ERROR");
            result.setErrorInfo("UPGRADE_VCHTEMPLATE_ERROR" + ExceptionUtils.getExceptionStackTraceMessage((Exception)e));
        }
        return result;
    }

    private void preData() {
        Object nc;
        Map<String, Object> changeVchTemplateControl = this.changeVchTemplateControl();
        if (this.checkNeedInsertData_km()) {
            List<String> sqlFile = this.readSQLFile(fileName);
            PreAiDataUpgradeService.executeSqls(sqlFile);
        }
        if (this.checkNeedInsertData_vch()) {
            this.importVchtemplate(fileName_vch);
        }
        if (((Boolean)(nc = changeVchTemplateControl.get("needChange"))).booleanValue()) {
            this.returnVchTemplateControl(changeVchTemplateControl);
        }
        if (!this.needChangeDateAndCreator.isEmpty()) {
            this.changeVchtemplateDateAndCreator();
        }
        VchTemplateUtils.exceteChangeData((Boolean)false);
    }

    private void changeVchtemplateDateAndCreator() {
        SimpleDateFormat sdf = new SimpleDateFormat("yyyy-MM-dd HH:mm:ss");
        Date parse = new Date();
        try {
            parse = sdf.parse("2018-08-08  18:08:08");
        }
        catch (ParseException e) {
            log.error("--DAP--" + ExceptionUtils.getExceptionStackTraceMessage((Exception)e));
        }
        Long creator = 1L;
        String sql = "update t_ai_vchtemplate set fcreatorid = ? , fcreatetime = ? , fmodifierid = ? , fmodifytime = ? where fnumber = ?";
        ArrayList<Object[]> params = new ArrayList<Object[]>(this.needChangeDateAndCreator.size());
        for (String ncd : this.needChangeDateAndCreator) {
            params.add(new Object[]{creator, parse, creator, parse, ncd});
        }
        DB.executeBatch((DBRoute)DBRoute.of((String)"ai"), (String)sql, params);
    }

    private void returnVchTemplateControl(Map<String, Object> changeVchTemplateControl) {
        Boolean isEntry = (Boolean)changeVchTemplateControl.get("isEntry");
        String ctrl = (String)changeVchTemplateControl.get("ctrl");
        Long entryid = 0L;
        if (isEntry.booleanValue()) {
            entryid = (Long)changeVchTemplateControl.get("entryid");
        }
        String sql = "";
        if (isEntry.booleanValue()) {
            sql = "update T_BD_CtrlStrategyDetail set FCtrlStrategy = ? where fid = ?";
            DB.execute((DBRoute)DBRoute.of((String)"sys"), (String)sql, (Object[])new Object[]{ctrl, entryid});
        } else {
            sql = "update T_BD_DefaultCtrlStrategy set FDefaultCtrlStrategy = ? where fbasedataid = 'ai_vchtemplate';";
            DB.execute((DBRoute)DBRoute.of((String)"sys"), (String)sql, (Object[])new Object[]{ctrl});
        }
    }

    private Map<String, Object> changeVchTemplateControl() {
        boolean needChange;
        DataSet queryDataSet;
        Object iterator;
        String sql = "select b.fid id from t_bd_basedataview a left join T_BD_CtrlStrategy b on b.FBaseDataViewID = a.fid where a.fbasedataid = 'ai_vchtemplate' and b.FCUID = '100000';";
        Long entryid = null;
        String ctrl = "";
        try (DataSet queryDataSet2 = DB.queryDataSet((String)"kd.fi.ai.upgradeservice.PreAiDataUpgradeService", (DBRoute)DBRoute.of((String)"sys"), (String)sql);){
            iterator = queryDataSet2.iterator();
            while (iterator.hasNext()) {
                entryid = ((Row)iterator.next()).getLong("id");
            }
        }
        Boolean isEntry = entryid != null;
        if (isEntry.booleanValue()) {
            sql = "select FCtrlStrategy ct from T_BD_CtrlStrategyDetail where fid = ?";
            queryDataSet = DB.queryDataSet((String)"kd.fi.ai.upgradeservice.PreAiDataUpgradeService", (DBRoute)DBRoute.of((String)"sys"), (String)sql, (Object[])new Object[]{entryid});
            iterator = null;
            try {
                Iterator iterator2 = queryDataSet.iterator();
                while (iterator2.hasNext()) {
                    ctrl = ((Row)iterator2.next()).getString("ct");
                }
            }
            catch (Throwable iterator2) {
                iterator = iterator2;
                throw iterator2;
            }
            finally {
                if (queryDataSet != null) {
                    if (iterator != null) {
                        try {
                            queryDataSet.close();
                        }
                        catch (Throwable iterator2) {
                            ((Throwable)iterator).addSuppressed(iterator2);
                        }
                    } else {
                        queryDataSet.close();
                    }
                }
            }
        }
        sql = "select FDefaultCtrlStrategy ct from T_BD_DefaultCtrlStrategy where fbasedataid = 'ai_vchtemplate';";
        queryDataSet = DB.queryDataSet((String)"kd.fi.ai.upgradeservice.PreAiDataUpgradeService", (DBRoute)DBRoute.of((String)"sys"), (String)sql);
        iterator = null;
        try {
            Iterator iterator3 = queryDataSet.iterator();
            while (iterator3.hasNext()) {
                ctrl = ((Row)iterator3.next()).getString("ct");
            }
        }
        catch (Throwable throwable) {
            iterator = throwable;
            throw throwable;
        }
        finally {
            if (queryDataSet != null) {
                if (iterator != null) {
                    try {
                        queryDataSet.close();
                    }
                    catch (Throwable throwable) {
                        ((Throwable)iterator).addSuppressed(throwable);
                    }
                } else {
                    queryDataSet.close();
                }
            }
        }
        boolean bl = needChange = !ctrl.equals("5");
        if (needChange) {
            if (isEntry.booleanValue()) {
                sql = "update T_BD_CtrlStrategyDetail set FCtrlStrategy = '5' where fid = ?";
                DB.execute((DBRoute)DBRoute.of((String)"sys"), (String)sql, (Object[])new Object[]{entryid});
            } else {
                sql = "update T_BD_DefaultCtrlStrategy set FDefaultCtrlStrategy = '5' where fbasedataid = 'ai_vchtemplate';";
                DB.execute((DBRoute)DBRoute.of((String)"sys"), (String)sql);
            }
        }
        HashMap<String, Object> result = new HashMap<String, Object>(4);
        result.put("isEntry", isEntry);
        result.put("needChange", needChange);
        result.put("ctrl", ctrl);
        result.put("entryid", entryid);
        return result;
    }

    private boolean checkNeedInsertData_vch() {
        List<Object> numbercol = PreAiDataUpgradeService.getVchNumber();
        HashSet<String> result = new HashSet<String>(65);
        SqlBuilder sbf = new SqlBuilder();
        sbf.append("select fnumber,fid from t_ai_vchtemplate where ", new Object[0]).appendIn("fnumber", numbercol);
        try (DataSet queryDataSet = DB.queryDataSet((String)"", (DBRoute)DBRoute.of((String)"fi"), (SqlBuilder)sbf);){
            for (Row row : queryDataSet) {
                result.add(row.getString("fnumber"));
            }
        }
        boolean exists_vch = result.size() == numbercol.size();
        this.notNeedImport = result;
        boolean exists_at = QueryServiceHelper.exists((String)"bd_accounttable", (Object)1318154893474663424L);
        return !exists_vch && exists_at;
    }

    private boolean checkNeedInsertData_km() {
        long[] ids = new long[]{1332643022466189312L, 1342772280308008960L, 1342772282765871104L, 1332621648066513920L, 1336934089269184512L, 1336982180965911552L};
        boolean exists_km = QueryServiceHelper.exists((String)"ai_accountmaptype", (QFilter[])new QFilter("id", "in", (Object)ids).toArray());
        boolean exists_at = QueryServiceHelper.exists((String)"bd_accounttable", (Object)1318154893474663424L);
        return !exists_km && exists_at;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private List<String> readSQLFile(String filename) {
        String className = Thread.currentThread().getStackTrace()[3].getClassName();
        ArrayList<String> result = new ArrayList<String>(100);
        InputStream sqlFileStream = null;
        String path = "/D:/2022-03-10-patch/310new-patch-code/fi-ai-upgradeservice";
        try {
            sqlFileStream = new FileInputStream(path + "/src/main/java/resources/" + filename);
        }
        catch (Exception exception) {
            // empty catch block
        }
        if (sqlFileStream == null) {
            try {
                sqlFileStream = Class.forName(className).getResourceAsStream("/resources/" + filename);
            }
            catch (Exception ex) {
                log.info("--DAP--" + ExceptionUtils.getExceptionStackTraceMessage((Exception)ex));
                return result;
            }
        }
        if (sqlFileStream != null) {
            try (InputStreamReader isr = new InputStreamReader(sqlFileStream, "UTF-8");
                 BufferedReader br = new BufferedReader(isr);){
                String line = "";
                while ((line = br.readLine()) != null) {
                    line = line.trim();
                    result.add(line);
                }
            }
            catch (Exception e) {
                log.info("--DAP--" + ExceptionUtils.getExceptionStackTraceMessage((Exception)e));
            }
            finally {
                if (sqlFileStream != null) {
                    try {
                        sqlFileStream.close();
                    }
                    catch (IOException e) {
                        log.info("--updatevchtemplate--" + ExceptionUtils.getExceptionStackTraceMessage((Exception)e));
                    }
                }
            }
        }
        return result;
    }

    private static void executeSqls(List<String> sqlLst) {
        for (String sql : sqlLst) {
            if (sql.length() == 0 || sql.startsWith("--")) continue;
            PreAiDataUpgradeService.excsql(sql);
        }
    }

    private static void excsql(String sql) {
        DB.execute((DBRoute)DBRoute.of((String)"ai"), (String)sql);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void importVchtemplate(String file) {
        int limitsiz = 0x500000;
        String jsonFileSuffix = ".xml";
        DapFileUtil.setOrgId((Long)100000L);
        ZipEntry zipEntry = null;
        ZipInputStream zipIn = null;
        try {
            InputStream in = null;
            try {
                String path = "/D:/2022-03-10-patch/310new-patch-code/fi-ai-upgradeservice/";
                String new_path = path + "src/main/java/resources/" + file;
                in = new BufferedInputStream(new FileInputStream(new_path));
                zipIn = new ZipInputStream(in);
            }
            catch (Exception e) {
                Class<?> clazz = null;
                String className = Thread.currentThread().getStackTrace()[3].getClassName();
                clazz = Class.forName(className);
                String newFileName = "/resources/" + file;
                in = clazz.getResourceAsStream(newFileName);
                zipIn = new ZipInputStream(in);
            }
        }
        catch (Exception e) {
            log.info("--updatevchtemplate--" + ExceptionUtils.getExceptionStackTraceMessage((Exception)e));
        }
        try {
            if (zipIn != null) {
                while ((zipEntry = zipIn.getNextEntry()) != null) {
                    if (zipEntry.isDirectory()) continue;
                    String metaName = zipEntry.getName();
                    int readLength = 0;
                    int len = 0;
                    byte[] buf = new byte[limitsiz];
                    if (!metaName.endsWith(jsonFileSuffix)) continue;
                    while ((readLength = zipIn.read()) != -1) {
                        buf[len] = (byte)readLength;
                        ++len;
                    }
                    String content = new String(buf, 0, len);
                    DynamicObject template = (DynamicObject)VchTemplateConvertHelper.formatXML((String)"ai_vchtemplate", (String)content);
                    if (template == null || this.notNeedImport.contains(template.getString("number"))) continue;
                    this.needChangeDateAndCreator.add(template.getString("number"));
                    DataEntityPropertyCollection properties = template.getDynamicObjectType().getProperties();
                    DynamicObject newTemp = PreAiDataUpgradeService.createDynamicObject(template);
                    for (IDataEntityProperty prop : properties) {
                        if (template.getDynamicObjectType().getPrimaryKey().equals(prop) || prop instanceof DynamicLocaleProperty) continue;
                        if (prop instanceof MuliLangTextProp) {
                            ILocaleString value = (ILocaleString)template.get(prop);
                            LocaleString newLoc = (LocaleString)TypesContainer.createInstance(LocaleString.class);
                            newLoc.setLocaleValue_en(value.getLocaleValue_en());
                            newLoc.setLocaleValue_zh_CN(value.getLocaleValue_zh_CN());
                            newLoc.setLocaleValue_zh_TW(value.getLocaleValue_zh_TW());
                            newTemp.set(prop, (Object)newLoc);
                            continue;
                        }
                        if (prop instanceof MulBasedataProp) {
                            DynamicObjectCollection m = (DynamicObjectCollection)template.get(prop);
                            for (DynamicObject d : m) {
                                d.set("pkid", null);
                                Object baseid = d.get("fbasedataid_id");
                                d.set("fbasedataid_id", null);
                                d.set("fbasedataid_id", baseid);
                                Object basedata = d.get("fbasedataid");
                                d.set("fbasedataid", null);
                                d.set("fbasedataid", basedata);
                            }
                            newTemp.set(prop, (Object)m);
                            continue;
                        }
                        newTemp.set(prop, template.get(prop));
                    }
                    newTemp.set("ctrlstrategy", (Object)"");
                    String billno = newTemp.getString("number");
                    if (QueryServiceHelper.exists((String)"ai_vchtemplate", (QFilter[])new QFilter[]{new QFilter("number", "=", (Object)billno)})) {
                        newTemp.set("number", (Object)(billno + "#"));
                        PreAiDataUpgradeService.createNewBillNo(newTemp);
                    }
                    DynamicObject org = BusinessDataServiceHelper.newDynamicObject((String)"bos_org");
                    org.set("id", (Object)100000L);
                    newTemp.set("createorg", (Object)org);
                    newTemp.set("org", (Object)org);
                    OperationServiceHelper.executeOperate((String)"save", (String)"ai_vchtemplate", (DynamicObject[])new DynamicObject[]{newTemp}, (OperateOption)OperateOption.create());
                }
            }
        }
        catch (IOException e) {
            log.info("--updatevchtemplate--" + ExceptionUtils.getExceptionStackTraceMessage((Exception)e));
        }
        finally {
            if (zipIn != null) {
                try {
                    zipIn.close();
                }
                catch (IOException e) {
                    log.info("--updatevchtemplate--" + ExceptionUtils.getExceptionStackTraceMessage((Exception)e));
                }
            }
        }
    }

    private static DynamicObject createDynamicObject(DynamicObject template) {
        ORM orm = ORM.create();
        return orm.newDynamicObject(template.getDynamicObjectType());
    }

    private static void createNewBillNo(DynamicObject newTemp) {
        String billno = newTemp.getString("number");
        if (QueryServiceHelper.exists((String)"ai_vchtemplate", (QFilter[])new QFilter[]{new QFilter("number", "=", (Object)billno)})) {
            newTemp.set("number", (Object)(billno + "#"));
            PreAiDataUpgradeService.createNewBillNo(newTemp);
        } else {
            String toJson = newTemp.getString("fxml");
            ILocaleValue langJsons = (ILocaleValue)newTemp.get("fxmllang");
            VCHTemplate vchTemplate = VCHTemplate.deserializeFromString((String)toJson, (Map)langJsons);
            vchTemplate.setBillNo(billno);
            Map jsonDatas = vchTemplate.serializeToString();
            newTemp.set("fxml", jsonDatas.get("json"));
        }
    }

    private static List<Object> getVchNumber() {
        ArrayList<Object> numbercol = new ArrayList<Object>(65);
        numbercol.add("AP004");
        numbercol.add("CH017");
        numbercol.add("GDZC003");
        numbercol.add("CH002");
        numbercol.add("GDZC004");
        numbercol.add("GDZC005");
        numbercol.add("GDZC006");
        numbercol.add("AR002");
        numbercol.add("AR006");
        numbercol.add("CH006");
        numbercol.add("CH019");
        numbercol.add("CH018");
        numbercol.add("GDZC002");
        numbercol.add("AP005");
        numbercol.add("AP008");
        numbercol.add("AR001");
        numbercol.add("AR007");
        numbercol.add("CN001");
        numbercol.add("CN008");
        numbercol.add("PJ001");
        numbercol.add("FYHS003");
        numbercol.add("GDZC007");
        numbercol.add("GDZC008");
        numbercol.add("FYHS004");
        numbercol.add("FYHS006");
        numbercol.add("CN011");
        numbercol.add("FYHS007");
        numbercol.add("FYHS002");
        numbercol.add("FYHS001");
        numbercol.add("CN002");
        numbercol.add("CH012");
        numbercol.add("CH014");
        numbercol.add("CH001");
        numbercol.add("AP006");
        numbercol.add("CH013");
        numbercol.add("CH003");
        numbercol.add("CH004");
        numbercol.add("CH007");
        numbercol.add("CH008");
        numbercol.add("CH009");
        numbercol.add("CH011");
        numbercol.add("CN006");
        numbercol.add("AP007");
        numbercol.add("AP003");
        numbercol.add("CH005");
        numbercol.add("CH015");
        numbercol.add("AR003");
        numbercol.add("AR004");
        numbercol.add("CN003");
        numbercol.add("CN005");
        numbercol.add("CN007");
        numbercol.add("CN010");
        numbercol.add("CN012");
        numbercol.add("CN013");
        numbercol.add("CN004");
        numbercol.add("CH010");
        numbercol.add("FYHS005");
        numbercol.add("GDZC001");
        numbercol.add("AP001");
        numbercol.add("CH021");
        numbercol.add("FYHS008");
        numbercol.add("AP002");
        numbercol.add("CN009");
        numbercol.add("CH020");
        numbercol.add("CH016");
        return numbercol;
    }
}

