/*
 * Decompiled with CFR 0.152.
 */
package kd.fi.ai.upgradeservice;

import java.util.Date;
import java.util.List;
import java.util.Map;
import kd.bos.context.RequestContext;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.metadata.IDataEntityType;
import kd.bos.dataentity.metadata.dynamicobject.DynamicObjectType;
import kd.bos.db.tx.TX;
import kd.bos.db.tx.TXHandle;
import kd.bos.entity.EntityMetadataCache;
import kd.bos.entity.MainEntityType;
import kd.bos.entity.property.BasedataProp;
import kd.bos.ext.fi.ai.BookdateReconds;
import kd.bos.ext.fi.ai.BookdateRecondsParam;
import kd.bos.ext.fi.ai.VoucherOperation;
import kd.bos.kdtx.common.exception.NoRetryException;
import kd.bos.kdtx.common.invoke.DtxResponse;
import kd.bos.kdtx.sdk.api.EventualConsistencyService;
import kd.bos.logging.Log;
import kd.bos.logging.LogFactory;
import kd.bos.servicehelper.operation.DeleteServiceHelper;
import kd.bos.servicehelper.operation.SaveServiceHelper;

public class TransbookdateUtilService
extends EventualConsistencyService {
    private static Log logger = LogFactory.getLog(TransbookdateUtilService.class);

    public DtxResponse execute(Object param, Object lastReturn) throws Exception {
        logger.info("enter TransbookdateUtilService execute.. .");
        BookdateRecondsParam params = (BookdateRecondsParam)param;
        try (TXHandle x = TX.requiresNew();){
            try {
                if (params.getOperation().equals((Object)VoucherOperation.TransBookdate)) {
                    TransbookdateUtilService.insertReconds(params.getMap(), params.getList());
                } else if (params.getOperation().equals((Object)VoucherOperation.BackTransBookdate)) {
                    TransbookdateUtilService.deleteReconds(params.getMap(), params.getList());
                }
            }
            catch (Throwable cause) {
                logger.error("#" + params.getList() + "#\u8f6c\u5165\u4e0b\u6708\u6216\u8005\u53d6\u6d88\u8f6c\u5165\u4e0b\u6708\u8c03\u7528\u5931\u8d25###");
                logger.error(cause);
                x.markRollback();
                throw new NoRetryException("invoke TransbookdateUtilService fail", cause);
            }
        }
        logger.info("finish TransbookdateUtilService execute.");
        return null;
    }

    public static void insertReconds(Map<Long, BookdateReconds> map, List<Long> list) {
        DynamicObject[] bookdates = new DynamicObject[list.size()];
        MainEntityType mainEntityType = EntityMetadataCache.getDataEntityType((String)"ai_bookdatereconds");
        for (int i = 0; i < list.size(); ++i) {
            Long id = list.get(i);
            DynamicObject object = TransbookdateUtilService.createReconds(mainEntityType);
            object.set("sourcebillid", (Object)id);
            object.set("billno", (Object)id);
            object.set("billtype", (Object)map.get(id).getBilltype());
            object.set("oldbookdate", (Object)map.get(id).getOldbookdate());
            object.set("bookdate", (Object)map.get(id).getBookdate());
            object.set("index", (Object)map.get(id).getIndex());
            bookdates[i] = object;
        }
        SaveServiceHelper.save((DynamicObject[])bookdates);
    }

    public static void deleteReconds(Map<Long, BookdateReconds> map, List<Long> list) {
        Object[] bookdates = new DynamicObject[list.size()];
        MainEntityType mainEntityType = EntityMetadataCache.getDataEntityType((String)"ai_bookdatereconds");
        for (int i = 0; i < list.size(); ++i) {
            Long id = list.get(i);
            DynamicObject object = TransbookdateUtilService.createReconds(mainEntityType);
            object.set("id", (Object)id);
            bookdates[i] = object;
        }
        DeleteServiceHelper.delete((IDataEntityType)mainEntityType, (Object[])bookdates);
    }

    private static DynamicObject createReconds(MainEntityType type) {
        DynamicObject reconds = new DynamicObject((DynamicObjectType)type);
        reconds.set("billstatus", (Object)"C");
        String currUserId = RequestContext.get().getUserId();
        BasedataProp creatorProp = (BasedataProp)type.getProperty("creator");
        creatorProp.getRefIdProp().setValue((Object)reconds, (Object)currUserId);
        reconds.set("createtime", (Object)new Date());
        reconds.set("modifytime", (Object)new Date());
        return reconds;
    }
}

