/*
 * Decompiled with CFR 0.152.
 */
package kd.fi.ai.upgradeservice;

import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.entity.ILocaleValue;
import kd.bos.dataentity.entity.LocaleString;
import kd.bos.logging.Log;
import kd.bos.logging.LogFactory;
import kd.bos.orm.query.QFilter;
import kd.bos.service.upgrade.IUpgradeService;
import kd.bos.service.upgrade.UpgradeResult;
import kd.bos.servicehelper.BusinessDataServiceHelper;
import kd.bos.servicehelper.operation.SaveServiceHelper;
import kd.bos.util.StringUtils;
import kd.fi.ai.AbstractVchTplAsst;
import kd.fi.ai.AbstractVchTplItemMap;
import kd.fi.ai.VCHTemplate;
import kd.fi.ai.VchTplAgrs;
import kd.fi.ai.VchTplAgrss;
import kd.fi.ai.VchTplAsst;
import kd.fi.ai.VchTplBizGroup;
import kd.fi.ai.VchTplEntry;
import kd.fi.ai.VchTplMainAsst;

public class VchTempAsstnumUpgradeService
implements IUpgradeService {
    private static final Log log = LogFactory.getLog((String)"kd.fi.ai.upgradeservice.VchTempAsstnumUpgradeService");

    public UpgradeResult beforeExecuteSqlWithResult(String ver, String iteration, String dbKey, String sqlFileName) {
        UpgradeResult upgradeResult = new UpgradeResult();
        DynamicObject[] vchTemplates = BusinessDataServiceHelper.load((String)"ai_vchtemplate", (String)"fxml,fxmllang", null);
        if (vchTemplates.length == 0) {
            return upgradeResult;
        }
        ArrayList<DynamicObject> result = new ArrayList<DynamicObject>(vchTemplates.length);
        for (DynamicObject vchTemplateinfo : vchTemplates) {
            Map jsonDatas;
            String json = vchTemplateinfo.getString("fxml");
            ILocaleValue langJsons = (ILocaleValue)vchTemplateinfo.get("fxmllang");
            VCHTemplate vchTemplate = null;
            try {
                vchTemplate = VCHTemplate.deserializeFromString((String)json, (Map)langJsons);
                List bizGroups = vchTemplate.getBizGroups();
                for (VchTplBizGroup vchTplBizGroup : bizGroups) {
                    List vchEntrys = vchTplBizGroup.getVchEntrys();
                    for (VchTplEntry vchEntry : vchEntrys) {
                        VchTplAsst vchTplAsst = vchEntry.getAsst();
                        VchTplMainAsst vchTplMainAsst = vchEntry.getMainAsst();
                        this.handleAsstValue((AbstractVchTplAsst)vchTplAsst);
                        this.handleAsstValue((AbstractVchTplAsst)vchTplMainAsst);
                    }
                }
            }
            catch (Throwable e) {
                log.info("\u51ed\u8bc1\u6a21\u677f\u6838\u7b97\u7ef4\u5ea6\u6570\u636e\u5347\u7ea7\u5931\u8d25");
            }
            if (vchTemplate == null || (jsonDatas = vchTemplate.serializeToString()) == null) continue;
            langJsons = new LocaleString();
            for (Map.Entry entry : jsonDatas.entrySet()) {
                if (((String)entry.getKey()).equalsIgnoreCase("json")) continue;
                langJsons.setItem((String)entry.getKey(), entry.getValue());
            }
            vchTemplateinfo.set("fxml", jsonDatas.get("json"));
            vchTemplateinfo.set("fxmllang", (Object)langJsons);
            result.add(vchTemplateinfo);
        }
        SaveServiceHelper.save((DynamicObject[])result.toArray(new DynamicObject[0]));
        return upgradeResult;
    }

    private void handleAsstValue(AbstractVchTplAsst vchTplAsst) {
        List itemClassMaps = vchTplAsst.getItemClassMaps();
        for (AbstractVchTplItemMap vchTplItemMap : itemClassMaps) {
            String type;
            VchTplAgrss vchTplAgrss = vchTplItemMap.getVchTplAgrss();
            if (vchTplAgrss == null || vchTplAgrss.getItems().size() <= 0) continue;
            DynamicObject dyn = BusinessDataServiceHelper.loadSingle((Object)Long.parseLong(vchTplItemMap.getItemClass()), (String)"bd_asstacttype");
            String valuetype = dyn.getString("valuetype");
            List items = vchTplAgrss.getItems();
            if ("1".equals(valuetype)) {
                type = dyn.getString("valuesource.id");
                if (StringUtils.isEmpty((String)vchTplItemMap.getItemNumber())) {
                    vchTplItemMap.setItemNumber(type);
                    vchTplItemMap.setItemType("1");
                }
                for (VchTplAgrs item : items) {
                    if (!StringUtils.isEmpty((String)item.getAsstNumber()) || (dyn = BusinessDataServiceHelper.loadSingleFromCache((Object)Long.parseLong(item.getAsstid()), (String)type)) == null) continue;
                    item.setAsstNumber(dyn.getString("number"));
                }
                continue;
            }
            if (!"2".equals(valuetype)) continue;
            type = dyn.getString("assistanttype.number");
            if (StringUtils.isEmpty((String)vchTplItemMap.getItemNumber())) {
                vchTplItemMap.setItemNumber(type);
                vchTplItemMap.setItemType("2");
            }
            for (VchTplAgrs item : items) {
                QFilter[] filters;
                if (!StringUtils.isEmpty((String)item.getAsstNumber()) || (dyn = BusinessDataServiceHelper.loadSingleFromCache((String)"bos_assistantdata_detail", (QFilter[])(filters = new QFilter[]{new QFilter("group.number", "=", (Object)type), new QFilter("id", "=", (Object)Long.parseLong(item.getAsstid()))}))) == null) continue;
                item.setAsstNumber(dyn.getString("number"));
            }
        }
    }
}

