/*
 * Decompiled with CFR 0.152.
 */
package kd.fi.ai.upgradeservice;

import java.util.ArrayList;
import java.util.Date;
import java.util.List;
import java.util.Map;
import kd.bos.algo.DataSet;
import kd.bos.algo.Row;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.dataentity.serialization.SerializationUtils;
import kd.bos.db.DB;
import kd.bos.db.DBRoute;
import kd.bos.db.tx.TX;
import kd.bos.db.tx.TXHandle;
import kd.bos.logging.Log;
import kd.bos.logging.LogFactory;
import kd.bos.service.upgrade.IUpgradeService;
import kd.bos.service.upgrade.UpgradeResult;
import kd.bos.servicehelper.DBServiceHelper;

public class VchTemplateBuildWayUpgradeService
implements IUpgradeService {
    private static final Log log = LogFactory.getLog((String)"kd.fi.ai.upgradeservice.VchTemplateBuildWayUpgradeService");
    private static final char DEMOT = '.';

    public UpgradeResult beforeExecuteSqlWithResult(String ver, String iteration, String dbKey, String sqlFileName) {
        log.info("class VchTemplateBuildWayUpgradeService Execute starting...");
        UpgradeResult result = new UpgradeResult();
        try {
            this.upgrade();
            result.setSuccess(true);
        }
        catch (Exception e) {
            result.setErrorInfo(e.getMessage());
            result.setSuccess(false);
        }
        log.info("class VchTemplateBuildWayUpgradeService Execute end...");
        return result;
    }

    public void upgrade() throws Exception {
        DBRoute meta = DBRoute.of((String)"sys.meta");
        String sql = "select a.fid,a.fobjecttypeid,t.foperationkey from t_meta_opbizruleset a, t_meta_opbizrulesetentry t where a.fid = t.fid and a.fopbizrule = 'OnTimeGenerateVoucher'";
        DataSet rulesets = DB.queryDataSet((String)VchTemplateBuildWayUpgradeService.class.getName(), (DBRoute)meta, (String)sql);
        ArrayList<Object[]> paramsList = new ArrayList<Object[]>();
        ArrayList<Object[]> eventparams = new ArrayList<Object[]>();
        ArrayList<Object[]> eventZhparams = new ArrayList<Object[]>();
        ArrayList<Object[]> eventSubparams = new ArrayList<Object[]>();
        ArrayList<Object[]> eventSubZhparams = new ArrayList<Object[]>();
        for (Row row : rulesets) {
            Object uniquelate2;
            paramsList.add(new Object[]{row.getLong("fid")});
            String objecttypeId = row.getString("fobjecttypeid");
            String operationKey = row.getString("foperationkey");
            StringBuilder numberSb = new StringBuilder();
            numberSb.append(objecttypeId).append('.').append(operationKey);
            boolean uniqueFlag = true;
            Long uniqueFid = 0L;
            try (DataSet uniqueEventData = this.getUniqueEventData(numberSb.toString());){
                if (!uniqueEventData.isEmpty()) {
                    uniqueFlag = false;
                    for (Object uniquelate2 : uniqueEventData) {
                        uniqueFid = uniquelate2.getLong("fid");
                    }
                }
            }
            Object creatoid = 0L;
            Object modifyTime = new Date();
            DataSet vchTemplateData = this.getVchTemplateData(objecttypeId, operationKey);
            uniquelate2 = null;
            try {
                DataSet vchTemplateDataCopy = vchTemplateData.copy();
                if (vchTemplateDataCopy == null || vchTemplateDataCopy.isEmpty()) continue;
                for (Row rowTemplate : vchTemplateData) {
                    if (rowTemplate.get("fcreatorid") == null || rowTemplate.get("fmodifytime") == null) continue;
                    creatoid = rowTemplate.get("fcreatorid");
                    modifyTime = rowTemplate.get("fmodifytime");
                    break;
                }
            }
            catch (Throwable vchTemplateDataCopy) {
                uniquelate2 = vchTemplateDataCopy;
                throw vchTemplateDataCopy;
            }
            finally {
                if (vchTemplateData == null) continue;
                if (uniquelate2 != null) {
                    try {
                        vchTemplateData.close();
                    }
                    catch (Throwable throwable) {
                        ((Throwable)uniquelate2).addSuppressed(throwable);
                    }
                    continue;
                }
                vchTemplateData.close();
                continue;
            }
            String bizappid = "";
            String billName = "";
            DataSet entitySourceData = this.getEntitSourceData(objecttypeId);
            Object object = null;
            try {
                for (Row rowentitySource : entitySourceData) {
                    bizappid = rowentitySource.get("fbizappid") == null ? "" : rowentitySource.get("fbizappid");
                    billName = rowentitySource.get("fname") == null ? "" : rowentitySource.get("fname");
                }
            }
            catch (Throwable throwable) {
                object = throwable;
                throw throwable;
            }
            finally {
                if (entitySourceData != null) {
                    if (object != null) {
                        try {
                            entitySourceData.close();
                        }
                        catch (Throwable throwable) {
                            ((Throwable)object).addSuppressed(throwable);
                        }
                    } else {
                        entitySourceData.close();
                    }
                }
            }
            Object operationName = this.getOperationName(objecttypeId, operationKey);
            if (uniqueFlag) {
                uniqueFid = DBServiceHelper.genLongIds((String)"wfs", (String)"t_evt_event", (int)1)[0];
            }
            Long eventSubId = DBServiceHelper.genLongIds((String)"wfs", (String)"t_evt_subscription", (int)1)[0];
            if (uniqueFlag) {
                eventparams.add(this.getEventObject(objecttypeId, operationKey, numberSb, creatoid, modifyTime, bizappid, operationName, uniqueFid));
                eventZhparams.add(this.getEventLObject(uniqueFid, billName, operationName));
            }
            eventSubparams.add(this.getEventSubObject(objecttypeId, operationKey, numberSb, creatoid, modifyTime, bizappid, operationName, uniqueFid, billName, eventSubId));
            eventSubZhparams.add(this.getEventLSubObject(eventSubId, billName, operationName));
        }
        log.info("delete t_meta_opbizruleset param:{}", paramsList);
        log.info("insert t_evt_event param:{}", eventparams);
        log.info("insert t_evt_event_L param:{}", eventZhparams);
        log.info("insert t_evt_subscription param:{}", eventSubparams);
        log.info("insert t_evt_subscription_L param:{}", eventSubZhparams);
        this.insertEvent(paramsList, eventparams, eventZhparams, eventSubparams, eventSubZhparams);
    }

    private DataSet getEntitSourceData(String objecttypeId) {
        Object[] sourceBill = new Object[]{objecttypeId};
        DBRoute meta = DBRoute.of((String)"sys.meta");
        String entitySourceSql = "select A.fbizappid,B.fname from t_meta_mainentityinfo A JOIN t_meta_mainentityinfo_L B ON B.FId=A.FId AND B.FLocaleId='zh_CN' and A.fid = ?";
        DataSet entitySourceData = DB.queryDataSet((String)VchTemplateBuildWayUpgradeService.class.getName(), (DBRoute)meta, (String)entitySourceSql, (Object[])sourceBill);
        return entitySourceData;
    }

    private DataSet getVchTemplateData(String objecttypeId, String operationKey) {
        String vchTemplateSql = "select fcreatorid,fmodifytime,fname from t_ai_vchtemplate where fsourcebill = ? and foper = ? and fenable = '1' and fbuildvchgen = '1' ";
        Object[] sourceBills = new Object[]{objecttypeId, operationKey};
        DBRoute ai = DBRoute.of((String)"ai");
        DataSet vchTemplateData = DB.queryDataSet((String)VchTemplateBuildWayUpgradeService.class.getName(), (DBRoute)ai, (String)vchTemplateSql, (Object[])sourceBills);
        return vchTemplateData;
    }

    private DataSet getUniqueEventData(String fnumber) {
        DBRoute eventwfs = DBRoute.of((String)"wfs");
        String uniqueEventSql = "SELECT fid FROM t_evt_event t where fnumber = ? ";
        DataSet vchTemplateData = DB.queryDataSet((String)VchTemplateBuildWayUpgradeService.class.getName(), (DBRoute)eventwfs, (String)uniqueEventSql, (Object[])new Object[]{fnumber});
        return vchTemplateData;
    }

    private void insertEvent(List<Object[]> paramsList, List<Object[]> eventparams, List<Object[]> eventZhparams, List<Object[]> eventSubparams, List<Object[]> eventSubZhparams) throws Exception {
        try (TXHandle txHandle = TX.requiresNew();){
            try {
                DBRoute eventwfs = DBRoute.of((String)"wfs");
                if (!eventparams.isEmpty()) {
                    String insertEvent = "INSERT INTO t_evt_event(fcreater,fmodifier,fsource,fentity,fispreinsdata,fismodified,fstatus,fnumber,fscene,fcreatedate,fmodifydate,fopernumber,foperation,ftype,FId,fdescription) VALUES (?,?,?,?,?,?,?,?,?,?,?,?,?,?,?,?)";
                    DB.executeBatch((DBRoute)eventwfs, (String)insertEvent, eventparams);
                }
                if (!eventZhparams.isEmpty()) {
                    String insertEventL = "INSERT INTO t_evt_event_L(FId,fdescription,fname,FLocaleId,Fpkid) VALUES (?,?,?,?,?)";
                    DB.executeBatch((DBRoute)eventwfs, (String)insertEventL, eventZhparams);
                }
                if (!eventSubparams.isEmpty()) {
                    String insertEventSub = "INSERT INTO t_evt_subscription(fmodifier,fcreater,fservice,fevent,fismodified,fispreinsdata,fexecutor,fexecutorvalue,fstatus,ferrornotify,fnotifytext,fservicenumber,feventnumber,ftimingstrategy,fsequence,fmodifydate,fcreatedate,ferrorstrategy,fcondition,fexpression,fisconcurrent,fname,fnumber,fserviceconfig,FId) VALUES (?,?,?,?,?,?,?,?,?,?,?,?,?,?,?,?,?,?,?,?,?,?,?,?,?)";
                    DB.executeBatch((DBRoute)eventwfs, (String)insertEventSub, eventSubparams);
                }
                if (!eventSubZhparams.isEmpty()) {
                    String insertEventSubL = "INSERT INTO t_evt_subscription_L(FId,fname,FLocaleId,Fpkid) VALUES (?,?,?,?)";
                    DB.executeBatch((DBRoute)eventwfs, (String)insertEventSubL, eventSubZhparams);
                }
            }
            catch (Exception e) {
                txHandle.markRollback();
                log.error((Throwable)e);
                throw e;
            }
        }
        txHandle = TX.requiresNew();
        var7_7 = null;
        try {
            DBRoute meta = DBRoute.of((String)"sys.meta");
            if (!paramsList.isEmpty()) {
                String rulesetentrySql = "DELETE FROM t_meta_opbizrulesetentry WHERE fid = ? ";
                String rulesetSql = "DELETE FROM t_meta_opbizruleset WHERE fid = ? ";
                DB.executeBatch((DBRoute)meta, (String)rulesetentrySql, paramsList);
                DB.executeBatch((DBRoute)meta, (String)rulesetSql, paramsList);
            }
        }
        catch (Throwable throwable) {
            var7_7 = throwable;
            throw throwable;
        }
        finally {
            if (txHandle != null) {
                if (var7_7 != null) {
                    try {
                        txHandle.close();
                    }
                    catch (Throwable throwable) {
                        var7_7.addSuppressed(throwable);
                    }
                } else {
                    txHandle.close();
                }
            }
        }
    }

    private Object getOperationName(String objecttypeId, String operationKey) {
        DBRoute meta = DBRoute.of((String)"sys.meta");
        Object[] metaMntityParam = new Object[]{objecttypeId, operationKey};
        String metaMntitySql = "select fdata from T_META_ENTITY where fnumber=? and fkey=? and ftype=13 ";
        DataSet metaMntityData = DB.queryDataSet((String)VchTemplateBuildWayUpgradeService.class.getName(), (DBRoute)meta, (String)metaMntitySql, (Object[])metaMntityParam);
        String operationName = operationKey;
        for (Row metaMntitySource : metaMntityData) {
            String fdata;
            Map fromJsonMap;
            if (null == metaMntitySource.get("fdata") || null == (fromJsonMap = (Map)SerializationUtils.fromJsonString((String)(fdata = (String)metaMntitySource.get("fdata")), Map.class)).get("name")) continue;
            Map nameMap = (Map)fromJsonMap.get("name");
            operationName = nameMap.get("zh_CN") == null ? operationKey : nameMap.get("zh_CN");
            break;
        }
        return operationName;
    }

    private Object[] getEventLSubObject(Long eventSubId, Object billName, Object operationName) {
        Object[] eventSubZh = new Object[4];
        eventSubZh[0] = eventSubId;
        String fpkSubId = DBServiceHelper.genStringId();
        StringBuilder nameSubSb = new StringBuilder();
        nameSubSb.append(billName).append('.').append(operationName).append('.').append(ResManager.loadKDString((String)"\u6267\u884c\u64cd\u4f5c", (String)"VchTemplateBuildWayUpgradeService_0", (String)"fi-ai-upgradeservice", (Object[])new Object[0]));
        eventSubZh[1] = nameSubSb.toString();
        eventSubZh[2] = "zh_CN";
        eventSubZh[3] = fpkSubId;
        return eventSubZh;
    }

    private Object[] getEventSubObject(String objecttypeId, String operationKey, StringBuilder numberSb, Object creatoid, Object modifyTime, Object bizappid, Object operationName, Long eventId, Object billName, Long eventSubId) {
        Object[] eventSub = new Object[25];
        eventSub[0] = creatoid;
        eventSub[1] = creatoid;
        eventSub[2] = 915117758415374336L;
        eventSub[3] = eventId;
        eventSub[4] = 1;
        eventSub[5] = 1;
        eventSub[6] = "";
        eventSub[7] = "";
        eventSub[8] = 1;
        eventSub[9] = "";
        eventSub[10] = "";
        eventSub[11] = "executeOperation";
        StringBuilder eventNumber = new StringBuilder();
        eventNumber.append(objecttypeId).append('.').append(operationKey);
        eventSub[12] = eventNumber.toString();
        eventSub[13] = "";
        eventSub[14] = 0;
        eventSub[15] = modifyTime;
        eventSub[16] = modifyTime;
        eventSub[17] = "retry";
        eventSub[18] = "";
        eventSub[19] = "";
        eventSub[20] = 1;
        StringBuilder nameSubSb = new StringBuilder();
        nameSubSb.append(billName).append('.').append(operationName).append('.').append(ResManager.loadKDString((String)"\u6267\u884c\u64cd\u4f5c", (String)"VchTemplateBuildWayUpgradeService_0", (String)"fi-ai-upgradeservice", (Object[])new Object[0]));
        eventSub[21] = nameSubSb.toString();
        StringBuilder fNumber = new StringBuilder();
        fNumber.append("voucher").append('.').append((CharSequence)eventNumber).append('.').append("executeOperation");
        String fnumber = "";
        fnumber = fNumber.length() > 50 ? fNumber.substring(0, 50) : fNumber.toString();
        eventSub[22] = fnumber;
        String kdString1 = ResManager.loadKDString((String)"\u6267\u884c\u5f53\u524d\u5b9e\u4f53\u7684\u64cd\u4f5c", (String)"VchTemplateBuildWayUpgradeService_1", (String)"fi-ai-upgradeservice", (Object[])new Object[0]);
        String kdString2 = ResManager.loadKDString((String)"\u751f\u6210\u51ed\u8bc1", (String)"VchTemplateBuildWayUpgradeService_2", (String)"fi-ai-upgradeservice", (Object[])new Object[0]);
        String explainStr = "{\"relationdesc\":\"" + kdString1 + "\u3002\",\"optype\":\"cosmic\",\"entityrange\":\"currententity\",\"operationname\":\"" + kdString2 + "\",\"filtergridap\":\"{\\\"filterRow\\\":[],\\\"forList\\\":false}\",\"evententity\":\"" + objecttypeId + "\",\"operation\":\"generatevoucher\"}";
        eventSub[23] = explainStr;
        eventSub[24] = eventSubId;
        return eventSub;
    }

    private Object[] getEventLObject(Long eventId, Object billName, Object operationName) {
        Object[] objectZh = new Object[5];
        objectZh[0] = eventId;
        String fpkId = DBServiceHelper.genStringId();
        objectZh[4] = fpkId;
        objectZh[3] = "zh_CN";
        StringBuilder nameSb = new StringBuilder();
        nameSb.append(billName).append('.').append(operationName);
        objectZh[2] = nameSb.toString();
        objectZh[1] = ResManager.loadKDString((String)"\u51ed\u8bc1\u6a21\u677f\u5220\u9664\u5b9e\u65f6\u751f\u6210\u51ed\u8bc1\u529f\u80fd\u65f6\uff0c\u539f\u5b9e\u65f6\u751f\u6210\u51ed\u8bc1\u7684\u6570\u636e\u5c06\u81ea\u52a8\u751f\u6210\u4e1a\u52a1\u4e8b\u4ef6", (String)"VchTemplateBuildWayUpgradeService_3", (String)"fi-ai-upgradeservice", (Object[])new Object[0]);
        return objectZh;
    }

    private Object[] getEventObject(String objecttypeId, String operationKey, StringBuilder numberSb, Object creatoid, Object modifyTime, Object bizappid, Object operationName, Long eventId) {
        Object[] object = new Object[16];
        object[0] = creatoid;
        object[1] = creatoid;
        object[9] = modifyTime;
        object[10] = modifyTime;
        object[2] = bizappid;
        object[3] = objecttypeId;
        object[4] = 1;
        object[5] = 1;
        object[6] = 1;
        object[7] = numberSb.toString();
        object[8] = "operate";
        object[11] = operationKey;
        object[12] = operationName;
        object[13] = "cosmic";
        object[14] = eventId;
        object[15] = ResManager.loadKDString((String)"\u51ed\u8bc1\u6a21\u677f\u81ea\u52a8\u5347\u7ea7", (String)"VchTemplateBuildWayUpgradeService_4", (String)"fi-ai-upgradeservice", (Object[])new Object[0]);
        return object;
    }
}

