/*
 * Decompiled with CFR 0.152.
 */
package kd.fi.ai.upgradeservice;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.entity.ILocaleValue;
import kd.bos.dataentity.entity.LocaleString;
import kd.bos.dataentity.serialization.SerializationUtils;
import kd.bos.dataentity.utils.StringUtils;
import kd.bos.entity.MainEntityType;
import kd.bos.logging.Log;
import kd.bos.logging.LogFactory;
import kd.bos.service.upgrade.IUpgradeService;
import kd.bos.service.upgrade.UpgradeResult;
import kd.bos.servicehelper.BusinessDataServiceHelper;
import kd.bos.servicehelper.MetadataServiceHelper;
import kd.bos.servicehelper.operation.SaveServiceHelper;
import kd.bos.util.ExceptionUtils;
import kd.fi.ai.VCHTemplate;
import kd.fi.ai.VchTplBizGroup;

public class VchTemplateMultiRelationbillsUpgradeService
implements IUpgradeService {
    private static final Log log = LogFactory.getLog((String)"kd.fi.ai.upgradeservice.VchTemplateMultiRelationbillsUpgradeService");
    private static final String algoKey = "kd.fi.ai.upgradeservice.VchTemplateMultiRelationbillsUpgradeService";

    public UpgradeResult beforeExecuteSqlWithResult(String ver, String iteration, String dbKey, String sqlFileName) {
        UpgradeResult result = new UpgradeResult();
        try {
            this.updateData();
            result.setSuccess(true);
            log.info("UPGRADE_VCHTEMPLATE_SUCCESS");
        }
        catch (Exception e) {
            result.setSuccess(false);
            log.info("UPGRADE_VCHTEMPLATE_ERROR");
            result.setErrorInfo("UPGRADE_VCHTEMPLATE_ERROR" + ExceptionUtils.getExceptionStackTraceMessage((Exception)e));
        }
        return result;
    }

    private void updateData() {
        log.info("**\u5f00\u59cb\u8fdb\u884c\u5173\u8054\u5355\u636e\u5347\u7ea7\u4e3a\u591a\u9009\u5173\u8054\u5355\u636e**");
        DynamicObject[] vchTemplateCol = BusinessDataServiceHelper.load((String)"ai_vchtemplate", (String)"number,fxml,fxmllang", null);
        log.info("**\u5f00\u59cb\u5347\u7ea7\uff0c\u53c2\u4e0e\u5347\u7ea7\u6a21\u677f\u6570\u91cf\u4e3a**" + vchTemplateCol.length);
        ArrayList<DynamicObject> result = new ArrayList<DynamicObject>(vchTemplateCol.length);
        HashMap<String, String> newrs = new HashMap<String, String>();
        int index = 0;
        for (DynamicObject tem : vchTemplateCol) {
            String relationshipSourcebill;
            String json = tem.getString("fxml");
            ILocaleValue langJsons = (ILocaleValue)tem.get("fxmllang");
            VCHTemplate vchTemplate = null;
            if (StringUtils.isBlank((CharSequence)json) || !StringUtils.isNotBlank((CharSequence)(relationshipSourcebill = (vchTemplate = VCHTemplate.deserializeFromString((String)json, (Map)langJsons)).getRelationshipSourcebill()))) continue;
            ++index;
            String sourceBill = vchTemplate.getSourceBill();
            ArrayList<String> rs = new ArrayList<String>();
            rs.add(relationshipSourcebill);
            vchTemplate.setRelationshipSourcebillcol(rs);
            String sourceField = vchTemplate.getSourceField();
            String targetField = vchTemplate.getTargetField();
            newrs.clear();
            if (StringUtils.isNotBlank((CharSequence)sourceField)) {
                String key = sourceBill + "-" + relationshipSourcebill;
                newrs.put(sourceBill, "upgrade-" + sourceField);
                newrs.put(relationshipSourcebill, "upgrade-" + targetField);
                MainEntityType sourceType = MetadataServiceHelper.getDataEntityType((String)sourceBill);
                MainEntityType targetType = MetadataServiceHelper.getDataEntityType((String)relationshipSourcebill);
                String src = sourceType.getProperty(sourceField).getDisplayName().getLocaleValue();
                String tar = targetType.getProperty(targetField).getDisplayName().getLocaleValue();
                HashMap<String, String> resultaa = new HashMap<String, String>();
                resultaa.put(key, SerializationUtils.toJsonString(newrs));
                resultaa.put("str", src + ":" + tar);
                vchTemplate.setSourceAndTargetFieldcol(resultaa);
            }
            vchTemplate.setRelationshipSourcebill("");
            vchTemplate.setSourceField("");
            vchTemplate.setTargetField("");
            List bizGroups = vchTemplate.getBizGroups();
            for (VchTplBizGroup bg : bizGroups) {
                List vchEntrys = bg.getVchEntrys();
                vchEntrys.forEach(v -> {
                    v.setBelongSources(v.getBelongSource());
                    v.setBelongSource("");
                });
            }
            Map jsonDatas = vchTemplate.serializeToString();
            if (jsonDatas == null) continue;
            LocaleString langJsonss = new LocaleString();
            for (Map.Entry entry : jsonDatas.entrySet()) {
                if (((String)entry.getKey()).equalsIgnoreCase("json")) continue;
                langJsonss.setItem((String)entry.getKey(), entry.getValue());
            }
            tem.set("fxml", jsonDatas.get("json"));
            tem.set("fxmllang", (Object)langJsons);
            result.add(tem);
        }
        log.info("**\u5347\u7ea7\u6709\u5173\u5173\u8054\u5355\u636e\u7684\u6a21\u677f\u6570\u636e\u91cf\u4e3a**" + index);
        log.info("**\u5165\u5e93**");
        SaveServiceHelper.save((DynamicObject[])result.toArray(new DynamicObject[0]));
        log.info("**done!!!**");
    }
}

