/*
 * Decompiled with CFR 0.152.
 */
package kd.fi.ai.upgradeservice;

import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.entity.ILocaleValue;
import kd.bos.dataentity.entity.LocaleString;
import kd.bos.dataentity.utils.StringUtils;
import kd.bos.lang.Lang;
import kd.bos.logging.Log;
import kd.bos.logging.LogFactory;
import kd.bos.service.upgrade.IUpgradeService;
import kd.bos.service.upgrade.UpgradeResult;
import kd.bos.servicehelper.BusinessDataServiceHelper;
import kd.bos.servicehelper.operation.SaveServiceHelper;
import kd.bos.util.ExceptionUtils;
import kd.fi.ai.ExpressionType;
import kd.fi.ai.VCHTemplate;
import kd.fi.ai.VchExpireDate;
import kd.fi.ai.VchFormulaFilterSetRow;
import kd.fi.ai.VchTplBizGroup;
import kd.fi.ai.VchTplEntry;
import kd.fi.ai.VchTplExpression;

public class VchTplDateConditionFieldUpgradeService
implements IUpgradeService {
    private static final Log log = LogFactory.getLog(VchTplDateConditionFieldUpgradeService.class);

    public UpgradeResult beforeExecuteSqlWithResult(String ver, String iteration, String dbKey, String sqlFileName) {
        UpgradeResult upgradeResult = new UpgradeResult();
        try {
            DynamicObject[] vchTemplates = BusinessDataServiceHelper.load((String)"ai_vchtemplate", (String)"fxml,fxmllang", null);
            if (vchTemplates.length == 0) {
                return upgradeResult;
            }
            this.upgrade(vchTemplates);
            upgradeResult.setSuccess(true);
            log.info("VchTplDateConditionFieldUpgradeService_SUCCESS");
        }
        catch (Exception e) {
            upgradeResult.setSuccess(false);
            log.info("VchTplDateConditionFieldUpgradeService_ERROR");
            upgradeResult.setErrorInfo("VchTemplateDateFieldUpgradeService_ERROR" + ExceptionUtils.getExceptionStackTraceMessage((Exception)e));
        }
        return upgradeResult;
    }

    private void upgrade(DynamicObject[] vchTemplates) {
        ArrayList<DynamicObject> result = new ArrayList<DynamicObject>(vchTemplates.length);
        for (DynamicObject vchTemplateinfo : vchTemplates) {
            Map jsonDatas;
            String json = vchTemplateinfo.getString("fxml");
            ILocaleValue langJsons = (ILocaleValue)vchTemplateinfo.get("fxmllang");
            VCHTemplate vchTemplate = null;
            try {
                vchTemplate = VCHTemplate.deserializeFromString((String)json, (Map)langJsons);
                this.upgradeDateConditionField(vchTemplate.getVchDateSet2());
                this.upgradeDateConditionField(vchTemplate.getBizDateSet2());
                List bizGroups = vchTemplate.getBizGroups();
                for (VchTplBizGroup vchTplBizGroup : bizGroups) {
                    List vchEntrys = vchTplBizGroup.getVchEntrys();
                    for (VchTplEntry vchEntry : vchEntrys) {
                        VchExpireDate date = vchEntry.getExpireDate();
                        this.upgradeDateConditionField(date);
                    }
                }
            }
            catch (Throwable e) {
                log.info("\u51ed\u8bc1\u6a21\u677f\u6838\u7b97\u7ef4\u5ea6\u6570\u636e\u5347\u7ea7\u5931\u8d25");
            }
            if (vchTemplate == null || (jsonDatas = vchTemplate.serializeToString()) == null) continue;
            langJsons = new LocaleString();
            for (Map.Entry entry : jsonDatas.entrySet()) {
                if (((String)entry.getKey()).equalsIgnoreCase("json")) continue;
                langJsons.setItem((String)entry.getKey(), entry.getValue());
            }
            vchTemplateinfo.set("fxml", jsonDatas.get("json"));
            vchTemplateinfo.set("fxmllang", (Object)langJsons);
            result.add(vchTemplateinfo);
        }
        SaveServiceHelper.save((DynamicObject[])result.toArray(new DynamicObject[0]));
    }

    private void upgradeDateConditionField(VchExpireDate expireDate) {
        if (!"fix".equalsIgnoreCase(expireDate.getSourcetype()) || expireDate.getConstDate() == null || !StringUtils.isEmpty((CharSequence)expireDate.getExp())) {
            if (expireDate.ifNewDate()) {
                List items = expireDate.getItems();
                VchFormulaFilterSetRow row = new VchFormulaFilterSetRow();
                VchTplExpression exprObj = new VchTplExpression();
                exprObj.setExprType(ExpressionType.Formula);
                exprObj.setExpression("Dapfield_newdate");
                LocaleString description = new LocaleString();
                description.put(Lang.zh_CN.toString(), (Object)VchExpireDate.newDateAlias());
                exprObj.setDescription(description);
                row.setFieldExp(exprObj);
                items.add(row);
                expireDate.setSourcetype(null);
            } else if (expireDate.ifLastDate()) {
                List items = expireDate.getItems();
                VchFormulaFilterSetRow row = new VchFormulaFilterSetRow();
                VchTplExpression exprObj = new VchTplExpression();
                exprObj.setExprType(ExpressionType.Formula);
                exprObj.setExpression("Dapfield_lastdate");
                LocaleString description = new LocaleString();
                description.put(Lang.zh_CN.toString(), (Object)VchExpireDate.lastDateAlias());
                exprObj.setDescription(description);
                row.setFieldExp(exprObj);
                items.add(row);
                expireDate.setSourcetype(null);
            } else if ("exp".equalsIgnoreCase(expireDate.getSourcetype()) && StringUtils.isNotBlank((CharSequence)expireDate.getExp())) {
                List items = expireDate.getItems();
                VchFormulaFilterSetRow row = new VchFormulaFilterSetRow();
                VchTplExpression exprObj = new VchTplExpression();
                exprObj.setExprType(ExpressionType.Formula);
                String exp = expireDate.getExp().trim();
                if ("newdate".equals(exp)) {
                    exp = "Dapfield_newdate";
                } else if ("lastdate".equals(exp)) {
                    exp = "lastdate";
                }
                exprObj.setExpression(exp);
                LocaleString description = new LocaleString();
                description.put(Lang.zh_CN.toString(), (Object)expireDate.getDateName());
                exprObj.setDescription(description);
                row.setFieldExp(exprObj);
                items.add(row);
                expireDate.setSourcetype(null);
            }
        }
    }
}

