/*
 * Decompiled with CFR 0.152.
 */
package kd.fi.ai;

import java.util.Date;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Map;
import java.util.Set;
import kd.bos.cache.ThreadCache;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.entity.DynamicObjectCollection;
import kd.bos.servicehelper.BusinessDataServiceHelper;

public class EntryAccountInfo {
    private static final String ACCT_SELECTOR = "id,isleaf,masterid,isassist,bw,number,dc,accrualdirection,acctcurrency,isqty,pltype,iscash,isbank,iscashequivalent,acnotice,accheck,startdate,enddate,accounttable,checkitementry.asstactitem,checkitementry.isrequire,checkitementry.isdetail,currencyentry.currency,accounttype.accounttype";
    private Object pk;
    private long masterId;
    private String number;
    private boolean leaf;
    private boolean assist;
    private boolean cash;
    private boolean qty;
    private boolean bw;
    private boolean pl;
    private boolean acnotice;
    private boolean accheck;
    private String accrualdirection;
    private String acctcurrency;
    private Date startDate;
    private Date endDate;
    private long accountTable;
    private String dc;
    private String accountType;
    private Set<Long> currencyPkList = new HashSet<Long>();
    private Map<String, String> requiredFlexs = new HashMap<String, String>();
    private Map<String, String> detailFlexs = new HashMap<String, String>();

    private EntryAccountInfo(Object pk) {
        this.pk = pk;
    }

    public Object getPk() {
        return this.pk;
    }

    public String getNumber() {
        return this.number;
    }

    public boolean isLeaf() {
        return this.leaf;
    }

    public boolean isAssist() {
        return this.assist;
    }

    public boolean isCash() {
        return this.cash;
    }

    public boolean isQty() {
        return this.qty;
    }

    public boolean isPl() {
        return this.pl;
    }

    public boolean isBw() {
        return this.bw;
    }

    public boolean isAcnotice() {
        return this.acnotice;
    }

    public String getAccrualdirection() {
        return this.accrualdirection;
    }

    public String getAcctcurrency() {
        return this.acctcurrency;
    }

    public Set<Long> getCurrencyPkList() {
        return this.currencyPkList;
    }

    public Map<String, String> getRequiredFlexs() {
        return this.requiredFlexs;
    }

    private void setPl(boolean pl) {
        this.pl = pl;
    }

    private void setBw(boolean bw) {
        this.bw = bw;
    }

    private void setAcnotice(boolean acnotice) {
        this.acnotice = acnotice;
    }

    private void setAccrualdirection(String accrualdirection) {
        this.accrualdirection = accrualdirection;
    }

    private void setNumber(String number) {
        this.number = number;
    }

    private void setLeaf(boolean isleaf) {
        this.leaf = isleaf;
    }

    private void setAssist(boolean isassist) {
        this.assist = isassist;
    }

    private void setCash(boolean iscash) {
        this.cash = iscash;
    }

    private void setQty(boolean isqty) {
        this.qty = isqty;
    }

    private void setAcctcurrency(String acctcurrency) {
        this.acctcurrency = acctcurrency;
    }

    private void addRequiredFlex(String flexField, String flexName) {
        this.requiredFlexs.put(flexField, flexName);
    }

    private void addCurrencyPk(Long currencyPk) {
        this.currencyPkList.add(currencyPk);
    }

    public Map<String, String> getDetailFlexs() {
        return this.detailFlexs;
    }

    private void addDetailFlex(String flexField, String flexName) {
        this.detailFlexs.put(flexField, flexName);
    }

    public boolean isAccheck() {
        return this.accheck;
    }

    public void setAccheck(boolean accheck) {
        this.accheck = accheck;
    }

    public long getMasterId() {
        return this.masterId;
    }

    public void setMasterId(long masterId) {
        this.masterId = masterId;
    }

    public Date getStartDate() {
        return this.startDate;
    }

    public void setStartDate(Date startDate) {
        this.startDate = startDate;
    }

    public Date getEndDate() {
        return this.endDate;
    }

    public void setEndDate(Date endDate) {
        this.endDate = endDate;
    }

    public long getAccountTable() {
        return this.accountTable;
    }

    public void setAccountTable(long accountTable) {
        this.accountTable = accountTable;
    }

    public String getDc() {
        return this.dc;
    }

    public void setDc(String dc) {
        this.dc = dc;
    }

    public String getAccountType() {
        return this.accountType;
    }

    public void setAccountType(String accountType) {
        this.accountType = accountType;
    }

    public static EntryAccountInfo load(Long accountPk) {
        return (EntryAccountInfo)ThreadCache.get((Object)("ACCOUNT_INFO_" + accountPk), () -> {
            EntryAccountInfo acc = new EntryAccountInfo(accountPk);
            DynamicObject acct = BusinessDataServiceHelper.loadSingleFromCache((Object)accountPk, (String)"bd_accountview", (String)ACCT_SELECTOR);
            acc.setStartDate(acct.getDate("startdate"));
            acc.setEndDate(acct.getDate("enddate"));
            acc.setAccountTable(acct.getLong("accounttable_id"));
            acc.setNumber(acct.getString("number"));
            acc.setLeaf(acct.getBoolean("isleaf"));
            acc.setAssist(acct.getBoolean("isassist"));
            acc.setQty(acct.getBoolean("isqty"));
            acc.setCash(acct.getBoolean("isbank") || acct.getBoolean("iscash") || acct.getBoolean("iscashequivalent"));
            acc.setBw(acct.getBoolean("bw"));
            acc.setAcnotice(acct.getBoolean("acnotice"));
            acc.setAccrualdirection(acct.getString("accrualdirection"));
            acc.setAcctcurrency(acct.getString("acctcurrency"));
            acc.setAccheck(acct.getBoolean("accheck"));
            acc.setMasterId(acct.getLong("masterid"));
            acc.setPl(!"0".equals(acct.getString("pltype")));
            acc.setDc(acct.getString("dc"));
            acc.setAccountType(acct.getString("accounttype.accounttype"));
            DynamicObjectCollection asstColl = acct.getDynamicObjectCollection("checkitementry");
            for (DynamicObject obj : asstColl) {
                if (obj.getBoolean("isrequire")) {
                    acc.addRequiredFlex(obj.getString("asstactitem.flexfield"), obj.getString("asstactitem.name"));
                }
                if (!obj.getBoolean("isdetail")) continue;
                acc.addDetailFlex(obj.getString("asstactitem.flexfield"), obj.getString("asstactitem.name"));
            }
            DynamicObjectCollection cyColl = acct.getDynamicObjectCollection("currencyentry");
            for (DynamicObject obj : cyColl) {
                acc.addCurrencyPk(obj.getLong("currency.id"));
            }
            return acc;
        });
    }
}

