/*
 * Decompiled with CFR 0.152.
 */
package kd.fi.ai;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import kd.bos.dataentity.metadata.IDataEntityProperty;
import kd.bos.dataentity.metadata.dynamicobject.DynamicProperty;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.dataentity.serialization.SerializationUtils;
import kd.bos.dataentity.utils.StringUtils;
import kd.bos.entity.MainEntityType;
import kd.bos.formula.FormulaEngine;
import kd.fi.ai.AbstractVchTplAsst;
import kd.fi.ai.AbstractVchTplItemMap;
import kd.fi.ai.VchExpireDate;
import kd.fi.ai.VchTplAcctFactorMap;
import kd.fi.ai.VchTplAccts;
import kd.fi.ai.VchTplAsstDimFactorSource;
import kd.fi.ai.VchTplCashflow;
import kd.fi.ai.VchTplDcs;
import kd.fi.ai.VchTplExpression;
import kd.fi.ai.VchTplMeasureUnit;
import kd.fi.ai.VchTplRate;
import kd.fi.ai.enums.Token;

public class VchTemplEntryFieldInfo {
    private int seq;
    private MainEntityType type;
    private Map<String, String> fieldAndName;
    private Map<String, Map<String, Set<String>>> entryFields = new HashMap<String, Map<String, Set<String>>>();

    public VchTemplEntryFieldInfo(int seq, MainEntityType type) {
        this.seq = seq;
        this.type = type;
    }

    public int getSeq() {
        return this.seq;
    }

    public void setSeq(int seq) {
        this.seq = seq;
    }

    public Map<String, Map<String, Set<String>>> getEntryFields() {
        return this.entryFields;
    }

    public boolean equals(Object seq) {
        return seq instanceof Integer && this.seq == Integer.parseInt(seq + "");
    }

    public int hashCode() {
        return Integer.hashCode(this.seq);
    }

    public boolean isCrossEntity() {
        HashSet<String> set = new HashSet<String>();
        for (Map.Entry<String, Map<String, Set<String>>> entryFeild : this.entryFields.entrySet()) {
            for (Map.Entry<String, Set<String>> property : entryFeild.getValue().entrySet()) {
                set.add(property.getKey());
                if (set.size() <= 1) continue;
                return true;
            }
        }
        return false;
    }

    public void setExplanation(String formula) {
        try {
            String[] fields = this.extractVariables(formula);
            this.entryFields.put("description", this.getFieldMap(fields));
        }
        catch (Exception exception) {
            // empty catch block
        }
    }

    public void setAccount(VchTplAccts vchAcctObj) {
        try {
            String sourceType = vchAcctObj.getSourcetype();
            HashSet<String> resolveProperties = new HashSet<String>();
            if ("mapping".equals(sourceType)) {
                List<VchTplAcctFactorMap> factors = vchAcctObj.getFactorMaps();
                if (factors != null && !factors.isEmpty()) {
                    for (VchTplAcctFactorMap fact : factors) {
                        if (StringUtils.isNotBlank((CharSequence)fact.getSourceFieldKey())) {
                            resolveProperties.add(fact.getSourceFieldKey());
                            continue;
                        }
                        String[] vars = FormulaEngine.extractVariables((String)fact.getExpvalentity());
                        resolveProperties.addAll(Arrays.asList(vars));
                    }
                }
            } else if ("exp".equals(sourceType)) {
                String[] vars = FormulaEngine.extractVariables((String)vchAcctObj.getExp());
                resolveProperties.addAll(Arrays.asList(vars));
            }
            if (resolveProperties != null) {
                this.entryFields.put("account", this.getFieldMap(resolveProperties.toArray(new String[0])));
            }
        }
        catch (Exception exception) {
            // empty catch block
        }
    }

    public void setAsst(AbstractVchTplAsst vchTplAsst) {
        try {
            List<VchTplAsstDimFactorSource> factors;
            List<AbstractVchTplItemMap> tplItems = vchTplAsst.getItemClassMaps();
            HashSet<String> resolveProperties = new HashSet<String>();
            if (tplItems != null && !tplItems.isEmpty()) {
                for (AbstractVchTplItemMap tplItem : tplItems) {
                    if (StringUtils.isNotBlank((CharSequence)tplItem.getSourceFieldKey())) {
                        resolveProperties.add(tplItem.getSourceFieldKey());
                        continue;
                    }
                    if (!StringUtils.isNotBlank((CharSequence)tplItem.getExp())) continue;
                    String[] vars = FormulaEngine.extractVariables((String)tplItem.getExp());
                    resolveProperties.addAll(Arrays.asList(vars));
                }
            }
            if ((factors = vchTplAsst.getAsstFactors()) != null && !factors.isEmpty()) {
                for (VchTplAsstDimFactorSource fact : factors) {
                    if (StringUtils.isNotBlank((CharSequence)fact.getSourceFieldKey())) {
                        resolveProperties.add(fact.getSourceFieldKey());
                        continue;
                    }
                    String[] vars = FormulaEngine.extractVariables((String)fact.getEntityExp());
                    resolveProperties.addAll(Arrays.asList(vars));
                }
            }
            if (resolveProperties != null) {
                this.entryFields.put("accountAsst", this.getFieldMap(resolveProperties.toArray(new String[0])));
            }
        }
        catch (Exception exception) {
            // empty catch block
        }
    }

    public void setExpireData(VchExpireDate vchExpireDate) {
        this.entryFields.put("expiredata", new HashMap());
    }

    public void setCashFlow(VchTplCashflow vchTplCashflow) {
        try {
            String type = vchTplCashflow.getSourcetype();
            if (type == null) {
                return;
            }
            switch (type) {
                case "exp": {
                    String[] vars = FormulaEngine.extractVariables((String)vchTplCashflow.getExp());
                    this.entryFields.put("cashflowitem", this.getFieldMap(vars));
                    break;
                }
                case "mapping": {
                    this.entryFields.put("cashflowitem", this.getFieldMap(new String[]{vchTplCashflow.getSourcefield()}));
                }
            }
        }
        catch (Exception exception) {
            // empty catch block
        }
    }

    public void setCashAsst(AbstractVchTplAsst vchTplAsst) {
        try {
            List<VchTplAsstDimFactorSource> factors;
            List<AbstractVchTplItemMap> tplItems = vchTplAsst.getItemClassMaps();
            HashSet<String> resolveProperties = new HashSet<String>();
            if (tplItems != null && !tplItems.isEmpty()) {
                for (AbstractVchTplItemMap tplItem : tplItems) {
                    if (StringUtils.isNotBlank((CharSequence)tplItem.getSourceFieldKey())) {
                        resolveProperties.add(tplItem.getSourceFieldKey());
                        continue;
                    }
                    String[] vars = FormulaEngine.extractVariables((String)tplItem.getExp());
                    resolveProperties.addAll(Arrays.asList(vars));
                }
            }
            if ((factors = vchTplAsst.getAsstFactors()) != null && !factors.isEmpty()) {
                for (VchTplAsstDimFactorSource fact : factors) {
                    if (StringUtils.isNotBlank((CharSequence)fact.getSourceFieldKey())) {
                        resolveProperties.add(fact.getSourceFieldKey());
                        continue;
                    }
                    String[] vars = FormulaEngine.extractVariables((String)fact.getEntityExp());
                    resolveProperties.addAll(Arrays.asList(vars));
                }
            }
            if (resolveProperties != null) {
                this.entryFields.put("cashflowAsst", this.getFieldMap(resolveProperties.toArray(new String[0])));
            }
        }
        catch (Exception exception) {
            // empty catch block
        }
    }

    public void setDC(VchTplDcs vchTplDcs) {
        this.entryFields.put("dc", new HashMap());
    }

    public void setQuantity(String ... fields) {
        try {
            ArrayList<String> fieldlist = new ArrayList<String>();
            for (String field : fields) {
                if ("@autoCal".equals(field) || !StringUtils.isNotBlank((CharSequence)field)) continue;
                String[] vars = FormulaEngine.extractVariables((String)field);
                fieldlist.addAll(Arrays.asList(vars));
            }
            this.entryFields.put("quantity", this.getFieldMap(fieldlist.toArray(new String[0])));
        }
        catch (Exception exception) {
            // empty catch block
        }
    }

    public void setPrice(String ... fields) {
        try {
            ArrayList<String> fieldlist = new ArrayList<String>();
            for (String field : fields) {
                if ("@autoCal".equals(field) || !StringUtils.isNotBlank((CharSequence)field)) continue;
                String[] vars = FormulaEngine.extractVariables((String)field);
                fieldlist.addAll(Arrays.asList(vars));
            }
            this.entryFields.put("price", this.getFieldMap(fieldlist.toArray(new String[0])));
        }
        catch (Exception exception) {
            // empty catch block
        }
    }

    public void setMeasureunit(VchTplMeasureUnit vchTplMeasureUnit) {
        this.entryFields.put("measureunit", new HashMap());
    }

    public void setCurrency(String ... fields) {
        this.entryFields.put("currency", this.getFieldMap(fields));
    }

    public void setRate(String propName, boolean isOld) {
        try {
            if (isOld) {
                if (StringUtils.isNotBlank((CharSequence)propName)) {
                    String[] vars = FormulaEngine.extractVariables((String)propName);
                    this.entryFields.put("Rate", this.getFieldMap(vars));
                }
            } else {
                String type;
                VchTplRate rate = (VchTplRate)SerializationUtils.fromJsonString((String)propName, VchTplRate.class);
                switch (type = rate.getSourcetype()) {
                    case "field": {
                        if ("@autoCal".equals(rate.getExp()) || !StringUtils.isNotBlank((CharSequence)rate.getExp())) break;
                        String[] vars = FormulaEngine.extractVariables((String)rate.getExp());
                        this.entryFields.put("Rate", this.getFieldMap(vars));
                    }
                }
            }
        }
        catch (Exception exception) {
            // empty catch block
        }
    }

    public void setOriAmount(String ... fields) {
        try {
            ArrayList<String> fieldlist = new ArrayList<String>();
            for (String field : fields) {
                if ("@autoCal".equals(field) || !StringUtils.isNotBlank((CharSequence)field)) continue;
                String[] vars = FormulaEngine.extractVariables((String)field);
                fieldlist.addAll(Arrays.asList(vars));
            }
            this.entryFields.put("oriamount", this.getFieldMap(fieldlist.toArray(new String[0])));
        }
        catch (Exception exception) {
            // empty catch block
        }
    }

    public void setLocalAmount(String ... fields) {
        try {
            ArrayList<String> fieldlist = new ArrayList<String>();
            for (String field : fields) {
                if ("@autoCal".equals(field)) continue;
                fieldlist.add(field);
            }
            this.entryFields.put("localamount", this.getFieldMap(fieldlist.toArray(new String[0])));
        }
        catch (Exception exception) {
            // empty catch block
        }
    }

    public void setDatascope(VchTplExpression vchTplExpression) {
        try {
            String expression = vchTplExpression.getExpression();
            if (vchTplExpression.getFilterCondition() != null) {
                expression = vchTplExpression.buildFullFormula(this.type);
            }
            if (expression != null) {
                this.entryFields.put("datascope", this.getFieldMap(FormulaEngine.extractVariables((String)expression)));
            }
        }
        catch (Exception exception) {
            // empty catch block
        }
    }

    private String[] extractVariables(String formula) {
        ArrayList<String> variables = new ArrayList<String>();
        int len = formula.length();
        Token token = Token.Text;
        for (int pos = 0; pos < len; ++pos) {
            char c = formula.charAt(pos);
            switch (c) {
                case '{': {
                    boolean condition = pos + 1 < len && formula.charAt(pos + 1) == '{';
                    Token token2 = token = condition ? Token.Escape : Token.Variable;
                }
            }
            if (token != Token.Variable) continue;
            int endIndex = formula.indexOf(125, pos + 1);
            if (endIndex == -1) break;
            String variableName = formula.substring(pos + 1, endIndex);
            variables.add(variableName);
            pos = endIndex;
            token = Token.Text;
        }
        return variables.toArray(new String[variables.size()]);
    }

    private Map<String, Set<String>> getFieldMap(String[] fields) {
        HashMap<String, Set<String>> map = new HashMap<String, Set<String>>();
        try {
            for (String field : fields) {
                String[] split = field.split("\\.");
                if (split.length > 1) {
                    if (this.type.getAllFields().get(split[0]) == null) continue;
                    map.computeIfAbsent(((IDataEntityProperty)this.type.getAllFields().get(split[0])).getParent().getName(), k -> new HashSet()).add(field);
                    continue;
                }
                if (this.type.getAllFields().get(field) == null) continue;
                map.computeIfAbsent(((IDataEntityProperty)this.type.getAllFields().get(field)).getParent().getName(), k -> new HashSet()).add(field);
            }
        }
        catch (Exception exception) {
            // empty catch block
        }
        return map;
    }

    public MainEntityType getType() {
        return this.type;
    }

    public Map<String, Set<String>> getFieldAndEntityInfo() {
        HashMap<String, Set<String>> map = new HashMap<String, Set<String>>();
        for (Map.Entry<String, Map<String, Set<String>>> entryField : this.entryFields.entrySet()) {
            for (Map.Entry<String, Set<String>> entry : entryField.getValue().entrySet()) {
                DynamicProperty property = this.type.getProperty(entry.getKey());
                if (property == null) continue;
                map.computeIfAbsent(entryField.getKey(), k -> new HashSet()).add(property.getDisplayName().getLocaleValue());
            }
        }
        return map;
    }

    public Map<String, String> getFieldAndName() {
        if (this.fieldAndName == null) {
            this.fieldAndName = new HashMap<String, String>();
            this.fieldAndName.put("description", ResManager.loadKDString((String)"\u6458\u8981", (String)"VchTemplEntryFieldInfo_0", (String)"fi-ai-common", (Object[])new Object[0]));
            this.fieldAndName.put("account", ResManager.loadKDString((String)"\u79d1\u76ee", (String)"VchTemplEntryFieldInfo_1", (String)"fi-ai-common", (Object[])new Object[0]));
            this.fieldAndName.put("accountAsst", ResManager.loadKDString((String)"\u6838\u7b97\u7ef4\u5ea6", (String)"VchTemplEntryFieldInfo_2", (String)"fi-ai-common", (Object[])new Object[0]));
            this.fieldAndName.put("expiredata", ResManager.loadKDString((String)"\u5230\u671f\u65e5", (String)"VchTemplEntryFieldInfo_3", (String)"fi-ai-common", (Object[])new Object[0]));
            this.fieldAndName.put("cashflowitem", ResManager.loadKDString((String)"\u73b0\u91d1\u6d41\u91cf\u9879\u76ee", (String)"VchTemplEntryFieldInfo_4", (String)"fi-ai-common", (Object[])new Object[0]));
            this.fieldAndName.put("cashflowAsst", ResManager.loadKDString((String)"\u4e3b\u8868\u9879\u76ee", (String)"VchTemplEntryFieldInfo_5", (String)"fi-ai-common", (Object[])new Object[0]));
            this.fieldAndName.put("dc", ResManager.loadKDString((String)"\u65b9\u5411", (String)"VchTemplEntryFieldInfo_6", (String)"fi-ai-common", (Object[])new Object[0]));
            this.fieldAndName.put("quantity", ResManager.loadKDString((String)"\u6570\u91cf", (String)"VchTemplEntryFieldInfo_7", (String)"fi-ai-common", (Object[])new Object[0]));
            this.fieldAndName.put("price", ResManager.loadKDString((String)"\u5355\u4ef7", (String)"VchTemplEntryFieldInfo_8", (String)"fi-ai-common", (Object[])new Object[0]));
            this.fieldAndName.put("measureunit", ResManager.loadKDString((String)"\u8ba1\u91cf\u5355\u4f4d", (String)"VchTemplEntryFieldInfo_9", (String)"fi-ai-common", (Object[])new Object[0]));
            this.fieldAndName.put("currency", ResManager.loadKDString((String)"\u5e01\u79cd", (String)"VchTemplEntryFieldInfo_10", (String)"fi-ai-common", (Object[])new Object[0]));
            this.fieldAndName.put("Rate", ResManager.loadKDString((String)"\u6c47\u7387", (String)"VchTemplEntryFieldInfo_11", (String)"fi-ai-common", (Object[])new Object[0]));
            this.fieldAndName.put("oriamount", ResManager.loadKDString((String)"\u539f\u5e01", (String)"VchTemplEntryFieldInfo_12", (String)"fi-ai-common", (Object[])new Object[0]));
            this.fieldAndName.put("localamount", ResManager.loadKDString((String)"\u672c\u4f4d\u5e01", (String)"VchTemplEntryFieldInfo_13", (String)"fi-ai-common", (Object[])new Object[0]));
            this.fieldAndName.put("datascope", ResManager.loadKDString((String)"\u5206\u5f55\u7b5b\u9009\u6761\u4ef6", (String)"VchTemplEntryFieldInfo_14", (String)"fi-ai-common", (Object[])new Object[0]));
        }
        return this.fieldAndName;
    }
}

