/*
 * Decompiled with CFR 0.152.
 */
package kd.fi.ai;

import com.fasterxml.jackson.annotation.JsonIgnore;
import java.io.Serializable;
import java.util.ArrayList;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.stream.Collectors;
import kd.bos.dataentity.entity.CollectionPropertyAttribute;
import kd.bos.dataentity.entity.ComplexPropertyAttribute;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.servicehelper.BusinessDataServiceHelper;
import kd.fi.ai.AbstractVchTplAsst;
import kd.fi.ai.AbstractVchTplItemMap;
import kd.fi.ai.VchFlexMappingItem;
import kd.fi.ai.VchTplAsstDimFactorSource;
import kd.fi.v2.fah.converters.common.ObjectConverterFactory;

public class VchTplMainAsst
extends AbstractVchTplAsst
implements Serializable {
    private static final long serialVersionUID = -7369485222716636504L;
    private List<AbstractVchTplItemMap> itemClassMaps = new ArrayList<AbstractVchTplItemMap>();
    private List<VchTplAsstDimFactorSource> asstFactors = new ArrayList<VchTplAsstDimFactorSource>();
    private VchFlexMappingItem flexMappingItem = new VchFlexMappingItem();

    @Override
    @CollectionPropertyAttribute(collectionItemPropertyType=AbstractVchTplItemMap.class)
    public List<AbstractVchTplItemMap> getItemClassMaps() {
        return this.itemClassMaps;
    }

    @Override
    public void setItemClassMaps(List<AbstractVchTplItemMap> itemClassMaps) {
        this.itemClassMaps = itemClassMaps;
    }

    @Override
    @CollectionPropertyAttribute(collectionItemPropertyType=VchTplAsstDimFactorSource.class)
    public List<VchTplAsstDimFactorSource> getAsstFactors() {
        return this.asstFactors;
    }

    @Override
    public void setAsstFactors(List<VchTplAsstDimFactorSource> asstFactors) {
        this.asstFactors = asstFactors;
    }

    @Override
    @JsonIgnore
    public Set<String> getAllItemID() {
        HashSet<String> ids = new HashSet<String>(this.itemClassMaps.size());
        for (AbstractVchTplItemMap m : this.itemClassMaps) {
            ids.add(m.getItemClass());
        }
        return ids;
    }

    @Override
    @JsonIgnore
    public String getDesc() {
        StringBuilder s = new StringBuilder();
        Set pks = this.itemClassMaps.stream().map(o -> ObjectConverterFactory.getLong(o.getItemClass())).collect(Collectors.toSet());
        Map nameMap = BusinessDataServiceHelper.loadFromCache((Object[])pks.toArray(), (String)"bd_asstacttype");
        for (AbstractVchTplItemMap itemMap : this.itemClassMaps) {
            String name = ((DynamicObject)nameMap.get(ObjectConverterFactory.getLong(itemMap.getItemClass()))).getString("name");
            s.append(name);
            s.append("/");
        }
        if (s.length() > 0 && '/' == s.charAt(s.length() - 1)) {
            s.deleteCharAt(s.length() - 1);
        }
        if (s.length() > 15) {
            return s.substring(0, 15) + "..";
        }
        return s.toString();
    }

    @Override
    @ComplexPropertyAttribute
    public VchFlexMappingItem getFlexMappingItem() {
        return this.flexMappingItem;
    }

    @Override
    public void setFlexMappingItem(VchFlexMappingItem flexMappingItem) {
        this.flexMappingItem = flexMappingItem;
    }
}

