/*
 * Decompiled with CFR 0.152.
 */
package kd.fi.ai.accountversion;

import java.util.ArrayList;
import java.util.Collections;
import java.util.Date;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.entity.DynamicObjectCollection;
import kd.bos.db.tx.TX;
import kd.bos.db.tx.TXHandle;
import kd.bos.ext.fi.accountref.AccountTableRef;
import kd.bos.orm.query.QFilter;
import kd.bos.servicehelper.BusinessDataServiceHelper;
import kd.bos.servicehelper.QueryServiceHelper;
import kd.bos.servicehelper.operation.DeleteServiceHelper;
import kd.bos.servicehelper.operation.SaveServiceHelper;
import kd.fi.ai.accountversion.AccountVersionBackup;
import kd.fi.ai.accountversion.VersionBackupUtil;

public class AccountMappingVersion {
    private static final String ACCOUNT_VIEW = "bd_accountview";
    private static final String BASE_FACTOR = "basefactor";

    public static void enable(long orgId, Date enableDate, AccountTableRef accountIdRef) {
        DynamicObject[] dynamicObjectArray;
        QFilter qfOrg = new QFilter("createorg", "=", (Object)orgId);
        QFilter tableQF = new QFilter("acctmapentry.entryaccttable", "=", (Object)accountIdRef.getOldAccountTableId());
        QFilter entityQF = new QFilter("fieldmapentry.entityid", "=", (Object)ACCOUNT_VIEW);
        AccountMappingVersion.changeFactoryAccountTable(orgId, enableDate, accountIdRef, new QFilter[]{qfOrg, entityQF});
        DynamicObjectCollection mappingInfo = QueryServiceHelper.query((String)"ai_accountmaptype", (String)"id,fieldmapentry.fieldkey fieldkey", (QFilter[])new QFilter[]{qfOrg, entityQF});
        HashMap<Long, String> idAndKey = new HashMap<Long, String>();
        ArrayList<QFilter> qfs = new ArrayList<QFilter>(idAndKey.size());
        for (Object mapping : mappingInfo) {
            String string2 = mapping.getString("fieldkey");
            string2 = BASE_FACTOR + string2.substring(string2.length() - 1);
            idAndKey.put(mapping.getLong("id"), string2);
        }
        qfs.add(new QFilter("id", "in", idAndKey.keySet()));
        StringBuilder strB = new StringBuilder();
        for (Map.Entry entry : idAndKey.entrySet()) {
            String value = (String)entry.getValue();
            strB.append("entryentity.");
            strB.append(value);
            strB.append(',');
            qfs.add(new QFilter("entryentity." + value, "in", (Object)accountIdRef.getOldAccountIdSet()));
        }
        strB.append("id,");
        strB.append("entryentity.entryid");
        ArrayList accInfos = new ArrayList();
        DynamicObject[] dynamicObjectArray2 = BusinessDataServiceHelper.load((String)"ai_accountmaptype", (String)strB.toString(), (QFilter[])qfs.toArray(new QFilter[0]));
        ArrayList<AccountVersionBackup> backups = new ArrayList<AccountVersionBackup>();
        for (DynamicObject account : dynamicObjectArray2) {
            String key = (String)idAndKey.get(account.getLong("id"));
            for (DynamicObject entry : account.getDynamicObjectCollection("entryentity")) {
                entry.set(key, (Object)accountIdRef.getNewAccountId(Long.valueOf(entry.getLong(key + "_id"))));
                backups.add(VersionBackupUtil.genAccountMappingAcctBackUp(orgId, entry.getLong(key + "_id"), enableDate, accountIdRef, account.getLong("id"), entry.getLong("entryid"), key));
            }
        }
        Collections.addAll(accInfos, dynamicObjectArray2);
        String strAc = "id,mulaccttable,acctmapentry.entryaccttable,acctmapentry,entryentity.accfield";
        for (DynamicObject account : dynamicObjectArray = BusinessDataServiceHelper.load((String)"ai_accountmaptype", (String)strAc, (QFilter[])new QFilter[]{qfOrg, tableQF})) {
            for (DynamicObject dyo : account.getDynamicObjectCollection("mulaccttable")) {
                if (dyo.getLong("fbasedataid_id") != accountIdRef.getOldAccountTableId()) continue;
                dyo.set("fbasedataid_id", (Object)accountIdRef.getNewAccountTableId());
            }
            for (DynamicObject entry : account.getDynamicObjectCollection("acctmapentry")) {
                if (entry.getLong("entryaccttable.id") != accountIdRef.getOldAccountTableId()) continue;
                entry.set("entryaccttable_id", (Object)accountIdRef.getNewAccountTableId());
                backups.add(VersionBackupUtil.genAccountMappingTableBackUp(orgId, enableDate, accountIdRef, account.getLong("id"), entry.getLong("id")));
            }
            for (DynamicObject entry : account.getDynamicObjectCollection("entryentity")) {
                Long oldAcc = entry.getLong("accfield.id");
                Long newAcc = accountIdRef.getNewAccountId(oldAcc);
                if (newAcc == null || newAcc == 0L) continue;
                String name = "accfield";
                entry.set(name, (Object)newAcc);
                backups.add(VersionBackupUtil.genAccountMappingAcctBackUp(orgId, oldAcc, enableDate, accountIdRef, account.getLong("id"), entry.getLong("id"), name));
            }
        }
        Collections.addAll(accInfos, dynamicObjectArray);
        AccountMappingVersion.saveInfo(accInfos.toArray(new DynamicObject[0]), backups);
    }

    private static void saveInfo(DynamicObject[] accountInfo, List<AccountVersionBackup> backups) {
        try (TXHandle h = TX.required((String)"accountmappingversion");){
            try {
                SaveServiceHelper.save((DynamicObject[])accountInfo);
                VersionBackupUtil.saveVersionBackup(backups);
            }
            catch (Throwable e) {
                h.markRollback();
                throw e;
            }
        }
    }

    public static void disable(long orgId, Date disableDate, AccountTableRef accountIdRef) {
        QFilter qfOrg = new QFilter("org", "=", (Object)orgId);
        QFilter dateQF = new QFilter("versiondate", "=", (Object)disableDate);
        QFilter metaQF = new QFilter("metadata", "=", (Object)"ai_accountmaptype");
        String select = "dataid,dataentryid,afaccountid,reaccountid,fieldtype";
        DynamicObjectCollection versions = QueryServiceHelper.query((String)"bd_account_updaterecord", (String)select, (QFilter[])new QFilter[]{qfOrg, dateQF, metaQF});
        if (versions.isEmpty()) {
            return;
        }
        HashMap<Long, List<DynamicObject>> mapidForDyo = new HashMap<Long, List<DynamicObject>>();
        for (DynamicObject version : versions) {
            List computeIfAbsent = mapidForDyo.computeIfAbsent(version.getLong("dataid"), k -> new ArrayList());
            computeIfAbsent.add(version);
        }
        String selectDis = "id,mulaccttable,acctmapentry.entryaccttable,acctmapentry,entryentity.accfield";
        DynamicObject[] maptypes = BusinessDataServiceHelper.load((String)"ai_accountmaptype", (String)selectDis, (QFilter[])new QFilter[]{new QFilter("id", "in", mapidForDyo.keySet())});
        if (accountIdRef.getOldAccountTableId() != accountIdRef.getNewAccountTableId()) {
            AccountMappingVersion.enableAccountRef(maptypes, mapidForDyo, accountIdRef);
        } else {
            AccountMappingVersion.disEnableSingleAccountRef(maptypes, mapidForDyo, accountIdRef);
        }
        SaveServiceHelper.save((DynamicObject[])maptypes);
        DeleteServiceHelper.delete((String)"bd_account_updaterecord", (QFilter[])new QFilter("dataid", "in", mapidForDyo.keySet()).toArray());
    }

    private static void changeFactoryAccountTable(long orgId, Date enableDate, AccountTableRef accountIdRef, QFilter[] qf) {
        DynamicObjectCollection mappingInfo = QueryServiceHelper.query((String)"ai_accountmaptype", (String)"id,fieldmapentry.fieldkey fieldkey", (QFilter[])qf);
        HashMap<Long, String> idAndKey = new HashMap<Long, String>();
        ArrayList<QFilter> qfs = new ArrayList<QFilter>(idAndKey.size());
        for (Object mapping : mappingInfo) {
            String string2 = mapping.getString("fieldkey");
            string2 = BASE_FACTOR + string2.substring(string2.length() - 1);
            idAndKey.put(mapping.getLong("id"), string2);
        }
        qfs.add(new QFilter("id", "in", idAndKey.keySet()));
        StringBuilder strB = new StringBuilder();
        for (Map.Entry entry : idAndKey.entrySet()) {
            String value = (String)entry.getValue();
            strB.append("entryentity.");
            strB.append(value);
            strB.append(',');
            qfs.add(new QFilter("entryentity." + value, "in", (Object)accountIdRef.getOldAccountIdSet()));
        }
        strB.append("id,");
        strB.append("entryentity.entryid");
        DynamicObject[] accountInfo = BusinessDataServiceHelper.load((String)"ai_accountmaptype", (String)strB.toString(), (QFilter[])qfs.toArray(new QFilter[0]));
        ArrayList<AccountVersionBackup> arrayList = new ArrayList<AccountVersionBackup>();
        for (DynamicObject account : accountInfo) {
            String key = (String)idAndKey.get(account.getLong("id"));
            for (DynamicObject entry : account.getDynamicObjectCollection("entryentity")) {
                entry.set(key, (Object)accountIdRef.getNewAccountId(Long.valueOf(entry.getLong(key + "_id"))));
                arrayList.add(VersionBackupUtil.genAccountMappingAcctBackUp(orgId, entry.getLong(key + "_id"), enableDate, accountIdRef, account.getLong("id"), entry.getLong("entryid"), key));
            }
        }
        VersionBackupUtil.saveVersionBackup(arrayList);
    }

    private static void disEnableSingleAccountRef(DynamicObject[] maptypes, Map<Long, List<DynamicObject>> mapidForDyo, AccountTableRef accountIdRef) {
        for (DynamicObject maptype : maptypes) {
            List<DynamicObject> vers = mapidForDyo.get(maptype.getLong("id"));
            for (DynamicObject ver : vers) {
                if (!Objects.equals(ver.getString("fieldtype"), "acct")) continue;
                for (DynamicObject dyo : maptype.getDynamicObjectCollection("entryentity")) {
                    if (dyo.getLong("id") != ver.getLong("dataentryid")) continue;
                    Map oldAndNewAccountRef = accountIdRef.getAccountRef().getOldAndNewAccountRef();
                    for (Map.Entry entry : oldAndNewAccountRef.entrySet()) {
                        if (((Long)entry.getValue()).longValue() != ver.getLong("afaccountid")) continue;
                        dyo.set("accfield", entry.getKey());
                    }
                }
            }
        }
    }

    private static void enableAccountRef(DynamicObject[] maptypes, Map<Long, List<DynamicObject>> mapidForDyo, AccountTableRef accountIdRef) {
        for (DynamicObject maptype : maptypes) {
            List<DynamicObject> vers = mapidForDyo.get(maptype.getLong("id"));
            for (DynamicObject ver : vers) {
                if (Objects.equals(ver.getString("fieldtype"), "acct")) {
                    for (DynamicObject dyo : maptype.getDynamicObjectCollection("entryentity")) {
                        if (dyo.getLong("id") != ver.getLong("dataentryid")) continue;
                        dyo.set("accfield", (Object)ver.getLong("reaccountid"));
                        break;
                    }
                } else {
                    for (DynamicObject dyo : maptype.getDynamicObjectCollection("acctmapentry")) {
                        if (dyo.getLong("id") != ver.getLong("dataentryid")) continue;
                        dyo.set("entryaccttable", (Object)ver.getLong("reaccountid"));
                        break;
                    }
                }
                for (DynamicObject dyo : maptype.getDynamicObjectCollection("mulaccttable")) {
                    if (dyo.getLong("fbasedataid_id") != accountIdRef.getNewAccountTableId()) continue;
                    dyo.set("fbasedataid_id", (Object)accountIdRef.getOldAccountTableId());
                }
            }
        }
    }
}

