/*
 * Decompiled with CFR 0.152.
 */
package kd.fi.ai.convert.impl;

import java.util.List;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.serialization.SerializationUtils;
import kd.bos.orm.query.QFilter;
import kd.bos.servicehelper.BusinessDataServiceHelper;
import kd.bos.util.StringUtils;
import kd.fi.ai.AbstractVchTplItemMap;
import kd.fi.ai.VchTplAcctItemMap;
import kd.fi.ai.VchTplAgrs;
import kd.fi.ai.VchTplAgrss;
import kd.fi.ai.VchTplAsst;
import kd.fi.ai.VchTplAsstDimFactorSource;
import kd.fi.ai.VchTplExpression;
import kd.fi.ai.convert.core.MarshallingContext;
import kd.fi.ai.convert.core.UnmarshallingContext;
import kd.fi.ai.convert.impl.AbstractConverter;
import org.dom4j.DocumentHelper;
import org.dom4j.Element;

public class AccountAsstConverter
extends AbstractConverter {
    @Override
    public Object marshal(String field, Object source, MarshallingContext context) {
        super.marshal(field, source, context);
        if (source == null) {
            return this.root;
        }
        VchTplAsst accts = (VchTplAsst)source;
        List<AbstractVchTplItemMap> items = accts.getItemClassMaps();
        if (items.size() == 0) {
            return this.root;
        }
        this.marshalItemClass(items);
        List<VchTplAsstDimFactorSource> acctFactors = accts.getAsstFactors();
        this.marshalAcctFactor(acctFactors);
        return this.root;
    }

    @Override
    public Object unmarshal(Object source, UnmarshallingContext context) {
        Element factors;
        VchTplAsst accts = new VchTplAsst();
        if (source == null) {
            return accts;
        }
        Element data = (Element)source;
        if (data.elements().size() == 0) {
            return accts;
        }
        Element assts = data.element("assts");
        if (assts != null) {
            this.unmarshalItemClass(accts, assts.elements());
        }
        if ((factors = data.element("factors")) != null) {
            this.unmarshalAcctFactor(accts, factors.elements());
        }
        return accts;
    }

    private void marshalItemClass(List<AbstractVchTplItemMap> items) {
        DynamicObject asstType = null;
        String dt = null;
        String valueType = null;
        Element asstNodes = DocumentHelper.createElement((String)"assts");
        this.addChild(this.root, asstNodes);
        for (AbstractVchTplItemMap item : items) {
            Element asstSonNodes;
            Element asstNode = DocumentHelper.createElement((String)"assts");
            VchTplAgrss vchTplAgrss = item.getVchTplAgrss();
            if (StringUtils.isNotEmpty((String)item.getItemClass())) {
                asstType = BusinessDataServiceHelper.loadSingle((Object)item.getItemClass(), (String)"bd_asstacttype");
            }
            if (asstType == null) continue;
            this.addChild(asstNode, "asstType", asstType.getString("number"));
            valueType = asstType.getString("valuetype");
            if ("1".equals(valueType)) {
                DynamicObject baseData = (DynamicObject)asstType.get("valuesource");
                dt = baseData.getString("id");
            }
            if ("2".equals(valueType)) {
                dt = "bos_assistantdata_detail";
            }
            this.addChild(asstNode, "dt", dt);
            String sourceFieldKey = item.getSourceFieldKey();
            Long mapId = item.getAsstDimMapID();
            String exp = item.getExp();
            if (StringUtils.isNotEmpty((String)sourceFieldKey)) {
                this.addChild(asstNode, "type", "1");
                this.addChild(asstNode, "value", item.getSourceFieldKey());
                this.addChild(asstNode, "desc", item.getConstName());
            } else if (Long.class.getName().equals(item.getConstType())) {
                this.addChild(asstNode, "type", "5");
                this.addChild(asstNode, "valueType", valueType);
                Element asstSonNode = DocumentHelper.createElement((String)"asstSon");
                this.addChild(asstSonNode, "filterSet", SerializationUtils.toJsonString((Object)new VchTplExpression()));
                if ("1".equals(valueType)) {
                    if (StringUtils.isNotEmpty((String)item.getConstValue())) {
                        DynamicObject baseData = BusinessDataServiceHelper.loadSingle((Object)item.getConstValue(), (String)dt);
                        this.addChild(asstNode, "value", baseData == null ? "" : baseData.getString("number"));
                        this.addChild(asstSonNode, "asstid", item.getConstValue());
                        this.addChild(asstSonNode, "asstName", baseData == null ? "" : baseData.getString("name"));
                    }
                } else if ("2".equals(valueType)) {
                    if (StringUtils.isNotEmpty((String)item.getConstValue())) {
                        DynamicObject type = (DynamicObject)asstType.get("assistanttype");
                        DynamicObject baseData = BusinessDataServiceHelper.loadSingle((Object)item.getConstValue(), (String)dt);
                        this.addChild(asstNode, "type", type.getString("number"));
                        this.addChild(asstNode, "value", baseData.getString("number"));
                        this.addChild(asstSonNode, "asstid", item.getConstValue());
                        this.addChild(asstSonNode, "asstName", baseData.getString("name"));
                    }
                } else if ("3".equals(valueType)) {
                    this.addChild(asstNode, "value", item.getConstName());
                    this.addChild(asstNode, "desc", item.getConstValue());
                }
                asstSonNodes = DocumentHelper.createElement((String)"asstSons");
                this.addChild(asstSonNodes, asstSonNode);
                this.addChild(asstNode, asstSonNodes);
            } else if (mapId != 0L) {
                this.addChild(asstNode, "type", "3");
                if (mapId != 0L) {
                    DynamicObject mapping = BusinessDataServiceHelper.loadSingle((Object)mapId, (String)"ai_asstdimmaptype");
                    this.addChild(asstNode, "value", mapping == null ? "" : mapping.getString("number"));
                }
            } else if (StringUtils.isNotEmpty((String)exp)) {
                this.addChild(asstNode, "type", "4");
                this.addChild(asstNode, "value", item.getExp());
                this.addChild(asstNode, "desc", item.getExpDesc());
            } else if (vchTplAgrss != null) {
                List<VchTplAgrs> assitems = vchTplAgrss.getItems();
                this.addChild(asstNode, "type", "5");
                asstSonNodes = DocumentHelper.createElement((String)"asstSons");
                for (VchTplAgrs vchTplAgrs : assitems) {
                    Element asstSonNode = DocumentHelper.createElement((String)"asstSon");
                    this.addChild(asstSonNode, "asstid", vchTplAgrs.getAsstid());
                    this.addChild(asstSonNode, "asstName", vchTplAgrs.getAsstName());
                    this.addChild(asstSonNode, "asstNumber", vchTplAgrs.getAsstNumber());
                    this.addChild(asstSonNode, "filterSet", SerializationUtils.toJsonString((Object)vchTplAgrs.getFilterSet()));
                    this.addChild(asstSonNodes, asstSonNode);
                }
                this.addChild(asstNode, asstSonNodes);
            }
            this.addChild(asstNodes, asstNode);
        }
    }

    private void marshalAcctFactor(List<VchTplAsstDimFactorSource> acctFactors) {
        Element factorNodes = DocumentHelper.createElement((String)"factors");
        this.addChild(this.root, factorNodes);
        for (VchTplAsstDimFactorSource item : acctFactors) {
            Element factorNode = DocumentHelper.createElement((String)"factor");
            this.addChild(factorNode, "type", item.getDataType());
            this.addChild(factorNode, "srcField", item.getSourceFieldKey());
            this.addChild(factorNode, "exp", item.getEntityExp());
            this.addChild(factorNode, "desc", item.getEntityExpDesc());
            this.addChild(factorNode, "name", item.getFactorName());
            this.addChild(factorNode, "key", item.getFactorKey());
            this.addChild(factorNodes, factorNode);
        }
    }

    private void unmarshalItemClass(VchTplAsst accts, List<Element> nodes) {
        if (nodes == null || nodes.size() == 0) {
            return;
        }
        String asstTypeNum = null;
        String dt = null;
        String type = null;
        String value = null;
        String desc = null;
        String valueType = null;
        DynamicObject asstType = null;
        DynamicObject baseData = null;
        for (Element node : nodes) {
            VchTplAcctItemMap item = new VchTplAcctItemMap();
            asstTypeNum = node.elementText("asstType");
            String flexmapping = node.elementText("flexmapping");
            if (flexmapping != null) {
                item.setFlexMappingid(Long.parseLong(flexmapping));
            }
            if (StringUtils.isEmpty((String)asstTypeNum) || (asstType = BusinessDataServiceHelper.loadSingleFromCache((String)"bd_asstacttype", (String)"id, name, valuesource, assistanttype", (QFilter[])new QFilter[]{new QFilter("number", "=", (Object)asstTypeNum)})) == null) continue;
            item.setItemClass(asstType.getString("id"));
            item.setItemName(asstType.getString("name"));
            String valuesource = null;
            Long assitanttype = null;
            if (null != asstType.getDynamicObject("valuesource") && null != asstType.getDynamicObject("assistanttype")) {
                valuesource = asstType.getDynamicObject("valuesource").getString("id");
                assitanttype = asstType.getDynamicObject("assistanttype").getLong("id");
            }
            dt = node.elementText("dt");
            type = node.elementText("type");
            value = node.elementText("value");
            desc = node.elementText("desc");
            item.setConstType(String.class.getName());
            if (type == null) {
                accts.getItemClassMaps().add(item);
                continue;
            }
            switch (type) {
                case "1": {
                    item.setSourceFieldKey(value);
                    item.setConstName(desc);
                    break;
                }
                case "2": {
                    valueType = node.elementText("valueType");
                    item.setConstType(Long.class.getName());
                    switch (valueType) {
                        case "1": {
                            baseData = BusinessDataServiceHelper.loadSingleFromCache((String)dt, (String)"id,name", (QFilter[])new QFilter[]{new QFilter("number", "=", (Object)value)});
                            if (baseData == null) break;
                            item.setConstName(baseData.getString("name"));
                            item.setConstValue(baseData.getString("id"));
                            break;
                        }
                        case "2": {
                            baseData = BusinessDataServiceHelper.loadSingle((String)dt, (String)"id,name", (QFilter[])new QFilter[]{new QFilter("number", "=", (Object)value)});
                            if (baseData == null) break;
                            item.setConstValue(baseData.getString("id"));
                            item.setConstName(baseData.getString("name"));
                            break;
                        }
                        case "3": {
                            item.setConstValue(desc);
                            item.setConstName(value);
                        }
                    }
                    break;
                }
                case "3": {
                    baseData = BusinessDataServiceHelper.loadSingleFromCache((String)"ai_asstdimmaptype", (String)"id,name", (QFilter[])new QFilter[]{new QFilter("number", "=", (Object)value)});
                    if (baseData == null) break;
                    item.setAsstDimMapID(baseData.getLong("id"));
                    break;
                }
                case "4": {
                    item.setExp(value);
                    item.setExpDesc(desc);
                    break;
                }
                case "5": {
                    VchTplAgrss vchTplAgrss = new VchTplAgrss();
                    Element asstSons = node.element("asstSons");
                    List sons = asstSons.elements();
                    StringBuilder sb = new StringBuilder();
                    for (Element son : sons) {
                        DynamicObject dyn = null;
                        dyn = "bos_assistantdata_detail".equals(valuesource) ? this.getAsstDynamicObject(son, dt, assitanttype) : this.getAsstDynamicObject(son, dt);
                        if (dyn == null) continue;
                        VchTplAgrs vchTplAgrs = new VchTplAgrs();
                        vchTplAgrs.setAsstid(dyn.getString("id"));
                        vchTplAgrs.setAsstName(dyn.getString("name"));
                        vchTplAgrs.setAsstNumber(dyn.getString("number"));
                        vchTplAgrs.setFilterSet((VchTplExpression)SerializationUtils.fromJsonString((String)son.elementText("filterSet"), VchTplExpression.class));
                        vchTplAgrss.getItems().add(vchTplAgrs);
                        sb.append(son.elementText("asstName")).append('/');
                    }
                    item.setVchTplAgrss(vchTplAgrss);
                    if (sb.length() <= 0) break;
                    item.setVchTplAgrssName(sb.substring(0, sb.length() - 1));
                }
            }
            accts.getItemClassMaps().add(item);
        }
    }

    private DynamicObject getAsstDynamicObject(Element son, String entity) {
        if (StringUtils.isEmpty((String)entity)) {
            return null;
        }
        DynamicObject dynamicObject = null;
        if (StringUtils.isNotEmpty((String)son.elementText("asstid"))) {
            QFilter idFilter = new QFilter("id", "=", (Object)Long.valueOf(son.elementText("asstid")));
            dynamicObject = BusinessDataServiceHelper.loadSingle((String)entity, (String)"id,name,number", (QFilter[])idFilter.toArray());
        }
        if (dynamicObject != null) {
            return dynamicObject;
        }
        String number = son.elementText("asstNumber");
        if (StringUtils.isNotEmpty((String)number)) {
            QFilter numberFilter = new QFilter("number", "=", (Object)number);
            dynamicObject = BusinessDataServiceHelper.loadSingle((String)entity, (String)"id,name,number", (QFilter[])numberFilter.toArray());
        }
        return dynamicObject;
    }

    private DynamicObject getAsstDynamicObject(Element son, String entity, Long assitanttype) {
        if (StringUtils.isEmpty((String)entity)) {
            return null;
        }
        DynamicObject dynamicObject = null;
        if (StringUtils.isNotEmpty((String)son.elementText("asstid"))) {
            QFilter idFilter = new QFilter("id", "=", (Object)Long.valueOf(son.elementText("asstid")));
            dynamicObject = BusinessDataServiceHelper.loadSingle((String)entity, (String)"id,name,number", (QFilter[])idFilter.toArray());
        }
        if (dynamicObject != null) {
            return dynamicObject;
        }
        String number = son.elementText("asstNumber");
        if (StringUtils.isNotEmpty((String)number)) {
            dynamicObject = BusinessDataServiceHelper.loadSingle((String)entity, (String)"id,name,number", (QFilter[])new QFilter[]{new QFilter("number", "=", (Object)number), new QFilter("group", "=", (Object)assitanttype)});
        }
        return dynamicObject;
    }

    private void unmarshalAcctFactor(VchTplAsst accts, List<Element> nodes) {
        if (nodes == null || nodes.size() == 0) {
            return;
        }
        for (Element node : nodes) {
            VchTplAsstDimFactorSource vchTpAsst = new VchTplAsstDimFactorSource();
            vchTpAsst.setDataType(node.elementText("type"));
            vchTpAsst.setSourceFieldKey(node.elementText("srcField"));
            vchTpAsst.setEntityExp(node.elementText("exp"));
            vchTpAsst.setEntityExpDesc(node.elementText("desc"));
            vchTpAsst.setFactorName(node.elementText("name"));
            vchTpAsst.setFactorKey(node.elementText("key"));
            accts.getAsstFactors().add(vchTpAsst);
        }
    }

    @Override
    public String getType() {
        return "bd_accountasst";
    }
}

