/*
 * Decompiled with CFR 0.152.
 */
package kd.fi.ai.convert.impl;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.dataentity.serialization.SerializationUtils;
import kd.bos.dataentity.utils.StringUtils;
import kd.bos.exception.BosErrorCode;
import kd.bos.exception.KDBizException;
import kd.bos.orm.query.QFilter;
import kd.bos.servicehelper.BusinessDataServiceHelper;
import kd.fi.ai.VCHTemplate;
import kd.fi.ai.VchFlexMappingItem;
import kd.fi.ai.VchSingleFlexMapping;
import kd.fi.ai.VchTplAcccounts;
import kd.fi.ai.VchTplAccount;
import kd.fi.ai.VchTplAcctFactorMap;
import kd.fi.ai.VchTplAccts;
import kd.fi.ai.VchTplExpression;
import kd.fi.ai.convert.core.MarshallingContext;
import kd.fi.ai.convert.core.UnmarshallingContext;
import kd.fi.ai.convert.impl.AbstractConverter;
import kd.fi.ai.util.DapFileUtil;
import kd.fi.v2.fah.dao.sys.SysBasePropDataDaoImpl;
import org.dom4j.DocumentHelper;
import org.dom4j.Element;

public class AccountConverter
extends AbstractConverter {
    @Override
    public Object marshal(String field, Object source, MarshallingContext context) {
        super.marshal(field, source, context);
        if (source == null) {
            return this.root;
        }
        VchTplAccts accts = (VchTplAccts)source;
        if (StringUtils.isEmpty((CharSequence)accts.getSourcetype())) {
            return this.root;
        }
        HashMap<String, String> mapNumMap = new HashMap<String, String>();
        this.addChild(this.root, "type", accts.getSourcetype());
        if ("fix".equalsIgnoreCase(accts.getSourcetype())) {
            DynamicObject account = BusinessDataServiceHelper.loadSingle((Object)accts.getConstid(), (String)"bd_accountview", (String)"id,number,name,masterid");
            if (account != null) {
                this.addChild(this.root, "masterid", account.getString("masterid"));
                this.addChild(this.root, "number", account.getString("number"));
                this.addChild(this.root, "name", account.getString("name"));
            }
        } else if ("mapping".equalsIgnoreCase(accts.getSourcetype())) {
            DynamicObject mapping = BusinessDataServiceHelper.loadSingle((Object)accts.getMappingid(), (String)"ai_accountmaptype", (String)"id,number,name");
            if (mapping != null) {
                this.addChild(this.root, "id", accts.getMappingid() + "");
                this.addChild(this.root, "number", mapping.getString("number"));
                this.addChild(this.root, "name", mapping.getString("name"));
                mapNumMap.put(accts.getMappingid() + "", mapping.getString("number"));
            }
        } else if ("exp".equalsIgnoreCase(accts.getSourcetype())) {
            this.addChild(this.root, "name", accts.getAcctName());
            this.addChild(this.root, "exp", accts.getExp());
        } else if ("conditionexp".equalsIgnoreCase(accts.getSourcetype())) {
            List<VchTplAccount> items;
            this.addChild(this.root, "name", accts.getAcctName());
            VchTplAcccounts vchTplAcccounts = accts.getVchTplAcccounts();
            if (vchTplAcccounts != null && (items = vchTplAcccounts.getItems()).size() > 0) {
                this.marshalVchTplAccount(items);
            }
        } else if ("commonmapping".equalsIgnoreCase(accts.getSourcetype())) {
            this.addChild(this.root, "flexmappignid", accts.getFlexMappingId() + "");
            this.addChild(this.root, "flexmappignidname", accts.getAcctName() + "");
            Element accountNodes = DocumentHelper.createElement((String)"flexmappignitem");
            this.addChild(this.root, accountNodes);
            for (VchSingleFlexMapping data : accts.getFlexMappingItem().getDataCol()) {
                Element accountNode = DocumentHelper.createElement((String)"accountflex");
                this.addChild(accountNode, "mappingtype", data.getMappingType() + "");
                this.addChild(accountNode, "mappingname", data.getMappingName() + "");
                this.addChild(accountNode, "ismustinput", (Element)context.marshall("mustinput", "boolean", data.isIsmustInput()));
                this.addChild(accountNode, "sourcefield", data.getSourceField() + "");
                this.addChild(accountNode, "mappingextstr", data.getMappingexpstr() + "");
                this.addChild(accountNode, "mappingext", data.getMappingexp() + "");
                this.addChild(accountNode, "parentid", data.getParentIds() + "");
                this.addChild(accountNodes, accountNode);
            }
        }
        List<VchTplAcctFactorMap> factors = accts.getFactorMaps();
        if (factors.size() > 0) {
            this.marshalAcctFactor(factors, mapNumMap);
        }
        return this.root;
    }

    private void marshalVchTplAccount(List<VchTplAccount> items) {
        Element accountNodes = DocumentHelper.createElement((String)"accounts");
        this.addChild(this.root, accountNodes);
        for (VchTplAccount item : items) {
            Element accountNode = DocumentHelper.createElement((String)"account");
            this.addChild(accountNode, "id", item.getAccountid() + "");
            this.addChild(accountNode, "number", item.getAccountNumber());
            this.addChild(accountNode, "name", item.getAccountNumber());
            this.addChild(accountNode, "filterSet", SerializationUtils.toJsonString((Object)item.getFilterSet()));
            this.addChild(accountNodes, accountNode);
        }
    }

    private void marshalAcctFactor(List<VchTplAcctFactorMap> factors, Map<String, String> mapNumMap) {
        Element factorNodes = DocumentHelper.createElement((String)"factors");
        this.addChild(this.root, factorNodes);
        for (VchTplAcctFactorMap item : factors) {
            Element factorNode = DocumentHelper.createElement((String)"factor");
            this.addChild(factorNode, "factor", item.getFactor());
            this.addChild(factorNode, "expdescentity", item.getExpdescentity());
            this.addChild(factorNode, "expvalentity", item.getExpvalentity());
            this.addChild(factorNode, "sourceFieldKey", item.getSourceFieldKey());
            this.addChild(factorNode, "number", item.getMapping() + "");
            this.addChild(factorNodes, factorNode);
        }
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    @Override
    public Object unmarshal(Object source, UnmarshallingContext context) {
        Element flexmappignitem;
        VchTplAccts accts = new VchTplAccts();
        if (source == null) {
            return accts;
        }
        Element data = (Element)source;
        if (data.elements().size() == 0) {
            return accts;
        }
        String type = this.getElementText(data.element("type"));
        accts.setSourcetype(type);
        VCHTemplate vchTemplate = (VCHTemplate)context.get("vchTemplate");
        HashMap<String, Long> mapNumMap = new HashMap<String, Long>();
        if ("fix".equalsIgnoreCase(type)) {
            QFilter tableFilter = new QFilter("accounttable", "=", (Object)vchTemplate.getAcctTableId());
            QFilter filter = new QFilter("number", "=", (Object)this.getElementText(data.element("number")));
            Map<Object, DynamicObject> account = SysBasePropDataDaoImpl.queryBaseDataMap("bd_accountview", DapFileUtil.getOrgId(), "id,number,name,masterid", tableFilter, filter);
            if (account != null && account.size() > 0) {
                DynamicObject acct = account.values().toArray(new DynamicObject[0])[0];
                VchTplAccount vchTplAccount = new VchTplAccount();
                vchTplAccount.setAccountid(acct.getLong("id"));
                vchTplAccount.setAccountNumber(acct.getString("number"));
                vchTplAccount.setAcctName(acct.getString("name"));
                accts.getVchTplAcccounts().getItems().add(vchTplAccount);
                accts.setAcctName(acct.getString("name"));
                accts.setSourcetype("conditionexp");
            }
        } else if ("mapping".equalsIgnoreCase(type)) {
            QFilter filter = new QFilter("number", "=", (Object)this.getElementText(data.element("number")));
            Map<Object, DynamicObject> account = SysBasePropDataDaoImpl.queryBaseDataMap("ai_accountmaptype", DapFileUtil.getOrgId(), "id,number,name", filter);
            if (account == null || account.size() <= 0) throw new KDBizException(BosErrorCode.operationFailed, new Object[]{ResManager.loadKDString((String)"\u79d1\u76ee\u5f71\u54cd\u56e0\u7d20\u4e0d\u5b58\u5728\uff0c\u8bf7\u5148\u7ef4\u62a4\u79d1\u76ee\u5f71\u54cd\u56e0\u7d20\u3002", (String)"AccountConverter_01", (String)"fi-ai-common", (Object[])new Object[0])});
            DynamicObject acct = account.values().toArray(new DynamicObject[0])[0];
            accts.setMappingid(acct.getLong("id"));
            accts.setAcctName(acct.getString("name"));
            mapNumMap.put(acct.getString("number"), acct.getLong("id"));
        } else if ("exp".equalsIgnoreCase(type)) {
            accts.setExp(this.getElementText(data.element("exp")));
            accts.setAcctName(this.getElementText(data.element("name")));
        } else if ("conditionexp".equalsIgnoreCase(accts.getSourcetype())) {
            Element accounts = data.element("accounts");
            if (accounts == null) {
                return accts;
            }
            List nodes = accounts.elements();
            HashMap<String, String> map = new HashMap<String, String>(nodes.size());
            ArrayList<String> numbers = new ArrayList<String>(nodes.size());
            for (Element node : nodes) {
                numbers.add(node.elementText("number"));
                map.put(node.elementText("number"), node.elementText("filterSet"));
            }
            QFilter tableFilter = new QFilter("accounttable", "=", (Object)vchTemplate.getAcctTableId());
            QFilter filter = new QFilter("number", "in", numbers);
            Map<Object, DynamicObject> dyns = SysBasePropDataDaoImpl.queryBaseDataMap("bd_accountview", DapFileUtil.getOrgId(), "id,number,name", tableFilter, filter);
            if (dyns != null && !dyns.isEmpty()) {
                HashMap<String, Long> numberIdMap = new HashMap<String, Long>(dyns.size());
                HashMap<String, String> numberNameMap = new HashMap<String, String>(dyns.size());
                for (Map.Entry<Object, DynamicObject> entry : dyns.entrySet()) {
                    DynamicObject dyn = entry.getValue();
                    numberIdMap.put(dyn.getString("number"), dyn.getLong("id"));
                    numberNameMap.put(dyn.getString("number"), dyn.getString("name"));
                }
                StringBuilder sb = new StringBuilder();
                for (String number : numbers) {
                    if (!numberIdMap.containsKey(number)) continue;
                    VchTplAccount vchTplAccount = new VchTplAccount();
                    vchTplAccount.setAccountid((Long)numberIdMap.get(number));
                    vchTplAccount.setAccountNumber(number);
                    vchTplAccount.setAcctName((String)numberNameMap.get(number));
                    vchTplAccount.setFilterSet((VchTplExpression)SerializationUtils.fromJsonString((String)((String)map.get(number)), VchTplExpression.class));
                    sb.append((String)numberNameMap.get(number)).append('/');
                    accts.getVchTplAcccounts().getItems().add(vchTplAccount);
                }
                if (sb.length() > 0) {
                    accts.setAcctName(sb.substring(0, sb.length() - 1));
                }
            }
        } else if ("commonmapping".equalsIgnoreCase(accts.getSourcetype()) && (flexmappignitem = data.element("flexmappignitem")) != null) {
            String elementText = this.getElementText(data.element("flexmappignid"));
            String flexmappignidname = this.getElementText(data.element("flexmappignidname"));
            accts.setFlexMappingId(elementText != null ? Long.parseLong(elementText) : 0L);
            accts.setAcctName(flexmappignidname);
            List nodes = flexmappignitem.elements();
            VchFlexMappingItem vchFlexMappingItem = new VchFlexMappingItem();
            for (Element node : nodes) {
                VchSingleFlexMapping singleFlex = new VchSingleFlexMapping();
                singleFlex.setMappingType(Long.parseLong(node.elementText("mappingtype")));
                singleFlex.setIsmustInput((Boolean)context.unmarshall("boolean", node.element("ismustinput")));
                singleFlex.setMappingexp(node.elementText("mappingext"));
                singleFlex.setMappingexpstr(node.elementText("mappingextstr"));
                singleFlex.setMappingName(node.elementText("mappingname"));
                singleFlex.setParentIds(Long.parseLong(node.elementText("parentid")));
                singleFlex.setSourceField(node.elementText("sourcefield"));
                vchFlexMappingItem.addDataCol(singleFlex);
            }
            accts.setFlexMappingItem(vchFlexMappingItem);
        }
        Element factors = data.element("factors");
        if (factors == null) return accts;
        this.unmarshalAcctFactor(accts, factors.elements(), mapNumMap);
        return accts;
    }

    private void unmarshalAcctFactor(VchTplAccts accts, List<Element> nodes, Map<String, Long> mapNumMap) {
        if (nodes == null || nodes.size() == 0) {
            return;
        }
        for (Element node : nodes) {
            VchTplAcctFactorMap vchTpAsst = new VchTplAcctFactorMap();
            vchTpAsst.setExpdescentity(node.elementText("expdescentity"));
            vchTpAsst.setExpvalentity(node.elementText("expvalentity"));
            vchTpAsst.setFactor(node.elementText("factor"));
            vchTpAsst.setSourceFieldKey(node.elementText("sourceFieldKey"));
            if (StringUtils.isNotEmpty((CharSequence)node.elementText("number"))) {
                vchTpAsst.setMapping(Long.valueOf(node.elementText("number")));
            }
            accts.getFactorMaps().add(vchTpAsst);
        }
    }

    @Override
    public String getType() {
        return "bd_accountview";
    }
}

