/*
 * Decompiled with CFR 0.152.
 */
package kd.fi.ai.convert.impl;

import java.util.ArrayList;
import java.util.List;
import kd.bos.algo.DataSet;
import kd.bos.algo.Row;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.entity.DynamicObjectCollection;
import kd.bos.dataentity.utils.Uuid8;
import kd.bos.orm.query.QFilter;
import kd.bos.servicehelper.QueryServiceHelper;
import kd.fi.ai.convert.core.MarshallingContext;
import kd.fi.ai.convert.core.UnmarshallingContext;
import kd.fi.ai.convert.impl.AbstractConverter;
import org.dom4j.DocumentHelper;
import org.dom4j.Element;

public class MultiBaseDataConverter
extends AbstractConverter {
    @Override
    public Object marshal(String field, Object source, MarshallingContext context) {
        super.marshal(field, source, context);
        if (source == null) {
            return this.root;
        }
        DynamicObjectCollection baseDataInfos = (DynamicObjectCollection)source;
        if (baseDataInfos.isEmpty()) {
            return this.root;
        }
        String name = ((DynamicObject)baseDataInfos.get(0)).getDynamicObject("fbasedataid").getDataEntityType().getName();
        for (DynamicObject baseDataInfo : baseDataInfos) {
            DynamicObject dyn = baseDataInfo.getDynamicObject("fbasedataid");
            Element element = DocumentHelper.createElement((String)name);
            this.addChild(element, "id", dyn.getString("masterid"));
            this.addChild(element, "number", dyn.getString("number"));
            this.addChild(element, "name", dyn.getString("name"));
            this.addChild(this.root, element);
        }
        return this.root;
    }

    @Override
    public Object unmarshal(Object source, UnmarshallingContext context) {
        QFilter filter;
        Element ele = (Element)source;
        List elements = ele.elements("bd_accountbookstype");
        if (elements == null || elements.isEmpty()) {
            return null;
        }
        ArrayList<Long> ids = new ArrayList<Long>(elements.size());
        ArrayList<String> numbers = new ArrayList<String>(elements.size());
        String entity = "bd_accountbookstype";
        for (Element element : elements) {
            ids.add(Long.parseLong(element.elementText("id")));
            numbers.add(element.elementText("number"));
        }
        QFilter idFilter = null;
        if (!ids.isEmpty()) {
            idFilter = new QFilter("id", "in", ids);
        }
        QFilter numberFilter = null;
        if (!numbers.isEmpty()) {
            numberFilter = new QFilter("number", "in", numbers);
        }
        QFilter qFilter = filter = idFilter == null ? numberFilter : idFilter.or(numberFilter);
        if (filter == null) {
            return null;
        }
        ArrayList<Long> booktypeids = new ArrayList<Long>(16);
        try (DataSet ds = QueryServiceHelper.queryDataSet((String)(this.getClass().getName() + Uuid8.generateShortUuid()), (String)entity, (String)"id", (QFilter[])new QFilter[]{filter}, null);){
            Row row = null;
            while (ds.hasNext()) {
                row = ds.next();
                booktypeids.add(row.getLong("id"));
            }
            ArrayList<Long> arrayList = booktypeids;
            return arrayList;
        }
    }

    @Override
    public String getType() {
        return "multibasedata";
    }
}

