/*
 * Decompiled with CFR 0.152.
 */
package kd.fi.ai.convert.impl;

import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.serialization.SerializationUtils;
import kd.bos.orm.query.QFilter;
import kd.bos.servicehelper.BusinessDataServiceHelper;
import kd.bos.servicehelper.basedata.BaseDataServiceHelper;
import kd.fi.ai.VchTplCreator;
import kd.fi.ai.VchTplExpression;
import kd.fi.ai.convert.core.MarshallingContext;
import kd.fi.ai.convert.core.UnmarshallingContext;
import kd.fi.ai.convert.impl.AbstractConverter;
import kd.fi.ai.util.DapFileUtil;
import org.dom4j.Element;

public class VchCreatorConverter
extends AbstractConverter {
    @Override
    public String getType() {
        return "vchcreator";
    }

    @Override
    public Object marshal(String field, Object source, MarshallingContext context) {
        super.marshal(field, source, context);
        if (source == null) {
            return this.root;
        }
        VchTplCreator vchTplCreator = (VchTplCreator)source;
        this.addChild(this.root, "type", vchTplCreator.getSourcetype());
        if ("fix".equalsIgnoreCase(vchTplCreator.getSourcetype())) {
            DynamicObject creator;
            if (vchTplCreator.getConstid() != 0L && (creator = BusinessDataServiceHelper.loadSingle((Object)vchTplCreator.getConstid(), (String)"bos_user", (String)"id,number,name,masterid")) != null) {
                this.addChild(this.root, "masterid", creator.getString("masterid"));
                this.addChild(this.root, "number", creator.getString("number"));
                this.addChild(this.root, "name", creator.getString("name"));
            }
        } else if ("bill".equalsIgnoreCase(vchTplCreator.getSourcetype())) {
            this.addChild(this.root, "name", vchTplCreator.getDescription());
            this.addChild(this.root, "exp", SerializationUtils.toJsonString((Object)vchTplCreator.getFieldExp()));
        }
        return this.root;
    }

    @Override
    public Object unmarshal(Object source, UnmarshallingContext context) {
        VchTplCreator vchTplCreator = new VchTplCreator();
        if (source == null) {
            return vchTplCreator;
        }
        Element data = (Element)source;
        if (data.elements().size() == 0) {
            return vchTplCreator;
        }
        String type = this.getElementText(data.element("type"));
        vchTplCreator.setSourcetype(type);
        if ("fix".equalsIgnoreCase(type)) {
            QFilter filter = new QFilter("number", "=", (Object)this.getElementText(data.element("number")));
            QFilter orgFilter = BaseDataServiceHelper.getBaseDataFilter((String)"bos_user", (Long)DapFileUtil.getOrgId());
            DynamicObject user = BusinessDataServiceHelper.loadSingleFromCache((String)"bos_user", (String)"id,number,name,masterid", (QFilter[])new QFilter[]{filter, orgFilter});
            if (user != null) {
                vchTplCreator.setConstid(user.getLong("id"));
                vchTplCreator.setDescription(user.getString("number") + " " + user.getString("name"));
            }
        } else if ("bill".equalsIgnoreCase(type)) {
            String expJson = this.getElementText(data.element("exp"));
            vchTplCreator.setFieldExp((VchTplExpression)SerializationUtils.fromJsonString((String)expJson, VchTplExpression.class));
        }
        return vchTplCreator;
    }
}

