/*
 * Decompiled with CFR 0.152.
 */
package kd.fi.ai.convert.impl;

import java.util.ArrayList;
import java.util.List;
import java.util.UUID;
import kd.bos.dataentity.serialization.SerializationUtils;
import kd.bos.util.StringUtils;
import kd.fi.ai.VCHTemplate;
import kd.fi.ai.VchTplBizGroup;
import kd.fi.ai.VchTplEntry;
import kd.fi.ai.VchTplExpression;
import kd.fi.ai.convert.core.MarshallingContext;
import kd.fi.ai.convert.core.UnmarshallingContext;
import kd.fi.ai.convert.impl.AbstractConverter;
import org.dom4j.DocumentHelper;
import org.dom4j.Element;

public class VchTplGroupConverter
extends AbstractConverter {
    private static final String TPL_ENTRY = "tpl_entry";

    @Override
    public Object marshal(String field, Object source, MarshallingContext context) {
        super.marshal(field, source, context);
        VCHTemplate vchTemplate = (VCHTemplate)source;
        List<VchTplBizGroup> entrys = vchTemplate.getBizGroups();
        if (entrys == null || entrys.size() == 0) {
            return this.root;
        }
        for (VchTplBizGroup bizGroup : entrys) {
            Element group = DocumentHelper.createElement((String)"group");
            this.marshalGroup(group, bizGroup, context);
            for (VchTplEntry entry : bizGroup.getVchEntrys()) {
                this.addChild(group, (Element)context.marshall(TPL_ENTRY, TPL_ENTRY, entry));
            }
            this.addChild(this.root, group);
        }
        return this.root;
    }

    @Override
    public Object unmarshal(Object source, UnmarshallingContext context) {
        Element tplGrpup = (Element)source;
        List children = tplGrpup.elements("group");
        ArrayList<VchTplBizGroup> groups = new ArrayList<VchTplBizGroup>(children.size());
        VchTplBizGroup group = null;
        for (Element child : children) {
            group = new VchTplBizGroup();
            this.unmarshalGroup(child, group, context);
            group.setVchEntrys((List)context.unmarshall(TPL_ENTRY, child.elements(TPL_ENTRY)));
            group.setId(UUID.randomUUID().toString());
            groups.add(group);
        }
        return groups;
    }

    private void marshalGroup(Element root, VchTplBizGroup bizGroup, MarshallingContext context) {
        this.addChild(root, "id", bizGroup.getId());
        this.addChild(root, "seq", bizGroup.getSeq());
        this.addChild(root, "filterSet", SerializationUtils.toJsonString((Object)bizGroup.getFilterSet()));
    }

    private void unmarshalGroup(Element root, VchTplBizGroup bizGroup, UnmarshallingContext context) {
        bizGroup.setSeq(Integer.parseInt(this.getElementText(root.element("seq"))));
        String filter = this.getElementText(root.element("filterSet"));
        if (StringUtils.isNotEmpty((String)filter)) {
            bizGroup.setFilterSet((VchTplExpression)SerializationUtils.fromJsonString((String)filter, VchTplExpression.class));
        }
    }

    @Override
    public String getType() {
        return "tpl_group";
    }
}

