/*
 * Decompiled with CFR 0.152.
 */
package kd.fi.ai.dap;

import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import java.util.stream.Collectors;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.entity.DynamicObjectCollection;
import kd.bos.dataentity.metadata.IDataEntityProperty;
import kd.bos.dataentity.metadata.IDataEntityType;
import kd.bos.dataentity.serialization.SerializationUtils;
import kd.bos.dataentity.utils.StringUtils;
import kd.bos.dlock.DLock;
import kd.bos.entity.AppInfo;
import kd.bos.entity.AppMetadataCache;
import kd.bos.entity.EntityMetadataCache;
import kd.bos.entity.EntityType;
import kd.bos.entity.MainEntityType;
import kd.bos.entity.SubEntryType;
import kd.bos.entity.cache.AppCache;
import kd.bos.entity.cache.IAppCache;
import kd.bos.entity.property.BasedataProp;
import kd.bos.entity.property.EntryProp;
import kd.bos.ext.fi.ai.dap.cache.CacheKeyPrefix;
import kd.bos.ext.fi.ai.dap.cache.DapLocalCache4H;
import kd.bos.ext.fi.ai.dap.cache.LocalCacheKey;
import kd.bos.lang.Lang;
import kd.bos.logging.Log;
import kd.bos.logging.LogFactory;
import kd.bos.orm.query.QFilter;
import kd.bos.servicehelper.BusinessDataServiceHelper;
import kd.bos.servicehelper.QueryServiceHelper;
import kd.fi.ai.AppBookConfig;
import kd.fi.ai.VCHTemplate;
import kd.fi.ai.VchExpireDate;
import kd.fi.ai.VchTplEntryNewSortOption;
import kd.fi.ai.dap.AppBizBookConfigCache;
import kd.fi.ai.dap.DapCacheMultiLangProcessUtil;
import kd.fi.ai.dap.DapConfig;
import kd.fi.ai.util.DapBuildVoucherCommonUtil;
import kd.fi.ai.util.DapUtil;
import kd.fi.bd.business.service.GLAccountBookService;
import kd.fi.v2.fah.dao.sys.SysBasePropDataDaoImpl;
import kd.fi.v2.fah.optimizor.FahOptimizeControlPanel;

public class DapCache {
    private static final String DapConfigCacheKey = "fi-ai-dapconfigs";
    private static Log log = LogFactory.getLog(DapCache.class);
    public static final AppBizBookConfigCache appConfig = new AppBizBookConfigCache();
    private static volatile Map<String, String> billBookTypeFieldCache = new HashMap<String, String>();
    private static volatile Map<String, String> billBookFieldCache = new HashMap<String, String>();
    private static volatile Map<String, String> billEntityAppNumCache = new HashMap<String, String>();
    private static final String SELECT_FIELDS = "id,booktype,newsortorder,buildbizvoucher,fsourcebill.id,createorg.id,name,number,modifytime,fxml";

    public static String getBillBookTypeField(String billType) {
        return DapCache.getBillBookTypeField(billType, null);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static String getBillBookTypeField(String billType, EntityType firstEntity) {
        String cacheKey = billType;
        if (firstEntity != null) {
            cacheKey = cacheKey + firstEntity.getName();
        }
        if (billBookTypeFieldCache.containsKey(cacheKey)) {
            return billBookTypeFieldCache.get(cacheKey);
        }
        Class<DapCache> clazz = DapCache.class;
        synchronized (DapCache.class) {
            MainEntityType meta = EntityMetadataCache.getDataEntityType((String)billType);
            String appNum = meta.getAppId();
            if (!billEntityAppNumCache.containsKey(billType)) {
                billEntityAppNumCache.put(billType, appNum);
            }
            if (appConfig.get(appNum) == null) {
                // ** MonitorExit[var3_3] (shouldn't be in output)
                return null;
            }
            String bookTypeEntity = DapCache.appConfig.get((String)appNum).bookTypeEntity;
            if (bookTypeEntity == null) {
                billBookTypeFieldCache.put(cacheKey, null);
                // ** MonitorExit[var3_3] (shouldn't be in output)
                return null;
            }
            HashSet<String> selectEntitys = null;
            if (firstEntity != null) {
                selectEntitys = new HashSet<String>();
                selectEntitys.add(firstEntity.getName());
                if (firstEntity instanceof SubEntryType) {
                    selectEntitys.add(firstEntity.getParent().getName());
                }
            }
            String bookTypeField = DapCache.searchField((IDataEntityType)meta, bookTypeEntity, null, selectEntitys);
            billBookTypeFieldCache.put(cacheKey, bookTypeField);
            // ** MonitorExit[var3_3] (shouldn't be in output)
            return bookTypeField;
        }
    }

    public static String getBillBookField(String billType) {
        return DapCache.getBillBookField(billType, null);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static String getBillBookField(String billType, EntityType firstEntity) {
        if (billBookFieldCache.containsKey(billType)) {
            return billBookFieldCache.get(billType);
        }
        Class<DapCache> clazz = DapCache.class;
        synchronized (DapCache.class) {
            MainEntityType meta = EntityMetadataCache.getDataEntityType((String)billType);
            String appNum = meta.getAppId();
            if (!billEntityAppNumCache.containsKey(billType)) {
                billEntityAppNumCache.put(billType, appNum);
            }
            if (appConfig.get(appNum) == null) {
                // ** MonitorExit[var2_2] (shouldn't be in output)
                return null;
            }
            String bookEntity = DapCache.appConfig.get((String)appNum).bookEntity;
            if (bookEntity == null) {
                billBookFieldCache.put(billType, null);
                // ** MonitorExit[var2_2] (shouldn't be in output)
                return null;
            }
            HashSet<String> selectEntitys = null;
            if (firstEntity != null) {
                selectEntitys = new HashSet<String>();
                selectEntitys.add(firstEntity.getName());
                if (firstEntity instanceof SubEntryType) {
                    selectEntitys.add(firstEntity.getParent().getName());
                }
            }
            String bookField = DapCache.searchField((IDataEntityType)meta, bookEntity, null, selectEntitys);
            billBookFieldCache.put(billType, bookField);
            // ** MonitorExit[var2_2] (shouldn't be in output)
            return bookField;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static String getBillEntityAppNumber(String billType) {
        if (billEntityAppNumCache.containsKey(billType)) {
            return billEntityAppNumCache.get(billType);
        }
        Class<DapCache> clazz = DapCache.class;
        synchronized (DapCache.class) {
            MainEntityType meta = EntityMetadataCache.getDataEntityType((String)billType);
            String appNum = meta.getAppId();
            if (!billEntityAppNumCache.containsKey(billType)) {
                billEntityAppNumCache.put(billType, appNum);
            }
            // ** MonitorExit[var1_1] (shouldn't be in output)
            return appNum;
        }
    }

    private static String searchField(IDataEntityType meta, String entityNumber, String prefix, Set<String> selectEntitys) {
        String fieldName = null;
        for (IDataEntityProperty property : meta.getProperties()) {
            BasedataProp bdProp;
            if (property instanceof EntryProp) {
                EntityType childEntity;
                if (selectEntitys != null && !selectEntitys.contains(property.getName()) || StringUtils.isBlank((CharSequence)(childEntity = (EntityType)((EntryProp)property).getItemType()).getAlias())) continue;
                String epx = null;
                epx = prefix == null ? property.getName() : prefix + "." + property.getName();
                fieldName = DapCache.searchField((IDataEntityType)childEntity, entityNumber, epx, selectEntitys);
                if (fieldName == null) continue;
                return fieldName;
            }
            if (!(property instanceof BasedataProp) || !entityNumber.equalsIgnoreCase((bdProp = (BasedataProp)property).getBaseEntityId())) continue;
            if (prefix != null) {
                return prefix + "." + property.getName();
            }
            return property.getName();
        }
        return fieldName;
    }

    public static VCHTemplate getTemplate(Long pk, String json) {
        return DapCache.getTemplateIsOtherField(pk, json, true);
    }

    public static VCHTemplate getTemplateIsOtherField(Long pk, String json, boolean isAddOtherField) {
        String langStr = Lang.get().toString();
        LocalCacheKey vlangsKey = LocalCacheKey.getCacheKey((CacheKeyPrefix)CacheKeyPrefix.GL_ACCOUNT_BASEDATAFILED, (Object[])new Object[]{"VCHTemplateLang"});
        HashSet<String> langs = (HashSet<String>)DapLocalCache4H.get((LocalCacheKey)vlangsKey, HashSet.class);
        if (langs == null) {
            langs = new HashSet<String>();
        }
        langs.add(langStr);
        DapLocalCache4H.put((LocalCacheKey)vlangsKey, langs);
        LocalCacheKey cacheKey = LocalCacheKey.getCacheKey((CacheKeyPrefix)CacheKeyPrefix.GL_ACCOUNT_BASEDATAFILED, (Object[])new Object[]{"VCHTemplate", pk, langStr});
        VCHTemplate tp = (VCHTemplate)DapLocalCache4H.get((LocalCacheKey)cacheKey, VCHTemplate.class);
        if (tp != null && null != pk && pk != 0L) {
            return tp;
        }
        String toJson = json;
        DynamicObject obj = null;
        if (toJson == null || isAddOtherField && null != pk && 0L != pk) {
            obj = BusinessDataServiceHelper.loadSingleFromCache((Object)pk, (String)"ai_vchtemplate", (String)SELECT_FIELDS);
            toJson = obj.getString("fxml");
        }
        if (!StringUtils.isBlank((CharSequence)toJson)) {
            VCHTemplate vchTemplate = VCHTemplate.deserializeFromString(toJson, null);
            vchTemplate = DapCacheMultiLangProcessUtil.processTemplateLang(vchTemplate);
            vchTemplate.setId(null == pk ? "0" : pk.toString());
            DapCache.setTemplateField(obj, vchTemplate);
            if (null != pk && 0L != pk) {
                DapLocalCache4H.put((LocalCacheKey)cacheKey, (Object)vchTemplate);
            }
            return vchTemplate;
        }
        return null;
    }

    public static VCHTemplate getTemplateFromLocalCache(Long pk) {
        String langStr = Lang.get().toString();
        LocalCacheKey cacheKey = LocalCacheKey.getCacheKey((CacheKeyPrefix)CacheKeyPrefix.GL_ACCOUNT_BASEDATAFILED, (Object[])new Object[]{"VCHTemplate", pk, langStr});
        VCHTemplate vchTemplate = (VCHTemplate)DapLocalCache4H.get((LocalCacheKey)cacheKey, VCHTemplate.class);
        if (null != vchTemplate && pk != 0L) {
            return vchTemplate;
        }
        return null;
    }

    public static List<VCHTemplate> getTemplateByFilters(List<QFilter> filters) {
        List vchTempIds;
        if (null == filters || filters.isEmpty()) {
            return Collections.emptyList();
        }
        LinkedList qFilters = new LinkedList();
        LinkedList billTypeValues = new LinkedList();
        filters.forEach(filter -> {
            if ("enable".equals(filter.getProperty())) {
                qFilters.add(filter);
            }
            if ("fsourcebill.id".equalsIgnoreCase(filter.getProperty()) || "fsourcebill".equalsIgnoreCase(filter.getProperty())) {
                billTypeValues.add((String)filter.getValue());
            }
        });
        if (qFilters.isEmpty()) {
            filters.add(new QFilter("enable", "=", (Object)"1"));
        }
        if ((vchTempIds = QueryServiceHelper.queryPrimaryKeys((String)"ai_vchtemplate", (QFilter[])filters.toArray(new QFilter[0]), null, (int)-1)).isEmpty()) {
            return Collections.emptyList();
        }
        ArrayList<VCHTemplate> returnTempList = new ArrayList<VCHTemplate>(vchTempIds.size());
        ArrayList<Long> notCacheIdList = new ArrayList<Long>(vchTempIds.size());
        vchTempIds.forEach(vchTempId -> {
            VCHTemplate template = DapCache.getTemplateFromLocalCache((Long)vchTempId);
            if (null != template) {
                returnTempList.add(template);
            } else {
                notCacheIdList.add((Long)vchTempId);
            }
        });
        if (!notCacheIdList.isEmpty()) {
            if (FahOptimizeControlPanel.getAddLockSelectTempSize() > notCacheIdList.size()) {
                returnTempList.addAll(DapCache.getTemplateSelectByIds(notCacheIdList));
            } else {
                StringBuilder sb = new StringBuilder();
                sb.append("dap-getTemplateByFilters-");
                billTypeValues.forEach(sb::append);
                returnTempList.addAll(DapCache.addLockSelectTempByIdList(sb.toString(), notCacheIdList));
            }
        }
        return returnTempList;
    }

    public static List<VCHTemplate> addLockSelectTempByIdList(String lockKey, List<Long> idList) {
        ArrayList<VCHTemplate> returnTempList = new ArrayList<VCHTemplate>(idList.size());
        try (DLock lock = DLock.create((String)lockKey).fastMode();){
            lock.lock();
            ArrayList<Long> secondNotCacheIdList = new ArrayList<Long>(idList.size());
            idList.forEach(vchTempId -> {
                VCHTemplate template = DapCache.getTemplateFromLocalCache(vchTempId);
                if (null != template) {
                    returnTempList.add(template);
                } else {
                    secondNotCacheIdList.add((Long)vchTempId);
                }
            });
            if (!secondNotCacheIdList.isEmpty()) {
                returnTempList.addAll(DapCache.getTemplateSelectByIds(secondNotCacheIdList));
            }
        }
        return returnTempList;
    }

    public static List<VCHTemplate> getTemplateByCacheThenSelectByIds(List<Long> ids) {
        if (null == ids || ids.isEmpty()) {
            return Collections.emptyList();
        }
        ArrayList<VCHTemplate> returnTempList = new ArrayList<VCHTemplate>(ids.size());
        ArrayList<Long> notCacheIdList = new ArrayList<Long>(ids.size());
        ids.forEach(vchTempId -> {
            VCHTemplate template = DapCache.getTemplateFromLocalCache(vchTempId);
            if (null != template) {
                returnTempList.add(template);
            } else {
                notCacheIdList.add((Long)vchTempId);
            }
        });
        if (!notCacheIdList.isEmpty()) {
            returnTempList.addAll(DapCache.getTemplateSelectByIds(notCacheIdList));
        }
        return returnTempList;
    }

    public static List<VCHTemplate> getTemplateSelectByIds(List<Long> ids) {
        if (null == ids || ids.isEmpty()) {
            return Collections.emptyList();
        }
        ArrayList<VCHTemplate> returnTempList = new ArrayList<VCHTemplate>(ids.size());
        List<List<Long>> splitBatchIdList = DapBuildVoucherCommonUtil.splitbatch(ids, FahOptimizeControlPanel.getTemplateByBatchSize());
        for (List<Long> longList : splitBatchIdList) {
            Map dynamicMap = BusinessDataServiceHelper.loadFromCache((String)"ai_vchtemplate", (String)SELECT_FIELDS, (QFilter[])new QFilter[]{new QFilter("id", "in", longList)});
            for (DynamicObject dynamic : dynamicMap.values()) {
                VCHTemplate template = DapCache.getTemplateIsOtherField(dynamic.getLong("id"), dynamic.getString("fxml"), false);
                DapCache.setTemplateField(dynamic, template);
                returnTempList.add(template);
            }
        }
        return returnTempList;
    }

    private static void setTemplateField(DynamicObject obj, VCHTemplate vchTemplate) {
        DynamicObjectCollection bookTypeCol;
        if (null == obj || null == vchTemplate) {
            return;
        }
        vchTemplate.setName(obj.getString("name"));
        vchTemplate.setCreateOrgId(obj.getLong("createorg.id"));
        vchTemplate.setModifyDate(obj.getDate("modifytime"));
        vchTemplate.setBillNo(obj.getString("number"));
        vchTemplate.setSourceBill(obj.getString("fsourcebill.id"));
        vchTemplate.setBuildbizvoucher(obj.getBoolean("buildbizvoucher"));
        if (StringUtils.isNotBlank((Object)obj.get("newsortorder"))) {
            String newSortObj = (String)obj.get("newsortorder");
            vchTemplate.setEntryNewSortOption((VchTplEntryNewSortOption)SerializationUtils.fromJsonString((String)newSortObj, VchTplEntryNewSortOption.class));
        }
        if ((bookTypeCol = obj.getDynamicObjectCollection("booktype")) != null && !bookTypeCol.isEmpty()) {
            List<Long> bookTypeIds = bookTypeCol.stream().map(v -> v.getLong("fbasedataid.id")).collect(Collectors.toList());
            vchTemplate.setBookTypeIds(bookTypeIds);
        }
    }

    public static void clearTemplateCache(Long pk) {
        LocalCacheKey vlangsKey = LocalCacheKey.getCacheKey((CacheKeyPrefix)CacheKeyPrefix.GL_ACCOUNT_BASEDATAFILED, (Object[])new Object[]{"VCHTemplateLang"});
        Set langs = (Set)DapLocalCache4H.get((LocalCacheKey)vlangsKey, HashSet.class);
        if (langs != null) {
            for (String lang : langs) {
                LocalCacheKey cacheKey = LocalCacheKey.getCacheKey((CacheKeyPrefix)CacheKeyPrefix.GL_ACCOUNT_BASEDATAFILED, (Object[])new Object[]{"VCHTemplate", pk, lang});
                DapLocalCache4H.remove((LocalCacheKey)cacheKey);
            }
        } else {
            LocalCacheKey cacheKey = LocalCacheKey.getCacheKey((CacheKeyPrefix)CacheKeyPrefix.GL_ACCOUNT_BASEDATAFILED, (Object[])new Object[]{"VCHTemplate", pk, Lang.get().toString()});
            DapLocalCache4H.remove((LocalCacheKey)cacheKey);
        }
    }

    public static DapConfig getDapConfigCache(String entityKey) {
        return DapCache.getDapConfigCache(entityKey, 0L);
    }

    public static DapConfig getDapConfigCache(String entityKey, long eventClassID) {
        LocalCacheKey cacheKey;
        DapConfig configsLoc;
        if ("ai_event".equalsIgnoreCase(entityKey)) {
            entityKey = "ai_eventclass";
        }
        if ((configsLoc = (DapConfig)DapLocalCache4H.get((LocalCacheKey)(cacheKey = LocalCacheKey.getCacheKey((CacheKeyPrefix)CacheKeyPrefix.GL_ASSGRP_REPLACE, (Object[])new Object[]{DapConfigCacheKey, entityKey, eventClassID})), DapConfig.class)) != null) {
            return configsLoc;
        }
        IAppCache cache = AppCache.get((String)"ai");
        DapConfig configs = (DapConfig)cache.get(DapConfigCacheKey + entityKey + eventClassID, DapConfig.class);
        if (configs != null) {
            DapLocalCache4H.put((LocalCacheKey)cacheKey, (Object)configs);
        } else {
            configs = DapCache.loadDapConfigs(entityKey, eventClassID);
            if (configs != null) {
                cache.put(DapConfigCacheKey + entityKey + eventClassID, (Object)configs);
                DapLocalCache4H.put((LocalCacheKey)cacheKey, (Object)configs);
            } else {
                log.error("load dapconfig error");
            }
        }
        return configs;
    }

    public static void updateDapConfigCache(String entityKey, long eventClassID, DapConfig cfg) {
        LocalCacheKey cacheKey = LocalCacheKey.getCacheKey((CacheKeyPrefix)CacheKeyPrefix.GL_ASSGRP_REPLACE, (Object[])new Object[]{DapConfigCacheKey, entityKey, eventClassID});
        AppCache.get((String)"ai").put(DapConfigCacheKey + entityKey + eventClassID, (Object)cfg);
        DapLocalCache4H.put((LocalCacheKey)cacheKey, (Object)cfg);
    }

    public static DapConfig getDapConfig(String billType, long bizOrgID) {
        Map<String, DapConfig> configs = DapCache.getCommonDapConfigs();
        DapConfig cg = configs.get(billType);
        Set<Object> acctOrgIDS = new HashSet(2);
        String appNumber = DapCache.getBillEntityAppNumber(billType);
        if (AppBizBookConfigCache.getInstance().isBookOnOrg(appNumber)) {
            AppInfo app = AppMetadataCache.getAppInfo((String)appNumber);
            Set set = GLAccountBookService.queryGlAccountBook((String)app.getId(), (Long)0L, (Long)bizOrgID);
            DynamicObjectCollection books = QueryServiceHelper.query((String)"gl_accountbook", (String)"id,org", (QFilter[])new QFilter("id", "in", (Object)set).toArray());
            for (Object glb : books) {
                acctOrgIDS.add(glb.getLong("org"));
            }
        } else if (AppBizBookConfigCache.getInstance().get(appNumber) != null) {
            AppBookConfig appconfig = appConfig.get(appNumber);
            QFilter qFilter = new QFilter(appconfig.bookEntityOrgField, "=", (Object)bizOrgID);
            List bizBookIds = QueryServiceHelper.queryPrimaryKeys((String)appconfig.bookEntity, (QFilter[])new QFilter[]{qFilter}, null, (int)-1);
            AppInfo app = AppMetadataCache.getAppInfo((String)appconfig.appNumber);
            for (Object bizbookid : bizBookIds) {
                Set glBookids = GLAccountBookService.queryGlAccountBook((String)app.getId(), (Long)((Long)bizbookid), (Long)0L);
                Iterator books = QueryServiceHelper.query((String)"gl_accountbook", (String)"id,org,bookstype", (QFilter[])new QFilter("id", "in", (Object)glBookids).toArray());
                Iterator<VCHTemplate> iterator = books.iterator();
                while (iterator.hasNext()) {
                    DynamicObject glb = (DynamicObject)iterator.next();
                    acctOrgIDS.add(glb.getLong("org"));
                }
            }
        }
        if (acctOrgIDS.isEmpty()) {
            acctOrgIDS = DapUtil.getAcctOrgIncludeSelf(bizOrgID);
        }
        if (acctOrgIDS.isEmpty()) {
            return null;
        }
        for (Long l : acctOrgIDS) {
            QFilter billTypeFilter = new QFilter("fsourcebill", "=", (Object)billType);
            QFilter enableFilter = new QFilter("enable", "!=", (Object)"0");
            QFilter[] qFilters = new QFilter[]{billTypeFilter, enableFilter};
            DynamicObjectCollection templates = SysBasePropDataDaoImpl.queryBaseData("ai_vchtemplate", l, "id", qFilters);
            LinkedList<Long> idList = new LinkedList<Long>();
            for (DynamicObject t : templates) {
                idList.add(t.getLong("id"));
            }
            List<VCHTemplate> vchTemplates = DapCache.getTemplateSelectByIds(idList);
            for (VCHTemplate vchTemplate : vchTemplates) {
                DapCache.loadingBizField(vchTemplate, cg);
            }
        }
        return cg;
    }

    private static DapConfig loadDapConfigs(String entityKey, long eventClassID) {
        DapConfig configs = DapCache.getCommonDapConfigs(entityKey, eventClassID);
        QFilter sourceQF = new QFilter("fsourcebill.id", "=", (Object)entityKey);
        if (eventClassID != 0L) {
            sourceQF = sourceQF.and(new QFilter("eventclass.id", "=", (Object)eventClassID));
        }
        ArrayList<QFilter> qFilters = new ArrayList<QFilter>();
        qFilters.add(sourceQF);
        qFilters.add(new QFilter("enable", "!=", (Object)"0"));
        List<VCHTemplate> vchTemplates = DapCache.getTemplateByFilters(qFilters);
        for (VCHTemplate template : vchTemplates) {
            String sourceBill = template.getSourceBill();
            if (sourceBill == null || !sourceBill.equals(entityKey)) continue;
            DapCache.loadingBizField(template, configs);
        }
        return configs;
    }

    public static void loadingBizField(VCHTemplate vchTemplate, DapConfig cg) {
        VchExpireDate vchDate;
        VchExpireDate bizDate = vchTemplate.getBizDateSet2();
        if (bizDate != null) {
            String exp = bizDate.getSingleField();
            if (StringUtils.isNotEmpty((CharSequence)exp) && !cg.getBizDateFields().contains(exp)) {
                cg.getBizDateFields().add(exp);
            }
        } else if (!cg.getBizDateFields().contains(vchTemplate.getBizDateSet())) {
            cg.getBizDateFields().add(vchTemplate.getBizDateSet());
        }
        if (!cg.getBizOrgFields().contains(vchTemplate.getAcctOrgSet())) {
            cg.getBizOrgFields().add(vchTemplate.getAcctOrgSet());
        }
        if ((vchDate = vchTemplate.getVchDateSet2()) != null) {
            String exp = vchDate.getSingleField();
            if (StringUtils.isNotEmpty((CharSequence)exp) && !cg.getVoucherDateFields().contains(exp)) {
                cg.getVoucherDateFields().add(exp);
            }
        } else if (!cg.getVoucherDateFields().contains(vchTemplate.getVchDateSet())) {
            cg.getVoucherDateFields().add(vchTemplate.getVchDateSet());
        }
    }

    private static Map<String, DapConfig> getCommonDapConfigs() {
        DynamicObject[] dapconfigs = BusinessDataServiceHelper.load((String)"ai_dapconfig", (String)"id,isdap,billentity,oper,entrysum,writebackplugin,savebizvoucherentry,delaybuildevent", (QFilter[])new QFilter[0]);
        HashMap<String, DapConfig> bills = new HashMap<String, DapConfig>();
        for (DynamicObject config : dapconfigs) {
            DapConfig cg = new DapConfig();
            String billEntity = config.getString("billentity.id");
            if (StringUtils.isEmpty((CharSequence)billEntity)) continue;
            cg.setBillentity(billEntity);
            cg.setEntrysum(config.getBoolean("entrysum"));
            cg.setIsdap(config.getBoolean("isdap"));
            cg.setOper(config.getString("oper"));
            cg.setWritebackplugin(config.getString("writebackplugin"));
            cg.setSavebizvoucherentry(config.getBoolean("savebizvoucherentry"));
            cg.setDelaybuildevent(config.getBoolean("delaybuildevent"));
            bills.put(billEntity, cg);
        }
        return bills;
    }

    private static DapConfig getCommonDapConfigs(String entityKey, long eventClassID) {
        QFilter qFilter1 = new QFilter("billentity.id", "=", (Object)entityKey);
        QFilter[] qFilters = new QFilter[]{qFilter1};
        if (eventClassID != 0L) {
            QFilter qFilter2 = new QFilter("eventclass.id", "=", (Object)eventClassID);
            qFilters = new QFilter[]{qFilter1, qFilter2};
        }
        DynamicObject config = BusinessDataServiceHelper.loadSingle((String)"ai_dapconfig", (String)"id,isdap,billentity,oper,entrysum,writebackplugin,savebizvoucherentry,delaybuildevent", (QFilter[])qFilters);
        DapConfig cg = new DapConfig();
        if (config != null) {
            String billEntity = config.getString("billentity.id");
            cg.setBillentity(billEntity);
            cg.setEntrysum(config.getBoolean("entrysum"));
            cg.setIsdap(config.getBoolean("isdap"));
            cg.setOper(config.getString("oper"));
            cg.setWritebackplugin(config.getString("writebackplugin"));
            cg.setSavebizvoucherentry(config.getBoolean("savebizvoucherentry"));
            cg.setDelaybuildevent(config.getBoolean("delaybuildevent"));
        }
        return cg;
    }

    public static void clearDapConfigCache() {
        IAppCache cache = AppCache.get((String)"ai");
        cache.remove("fi-ai-dapconfigs-dapcontrol");
        cache.remove("fi-ai-dapconfigs-dapcontrol-operation");
        cache.remove("ai-dap-writebackplugin");
        billBookTypeFieldCache.clear();
        billBookFieldCache.clear();
        AppBizBookConfigCache.clearCache();
    }

    public static void clearDapConfigCacheByEntity(String entityKey, long eventClassID) {
        IAppCache cache = AppCache.get((String)"ai");
        cache.remove(DapConfigCacheKey + entityKey + eventClassID);
        LocalCacheKey cacheKey = LocalCacheKey.getCacheKey((CacheKeyPrefix)CacheKeyPrefix.GL_ASSGRP_REPLACE, (Object[])new Object[]{DapConfigCacheKey, entityKey, eventClassID});
        DapLocalCache4H.remove((LocalCacheKey)cacheKey);
    }

    private static boolean is_a_word(String str) {
        str = str.trim();
        Pattern p = Pattern.compile("^[A-Za-z]+$");
        Matcher m = p.matcher(str);
        return m.matches();
    }
}

