/*
 * Decompiled with CFR 0.152.
 */
package kd.fi.ai.dap;

import java.util.HashMap;
import java.util.HashSet;
import java.util.Map;
import java.util.Set;
import kd.bos.algo.DataSet;
import kd.bos.algo.Row;
import kd.bos.dataentity.utils.StringUtils;
import kd.bos.db.DB;
import kd.bos.db.DBRoute;
import kd.bos.ext.fi.ai.DapBuildVoucherCommonUtil;
import kd.bos.ext.fi.ai.Voucher;
import kd.bos.logging.Log;
import kd.bos.logging.LogFactory;
import kd.bos.orm.query.QFilter;
import kd.bos.servicehelper.QueryServiceHelper;

public class DapWriteAndBlackOpSetUtil {
    private static Log logger = LogFactory.getLog(DapWriteAndBlackOpSetUtil.class);
    public static final String NEEDBUILDOPS = "needbuildops";
    public static final String NOTBUILDOPS = "notbuildops";

    public static Boolean registerDapWriteAndBlackOpService(Boolean isopen, String billtype) {
        return DapBuildVoucherCommonUtil.registerDapWriteAndBlackOpService((Boolean)isopen, (String)billtype);
    }

    public static Boolean createDapTableToBill(String billtype) {
        return DapBuildVoucherCommonUtil.createDapTableToBill((String)billtype);
    }

    public static Map<String, String> getBuildVoucherOptFromBill(String billtype) {
        return DapBuildVoucherCommonUtil.getBuildVoucherOptFromBill((String)billtype);
    }

    public static Map<String, Set<Long>> splitReloperAndBilltype(String billtype, Set<Long> billIds) {
        String mainoper;
        HashMap<String, Set<Long>> result = new HashMap<String, Set<Long>>(16);
        if (billtype == null || billIds == null || billIds.isEmpty()) {
            return result;
        }
        HashSet<Long> billids = new HashSet<Long>(billIds);
        Map<String, String> buildVoucherOptFromBill = DapWriteAndBlackOpSetUtil.getBuildVoucherOptFromBill(billtype);
        String string = mainoper = buildVoucherOptFromBill.size() == 1 ? buildVoucherOptFromBill.entrySet().iterator().next().getKey() : "audit";
        if (DapBuildVoucherCommonUtil.getDistributeHasDapWBill((String)billtype).booleanValue()) {
            String tableName = DapBuildVoucherCommonUtil.getWriteTableName((String)billtype);
            String join = StringUtils.join((Object[])billids.toArray(), (char)',');
            String sql = "select foper,fsourcebillid from " + tableName + " where fbilltype = ? and fsourcebillid in (" + join + ")";
            String dbRouteKey = DapBuildVoucherCommonUtil.getDBRouteKey((String)billtype);
            Object[] param = new Object[]{billtype};
            try (DataSet queryDataSet = DB.queryDataSet((String)"kd.fi.ai.dap.DapWriteAndBlackOpSetUtil", (DBRoute)DBRoute.of((String)dbRouteKey), (String)sql, (Object[])param);){
                for (Row row : queryDataSet) {
                    String oper = row.getString("foper");
                    if (oper == null || StringUtils.isBlank((CharSequence)oper)) continue;
                    Long sid = row.getLong("fsourcebillid");
                    Set ids = result.computeIfAbsent(oper, v -> new HashSet(16));
                    ids.add(sid);
                    billids.remove(sid);
                }
            }
        }
        Set ids = result.computeIfAbsent(mainoper, v -> new HashSet(16));
        ids.addAll(billids);
        return result;
    }

    public static void preCheckBillidsToReoper(Set<Long> sourcebillIds, String reoper, String billtype, Long booktype, Long org) {
        Map<String, String> buildVoucherOptFromBill = DapWriteAndBlackOpSetUtil.getBuildVoucherOptFromBill(billtype);
        if (buildVoucherOptFromBill.isEmpty()) {
            return;
        }
        QFilter Fi = new QFilter("sourcebillid", "in", sourcebillIds);
        QFilter Ft = new QFilter("billtype", "=", (Object)billtype);
        QFilter Fb = new QFilter("booktype", "=", (Object)booktype);
        QFilter Fr = new QFilter("reoper", "=", (Object)reoper);
        QFilter Fo = new QFilter("org", "=", (Object)org);
        try (DataSet queryDataSet = QueryServiceHelper.queryDataSet((String)"kd.fi.ai.mservice.service.GenerateVoucherProcess", (String)"ai_daptracker", (String)"sourcebillid", (QFilter[])new QFilter[]{Fi, Ft, Fb, Fr, Fo}, null);){
            for (Row row : queryDataSet) {
                sourcebillIds.remove(row.getLong("sourcebillid"));
            }
        }
    }

    public static void insertReOperToMap(Map<Long, Voucher> needInCol, String reoper) {
        for (Map.Entry<Long, Voucher> ni : needInCol.entrySet()) {
            ni.getValue().setReoper(reoper);
        }
    }
}

