/*
 * Decompiled with CFR 0.152.
 */
package kd.fi.ai.event.validator;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Set;
import kd.bos.algo.DataSet;
import kd.bos.algo.Row;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.entity.DynamicObjectCollection;
import kd.bos.dataentity.metadata.IDataEntityProperty;
import kd.bos.dataentity.metadata.IDataEntityType;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.dataentity.utils.StringUtils;
import kd.bos.db.DB;
import kd.bos.db.DBRoute;
import kd.bos.entity.EntryType;
import kd.bos.entity.MainEntityType;
import kd.bos.logging.Log;
import kd.bos.logging.LogFactory;
import kd.bos.orm.query.QFilter;
import kd.bos.servicehelper.BusinessDataServiceHelper;
import kd.bos.servicehelper.QueryServiceHelper;
import kd.fi.ai.enums.EventPreStatusEnum;
import kd.fi.ai.event.AiEventUtil;
import kd.fi.ai.event.DataSourceFactory;
import kd.fi.ai.event.dto.AiEventBlockDto;
import kd.fi.ai.event.dto.AiEventSqlQueryDto;
import kd.fi.ai.event.validator.ValidatorResultData;
import kd.fi.ai.util.AiEventMetaUtil;
import kd.fi.v2.fah.constant.enums.AppVersionEnum;
import kd.fi.v2.fah.constant.enums.StatusEnum;
import kd.fi.v2.fah.dao.datamodel.DataModelDaoImpl;

public class AiEventValidatorUtil {
    private static final String ENTITY_AI_EVENT = "ai_event";
    private static final String PRE_AI_WHERE = "| where";
    private static final String PRE_AI_PRAMS = "| params:";
    private static final String PRE_AI_SPLITS = "@@";
    private static final String FIELD_AI_CLASSENTRY = "masterid,preevent.preeventclass,preevent.preevtfield,preevent.evtfield,preevent.prestatus";
    private static final Log log = LogFactory.getLog(AiEventValidatorUtil.class);
    private static final String PRE_AI_SELECT = " select a.feventclassid eventclassid, a.feventid eventid,a.ffieldname ffieldname,a.ffieldvalue ffieldvalue, b.fid daptrackerid, b.fvoucherid voucherid from t_ai_event_index a inner join t_ai_event c on a.feventid=c.fid left join t_ai_daptracker b on a.feventid=b.fsourcebillid and b.fbilltype  ";

    public static ValidatorResultData checkPreEvent(Set<Long> selectPks) {
        Long eventClassId;
        ValidatorResultData retData = new ValidatorResultData();
        boolean checkStatus = true;
        if (selectPks == null || selectPks.isEmpty()) {
            retData.setStatus(checkStatus);
            return retData;
        }
        String selectFields = "id,number,eventclass.masterid eventclass";
        QFilter filter = new QFilter("id", "in", selectPks);
        DynamicObjectCollection eventColl = QueryServiceHelper.query((String)ENTITY_AI_EVENT, (String)selectFields, (QFilter[])filter.toArray());
        if (eventColl.isEmpty()) {
            retData.setStatus(checkStatus);
            return retData;
        }
        HashMap<Long, Long> eventIdClassMap = new HashMap<Long, Long>();
        HashMap<Long, String> eventIdNumberMap = new HashMap<Long, String>();
        HashMap<Long, Set> eventClassIdMap = new HashMap<Long, Set>();
        HashMap<Long, Set> eventClassSelFieldMap = new HashMap<Long, Set>();
        HashMap<Long, List> eventMainClassFilterMap = new HashMap<Long, List>();
        for (DynamicObject dyAiEvent : eventColl) {
            Long aiPK = dyAiEvent.getLong("id");
            eventClassId = dyAiEvent.getLong("eventclass");
            eventIdNumberMap.put(aiPK, dyAiEvent.getString("number"));
            eventIdClassMap.put(aiPK, eventClassId);
            eventClassIdMap.computeIfAbsent(eventClassId, p -> new HashSet()).add(aiPK);
        }
        String eventPreStatus = AiEventUtil.checkEventIfBlock(selectPks);
        if (!StringUtils.isEmpty((CharSequence)eventPreStatus)) {
            HashSet<Long> eventIds = new HashSet<Long>(selectPks);
            if (eventPreStatus.equals("oldData")) {
                retData.setMessage(ResManager.loadKDString((String)"\u9009\u4e2d\u7684\u5916\u90e8\u6570\u636e\u4e2d\u5b58\u5728\u963b\u585e\u4e8b\u4ef6\uff0c\u8bf7\u68c0\u67e5\u3002", (String)"AiEventValidatorUtil_0", (String)"fi-ai-common", (Object[])new Object[0]));
            } else {
                retData.setMessage(AiEventValidatorUtil.getMessageInfo(eventIds, eventIdNumberMap, eventPreStatus.equals(EventPreStatusEnum.VOUCHER.getValue())));
            }
            retData.setStatus(false);
            return retData;
        }
        QFilter eventClassFilter = new QFilter("masterid", "in", eventClassIdMap.keySet());
        QFilter oldAppVersionFilter = new QFilter("appversion", "=", (Object)String.valueOf(AppVersionEnum.OLD_APP.getCode()));
        QFilter newAppVersionFilter = new QFilter("appversion", "=", (Object)String.valueOf(AppVersionEnum.NEW_APP.getCode())).and("latestversion", "=", (Object)"1").and("status", "=", (Object)StatusEnum.PUBLISHED.getCode());
        oldAppVersionFilter.or(newAppVersionFilter);
        DynamicObject[] aiEventClassMap = BusinessDataServiceHelper.load((String)"ai_eventclass", (String)FIELD_AI_CLASSENTRY, (QFilter[])new QFilter[]{eventClassFilter, oldAppVersionFilter});
        HashMap<String, AiEventBlockDto> dtoMap = new HashMap<String, AiEventBlockDto>();
        HashMap<String, String> classIdFieldValueMap = new HashMap<String, String>();
        for (DynamicObject dyEventClass : aiEventClassMap) {
            Long eventMainClassId = dyEventClass.getLong("masterid");
            DynamicObject[] dyCols = DataModelDaoImpl.getModelRelations(eventMainClassId);
            if (dyCols == null || dyCols.length == 0) {
                eventClassIdMap.entrySet().removeIf(p -> ((Long)p.getKey()).longValue() == eventMainClassId.longValue());
                continue;
            }
            MainEntityType entityType = AiEventMetaUtil.getEntityType(eventMainClassId);
            for (DynamicObject dyEntry : dyCols) {
                StringBuilder sbFilters = new StringBuilder();
                Long evtClsId = dyEntry.getDynamicObject("predatamodel").getLong("masterid");
                String fieldName = dyEntry.getString("predatafield");
                IDataEntityProperty prop = entityType.findProperty(dyEntry.getString("datafield"));
                String propFullName = prop.getName();
                IDataEntityType parentProp = prop.getParent();
                if (parentProp instanceof EntryType) {
                    propFullName = parentProp.getName() + "." + propFullName;
                }
                eventClassSelFieldMap.computeIfAbsent(eventMainClassId, key -> new HashSet()).add(propFullName);
                sbFilters.append(evtClsId).append('|').append(propFullName).append("| where c.fstatus= ? and a.feventclassid = ? and a.ffieldname = ? and a.ffieldvalue = '@").append(propFullName).append('\'').append(PRE_AI_PRAMS).append(fieldName);
                eventMainClassFilterMap.computeIfAbsent(eventMainClassId, key -> new ArrayList()).add(sbFilters.toString());
                AiEventBlockDto dto = new AiEventBlockDto();
                dto.setEventClassId(evtClsId);
                dto.setFieldName(fieldName);
                dto.setPreStatus(dyEntry.getString("prestatus"));
                dto.setFieldValue(propFullName);
                dtoMap.put(eventMainClassId + "-" + evtClsId + "-" + propFullName, dto);
                classIdFieldValueMap.put(evtClsId + "-" + fieldName, propFullName);
            }
        }
        if (eventClassIdMap == null || eventClassIdMap.isEmpty()) {
            checkStatus = true;
            retData.setStatus(checkStatus);
            return retData;
        }
        Set eventIds = new HashSet();
        HashSet<String> selectFieldSet = new HashSet<String>();
        selectFieldSet.add("id");
        ArrayList<AiEventBlockDto> blockDtoList = new ArrayList<AiEventBlockDto>();
        HashMap<String, Map<String, String>> fieldValueMap = new HashMap<String, Map<String, String>>();
        HashMap<String, Long> paramParentEventIdMap = new HashMap<String, Long>();
        ArrayList<AiEventSqlQueryDto> sqlDtoList = new ArrayList<AiEventSqlQueryDto>();
        String billType = ENTITY_AI_EVENT;
        for (Map.Entry ety : eventClassIdMap.entrySet()) {
            DynamicObjectCollection billCols;
            eventClassId = (Long)ety.getKey();
            eventIds = (Set)ety.getValue();
            Set fieldSet = (Set)eventClassSelFieldMap.get(eventClassId);
            List filterList = (List)eventMainClassFilterMap.get(eventClassId);
            selectFieldSet.addAll(fieldSet);
            String selector = StringUtils.join((Object[])selectFieldSet.toArray(), (String)",");
            String metaEntityNum = DataModelDaoImpl.getTableNameById(eventClassId);
            if (!StringUtils.isEmpty((CharSequence)metaEntityNum)) {
                billCols = QueryServiceHelper.query((String)metaEntityNum, (String)selector, (QFilter[])new QFilter[]{new QFilter("id", "in", eventIds)});
                billType = metaEntityNum;
            } else {
                billCols = DataSourceFactory.getDataSource().getEventObjectCollection(eventClassId, eventIds, selector);
            }
            if (billCols == null || billCols.isEmpty()) continue;
            for (DynamicObject dyBill : billCols) {
                ArrayList resolveFilterList = new ArrayList();
                Map valueMap = fieldValueMap.computeIfAbsent(dyBill.getString("id"), key -> new HashMap());
                for (String field : fieldSet) {
                    valueMap.put(field, dyBill.getString(field));
                    filterList.stream().filter(p -> p.contains(field)).forEach(p -> {
                        StringBuilder sbFilter = new StringBuilder(p.replace("@" + field, ""));
                        sbFilter.append(PRE_AI_SPLITS).append(dyBill.getString(field));
                        resolveFilterList.add(sbFilter.toString());
                    });
                }
                Long parentEventId = dyBill.getLong("id");
                for (String whereSql : resolveFilterList) {
                    String blockKeyStr = whereSql.substring(0, whereSql.indexOf(PRE_AI_WHERE));
                    String paramsStr = whereSql.substring(whereSql.indexOf(PRE_AI_PRAMS) + PRE_AI_PRAMS.length());
                    String[] blockKeyArr = StringUtils.split((String)blockKeyStr, (String)"|");
                    String[] paramsArr = paramsStr.split(PRE_AI_SPLITS, 2);
                    String preEventClassIdStr = blockKeyArr[0];
                    String fieldValueKey = blockKeyArr[1];
                    whereSql = whereSql.substring(blockKeyStr.length() + 1, whereSql.indexOf(PRE_AI_PRAMS) - 2);
                    StringBuilder sbSelQuery = new StringBuilder();
                    sbSelQuery.append(PRE_AI_SELECT).append(whereSql).append('?');
                    Long preEventClassId = Long.parseLong(preEventClassIdStr.trim());
                    StringBuilder sbBlockKey = new StringBuilder();
                    sbBlockKey.append(eventClassId).append('-').append(preEventClassId).append('-').append(fieldValueKey);
                    ArrayList<String> params = new ArrayList<String>(paramsArr.length);
                    params.add("1");
                    params.add(preEventClassIdStr);
                    for (int i = 0; i < paramsArr.length; ++i) {
                        params.add(paramsArr[i]);
                    }
                    StringBuilder sbParamKey = new StringBuilder();
                    sbParamKey.append(preEventClassId).append('-').append(fieldValueKey).append('-').append(paramsArr[1]);
                    paramParentEventIdMap.put(sbParamKey.toString(), parentEventId);
                    AiEventSqlQueryDto sqlDto = new AiEventSqlQueryDto(parentEventId, eventClassId, preEventClassId, fieldValueKey, sbSelQuery.toString(), whereSql, params);
                    sqlDtoList.add(sqlDto);
                }
            }
        }
        String errorMessage = AiEventValidatorUtil.setEventBlockBatch(blockDtoList, sqlDtoList, eventIdClassMap, dtoMap, classIdFieldValueMap, paramParentEventIdMap, fieldValueMap, eventIdNumberMap, billType);
        if (!StringUtils.isEmpty((CharSequence)errorMessage)) {
            checkStatus = false;
            AiEventUtil.saveEventBlock(blockDtoList);
            blockDtoList.clear();
            log.info(String.format("\u4e8b\u4ef6ID:%s\u5df2\u88ab\u963b\u585e", StringUtils.join((Object[])selectPks.toArray(), (String)",")));
            retData.setStatus(false);
            retData.setMessage(errorMessage);
        }
        retData.setStatus(checkStatus);
        return retData;
    }

    private static String setEventBlockBatch(List<AiEventBlockDto> blockDtoList, List<AiEventSqlQueryDto> sqlDtoList, Map<Long, Long> eventIdClassMap, Map<String, AiEventBlockDto> dtoMap, Map<String, String> classIdFieldValueMap, Map<String, Long> paramParentEventIdMap, Map<String, Map<String, String>> fieldValueMap, Map<Long, String> eventIdNumberMap, String billType) {
        if (sqlDtoList == null || sqlDtoList.isEmpty()) {
            return null;
        }
        StringBuilder sbSelectSql = new StringBuilder(PRE_AI_SELECT);
        StringBuilder sbSelectParam = new StringBuilder(" in (");
        ArrayList fullParams = new ArrayList(10);
        ArrayList<String> statusParams = new ArrayList<String>(10);
        ArrayList<Long> eventClassIdParams = new ArrayList<Long>(10);
        ArrayList<String> fieldNameParams = new ArrayList<String>(10);
        ArrayList<String> fieldValueParams = new ArrayList<String>(10);
        HashSet<String> billTypeSet = new HashSet<String>(10);
        for (AiEventSqlQueryDto dto : sqlDtoList) {
            sbSelectParam.append("?,");
            statusParams.add(dto.getParams().get(0));
            eventClassIdParams.add(Long.parseLong(dto.getParams().get(1)));
            fieldNameParams.add(dto.getParams().get(2));
            fieldValueParams.add(dto.getParams().get(3));
            billTypeSet.add(DataModelDaoImpl.getTableNameById(dto.getPreEventClassId()));
        }
        sbSelectParam.deleteCharAt(sbSelectParam.length() - 1).append(')');
        if (ENTITY_AI_EVENT.equals(billType)) {
            billTypeSet = new HashSet();
            billTypeSet.add(ENTITY_AI_EVENT);
            sbSelectSql.append(" in (?)");
        } else {
            sbSelectSql.append((CharSequence)sbSelectParam);
        }
        sbSelectSql.append(" where c.fstatus ").append((CharSequence)sbSelectParam).append(" and a.feventclassid ").append((CharSequence)sbSelectParam).append(" and a.ffieldname ").append((CharSequence)sbSelectParam).append(" and a.ffieldvalue ").append((CharSequence)sbSelectParam);
        fullParams.addAll(billTypeSet);
        fullParams.addAll(statusParams);
        fullParams.addAll(eventClassIdParams);
        fullParams.addAll(fieldNameParams);
        fullParams.addAll(fieldValueParams);
        HashSet<Long> generateEventIds = new HashSet<Long>();
        HashSet<Long> generateVoucherEventIds = new HashSet<Long>();
        try (DataSet dsData = DB.queryDataSet((String)"AiEventValidatorUtil.setEventBlockBatch", (DBRoute)DBRoute.of((String)"ai"), (String)sbSelectSql.toString(), (Object[])fullParams.toArray());){
            Iterator iterRow = dsData.iterator();
            if (iterRow == null || !iterRow.hasNext()) {
                for (AiEventSqlQueryDto sqlDto : sqlDtoList) {
                    AiEventBlockDto tplDto = dtoMap.get(sqlDto.getQueryKey());
                    if (EventPreStatusEnum.EVENT.getValue().equals(tplDto.getPreStatus())) {
                        generateEventIds.add(sqlDto.getEventId());
                    } else {
                        generateVoucherEventIds.add(sqlDto.getEventId());
                    }
                    AiEventValidatorUtil.initEventBlockDto(tplDto, blockDtoList, sqlDto.getEventId(), fieldValueMap, sqlDto.getSelectQueryWhere());
                }
            } else {
                while (iterRow.hasNext()) {
                    Row row = (Row)iterRow.next();
                    Long voucherId = row.getLong("voucherid");
                    Long preEventClassId = row.getLong("eventclassid");
                    String fieldName = row.getString("ffieldname");
                    String fieldRealValue = row.getString("ffieldvalue");
                    String fieldValue = classIdFieldValueMap.get(preEventClassId + "-" + fieldName);
                    Long parentEventId = paramParentEventIdMap.get(preEventClassId + "-" + fieldValue + "-" + fieldRealValue);
                    Long eventClassId = eventIdClassMap.get(parentEventId);
                    StringBuilder sbBlockKey = new StringBuilder();
                    sbBlockKey.append(eventClassId).append('-').append(preEventClassId).append('-').append(fieldValue);
                    AiEventBlockDto tplDto = dtoMap.get(sbBlockKey.toString());
                    String preStatus = tplDto.getPreStatus();
                    if (!EventPreStatusEnum.VOUCHER.getValue().equals(preStatus) || voucherId != null && voucherId != 0L) continue;
                    AiEventValidatorUtil.initEventBlockDto(tplDto, blockDtoList, parentEventId, fieldValueMap, null);
                    generateVoucherEventIds.add(parentEventId);
                }
            }
        }
        return AiEventValidatorUtil.getMessageInfo(generateVoucherEventIds, eventIdNumberMap, true) + AiEventValidatorUtil.getMessageInfo(generateEventIds, eventIdNumberMap, false);
    }

    private static void initEventBlockDto(AiEventBlockDto tplDto, List<AiEventBlockDto> blockDtoList, Long parentEventId, Map<String, Map<String, String>> fieldValueMap, String whereSql) {
        AiEventBlockDto dto = new AiEventBlockDto();
        dto.setEventClassId(tplDto.getEventClassId());
        dto.setFieldName(tplDto.getFieldName());
        dto.setEventId(parentEventId);
        dto.setWhereSql(whereSql);
        dto.setPreStatus(tplDto.getPreStatus());
        Map<String, String> preValueMap = fieldValueMap.get(parentEventId.toString());
        if (preValueMap != null) {
            dto.setFieldValue(preValueMap.get(tplDto.getFieldValue()));
        }
        blockDtoList.add(dto);
    }

    private static String getMessageInfo(Set<Long> eventIds, Map<Long, String> eventIdNumberMap, boolean isVoucher) {
        if (eventIds == null || eventIds.isEmpty()) {
            return "";
        }
        Iterator<Long> iter = eventIds.iterator();
        StringBuilder sbMsg = new StringBuilder();
        while (iter.hasNext()) {
            Long eventId = iter.next();
            sbMsg.append(eventIdNumberMap.get(eventId)).append(',');
        }
        if (sbMsg.length() > 0) {
            sbMsg.deleteCharAt(sbMsg.length() - 1);
        }
        String result = isVoucher ? String.format(ResManager.loadKDString((String)"\u5916\u90e8\u6570\u636e\u7f16\u53f7\u201c%1$s\u201d\u5b58\u5728\u524d\u7f6e\u5916\u90e8\u6570\u636e\u6a21\u578b\u672a\u751f\u6210\u51ed\u8bc1\uff0c\u8bf7\u68c0\u67e5\u3002", (String)"AiEventValidatorUtil_2", (String)"fi-ai-common", (Object[])new Object[0]), sbMsg) : String.format(ResManager.loadKDString((String)"\u5916\u90e8\u6570\u636e\u7f16\u53f7\u201c%1$s\u201d\u5b58\u5728\u524d\u7f6e\u5916\u90e8\u6570\u636e\u6a21\u578b\u672a\u4ea7\u751f\u5916\u90e8\u6570\u636e\uff0c\u8bf7\u68c0\u67e5\u3002", (String)"AiEventValidatorUtil_3", (String)"fi-ai-common", (Object[])new Object[0]), sbMsg);
        return result;
    }
}

