/*
 * Decompiled with CFR 0.152.
 */
package kd.fi.ai.function;

import java.util.EventObject;
import java.util.HashSet;
import kd.bos.dataentity.metadata.IDataEntityType;
import kd.bos.dataentity.serialization.SerializationUtils;
import kd.bos.dataentity.utils.StringUtils;
import kd.bos.entity.MainEntityType;
import kd.bos.entity.datamodel.IDataModel;
import kd.bos.entity.property.EntryProp;
import kd.bos.entity.tree.TreeNode;
import kd.bos.form.CloseCallBack;
import kd.bos.form.FormShowParameter;
import kd.bos.form.ShowType;
import kd.bos.form.control.Control;
import kd.bos.form.events.ClosedCallBackEvent;
import kd.bos.form.func.AbstractFuncParamPlugIn;
import kd.bos.form.plugin.IFormPlugin;
import kd.fi.ai.ExpressionType;
import kd.fi.ai.util.DapUtil;
import kd.fi.ai.util.EntityFieldTreeOption;
import kd.fi.ai.util.EntityFieldTreeResult;
import kd.fi.ai.util.EntityTreeUtil;

public class CrossEntityPlugin
extends AbstractFuncParamPlugIn {
    public static final String ENTRYENTITY_FIRST = "entryentityfirst";
    public static final String ENTRYENTITY_SECOND = "entryentitysecond";
    public static final String COMPARE = "compare";

    public void registerListener(EventObject e) {
        super.registerListener(e);
        this.addClickListeners(new String[]{ENTRYENTITY_FIRST, ENTRYENTITY_SECOND});
    }

    public void click(EventObject evt) {
        super.click(evt);
        Control text = (Control)evt.getSource();
        this.showSelectField(text.getKey());
    }

    private void showSelectField(String key) {
        String entityNumber = this.getEntityNumber();
        MainEntityType dataEntityType = DapUtil.getEntityTypeByNumber(entityNumber);
        EntityFieldTreeResult result = this.getEntityFieldTreeResult(dataEntityType);
        TreeNode tree = EntityTreeUtil.buildBillTree(result.getNodes());
        TreeNode entityNode = new TreeNode(tree.getParentid(), tree.getId(), tree.getText());
        this.getAllEntiry(tree, (IDataEntityType)dataEntityType, entityNode);
        this.dealTreeEntity(entityNode, (IDataEntityType)dataEntityType);
        FormShowParameter showParameter = new FormShowParameter();
        showParameter.setFormId("botp_selectfield");
        String treeJson = SerializationUtils.toJsonString((Object)entityNode);
        showParameter.getCustomParams().put("treenodes", treeJson);
        showParameter.setCloseCallBack(new CloseCallBack((IFormPlugin)this, key));
        showParameter.getOpenStyle().setShowType(ShowType.Modal);
        this.getView().showForm(showParameter);
    }

    private void getAllEntiry(TreeNode treeNode, IDataEntityType dataEntityType, TreeNode entityNode) {
        boolean isEntity = dataEntityType.getProperties().get((Object)treeNode.getId()) instanceof EntryProp;
        if (isEntity) {
            entityNode.addChild(treeNode);
        } else if (treeNode.getChildren() != null) {
            for (TreeNode node : treeNode.getChildren()) {
                this.getAllEntiry(node, dataEntityType, entityNode);
            }
        }
    }

    private void dealTreeEntity(TreeNode treeNode, IDataEntityType dataEntityType) {
        HashSet<String> set = new HashSet<String>();
        set.add("id");
        set.add("seq");
        if (set.contains(treeNode.getId()) && StringUtils.isNotBlank((CharSequence)treeNode.getParentid())) {
            StringBuilder str = new StringBuilder();
            str.append(treeNode.getParentid());
            str.append('.');
            str.append(treeNode.getId());
            treeNode.setId(str.toString());
        }
        if (treeNode.getChildren() == null) {
            return;
        }
        for (TreeNode node : treeNode.getChildren()) {
            this.dealTreeEntity(node, dataEntityType);
        }
    }

    public String getSetting() {
        IDataModel model = this.getModel();
        Object first = model.getValue(ENTRYENTITY_FIRST);
        Object second = model.getValue(ENTRYENTITY_SECOND);
        Object compare = model.getValue(COMPARE);
        String setting = String.format("%s('%s',%s, '%s', %s)", this.getFuncId(), this.getEntityNumber(), first, compare.equals("1") ? "=" : "contains", second);
        return setting;
    }

    private EntityFieldTreeResult getEntityFieldTreeResult(MainEntityType mainType) {
        EntityFieldTreeOption option = EntityFieldTreeOption.create();
        option.setEntityType((IDataEntityType)mainType);
        option.setReadEntryEntity(this.readEntryProp());
        option.setExprType(ExpressionType.Condition);
        option.setIncludeID(true);
        EntityFieldTreeResult result = EntityTreeUtil.getEntityFieldNodes(option);
        return result;
    }

    protected boolean readEntryProp() {
        return true;
    }

    public void closedCallBack(ClosedCallBackEvent closedCallBackEvent) {
        super.closedCallBack(closedCallBackEvent);
        if (closedCallBackEvent.getReturnData() == null) {
            return;
        }
        if (StringUtils.equalsIgnoreCase((CharSequence)closedCallBackEvent.getActionId(), (CharSequence)ENTRYENTITY_FIRST)) {
            this.getModel().setValue(ENTRYENTITY_FIRST, closedCallBackEvent.getReturnData());
        } else if (StringUtils.equalsIgnoreCase((CharSequence)closedCallBackEvent.getActionId(), (CharSequence)ENTRYENTITY_SECOND)) {
            this.getModel().setValue(ENTRYENTITY_SECOND, closedCallBackEvent.getReturnData());
        }
    }
}

