/*
 * Decompiled with CFR 0.152.
 */
package kd.fi.ai.function;

import java.util.EventObject;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import java.util.stream.Collectors;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.entity.DynamicObjectCollection;
import kd.bos.dataentity.metadata.IDataEntityProperty;
import kd.bos.dataentity.metadata.IDataEntityType;
import kd.bos.dataentity.metadata.dynamicobject.DynamicObjectType;
import kd.bos.dataentity.metadata.dynamicobject.DynamicProperty;
import kd.bos.dataentity.serialization.SerializationUtils;
import kd.bos.dataentity.utils.ObjectUtils;
import kd.bos.dataentity.utils.StringUtils;
import kd.bos.entity.EntityMetadataCache;
import kd.bos.entity.MainEntityType;
import kd.bos.entity.datamodel.IDataModel;
import kd.bos.entity.property.EntryProp;
import kd.bos.entity.tree.TreeNode;
import kd.bos.form.CloseCallBack;
import kd.bos.form.FormShowParameter;
import kd.bos.form.ShowType;
import kd.bos.form.control.Control;
import kd.bos.form.events.ClosedCallBackEvent;
import kd.bos.form.field.BasedataEdit;
import kd.bos.form.field.events.BeforeF7SelectEvent;
import kd.bos.form.func.AbstractFuncParamPlugIn;
import kd.bos.form.plugin.IFormPlugin;
import kd.bos.list.ListShowParameter;
import kd.bos.orm.query.QFilter;
import kd.bos.servicehelper.QueryServiceHelper;
import kd.fi.ai.ExpressionType;
import kd.fi.ai.util.AiEventMetaUtil;
import kd.fi.ai.util.EntityFieldTreeOption;
import kd.fi.ai.util.EntityFieldTreeResult;
import kd.fi.ai.util.EntityTreeUtil;

public class GetAccEventPlugin
extends AbstractFuncParamPlugIn {
    private static final String EVENT_CLASS = "eventclass";
    private static final String PROPERTY_NAME = "propertyname";
    private static final String FILTER_PROP = "filterprop";
    private static final String FILTER_VALUE = "filtervalue";

    public void registerListener(EventObject e) {
        super.registerListener(e);
        this.addClickListeners(new String[]{PROPERTY_NAME, FILTER_PROP, FILTER_VALUE});
        BasedataEdit eventclass = (BasedataEdit)this.getControl(EVENT_CLASS);
        eventclass.addBeforeF7SelectListener(this::beforEventClassSelect);
    }

    private void beforEventClassSelect(BeforeF7SelectEvent evt) {
        Map customParams = this.getView().getFormShowParameter().getCustomParams();
        String eventClassIdStr = (String)customParams.get("entitynumber");
        if (!this.isNumeric(eventClassIdStr)) {
            return;
        }
        long eventClassId = Long.parseLong(eventClassIdStr);
        DynamicObjectCollection eventClasses = QueryServiceHelper.query((String)"ai_eventclass", (String)"preevent.preeventclass,preevent.evtfield", (QFilter[])new QFilter("id", "=", (Object)eventClassId).toArray());
        Set prevClassIds = eventClasses.stream().map(v -> v.get("preevent.preeventclass")).collect(Collectors.toSet());
        List qFilters = ((ListShowParameter)evt.getFormShowParameter()).getListFilterParameter().getQFilters();
        qFilters.add(new QFilter("id", "in", prevClassIds));
    }

    public void click(EventObject evt) {
        super.click(evt);
        Control source = (Control)evt.getSource();
        if (StringUtils.equalsIgnoreCase((CharSequence)source.getKey(), (CharSequence)PROPERTY_NAME)) {
            MainEntityType entityType = this.getEntityType();
            this.showPropertyUI(entityType, source.getKey());
        } else if (StringUtils.equalsIgnoreCase((CharSequence)source.getKey(), (CharSequence)FILTER_PROP)) {
            MainEntityType entityType = this.getEntityType();
            this.showPropertyUI(entityType, source.getKey());
        } else if (StringUtils.equalsIgnoreCase((CharSequence)source.getKey(), (CharSequence)FILTER_VALUE)) {
            MainEntityType eventEntityType = this.getSelfEventType();
            this.showPropertyUI(eventEntityType, FILTER_VALUE);
        }
    }

    private MainEntityType getSelfEventType() {
        Map customParams = this.getView().getFormShowParameter().getCustomParams();
        String eventClassIdStr = (String)customParams.get("entitynumber");
        if (!this.isNumeric(eventClassIdStr)) {
            return EntityMetadataCache.getDataEntityType((String)eventClassIdStr);
        }
        long eventClassId = Long.parseLong(eventClassIdStr);
        MainEntityType eventEntityType = AiEventMetaUtil.getEntityType(eventClassId);
        return eventEntityType;
    }

    private void showPropertyUI(MainEntityType type, String name) {
        if (type == null) {
            return;
        }
        EntityFieldTreeResult result = this.getEntityFieldTreeResult(type);
        TreeNode tree = EntityTreeUtil.buildBillTree(result.getNodes());
        String treeJson = SerializationUtils.toJsonString((Object)tree);
        FormShowParameter showParameter = new FormShowParameter();
        showParameter.setFormId("botp_selectfield");
        showParameter.getCustomParams().put("treenodes", treeJson);
        showParameter.setCloseCallBack(new CloseCallBack((IFormPlugin)this, name));
        showParameter.getOpenStyle().setShowType(ShowType.Modal);
        this.getView().showForm(showParameter);
    }

    protected MainEntityType getEntityType() {
        IDataModel model = this.getModel();
        DynamicObject eventclass = (DynamicObject)model.getValue(EVENT_CLASS);
        if (eventclass == null) {
            return null;
        }
        return AiEventMetaUtil.getEntityType(eventclass.getPkValue());
    }

    private EntityFieldTreeResult getEntityFieldTreeResult(MainEntityType mainType) {
        EntityFieldTreeOption option = EntityFieldTreeOption.create();
        option.setEntityType((IDataEntityType)mainType);
        option.setReadEntryEntity(true);
        option.setExprType(ExpressionType.Condition);
        option.setIncludeID(true);
        EntityFieldTreeResult result = EntityTreeUtil.getEntityFieldNodes(option);
        return result;
    }

    public void closedCallBack(ClosedCallBackEvent closedCallBackEvent) {
        super.closedCallBack(closedCallBackEvent);
        if (closedCallBackEvent.getReturnData() == null) {
            return;
        }
        if (StringUtils.equalsIgnoreCase((CharSequence)closedCallBackEvent.getActionId(), (CharSequence)PROPERTY_NAME) || StringUtils.equalsIgnoreCase((CharSequence)closedCallBackEvent.getActionId(), (CharSequence)FILTER_PROP)) {
            this.getModel().setValue(closedCallBackEvent.getActionId(), (Object)this.getLongProp((DynamicObjectType)this.getEntityType(), (String)closedCallBackEvent.getReturnData()));
        } else if (StringUtils.equalsIgnoreCase((CharSequence)closedCallBackEvent.getActionId(), (CharSequence)FILTER_VALUE)) {
            this.getModel().setValue(closedCallBackEvent.getActionId(), (Object)("$" + this.getLongProp((DynamicObjectType)this.getSelfEventType(), (String)closedCallBackEvent.getReturnData())));
        }
    }

    private String getLongProp(DynamicObjectType entityType, String prop) {
        if (prop.indexOf(46) > 0) {
            return prop;
        }
        DynamicProperty property = entityType.getProperty(prop);
        if (property != null) {
            return property.getName();
        }
        List entryProps = entityType.getProperties().stream().filter(v -> v instanceof EntryProp).collect(Collectors.toList());
        for (IDataEntityProperty _entryProp : entryProps) {
            EntryProp entryProp = (EntryProp)_entryProp;
            String entryName = entryProp.getName();
            DynamicObjectType entryType = entryProp.getDynamicCollectionItemPropertyType();
            String propName = this.getLongProp(entryType, prop);
            if (propName == null) continue;
            return entryName + "." + propName;
        }
        return null;
    }

    public String getSetting() {
        IDataModel model = this.getModel();
        Object prevEventClassObj = model.getValue(EVENT_CLASS);
        Object property = model.getValue(PROPERTY_NAME);
        if (ObjectUtils.isEmpty((Object)prevEventClassObj) || ObjectUtils.isEmpty((Object)property)) {
            return null;
        }
        Map customParams = this.getView().getFormShowParameter().getCustomParams();
        String eventClassIdStr = (String)customParams.get("entitynumber");
        if (!this.isNumeric(eventClassIdStr)) {
            return null;
        }
        long eventClassId = Long.parseLong(eventClassIdStr);
        Object prevEventClassId = ((DynamicObject)prevEventClassObj).getPkValue();
        DynamicObject prevEventClass = QueryServiceHelper.queryOne((String)"ai_eventclass", (String)"preevent.evtfield", (QFilter[])new QFilter[]{new QFilter("id", "=", (Object)eventClassId), new QFilter("preevent.preeventclass", "=", prevEventClassId)});
        String evtfield = prevEventClass.getString("preevent.evtfield");
        String filterProp = (String)model.getValue(FILTER_PROP);
        String filterValue = (String)model.getValue(FILTER_VALUE);
        filterValue = !filterValue.startsWith("$") ? "\"" + filterValue + "\"" : filterValue.substring(1);
        String setting = String.format("%s(\"%s\", %s, %s, \"%s\", \"%s\", %s)", this.getFuncId(), evtfield, evtfield, prevEventClassId, property, filterProp, filterValue);
        return setting;
    }

    public boolean isNumeric(String str) {
        Pattern pattern = Pattern.compile("[0-9]*");
        Matcher isNum = pattern.matcher(str);
        return isNum.matches();
    }
}

