/*
 * Decompiled with CFR 0.152.
 */
package kd.fi.ai.function;

import java.util.EventObject;
import java.util.HashSet;
import java.util.List;
import kd.bos.dataentity.metadata.IDataEntityType;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.dataentity.serialization.SerializationUtils;
import kd.bos.dataentity.utils.StringUtils;
import kd.bos.entity.MainEntityType;
import kd.bos.entity.tree.TreeNode;
import kd.bos.form.CloseCallBack;
import kd.bos.form.FormShowParameter;
import kd.bos.form.ShowType;
import kd.bos.form.control.Control;
import kd.bos.form.events.ClosedCallBackEvent;
import kd.bos.form.field.ComboEdit;
import kd.bos.form.field.ComboItem;
import kd.bos.form.func.AbstractFuncParamPlugIn;
import kd.bos.form.plugin.IFormPlugin;
import kd.fi.ai.ExpressionType;
import kd.fi.ai.util.DapUtil;
import kd.fi.ai.util.EntityFieldTreeOption;
import kd.fi.ai.util.EntityFieldTreeResult;
import kd.fi.ai.util.EntityTreeUtil;

public class GetInventoryCategoryByMaterialPlugin
extends AbstractFuncParamPlugIn {
    private static final String MATERIAL = "material";
    private static final String ORG = "org";

    public void initialize() {
        super.initialize();
        this.addClickListeners(new String[]{MATERIAL});
    }

    public void afterCreateNewData(EventObject e) {
        this.fillBox();
    }

    private void fillBox() {
        MainEntityType srcMainET = DapUtil.getEntityTypeByNumber(this.getEntityNumber());
        ComboEdit fieldEditor = (ComboEdit)this.getView().getControl(ORG);
        HashSet<String> entityIds = new HashSet<String>();
        entityIds.add("bos_org");
        entityIds.add("bos_adminorg");
        entityIds.add("bos_costcenter");
        List<ComboItem> items = null;
        items = DapUtil.buildPropComboItems(entityIds, srcMainET, false, true, false);
        DapUtil.removeItemClassPropComboItem(items, srcMainET);
        if (items != null && items.size() > 0) {
            fieldEditor.selectedStore(items.get(0));
        }
        fieldEditor.setComboItems(items);
    }

    public void click(EventObject evt) {
        super.click(evt);
        Control source = (Control)evt.getSource();
        if (StringUtils.equalsIgnoreCase((CharSequence)source.getKey(), (CharSequence)MATERIAL)) {
            FormShowParameter showParameter = new FormShowParameter();
            showParameter.setFormId("botp_selectfield");
            MainEntityType mainType = DapUtil.getEntityTypeByNumber(this.getEntityNumber());
            EntityFieldTreeResult result = this.getEntityFieldTreeResult(mainType);
            TreeNode tree = EntityTreeUtil.buildBillTree(result.getNodes());
            String nodesJson = SerializationUtils.toJsonString((Object)tree);
            showParameter.getCustomParams().put("treenodes", nodesJson);
            showParameter.setCloseCallBack(new CloseCallBack((IFormPlugin)this, MATERIAL));
            showParameter.getOpenStyle().setShowType(ShowType.Modal);
            this.getView().showForm(showParameter);
        }
    }

    private EntityFieldTreeResult getEntityFieldTreeResult(MainEntityType mainType) {
        EntityFieldTreeOption option = EntityFieldTreeOption.create();
        option.setEntityType((IDataEntityType)mainType);
        option.setReadEntryEntity(true);
        option.setExprType(ExpressionType.Condition);
        option.setIncludeID(true);
        EntityFieldTreeResult result = EntityTreeUtil.getEntityFieldNodes(option);
        return result;
    }

    public void closedCallBack(ClosedCallBackEvent closedCallBackEvent) {
        super.closedCallBack(closedCallBackEvent);
        if (closedCallBackEvent.getReturnData() == null) {
            return;
        }
        if (StringUtils.equalsIgnoreCase((CharSequence)closedCallBackEvent.getActionId(), (CharSequence)MATERIAL)) {
            this.getModel().setValue(MATERIAL, closedCallBackEvent.getReturnData());
        }
    }

    public Boolean checkSetting(StringBuilder msgBuilder) {
        String material = (String)this.getModel().getValue(MATERIAL);
        if (StringUtils.isBlank((CharSequence)material)) {
            msgBuilder.append(ResManager.loadKDString((String)"\u8bf7\u9009\u62e9\u7269\u6599\u3002", (String)"GetInventoryCategoryByMaterialPlugin_0", (String)"fi-ai-common", (Object[])new Object[0]));
            return Boolean.FALSE;
        }
        String org = (String)this.getModel().getValue(ORG);
        if (StringUtils.isBlank((CharSequence)org)) {
            msgBuilder.append(ResManager.loadKDString((String)"\u8bf7\u9009\u62e9\u6838\u7b97\u7ec4\u7ec7\u3002", (String)"GetInventoryCategoryByMaterialPlugin_1", (String)"fi-ai-common", (Object[])new Object[0]));
            return Boolean.FALSE;
        }
        return Boolean.TRUE;
    }

    public String getSetting() {
        String material = (String)this.getModel().getValue(MATERIAL);
        String org = (String)this.getModel().getValue(ORG);
        String setting = String.format("%s(%s, %s)", this.getFuncId(), material, org);
        return setting;
    }
}

