/*
 * Decompiled with CFR 0.152.
 */
package kd.fi.ai.function;

import java.util.ArrayList;
import java.util.EventObject;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import kd.bos.dataentity.entity.LocaleString;
import kd.bos.dataentity.metadata.IDataEntityProperty;
import kd.bos.dataentity.metadata.IDataEntityType;
import kd.bos.dataentity.metadata.clr.DataEntityPropertyCollection;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.dataentity.serialization.SerializationUtils;
import kd.bos.dataentity.utils.StringUtils;
import kd.bos.entity.EntityType;
import kd.bos.entity.MainEntityType;
import kd.bos.entity.ValueMapItem;
import kd.bos.entity.datamodel.IDataModel;
import kd.bos.entity.property.EntryProp;
import kd.bos.entity.property.ItemClassProp;
import kd.bos.entity.property.ItemClassTypeProp;
import kd.bos.entity.property.SubEntryProp;
import kd.bos.entity.tree.TreeNode;
import kd.bos.form.CloseCallBack;
import kd.bos.form.FormShowParameter;
import kd.bos.form.ShowType;
import kd.bos.form.control.Control;
import kd.bos.form.events.ClosedCallBackEvent;
import kd.bos.form.field.ComboEdit;
import kd.bos.form.field.ComboItem;
import kd.bos.form.func.AbstractFuncParamPlugIn;
import kd.bos.form.plugin.IFormPlugin;
import kd.bos.lang.Lang;
import kd.fi.ai.ExpressionType;
import kd.fi.ai.util.DapUtil;
import kd.fi.ai.util.EntityFieldTreeOption;
import kd.fi.ai.util.EntityFieldTreeResult;
import kd.fi.ai.util.EntityTreeUtil;

public class GetMuliBaseDataPlugin
extends AbstractFuncParamPlugIn {
    private static final String TYPE = "type";
    private static final String BASE_DATA = "basedata";
    private static final String SourcePropertyName = "sourceproname";
    private Map<String, List<String>> proMap = new HashMap<String, List<String>>();

    public void registerListener(EventObject e) {
        super.registerListener(e);
        this.addClickListeners(new String[]{SourcePropertyName});
    }

    public void afterCreateNewData(EventObject e) {
        String entityNumber = this.getEntityNumber();
        DataEntityPropertyCollection properties = DapUtil.getEntityTypeByNumber(entityNumber).getProperties();
        ComboEdit combTY = (ComboEdit)this.getControl(TYPE);
        ComboEdit combBD = (ComboEdit)this.getControl(BASE_DATA);
        ArrayList<ComboItem> typeList = new ArrayList<ComboItem>();
        ArrayList<ComboItem> baseList = new ArrayList<ComboItem>();
        this.getComb(properties, null, null, typeList, baseList);
        this.getPageCache().put("proMap", SerializationUtils.toJsonString(this.proMap));
        combTY.setComboItems(typeList);
        combBD.setComboItems(baseList);
    }

    private void getComb(DataEntityPropertyCollection properties, String entityKey, String entityName, List<ComboItem> typeList, List<ComboItem> baseList) {
        for (IDataEntityProperty propertie : properties) {
            String name;
            ComboItem co;
            if (propertie instanceof ItemClassTypeProp && StringUtils.isNotEmpty((CharSequence)propertie.getAlias())) {
                co = new ComboItem();
                if (entityKey == null) {
                    co.setCaption(propertie.getDisplayName());
                    co.setValue(propertie.getName());
                    this.creatProMap(propertie.getName(), propertie);
                } else {
                    name = entityName + "." + propertie.getDisplayName().getLocaleValue_zh_CN();
                    co.setCaption(new LocaleString(Lang.defaultLang().toString(), name));
                    co.setValue(entityKey + "." + propertie.getName());
                    this.creatProMap(entityKey + "." + propertie.getName(), propertie);
                }
                typeList.add(co);
                continue;
            }
            if (propertie instanceof ItemClassProp && StringUtils.isNotEmpty((CharSequence)propertie.getAlias())) {
                co = new ComboItem();
                if (entityKey == null) {
                    co.setCaption(propertie.getDisplayName());
                    co.setValue(propertie.getName());
                } else {
                    name = entityName + "." + propertie.getDisplayName().getLocaleValue_zh_CN();
                    co.setCaption(new LocaleString(Lang.defaultLang().toString(), name));
                    co.setValue(entityKey + "." + propertie.getName());
                }
                baseList.add(co);
                continue;
            }
            if (!(propertie instanceof EntryProp)) continue;
            String parentNameSub = propertie.getDisplayName().toString();
            String parentKeySub = null;
            if (propertie instanceof SubEntryProp) {
                parentKeySub = propertie.getParent().getName() + "." + propertie.getName();
                parentNameSub = entityName + "." + parentNameSub;
            } else if (entityKey != null) {
                parentKeySub = entityKey + "." + propertie.getName();
                parentNameSub = entityName + "." + parentNameSub;
            } else {
                parentKeySub = propertie.getName();
            }
            EntityType subEntityType = (EntityType)((EntryProp)propertie).getItemType();
            this.getComb(subEntityType.getProperties(), parentKeySub, parentNameSub, typeList, baseList);
        }
    }

    public String getSetting() {
        IDataModel model = this.getModel();
        Object type = model.getValue(TYPE);
        Object base = model.getValue(BASE_DATA);
        Object property = model.getValue(SourcePropertyName);
        String setting = String.format("%s(%s, %s, '%s')", this.getFuncId(), type, base, property);
        return setting;
    }

    public void click(EventObject evt) {
        super.click(evt);
        Control source = (Control)evt.getSource();
        if (StringUtils.equalsIgnoreCase((CharSequence)source.getKey(), (CharSequence)SourcePropertyName)) {
            FormShowParameter showParameter = new FormShowParameter();
            showParameter.setFormId("botp_selectfield");
            ArrayList<String> idLists = new ArrayList<String>();
            Object sourceEntity = this.getModel().getValue(TYPE);
            TreeNode rootTree = new TreeNode();
            rootTree.setText(ResManager.loadKDString((String)"\u5f80\u6765\u6237", (String)"GetMuliBaseDataPlugin_0", (String)"fi-ai-common", (Object[])new Object[0]));
            rootTree.setIsOpened(true);
            if (sourceEntity != null) {
                this.getProMap();
                List<String> list = this.proMap.get(sourceEntity);
                for (String string : list) {
                    MainEntityType mainType = DapUtil.getEntityTypeByNumber(string);
                    EntityFieldTreeResult result = this.getEntityFieldTreeResult(mainType);
                    TreeNode tree = EntityTreeUtil.buildBillTree(result.getNodes());
                    idLists.addAll(EntityTreeUtil.buildEntryTree(result.getNodes()));
                    tree.setIsOpened(false);
                    rootTree.addChild(tree);
                }
                String treeJson = SerializationUtils.toJsonString((Object)rootTree);
                showParameter.getCustomParams().put("treenodes", treeJson);
                showParameter.setCloseCallBack(new CloseCallBack((IFormPlugin)this, SourcePropertyName));
                showParameter.getOpenStyle().setShowType(ShowType.Modal);
                this.getView().showForm(showParameter);
                this.getPageCache().put("entries", SerializationUtils.toJsonString(idLists));
            }
        }
    }

    private EntityFieldTreeResult getEntityFieldTreeResult(MainEntityType mainType) {
        EntityFieldTreeOption option = EntityFieldTreeOption.create();
        option.setEntityType((IDataEntityType)mainType);
        option.setReadEntryEntity(false);
        option.setExprType(ExpressionType.Condition);
        option.setIncludeID(true);
        option.setIncludeParentID(true);
        EntityFieldTreeResult result = EntityTreeUtil.getEntityFieldNodes(option);
        return result;
    }

    public void closedCallBack(ClosedCallBackEvent closedCallBackEvent) {
        super.closedCallBack(closedCallBackEvent);
        if (closedCallBackEvent.getReturnData() == null) {
            return;
        }
        if (StringUtils.equalsIgnoreCase((CharSequence)closedCallBackEvent.getActionId(), (CharSequence)SourcePropertyName)) {
            String returnStr = (String)closedCallBackEvent.getReturnData();
            String entriesStr = this.getPageCache().get("entries");
            if (StringUtils.isNotBlank((CharSequence)entriesStr)) {
                List list = (List)SerializationUtils.fromJsonString((String)entriesStr, List.class);
                for (String str : list) {
                    if (!returnStr.contains(str) || returnStr.split(str + ".").length <= 1) continue;
                    returnStr = returnStr.split(str + ".")[1];
                    break;
                }
            }
            this.getModel().setValue(SourcePropertyName, (Object)returnStr);
        }
    }

    private void getProMap() {
        if (this.getPageCache().get("proMap") != null) {
            this.proMap = (Map)SerializationUtils.fromJsonString((String)this.getPageCache().get("proMap"), Map.class);
        }
    }

    private void creatProMap(String name, IDataEntityProperty propertie) {
        ItemClassTypeProp classType = (ItemClassTypeProp)propertie;
        List combs = classType.getComboItems();
        ArrayList<String> list = new ArrayList<String>(combs.size());
        for (ValueMapItem comb : combs) {
            list.add(comb.getValue());
        }
        this.proMap.put(name, list);
    }
}

