/*
 * Decompiled with CFR 0.152.
 */
package kd.fi.ai.function;

import java.util.EventObject;
import java.util.List;
import java.util.stream.Collectors;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.metadata.IDataEntityProperty;
import kd.bos.dataentity.metadata.IDataEntityType;
import kd.bos.dataentity.metadata.dynamicobject.DynamicObjectType;
import kd.bos.dataentity.metadata.dynamicobject.DynamicProperty;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.dataentity.serialization.SerializationUtils;
import kd.bos.dataentity.utils.StringUtils;
import kd.bos.entity.EntityMetadataCache;
import kd.bos.entity.MainEntityType;
import kd.bos.entity.property.EntryProp;
import kd.bos.entity.tree.TreeNode;
import kd.bos.form.CloseCallBack;
import kd.bos.form.FormShowParameter;
import kd.bos.form.ShowType;
import kd.bos.form.control.Control;
import kd.bos.form.events.ClosedCallBackEvent;
import kd.bos.form.func.AbstractFuncParamPlugIn;
import kd.bos.form.plugin.IFormPlugin;
import kd.fi.ai.ExpressionType;
import kd.fi.ai.util.DapUtil;
import kd.fi.ai.util.EntityFieldTreeOption;
import kd.fi.ai.util.EntityFieldTreeResult;
import kd.fi.ai.util.EntityTreeUtil;

public class GetNotBotpSourcePropPlugin
extends AbstractFuncParamPlugIn {
    private static final String CurrentBillID = "currentbillid";
    private static final String SourceEntityName = "sourceentityname";
    private static final String RelationPropertyName = "relationprop";
    private static final String SourcePropertyName = "propertyname";

    public void initialize() {
        super.initialize();
        this.addClickListeners(new String[]{CurrentBillID, SourcePropertyName, RelationPropertyName});
    }

    public void afterCreateNewData(EventObject e) {
        super.afterCreateNewData(e);
        this.getModel().setValue(CurrentBillID, (Object)"id");
    }

    public void click(EventObject evt) {
        super.click(evt);
        Control source = (Control)evt.getSource();
        if (StringUtils.equalsIgnoreCase((CharSequence)source.getKey(), (CharSequence)CurrentBillID)) {
            FormShowParameter showParameter = new FormShowParameter();
            showParameter.setFormId("botp_selectfield");
            MainEntityType mainType = DapUtil.getEntityTypeByNumber(this.getEntityNumber());
            EntityFieldTreeResult result = this.getEntityFieldTreeResult(mainType);
            TreeNode tree = EntityTreeUtil.buildBillTree(result.getNodes());
            String treeJson = SerializationUtils.toJsonString((Object)tree);
            showParameter.getCustomParams().put("treenodes", treeJson);
            showParameter.setCloseCallBack(new CloseCallBack((IFormPlugin)this, CurrentBillID));
            showParameter.getOpenStyle().setShowType(ShowType.Modal);
            this.getView().showForm(showParameter);
        } else if (StringUtils.equalsIgnoreCase((CharSequence)source.getKey(), (CharSequence)SourcePropertyName)) {
            FormShowParameter showParameter = new FormShowParameter();
            showParameter.setFormId("botp_selectfield");
            MainEntityType mainType = this.getSourceEntityType();
            if (mainType != null) {
                EntityFieldTreeResult result = this.getEntityFieldTreeResult(mainType);
                TreeNode tree = EntityTreeUtil.buildBillTree(result.getNodes());
                String treeJson = SerializationUtils.toJsonString((Object)tree);
                showParameter.getCustomParams().put("treenodes", treeJson);
                showParameter.setCloseCallBack(new CloseCallBack((IFormPlugin)this, SourcePropertyName));
                showParameter.getOpenStyle().setShowType(ShowType.Modal);
                this.getView().showForm(showParameter);
            }
        } else if (StringUtils.equalsIgnoreCase((CharSequence)source.getKey(), (CharSequence)RelationPropertyName)) {
            FormShowParameter showParameter = new FormShowParameter();
            showParameter.setFormId("botp_selectfield");
            MainEntityType mainType = this.getSourceEntityType();
            if (mainType != null) {
                EntityFieldTreeResult result = this.getEntityFieldTreeResult(mainType);
                TreeNode tree = EntityTreeUtil.buildBillTree(result.getNodes());
                String treeJson = SerializationUtils.toJsonString((Object)tree);
                showParameter.getCustomParams().put("treenodes", treeJson);
                showParameter.setCloseCallBack(new CloseCallBack((IFormPlugin)this, RelationPropertyName));
                showParameter.getOpenStyle().setShowType(ShowType.Modal);
                this.getView().showForm(showParameter);
            }
        }
    }

    private EntityFieldTreeResult getEntityFieldTreeResult(MainEntityType mainType) {
        EntityFieldTreeOption option = EntityFieldTreeOption.create();
        option.setEntityType((IDataEntityType)mainType);
        option.setReadEntryEntity(this.readEntryProp());
        option.setExprType(ExpressionType.Condition);
        option.setIncludeID(true);
        EntityFieldTreeResult result = EntityTreeUtil.getEntityFieldNodes(option);
        return result;
    }

    protected boolean readEntryProp() {
        return false;
    }

    protected MainEntityType getSourceEntityType() {
        DynamicObject sourceEntity = (DynamicObject)this.getModel().getValue(SourceEntityName);
        if (sourceEntity == null) {
            return null;
        }
        return EntityMetadataCache.getDataEntityType((String)sourceEntity.getPkValue().toString());
    }

    public void closedCallBack(ClosedCallBackEvent closedCallBackEvent) {
        super.closedCallBack(closedCallBackEvent);
        if (closedCallBackEvent.getReturnData() == null) {
            return;
        }
        if (StringUtils.equalsIgnoreCase((CharSequence)closedCallBackEvent.getActionId(), (CharSequence)CurrentBillID)) {
            this.getModel().setValue(CurrentBillID, closedCallBackEvent.getReturnData());
        } else if (StringUtils.equalsIgnoreCase((CharSequence)closedCallBackEvent.getActionId(), (CharSequence)SourcePropertyName)) {
            this.getModel().setValue(SourcePropertyName, (Object)this.getLongProp((DynamicObjectType)this.getSourceEntityType(), closedCallBackEvent.getReturnData()));
        } else if (StringUtils.equalsIgnoreCase((CharSequence)closedCallBackEvent.getActionId(), (CharSequence)RelationPropertyName)) {
            this.getModel().setValue(RelationPropertyName, (Object)this.getLongProp((DynamicObjectType)this.getSourceEntityType(), closedCallBackEvent.getReturnData()));
        }
    }

    private String getLongProp(DynamicObjectType entityType, Object propObj) {
        DynamicProperty property;
        if (propObj == null) {
            return null;
        }
        String prop = propObj.toString();
        if (StringUtils.isEmpty((CharSequence)prop)) {
            return null;
        }
        String prefix = prop;
        if (prop.indexOf(46) > 0) {
            prefix = prop.split("\\.")[0];
        }
        if ((property = entityType.getProperty(prefix)) != null) {
            return prop;
        }
        List entryProps = entityType.getProperties().stream().filter(v -> v instanceof EntryProp).collect(Collectors.toList());
        for (IDataEntityProperty _entryProp : entryProps) {
            EntryProp entryProp = (EntryProp)_entryProp;
            String entryName = entryProp.getName();
            DynamicObjectType entryType = entryProp.getDynamicCollectionItemPropertyType();
            String propName = this.getLongProp(entryType, prop);
            if (propName == null) continue;
            return entryName + "." + propName;
        }
        return null;
    }

    public String getSetting() {
        String currentBillID = (String)this.getModel().getValue(CurrentBillID);
        if (StringUtils.isBlank((CharSequence)currentBillID)) {
            currentBillID = "0";
        }
        DynamicObject sourceEntity = (DynamicObject)this.getModel().getValue(SourceEntityName);
        String sourceEntityName = sourceEntity.getString("number");
        String relatpropertyname = (String)this.getModel().getValue(RelationPropertyName);
        String propertyname = (String)this.getModel().getValue(SourcePropertyName);
        String setting = String.format("%s(%s, '%s', '%s', '%s')", this.getFuncId(), currentBillID, sourceEntityName, relatpropertyname, propertyname);
        return setting;
    }

    public Boolean checkSetting(StringBuilder msgBuilder) {
        String currentBillID = (String)this.getModel().getValue(CurrentBillID);
        if (StringUtils.isBlank((CharSequence)currentBillID)) {
            msgBuilder.append(ResManager.loadKDString((String)"\u8bf7\u9009\u62e9\u5f53\u524d\u5355\u636e\u5c5e\u6027\u3002", (String)"GetNotBotpSourcePropPlugin_0", (String)"fi-ai-common", (Object[])new Object[0]));
            return Boolean.FALSE;
        }
        Object sourceEntity = this.getModel().getValue(SourceEntityName);
        if (sourceEntity == null) {
            msgBuilder.append(ResManager.loadKDString((String)"\u8bf7\u9009\u62e9\u6e90\u5355\u7c7b\u578b\u3002", (String)"GetNotBotpSourcePropPlugin_1", (String)"fi-ai-common", (Object[])new Object[0]));
            return Boolean.FALSE;
        }
        Object relatpropertyname = this.getModel().getValue(RelationPropertyName);
        if (relatpropertyname == null) {
            msgBuilder.append(ResManager.loadKDString((String)"\u8bf7\u9009\u62e9\u672c\u5355\u4e0e\u6e90\u5355\u5173\u8054\u5c5e\u6027\u3002", (String)"GetNotBotpSourcePropPlugin_2", (String)"fi-ai-common", (Object[])new Object[0]));
            return Boolean.FALSE;
        }
        String propertyname = (String)this.getModel().getValue(SourcePropertyName);
        if (StringUtils.isBlank((CharSequence)propertyname)) {
            msgBuilder.append(this.getSourcePropertyValidateMsg());
            return Boolean.FALSE;
        }
        return Boolean.TRUE;
    }

    protected String getSourcePropertyValidateMsg() {
        return ResManager.loadKDString((String)"\u8bf7\u9009\u62e9\u6e90\u5355\u5c5e\u6027\u3002", (String)"GetNotBotpSourcePropPlugin_3", (String)"fi-ai-common", (Object[])new Object[0]);
    }
}

