/*
 * Decompiled with CFR 0.152.
 */
package kd.fi.ai.function;

import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.stream.Collectors;
import kd.bos.algo.DataSet;
import kd.bos.algo.Row;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.entity.DynamicObjectCollection;
import kd.bos.entity.formula.ExpressionContext;
import kd.bos.entity.function.BOSUDFunction;
import kd.bos.orm.query.QFilter;
import kd.bos.servicehelper.QueryServiceHelper;
import kd.bos.util.StringUtils;
import kd.fi.ai.function.Function;
import kd.fi.ai.function.GetSourceBillPropertyValue;

public class GetSourceBillVCPropertyValue
extends GetSourceBillPropertyValue {
    public GetSourceBillVCPropertyValue() {
    }

    public GetSourceBillVCPropertyValue(ExpressionContext expContext) {
        super(expContext);
    }

    @Override
    public BOSUDFunction getInstance(ExpressionContext expContext) {
        return new GetSourceBillVCPropertyValue(expContext);
    }

    @Override
    public String getName() {
        return "GetSourceBillVCPropertyValue";
    }

    @Override
    protected Object queryResult(Object id, String entityName, String select, Object ... arg) {
        DynamicObjectCollection daps;
        Object bookTypeId = arg[5];
        int rownum = (Integer)arg[6];
        String entrydc = null;
        if (arg.length > 7) {
            entrydc = (String)arg[7];
        }
        if ((daps = QueryServiceHelper.query((String)"ai_daptracker", (String)"voucherid", (QFilter[])new QFilter[]{new QFilter("sourcebillid", "=", id), new QFilter("booktype", "=", bookTypeId)})).size() > 0) {
            Object voucherId = ((DynamicObject)daps.get(0)).get("voucherId");
            ArrayList<QFilter> filterList = new ArrayList<QFilter>(10);
            filterList.add(new QFilter("id", "=", voucherId));
            if (rownum > 0) {
                filterList.add(new QFilter("entries.seq", "=", (Object)rownum));
            }
            if (entrydc != null) {
                filterList.add(new QFilter("entries.entrydc", "=", (Object)entrydc));
            }
            String vchAcctId = "entries.account.id";
            String vchAcct = "entries.account";
            DynamicObject voucherObj = null;
            if (vchAcct.equals(select) || vchAcctId.equals(select)) {
                select = vchAcct + ", entries.assgrp";
                voucherObj = QueryServiceHelper.queryOne((String)"gl_voucher", (String)select, (QFilter[])filterList.toArray(new QFilter[0]));
                Object[] value = new Object[]{voucherObj.get(vchAcct), voucherObj.get("entries.assgrp")};
                return value;
            }
            voucherObj = QueryServiceHelper.queryOne((String)"gl_voucher", (String)select, (QFilter[])filterList.toArray(new QFilter[0]));
            return voucherObj.get(select);
        }
        return null;
    }

    @Override
    protected Map<Function, Object> queryBatchResult(Map<Object, Collection<Long>> billRelation, Map<String, Function> functionMap, String key) {
        HashMap<Function, Object> result = new HashMap<Function, Object>(100);
        String[] keyvalues = key.split("\\@");
        String select = keyvalues[2];
        String bookTypeId = keyvalues[4];
        int rownum = 0;
        if (!StringUtils.isEmpty((String)keyvalues[5])) {
            rownum = Integer.parseInt(keyvalues[5] + "");
        }
        String entrydc = null;
        if (keyvalues.length > 6) {
            entrydc = keyvalues[6];
        }
        List sourceBillIds = billRelation.values().stream().flatMap(Collection::stream).collect(Collectors.toList());
        HashMap<Long, Long> sourcebillAndVoucher = new HashMap<Long, Long>();
        DataSet dapDataSet = QueryServiceHelper.queryDataSet((String)"kd.fi.ai.function.GetSourceBillVCPropertyValue.queryBatchResult1", (String)"ai_daptracker", (String)"sourcebillid,voucherid", (QFilter[])new QFilter[]{new QFilter("sourcebillid", "in", sourceBillIds), new QFilter("booktype", "=", (Object)Long.parseLong(bookTypeId + "")), new QFilter("billtype", "=", (Object)keyvalues[1])}, null);
        for (Row row : dapDataSet) {
            sourcebillAndVoucher.put(row.getLong("sourcebillid"), row.getLong("voucherid"));
        }
        HashMap<Long, Object> voucheridAndResult = new HashMap<Long, Object>();
        if (sourcebillAndVoucher.size() > 0) {
            ArrayList<QFilter> filterList = new ArrayList<QFilter>(10);
            filterList.add(new QFilter("id", "in", sourcebillAndVoucher.values()));
            if (rownum > 0) {
                filterList.add(new QFilter("entries.seq", "=", (Object)rownum));
            }
            if (entrydc != null) {
                filterList.add(new QFilter("entries.entrydc", "=", (Object)entrydc));
            }
            String vchAcctId = "entries.account.id";
            String string = "entries.account";
            if (string.equals(select) || vchAcctId.equals(select)) {
                select = string + ", entries.assgrp";
            }
            boolean isMultiValue = select.contains(",");
            String selectField = select;
            if (!select.equals("id")) {
                selectField = "id," + select;
            }
            DataSet voucherDataSet = QueryServiceHelper.queryDataSet((String)"kd.fi.ai.function.GetSourceBillVCPropertyValue.queryBatchResult1", (String)"gl_voucher", (String)selectField, (QFilter[])filterList.toArray(new QFilter[0]), null);
            for (Row row : voucherDataSet) {
                Long voucherId = row.getLong("id");
                if (isMultiValue) {
                    Object[] values = new Object[]{row.get(string), row.get("entries.assgrp")};
                    voucheridAndResult.put(voucherId, values);
                    continue;
                }
                voucheridAndResult.put(voucherId, row.get(select));
            }
        }
        HashMap<Long, Long> targetBillAndSrcBillMap = new HashMap<Long, Long>();
        for (Map.Entry<Object, Collection<Long>> entry : billRelation.entrySet()) {
            Long targetBillid = Long.parseLong(entry.getKey() + "");
            Collection<Long> srcBillIds = entry.getValue();
            if (srcBillIds == null || srcBillIds.isEmpty()) continue;
            targetBillAndSrcBillMap.put(targetBillid, srcBillIds.iterator().next());
        }
        for (Map.Entry<Object, Collection<Long>> entry : functionMap.entrySet()) {
            String[] arg = ((String)entry.getKey()).split("\\@");
            Long id = Long.parseLong(arg[arg.length - 1]);
            Long srcBillId = (Long)targetBillAndSrcBillMap.get(id);
            if (!((String)entry.getKey()).startsWith(key)) continue;
            result.put((Function)entry.getValue(), voucheridAndResult.get(sourcebillAndVoucher.get(srcBillId)));
        }
        return result;
    }
}

