/*
 * Decompiled with CFR 0.152.
 */
package kd.fi.ai.function;

import java.sql.ResultSet;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Set;
import kd.bos.botp.ConvertDataService;
import kd.bos.dataentity.SqlParameter;
import kd.bos.dataentity.metadata.IDataEntityType;
import kd.bos.dataentity.utils.OrmUtils;
import kd.bos.dataentity.utils.StringUtils;
import kd.bos.db.DB;
import kd.bos.db.DBRoute;
import kd.bos.db.ResultSetHandler;
import kd.bos.entity.botp.runtime.TableDefine;
import kd.bos.entity.formula.ExpressionContext;
import kd.bos.entity.function.BOSUDFunction;
import kd.bos.service.botp.track.bizentity.BillTracker;
import kd.fi.ai.function.Function;
import kd.fi.ai.function.IBatchFunctionHandler;

public class GetSourceEntityKey
implements BOSUDFunction,
IBatchFunctionHandler {
    private ExpressionContext expContext;

    public GetSourceEntityKey() {
    }

    public GetSourceEntityKey(ExpressionContext expContext) {
        this.expContext = expContext;
    }

    public BOSUDFunction getInstance(ExpressionContext expContext) {
        return new GetSourceEntityKey(expContext);
    }

    public Object call(Object ... arg) {
        String currentEntityName = (String)arg[0];
        long currentBillId = Long.parseLong(arg[1].toString());
        ConvertDataService tableService = new ConvertDataService();
        TableDefine currentTable = tableService.loadTableDefine(currentEntityName, currentEntityName);
        IDataEntityType bilTrackerType = OrmUtils.getDataEntityType(BillTracker.class);
        StringBuilder sBuilder = new StringBuilder();
        ArrayList<SqlParameter> params = new ArrayList<SqlParameter>();
        sBuilder.append("SELECT FSTableId ");
        sBuilder.append("FROM  T_BOTP_BillTracker ");
        sBuilder.append("WHERE FTTableId = ? ");
        params.add(new SqlParameter(":FTTableId", -5, (Object)currentTable.getTableId()));
        sBuilder.append("AND FTBillId = ? ");
        params.add(new SqlParameter(":FTBillId", -5, (Object)currentBillId));
        ResultSetHandler<Long> action = new ResultSetHandler<Long>(){

            public Long handle(ResultSet rs) throws Exception {
                Long sid = 0L;
                if (rs.next()) {
                    sid = (Long)rs.getObject(1);
                }
                return sid;
            }
        };
        Long sid = (Long)DB.query((DBRoute)new DBRoute(bilTrackerType.getDBRouteKey()), (String)sBuilder.toString(), (Object[])params.toArray(new SqlParameter[params.size()]), (ResultSetHandler)action);
        if (sid != 0L) {
            TableDefine sourceTable = tableService.loadTableDefine(sid);
            return sourceTable.getEntityNumber();
        }
        return null;
    }

    public String getName() {
        return "GetSourceEntityKey";
    }

    public ExpressionContext getExpContext() {
        return this.expContext;
    }

    public Map<Function, Object> execute(Set<Function> args) {
        HashMap<Long, Function> tempMap = new HashMap<Long, Function>(args.size());
        HashMap<Function, Object> resultMap = new HashMap<Function, Object>(args.size());
        ArrayList FTTableIds = new ArrayList();
        ArrayList FTBillIds = new ArrayList();
        HashMap currentTableMap = new HashMap(args.size());
        HashMap currentTableMap2 = new HashMap(args.size());
        args.forEach(fun -> {
            List param = fun.getParams();
            String currentEntityName = (String)param.get(0);
            long currentBillId = Long.parseLong(param.get(1).toString());
            tempMap.put(currentBillId, (Function)fun);
            ConvertDataService tableService = new ConvertDataService();
            if (currentTableMap.containsKey(currentEntityName)) {
                FTTableIds.add(((TableDefine)currentTableMap.get(currentEntityName)).getTableId());
            } else {
                TableDefine currentTable = tableService.loadTableDefine(currentEntityName, currentEntityName);
                FTTableIds.add(currentTable.getTableId());
                currentTableMap.put(currentEntityName, currentTable);
            }
            FTBillIds.add(currentBillId);
        });
        String joinTableIds = StringUtils.join((Object[])FTTableIds.toArray(), (char)',');
        String joinBillIds = StringUtils.join((Object[])FTBillIds.toArray(), (char)',');
        IDataEntityType bilTrackerType = OrmUtils.getDataEntityType(BillTracker.class);
        ConvertDataService tableService = new ConvertDataService();
        Map idMap = (Map)DB.query((DBRoute)DBRoute.of((String)bilTrackerType.getDBRouteKey()), (String)("SELECT FTBillId,FSTableId  from T_BOTP_BillTracker where  FTTableId in  (" + joinTableIds + ") and  FTBillId in  (" + joinBillIds + ") "), (Object[])new Object[0], e -> {
            HashMap<Long, String> map = new HashMap<Long, String>(2);
            TableDefine sourceTable = new TableDefine();
            while (e.next()) {
                if (currentTableMap.containsKey(e.getLong("FSTableId"))) {
                    sourceTable = (TableDefine)currentTableMap2.get(e.getLong("FSTableId"));
                } else {
                    sourceTable = tableService.loadTableDefine(Long.valueOf(e.getLong("FSTableId")));
                    currentTableMap2.put(e.getLong("FSTableId"), sourceTable);
                }
                map.put(e.getLong("FTBillId"), sourceTable.getEntityNumber());
            }
            return map;
        });
        tempMap.forEach((key, value) -> resultMap.put((Function)value, idMap.get(key)));
        return resultMap;
    }
}

