/*
 * Decompiled with CFR 0.152.
 */
package kd.fi.ai.function;

import java.util.EventObject;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.metadata.IDataEntityType;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.dataentity.serialization.SerializationUtils;
import kd.bos.dataentity.utils.StringUtils;
import kd.bos.entity.MainEntityType;
import kd.bos.entity.tree.TreeNode;
import kd.bos.form.CloseCallBack;
import kd.bos.form.FormShowParameter;
import kd.bos.form.IFormView;
import kd.bos.form.ShowType;
import kd.bos.form.control.Control;
import kd.bos.form.events.ClosedCallBackEvent;
import kd.bos.form.func.AbstractFuncParamPlugIn;
import kd.bos.form.plugin.IFormPlugin;
import kd.bos.orm.query.QFilter;
import kd.bos.servicehelper.QueryServiceHelper;
import kd.fi.ai.ExpressionType;
import kd.fi.ai.util.DapUtil;
import kd.fi.ai.util.EntityFieldTreeOption;
import kd.fi.ai.util.EntityFieldTreeResult;
import kd.fi.ai.util.EntityTreeUtil;

public class GetSourceEntityKeyPlugIn
extends AbstractFuncParamPlugIn {
    private static final String CurrentEntityName = "currententityname";
    private static final String CurrentBillID = "currentbillid";

    public void initialize() {
        super.initialize();
        this.addClickListeners(new String[]{CurrentBillID});
    }

    public void afterBindData(EventObject e) {
        super.afterBindData(e);
    }

    public void afterCreateNewData(EventObject e) {
        DynamicObject one = QueryServiceHelper.queryOne((String)"bos_entityobject", (String)"id,number,name", (QFilter[])new QFilter[]{new QFilter("number", "=", (Object)this.getEntityNumber())});
        this.getModel().setValue(CurrentEntityName, one == null ? null : one.get("id"));
        this.getModel().setValue(CurrentBillID, (Object)"id");
    }

    public void click(EventObject evt) {
        super.click(evt);
        Control source = (Control)evt.getSource();
        if (StringUtils.equalsIgnoreCase((CharSequence)source.getKey(), (CharSequence)CurrentBillID)) {
            FormShowParameter showParameter = new FormShowParameter();
            showParameter.setFormId("botp_selectfield");
            MainEntityType mainType = DapUtil.getEntityTypeByNumber(this.getEntityNumber());
            EntityFieldTreeOption option = EntityFieldTreeOption.create();
            option.setEntityType((IDataEntityType)mainType);
            option.setReadEntryEntity(false);
            option.setExprType(ExpressionType.Condition);
            option.setIncludeID(true);
            EntityFieldTreeResult result = EntityTreeUtil.getEntityFieldNodes(option);
            TreeNode tree = EntityTreeUtil.buildBillTree(result.getNodes());
            String treeJson = SerializationUtils.toJsonString((Object)tree);
            showParameter.getCustomParams().put("treenodes", treeJson);
            showParameter.setCloseCallBack(new CloseCallBack((IFormPlugin)this, CurrentBillID));
            showParameter.getOpenStyle().setShowType(ShowType.Modal);
            this.getView().showForm(showParameter);
        }
    }

    public void closedCallBack(ClosedCallBackEvent closedCallBackEvent) {
        super.closedCallBack(closedCallBackEvent);
        if (closedCallBackEvent.getReturnData() == null) {
            return;
        }
        if (StringUtils.equalsIgnoreCase((CharSequence)closedCallBackEvent.getActionId(), (CharSequence)CurrentBillID)) {
            this.getModel().setValue(CurrentBillID, closedCallBackEvent.getReturnData());
        }
    }

    public Boolean checkSetting(StringBuilder msgBuilder) {
        String currentBillID = (String)this.getModel().getValue(CurrentBillID);
        if (StringUtils.isBlank((CharSequence)currentBillID)) {
            msgBuilder.append(ResManager.loadKDString((String)"\u8bf7\u9009\u62e9\u5f53\u524d\u5355\u636eID\u5c5e\u6027\u3002", (String)"GetSourceEntityKeyPlugIn_0", (String)"fi-ai-common", (Object[])new Object[0]));
            return Boolean.FALSE;
        }
        return Boolean.TRUE;
    }

    public String getSetting() {
        DynamicObject currentEntity = (DynamicObject)this.getModel().getValue(CurrentEntityName);
        String currentEntityName = currentEntity.getString("number");
        String currentBillID = (String)this.getModel().getValue(CurrentBillID);
        if (StringUtils.isBlank((CharSequence)currentBillID)) {
            currentBillID = "0";
        }
        String setting = String.format("%s('%s', %s)", this.getFuncId(), currentEntityName, currentBillID);
        return setting;
    }

    protected String getEntityNumber() {
        IFormView parentView = this.getView().getParentView();
        if (parentView == null) {
            return null;
        }
        Object entityNumber = parentView.getFormShowParameter().getCustomParam("entitynumber");
        if (entityNumber == null) {
            return null;
        }
        return String.valueOf(entityNumber);
    }
}

