/*
 * Decompiled with CFR 0.152.
 */
package kd.fi.ai.function;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.stream.Collectors;
import kd.bos.algo.DataSet;
import kd.bos.algo.Row;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.metadata.ISimpleProperty;
import kd.bos.dataentity.utils.StringUtils;
import kd.bos.db.DB;
import kd.bos.db.DBRoute;
import kd.bos.entity.EntityMetadataCache;
import kd.bos.entity.MainEntityType;
import kd.bos.entity.formula.ExpressionContext;
import kd.bos.entity.function.BOSUDFunction;
import kd.bos.logging.Log;
import kd.bos.logging.LogFactory;
import kd.bos.orm.query.QFilter;
import kd.bos.servicehelper.QueryServiceHelper;
import kd.fi.ai.function.Function;
import kd.fi.ai.function.IBatchFunctionHandler;

public class GetSubEntryVerticalAssData
implements BOSUDFunction,
IBatchFunctionHandler {
    private static final String NULL = "@null@";
    private static final Log log = LogFactory.getLog(GetSubEntryVerticalAssData.class);
    private ExpressionContext expContext;

    public GetSubEntryVerticalAssData() {
    }

    public GetSubEntryVerticalAssData(ExpressionContext expContext) {
        this.expContext = expContext;
    }

    public Object call(Object ... arg) {
        String assType = (String)arg[0];
        long mainEntryId = (Long)arg[1];
        String subEntryTable = (String)arg[2];
        String assTypeField = (String)arg[3];
        String assValueField = (String)arg[4];
        String baseEntity = (String)arg[5];
        String assTypeProp = null;
        if (arg.length > 6) {
            assTypeProp = (String)arg[6];
        }
        String sql = "select " + assValueField + " assvalue from " + subEntryTable + " where fentryid=? and " + assTypeField + " =? ";
        log.info("SQL:" + sql);
        log.info("baseEntity" + baseEntity);
        log.info("mainEntryId" + mainEntryId);
        log.info("assType" + assType);
        String entityNumber = assType;
        MainEntityType baseType = EntityMetadataCache.getDataEntityType((String)baseEntity);
        MainEntityType entityType = null;
        try {
            entityType = EntityMetadataCache.getDataEntityType((String)assType);
        }
        catch (Exception exception) {
            // empty catch block
        }
        if (entityType == null) {
            entityNumber = "bos_assistantdata_detail";
            entityType = EntityMetadataCache.getDataEntityType((String)entityNumber);
        }
        ISimpleProperty pkp = entityType.getPrimaryKey();
        Object id = DB.query((DBRoute)DBRoute.of((String)baseType.getDBRouteKey()), (String)sql, (Object[])new Object[]{mainEntryId, assType}, e -> {
            if (e.next()) {
                Object assvalue = e.getObject("assvalue");
                int dbType = pkp.getDbType();
                switch (dbType) {
                    case 12: {
                        return assvalue.toString();
                    }
                    case -5: {
                        if (assvalue instanceof Long) {
                            return assvalue;
                        }
                        return Long.parseLong(assvalue.toString());
                    }
                }
                return assvalue;
            }
            return null;
        });
        if (assTypeProp == null) {
            return id;
        }
        QFilter filter = new QFilter("id", "=", id);
        DynamicObject obj = QueryServiceHelper.queryOne((String)entityNumber, (String)assTypeProp, (QFilter[])filter.toArray());
        if (obj != null) {
            return obj.get(assTypeProp);
        }
        return null;
    }

    public String getName() {
        return "GetSubEntryVerticalAssData";
    }

    public BOSUDFunction getInstance(ExpressionContext expContext) {
        return new GetSubEntryVerticalAssData(expContext);
    }

    public Map<Function, Object> execute(Set<Function> args) {
        HashMap<String, Function> funCache = new HashMap<String, Function>(args.size());
        HashMap<String, Config> datas = new HashMap<String, Config>(2);
        for (Function fun : args) {
            List param = fun.getParams();
            String assType = (String)param.get(0);
            long mainEntryId = (Long)param.get(1);
            String subEntryTable = (String)param.get(2);
            String assTypeField = (String)param.get(3);
            String assValueField = (String)param.get(4);
            String baseEntity = (String)param.get(5);
            String assTypeProp = NULL;
            if (param.size() > 6) {
                assTypeProp = (String)param.get(6);
            }
            Config ft = datas.computeIfAbsent(baseEntity, key -> new Config(subEntryTable, assTypeField, assValueField));
            Set propMap = ft.getAssTypeMap().computeIfAbsent(assType, key -> new HashSet(2));
            propMap.add(assTypeProp);
            ft.getEnryIds().add(Long.toString(mainEntryId));
            funCache.put(assType + mainEntryId + subEntryTable + assTypeField + assValueField + baseEntity + assTypeProp, fun);
        }
        HashMap<Function, Object> rs = new HashMap<Function, Object>();
        HashMap<String, Object> typeReplaces = new HashMap<String, Object>();
        datas.forEach((baseEntity1, cfg) -> {
            Object join_id;
            MainEntityType baseType = EntityMetadataCache.getDataEntityType((String)baseEntity1);
            Map<String, MainEntityType> assEntityTypeMap = cfg.getAssTypeMap().keySet().stream().collect(Collectors.toMap(v -> v, v -> {
                String entityNumber = v;
                MainEntityType entityType = null;
                try {
                    entityType = EntityMetadataCache.getDataEntityType((String)entityNumber);
                }
                catch (Exception exception) {
                    // empty catch block
                }
                if (entityType == null) {
                    entityNumber = "bos_assistantdata_detail";
                    entityType = EntityMetadataCache.getDataEntityType((String)entityNumber);
                }
                return entityType;
            }));
            ArrayList<Map<String, Object>> queryDataCol = new ArrayList<Map<String, Object>>(cfg.getEnryIds().size());
            if (cfg.getEnryIds().size() >= 5000) {
                void var10_13;
                int i = cfg.getEnryIds().size() / 5000 + 1;
                boolean bl = false;
                while (var10_13 < i) {
                    int end;
                    int start = 5000 * var10_13;
                    int n = end = 5000 * (var10_13 + true) > cfg.getEnryIds().size() ? cfg.getEnryIds().size() : 5000 * (var10_13 + true);
                    if (start != end) {
                        List<String> idscol = cfg.getEnryIds().subList(start, end);
                        join_id = String.join((CharSequence)",", idscol);
                        List collect = cfg.getAssTypeMap().keySet().stream().map(v -> "'" + v + "'").collect(Collectors.toList());
                        String join_asstype = String.join((CharSequence)",", collect);
                        String sql = "select " + cfg.getAssTypeField() + " asstype," + cfg.getAssValueField() + " assvalue,fentryid from " + cfg.getSubEntryTable() + " where fentryid in (" + (String)join_id + ") and " + cfg.getAssTypeField() + " in (" + join_asstype + ")";
                        List<Map<String, Object>> batchQueryData = this.batchQueryData(baseType.getDBRouteKey(), sql);
                        queryDataCol.addAll(batchQueryData);
                    }
                    ++var10_13;
                }
            } else {
                String join_id2 = String.join((CharSequence)",", cfg.getEnryIds());
                List list = cfg.getAssTypeMap().keySet().stream().map(v -> "'" + v + "'").collect(Collectors.toList());
                String join_asstype = String.join((CharSequence)",", list);
                String sql = "select " + cfg.getAssTypeField() + " asstype," + cfg.getAssValueField() + " assvalue,fentryid from " + cfg.getSubEntryTable() + " where fentryid in (" + join_id2 + ") and " + cfg.getAssTypeField() + " in (" + join_asstype + ")";
                DataSet queryDataSet = DB.queryDataSet((String)"kd.fi.ai.function.GetSubEntryVerticalAssData", (DBRoute)DBRoute.of((String)baseType.getDBRouteKey()), (String)sql);
                join_id = null;
                try {
                    for (Row row : queryDataSet) {
                        HashMap<String, Object> valuem = new HashMap<String, Object>(3);
                        valuem.put("assvalue", row.get("assvalue"));
                        valuem.put("fentryid", row.get("fentryid"));
                        valuem.put("asstype", row.getString("asstype"));
                        queryDataCol.add(valuem);
                    }
                }
                catch (Throwable iterator) {
                    join_id = iterator;
                    throw iterator;
                }
                finally {
                    if (queryDataSet != null) {
                        if (join_id != null) {
                            try {
                                queryDataSet.close();
                            }
                            catch (Throwable iterator) {
                                ((Throwable)join_id).addSuppressed(iterator);
                            }
                        } else {
                            queryDataSet.close();
                        }
                    }
                }
            }
            if (!queryDataCol.isEmpty()) {
                for (Map map : queryDataCol) {
                    Object assid;
                    Object assvalue = map.get("assvalue");
                    Object fentryid = map.get("fentryid");
                    String assType1 = (String)map.get("asstype");
                    MainEntityType mainEntityType = assEntityTypeMap.get(assType1);
                    int dbType = mainEntityType.getPrimaryKey().getDbType();
                    switch (dbType) {
                        case 12: {
                            assid = assvalue.toString();
                            break;
                        }
                        case -5: {
                            if (assvalue instanceof Long) {
                                assid = assvalue;
                                break;
                            }
                            assid = Long.parseLong(assvalue.toString());
                            break;
                        }
                        default: {
                            assid = assvalue;
                        }
                    }
                    Set<String> props = cfg.getAssTypeMap().get(assType1);
                    for (String p : props) {
                        rs.put((Function)funCache.get(assType1 + fentryid + cfg.getSubEntryTable() + cfg.getAssTypeField() + cfg.getAssValueField() + baseEntity1 + p), this.getPropValue(p, assType1, assid, typeReplaces, mainEntityType.getName().equalsIgnoreCase("bos_assistantdata_detail")));
                    }
                }
            }
        });
        return this.replacePropValue(rs, typeReplaces);
    }

    private List<Map<String, Object>> batchQueryData(String rk, String sql) {
        ArrayList<Map<String, Object>> queryDataCol = new ArrayList<Map<String, Object>>(16);
        try (DataSet queryDataSet = DB.queryDataSet((String)"kd.fi.ai.function.GetSubEntryVerticalAssData", (DBRoute)DBRoute.of((String)rk), (String)sql);){
            for (Row row : queryDataSet) {
                HashMap<String, Object> valuem = new HashMap<String, Object>(3);
                valuem.put("assvalue", row.get("assvalue"));
                valuem.put("fentryid", row.get("fentryid"));
                valuem.put("asstype", row.getString("asstype"));
                queryDataCol.add(valuem);
            }
        }
        return queryDataCol;
    }

    private Object getPropValue(String assTypeProp, String baseEntryType, Object id, Map<String, Object> typeReplace, Boolean isnotbaseData) {
        if (isnotbaseData.booleanValue()) {
            baseEntryType = "bos_assistantdata_detail";
        }
        if (assTypeProp == null) {
            return baseEntryType + "-id-" + id;
        }
        HashMap bets = typeReplace.get(baseEntryType) == null ? new HashMap() : (HashMap)typeReplace.get(baseEntryType);
        ArrayList props = bets.get("Prop") == null ? new ArrayList() : (ArrayList)bets.get("Prop");
        ArrayList ids = bets.get("Ids") == null ? new ArrayList() : (ArrayList)bets.get("Ids");
        props.add(assTypeProp);
        bets.put("Prop", props);
        ids.add(id);
        bets.put("Ids", ids);
        typeReplace.put(baseEntryType, bets);
        return baseEntryType + "-" + assTypeProp + "-" + id;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private Map<Function, Object> replacePropValue(Map<Function, Object> rs, Map<String, Object> typeReplace) {
        HashMap<String, Object> result = new HashMap<String, Object>();
        HashMap<Function, Object> recol = new HashMap<Function, Object>(rs.size());
        HashSet<String> propcol = null;
        for (Map.Entry<String, Object> entry : typeReplace.entrySet()) {
            if (entry.getValue() == null) continue;
            Object ids = ((HashMap)entry.getValue()).get("Ids");
            Object props = ((HashMap)entry.getValue()).get("Prop");
            if (ids == null) continue;
            List idcol = (List)ids;
            idcol = idcol.stream().distinct().collect(Collectors.toList());
            propcol = props == null ? new HashSet<String>() : new HashSet((List)props);
            propcol.add("id");
            propcol = new HashSet(propcol);
            Boolean hasHistoryData = false;
            if (propcol.remove(NULL)) {
                hasHistoryData = true;
            }
            String selectFields = StringUtils.join((Object[])propcol.toArray(), (String)",");
            try (DataSet queryDataSet = QueryServiceHelper.queryDataSet((String)"kd.fi.ai.function.GetSubEntryVerticalAssData", (String)entry.getKey(), (String)selectFields, (QFilter[])new QFilter("id", "in", idcol).toArray(), null);){
                for (Row row : queryDataSet) {
                    Object id = row.get("id");
                    for (Object e : propcol) {
                        Object propFieldValue = row.get(e.toString());
                        String key = StringUtils.join((Object[])new String[]{entry.getKey(), e.toString(), id.toString()}, (String)"-");
                        result.put(key, propFieldValue);
                    }
                    if (!hasHistoryData.booleanValue()) continue;
                    String key = StringUtils.join((Object[])new String[]{entry.getKey(), NULL, id.toString()}, (String)"-");
                    result.put(key, id);
                }
            }
        }
        for (Map.Entry<String, Object> entry : rs.entrySet()) {
            recol.put((Function)entry.getKey(), result.get(entry.getValue()));
        }
        return recol;
    }

    private static class Config {
        private String subEntryTable;
        private String assTypeField;
        private String assValueField;
        private Map<String, Set<String>> assTypeMap = new HashMap<String, Set<String>>(4);
        private List<String> enryIds = new ArrayList<String>(128);

        public List<String> getEnryIds() {
            return this.enryIds;
        }

        public Config(String subEntryTable, String assTypeField, String assValueField) {
            this.subEntryTable = subEntryTable;
            this.assTypeField = assTypeField;
            this.assValueField = assValueField;
        }

        public String getSubEntryTable() {
            return this.subEntryTable;
        }

        public String getAssTypeField() {
            return this.assTypeField;
        }

        public String getAssValueField() {
            return this.assValueField;
        }

        public Map<String, Set<String>> getAssTypeMap() {
            return this.assTypeMap;
        }
    }
}

