/*
 * Decompiled with CFR 0.152.
 */
package kd.fi.ai.function;

import java.util.ArrayList;
import java.util.EventObject;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.entity.LocaleString;
import kd.bos.dataentity.metadata.IDataEntityProperty;
import kd.bos.dataentity.metadata.IDataEntityType;
import kd.bos.dataentity.metadata.clr.DataEntityPropertyCollection;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.dataentity.serialization.SerializationUtils;
import kd.bos.dataentity.utils.StringUtils;
import kd.bos.entity.EntityMetadataCache;
import kd.bos.entity.MainEntityType;
import kd.bos.entity.datamodel.events.ChangeData;
import kd.bos.entity.datamodel.events.PropertyChangedArgs;
import kd.bos.entity.property.EntryProp;
import kd.bos.entity.property.SubEntryProp;
import kd.bos.entity.tree.TreeNode;
import kd.bos.form.CloseCallBack;
import kd.bos.form.FormShowParameter;
import kd.bos.form.IFormView;
import kd.bos.form.ShowType;
import kd.bos.form.control.Control;
import kd.bos.form.events.ClosedCallBackEvent;
import kd.bos.form.field.ComboEdit;
import kd.bos.form.field.ComboItem;
import kd.bos.form.func.AbstractFuncParamPlugIn;
import kd.bos.form.plugin.IFormPlugin;
import kd.fi.ai.ExpressionType;
import kd.fi.ai.util.DapUtil;
import kd.fi.ai.util.EntityFieldTreeOption;
import kd.fi.ai.util.EntityFieldTreeResult;
import kd.fi.ai.util.EntityTreeUtil;

public class GetSubEntryVerticalAssDataPlugin
extends AbstractFuncParamPlugIn {
    private static final String ASSTYPEPROPERTY = "asstypeproperty";
    private static final String ASSVALUEFIELD = "assvaluefield";
    private static final String ASSTYPEFIELD = "asstypefield";
    private static final String SUBENTRYTABLE = "subentrytable";
    private static final String MAINENTRYID = "mainentryid";
    private static final String PROP_NAME = "PropName";
    private static final String SUB_ENTRY_FIELD_MAPPING = "SubEntryFieldMapping";
    private static final String ENTRY_SUB_MAPPING = "EntrySubMapping";
    public static final String ASSTYPE_KEY = "asstypekey";

    public void afterCreateNewData(EventObject e) {
        Long assTypeKey = this.getAssTypeKey();
        if (assTypeKey != 0L) {
            this.getModel().setValue("asstype", (Object)assTypeKey);
        }
        MainEntityType entityType = DapUtil.getEntityTypeByNumber(this.getEntityNumber());
        DataEntityPropertyCollection pops = entityType.getProperties();
        HashMap<String, String> propName = new HashMap<String, String>();
        HashMap<String, ArrayList<String>> entrySubEntry = new HashMap<String, ArrayList<String>>();
        HashMap subFieldMap = new HashMap();
        for (Object p : pops) {
            if (!(p instanceof EntryProp)) continue;
            propName.put(p.getName(), p.getDisplayName().toString());
            IDataEntityType entryEntityType = ((EntryProp)p).getItemType();
            for (IDataEntityProperty ep : entryEntityType.getProperties()) {
                if (!(ep instanceof SubEntryProp)) continue;
                IDataEntityType subEntryEntityType = ((SubEntryProp)ep).getItemType();
                String subEntryKey = subEntryEntityType.getAlias();
                propName.put(subEntryKey, ep.getDisplayName().toString());
                ArrayList<String> subs = (ArrayList<String>)entrySubEntry.get(p.getName());
                if (subs == null) {
                    subs = new ArrayList<String>();
                    entrySubEntry.put(p.getName(), subs);
                }
                subs.add(subEntryKey);
                ArrayList<String> subFields = new ArrayList<String>();
                subFieldMap.put(subEntryKey, subFields);
                for (IDataEntityProperty sep : subEntryEntityType.getProperties()) {
                    if (sep.getDisplayName() == null) continue;
                    propName.put(sep.getAlias(), sep.getDisplayName().toString());
                    subFields.add(sep.getAlias());
                }
            }
        }
        this.getPageCache().put(PROP_NAME, SerializationUtils.toJsonString(propName));
        this.getPageCache().put(ENTRY_SUB_MAPPING, SerializationUtils.toJsonString(entrySubEntry));
        this.getPageCache().put(SUB_ENTRY_FIELD_MAPPING, SerializationUtils.toJsonString(subFieldMap));
        ArrayList<ComboItem> entryItems = new ArrayList<ComboItem>(entrySubEntry.size());
        for (String entryKey : entrySubEntry.keySet()) {
            ComboItem item = new ComboItem();
            item.setValue(entryKey);
            item.setCaption(new LocaleString((String)propName.get(entryKey)));
            entryItems.add(item);
        }
        ComboEdit mainentryidEditor = (ComboEdit)this.getView().getControl(MAINENTRYID);
        mainentryidEditor.setComboItems(entryItems);
        if (entryItems.size() > 0) {
            this.getModel().setValue(MAINENTRYID, (Object)((ComboItem)entryItems.get(0)).getValue());
            this.initSubEntryCombo(((ComboItem)entryItems.get(0)).getValue());
        }
    }

    public void registerListener(EventObject e) {
        super.registerListener(e);
        this.addClickListeners(new String[]{ASSTYPEPROPERTY});
    }

    public void propertyChanged(PropertyChangedArgs e) {
        super.propertyChanged(e);
        ChangeData data = e.getChangeSet()[0];
        String propName = e.getProperty().getName();
        if (propName.equalsIgnoreCase(MAINENTRYID)) {
            this.initSubEntryCombo(data.getNewValue().toString());
        } else if (propName.equalsIgnoreCase(SUBENTRYTABLE)) {
            this.initAssFieldCombo(data.getNewValue().toString());
        }
    }

    public void closedCallBack(ClosedCallBackEvent e) {
        super.closedCallBack(e);
        String actionId = e.getActionId();
        Object returnData = e.getReturnData();
        if (returnData == null) {
            return;
        }
        switch (actionId) {
            case "asstypeproperty": {
                this.getModel().setValue(ASSTYPEPROPERTY, returnData);
                break;
            }
        }
    }

    private void initSubEntryCombo(String entryKey) {
        ComboEdit subentrytableEditor = (ComboEdit)this.getView().getControl(SUBENTRYTABLE);
        if (StringUtils.isBlank((CharSequence)entryKey)) {
            subentrytableEditor.setComboItems(null);
            this.initAssFieldCombo(null);
            return;
        }
        String entrySubMapStr = this.getPageCache().get(ENTRY_SUB_MAPPING);
        if (StringUtils.isNotBlank((CharSequence)entrySubMapStr)) {
            Map propNames = (Map)SerializationUtils.fromJsonString((String)this.getPageCache().get(PROP_NAME), Map.class);
            Map entrySubEntry = (Map)SerializationUtils.fromJsonString((String)entrySubMapStr, Map.class);
            List subEntrys = (List)entrySubEntry.get(entryKey);
            ArrayList<ComboItem> subEntryItems = new ArrayList<ComboItem>(subEntrys.size());
            for (String subEntryKey : subEntrys) {
                ComboItem item = new ComboItem();
                item.setValue(subEntryKey);
                item.setCaption(new LocaleString((String)propNames.get(subEntryKey)));
                subEntryItems.add(item);
            }
            subentrytableEditor.setComboItems(subEntryItems);
            if (subEntryItems.size() > 0) {
                this.getModel().setValue(SUBENTRYTABLE, (Object)((ComboItem)subEntryItems.get(0)).getValue());
                this.initAssFieldCombo(((ComboItem)subEntryItems.get(0)).getValue());
            }
        } else {
            subentrytableEditor.setComboItems(null);
        }
    }

    public void click(EventObject evt) {
        super.click(evt);
        Control source = (Control)evt.getSource();
        if (StringUtils.equalsIgnoreCase((CharSequence)source.getKey(), (CharSequence)ASSTYPEPROPERTY)) {
            FormShowParameter showParameter = new FormShowParameter();
            showParameter.setFormId("botp_selectfield");
            MainEntityType mainType = this.getAssTypeEntityType();
            if (mainType != null) {
                EntityFieldTreeResult result = this.getEntityFieldTreeResult(mainType);
                TreeNode tree = EntityTreeUtil.buildBillTree(result.getNodes());
                String treeJson = SerializationUtils.toJsonString((Object)tree);
                showParameter.getCustomParams().put("treenodes", treeJson);
                showParameter.setCloseCallBack(new CloseCallBack((IFormPlugin)this, ASSTYPEPROPERTY));
                showParameter.getOpenStyle().setShowType(ShowType.Modal);
                this.getView().showForm(showParameter);
            }
        }
    }

    private EntityFieldTreeResult getEntityFieldTreeResult(MainEntityType mainType) {
        EntityFieldTreeOption option = EntityFieldTreeOption.create();
        option.setEntityType((IDataEntityType)mainType);
        option.setReadEntryEntity(this.readEntryProp());
        option.setExprType(ExpressionType.Condition);
        option.setIncludeID(true);
        EntityFieldTreeResult result = EntityTreeUtil.getEntityFieldNodes(option);
        return result;
    }

    protected boolean readEntryProp() {
        return false;
    }

    private MainEntityType getAssTypeEntityType() {
        DynamicObject assType = (DynamicObject)this.getModel().getValue("asstype");
        if (assType != null) {
            String entityNumber = null;
            String valueType = assType.getString("valuetype");
            if ("1".equals(valueType)) {
                entityNumber = assType.getString("valuesource.number");
            } else if ("2".equals(valueType)) {
                entityNumber = "bos_assistantdata_detail";
            }
            if (entityNumber != null) {
                return EntityMetadataCache.getDataEntityType((String)entityNumber);
            }
        }
        return null;
    }

    private void initAssFieldCombo(String subEntryKey) {
        String fieldStr = this.getPageCache().get(SUB_ENTRY_FIELD_MAPPING);
        ComboEdit asstypefieldEditor = (ComboEdit)this.getView().getControl(ASSTYPEFIELD);
        ComboEdit assvaluefieldEditor = (ComboEdit)this.getView().getControl(ASSVALUEFIELD);
        if (StringUtils.isBlank((CharSequence)subEntryKey)) {
            asstypefieldEditor.setComboItems(null);
            assvaluefieldEditor.setComboItems(null);
            return;
        }
        if (StringUtils.isNotBlank((CharSequence)fieldStr)) {
            Map subFieldMap = (Map)SerializationUtils.fromJsonString((String)fieldStr, Map.class);
            Map propNames = (Map)SerializationUtils.fromJsonString((String)this.getPageCache().get(PROP_NAME), Map.class);
            List fields = (List)subFieldMap.get(subEntryKey);
            ArrayList<ComboItem> fieldItems = new ArrayList<ComboItem>(fields.size());
            for (String field : fields) {
                ComboItem item = new ComboItem();
                item.setValue(field);
                item.setCaption(new LocaleString((String)propNames.get(field)));
                fieldItems.add(item);
            }
            asstypefieldEditor.setComboItems(fieldItems);
            assvaluefieldEditor.setComboItems(fieldItems);
        } else {
            asstypefieldEditor.setComboItems(null);
            assvaluefieldEditor.setComboItems(null);
        }
    }

    public Boolean checkSetting(StringBuilder msgBuilder) {
        DynamicObject assTypeObj = (DynamicObject)this.getModel().getValue("asstype");
        if (assTypeObj == null) {
            msgBuilder.append(ResManager.loadKDString((String)"\u8bf7\u9009\u62e9\u6838\u7b97\u7ef4\u5ea6\u3002", (String)"GetSubEntryVerticalAssDataPlugin_0", (String)"fi-ai-common", (Object[])new Object[0]));
            return Boolean.FALSE;
        }
        String mainentryid = (String)this.getModel().getValue(MAINENTRYID);
        if (StringUtils.isBlank((CharSequence)mainentryid)) {
            msgBuilder.append(ResManager.loadKDString((String)"\u8bf7\u9009\u62e9\u4e3b\u5206\u5f55\u3002", (String)"GetSubEntryVerticalAssDataPlugin_1", (String)"fi-ai-common", (Object[])new Object[0]));
            return Boolean.FALSE;
        }
        String subentrytable = (String)this.getModel().getValue(SUBENTRYTABLE);
        if (StringUtils.isBlank((CharSequence)subentrytable)) {
            msgBuilder.append(ResManager.loadKDString((String)"\u8bf7\u9009\u62e9\u5b50\u5206\u5f55\u3002", (String)"GetSubEntryVerticalAssDataPlugin_2", (String)"fi-ai-common", (Object[])new Object[0]));
            return Boolean.FALSE;
        }
        String assTypeField = (String)this.getModel().getValue(ASSTYPEFIELD);
        if (StringUtils.isBlank((CharSequence)assTypeField)) {
            msgBuilder.append(ResManager.loadKDString((String)"\u8bf7\u9009\u62e9\u6838\u7b97\u7ef4\u5ea6\u5217\u3002", (String)"GetSubEntryVerticalAssDataPlugin_3", (String)"fi-ai-common", (Object[])new Object[0]));
            return Boolean.FALSE;
        }
        String assValueField = (String)this.getModel().getValue(ASSVALUEFIELD);
        if (StringUtils.isBlank((CharSequence)assValueField)) {
            msgBuilder.append(ResManager.loadKDString((String)"\u8bf7\u9009\u62e9\u6838\u7b97\u7ef4\u5ea6\u503c\u5217\u3002", (String)"GetSubEntryVerticalAssDataPlugin_4", (String)"fi-ai-common", (Object[])new Object[0]));
            return Boolean.FALSE;
        }
        return Boolean.TRUE;
    }

    public String getSetting() {
        DynamicObject assTypeObj = (DynamicObject)this.getModel().getValue("asstype");
        String mainentryid = (String)this.getModel().getValue(MAINENTRYID);
        String subentrytable = (String)this.getModel().getValue(SUBENTRYTABLE);
        String assTypeField = (String)this.getModel().getValue(ASSTYPEFIELD);
        String assValueField = (String)this.getModel().getValue(ASSVALUEFIELD);
        String assTypeProperty = (String)this.getModel().getValue(ASSTYPEPROPERTY);
        assTypeProperty = StringUtils.isEmpty((CharSequence)assTypeProperty) ? "id" : assTypeProperty;
        String entityKey = null;
        String valueType = assTypeObj.getString("valuetype");
        if ("1".equals(valueType)) {
            entityKey = assTypeObj.getString("valuesource.number");
        } else if ("2".equals(valueType)) {
            entityKey = assTypeObj.getString("assistanttype.id");
        }
        String setting = String.format("%s('%s', %s, '%s', '%s', '%s', '%s', '%s')", this.getFuncId(), entityKey, mainentryid + ".id", subentrytable, assTypeField, assValueField, this.getEntityNumber(), assTypeProperty);
        return setting;
    }

    protected String getEntityNumber() {
        IFormView parentView = this.getView().getParentView();
        if (parentView == null) {
            return null;
        }
        Object entityNumber = parentView.getFormShowParameter().getCustomParam("entitynumber");
        if (entityNumber == null) {
            return null;
        }
        return String.valueOf(entityNumber);
    }

    protected Long getAssTypeKey() {
        IFormView parentView = this.getView().getParentView();
        if (parentView == null) {
            return 0L;
        }
        if ((parentView = parentView.getParentView()) == null) {
            return 0L;
        }
        Object assTypeKey = parentView.getFormShowParameter().getCustomParam(ASSTYPE_KEY);
        if (assTypeKey == null) {
            return 0L;
        }
        return (Long)assTypeKey;
    }
}

