/*
 * Decompiled with CFR 0.152.
 */
package kd.fi.ai.mservice.builder.buildresult;

import java.math.BigDecimal;
import java.util.ArrayList;
import java.util.Date;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Set;
import kd.bos.cache.ThreadCache;
import kd.bos.dataentity.entity.CollectionPropertyAttribute;
import kd.bos.dataentity.entity.DataEntityTypeAttribute;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.entity.DynamicObjectCollection;
import kd.bos.dataentity.entity.SimplePropertyAttribute;
import kd.bos.dataentity.metadata.IDataEntityProperty;
import kd.bos.dataentity.metadata.dynamicobject.DynamicObjectType;
import kd.bos.dataentity.metadata.dynamicobject.DynamicSimpleProperty;
import kd.bos.entity.EntryType;
import kd.bos.entity.property.BigIntProp;
import kd.bos.entity.property.EntryProp;
import kd.bos.logging.Log;
import kd.bos.logging.LogFactory;
import kd.bos.orm.ORM;
import kd.bos.servicehelper.BusinessDataServiceHelper;
import kd.fi.ai.ComAssistData;
import kd.fi.ai.VoucherSource;
import kd.fi.ai.VoucherType;
import kd.fi.ai.builder.GLVoucherUnionType;
import kd.fi.ai.builder.ISingleTaskContext;
import kd.fi.ai.mservice.builder.buildresult.GLVoucherEntry;
import kd.fi.ai.mservice.builder.buildresult.GLVoucherGroupKey;
import kd.fi.ai.mservice.builder.buildresult.IVoucher;
import kd.fi.ai.mservice.dao.BaseDataLoader;
import kd.fi.ai.util.BigdecimalUtil;
import kd.fi.ai.util.GLUtil;
import kd.fi.ai.util.SetExpandFieldValueUtil;

@DataEntityTypeAttribute(tableName="T_GL_VOUCHER", dbRouteKey="gl")
public class GLVoucher
implements IVoucher<GLVoucherEntry> {
    private static Log logger = LogFactory.getLog(GLVoucher.class);
    private long id;
    private String tmpGuid;
    private String number;
    private long bookId;
    private long booktypeId;
    private long orgId;
    private long periodId;
    private long vchTypeId;
    private long localcur;
    private String billStatus;
    private String description;
    private String vdescription;
    private Date bizDate;
    private Date bookedDate;
    private Long creatorId;
    private Date createTime;
    private Long modifierId;
    private Date modifyTime;
    private String templateId;
    private String sourceType;
    private String sourceSys;
    private String sourceBill;
    private long sourceBillId;
    private String sourceBillNo;
    private BigDecimal debitlocamount = BigDecimal.ZERO;
    private BigDecimal creditlocamount = BigDecimal.ZERO;
    private BigDecimal debitlocamount_saved = BigDecimal.ZERO;
    private BigDecimal creditlocamount_saved = BigDecimal.ZERO;
    private int attachment;
    private String attachmentType;
    private List<GLVoucherEntry> entryRows = new ArrayList<GLVoucherEntry>();
    private GLVoucherGroupKey groupKey;
    private GLVoucherUnionType unionType = GLVoucherUnionType.Single;
    private Long bookCyId;
    private Long cashier;
    private String checkstatus;
    private Boolean issubmit = false;
    private Map<String, Object> expandFieldValue = new HashMap<String, Object>(16);
    private boolean preSaveEntry = false;
    private boolean hasCashAcct = false;
    private boolean hasSyAcct = false;
    private boolean hasNcNpAcct = false;

    public boolean isPreSaveEntry() {
        return this.preSaveEntry;
    }

    public void setPreSaveEntry(boolean preSaveEntry) {
        this.preSaveEntry = preSaveEntry;
    }

    @Override
    @SimplePropertyAttribute(alias="FId", dbType=-5, isPrimaryKey=true)
    public long getId() {
        return this.id;
    }

    @Override
    public void setId(long id) {
        this.id = id;
    }

    @Override
    public String getTmpGuid() {
        return this.tmpGuid;
    }

    @Override
    public void setTmpGuid(String tmpGuid) {
        this.tmpGuid = tmpGuid;
    }

    @Override
    @SimplePropertyAttribute(alias="FNumber", dbType=12)
    public String getNumber() {
        return this.number;
    }

    @Override
    public void setNumber(String number) {
        this.number = number;
    }

    @Override
    @SimplePropertyAttribute(alias="FBookId", dbType=-5)
    public long getBookId() {
        return this.bookId;
    }

    @Override
    public void setBookId(long bookId) {
        this.bookId = bookId;
    }

    @SimplePropertyAttribute(alias="fbooktypeid", dbType=-5)
    public long getBookTypeId() {
        return this.booktypeId;
    }

    public void setBookTypeId(long booktypeId) {
        this.booktypeId = booktypeId;
    }

    @Override
    @SimplePropertyAttribute(alias="FOrgId", dbType=-5)
    public long getOrgId() {
        return this.orgId;
    }

    @Override
    public void setOrgId(long orgId) {
        this.orgId = orgId;
    }

    @Override
    @SimplePropertyAttribute(alias="FPeriodId", dbType=-5)
    public long getPeriodId() {
        return this.periodId;
    }

    @Override
    public void setPeriodId(long periodId) {
        this.periodId = periodId;
    }

    @Override
    @SimplePropertyAttribute(alias="FTypeId", dbType=-5)
    public long getVchTypeId() {
        return this.vchTypeId;
    }

    @Override
    public void setVchTypeId(long vchTypeId) {
        this.vchTypeId = vchTypeId;
    }

    @SimplePropertyAttribute(alias="FLoccurrency", dbType=-5)
    public long getLocalcur() {
        return this.localcur;
    }

    public void setLocalcur(long localcur) {
        this.localcur = localcur;
    }

    @SimplePropertyAttribute(alias="FBillStatus", dbType=1)
    public String getBillStatus() {
        return this.billStatus;
    }

    public void setBillStatus(String billStatus) {
        this.billStatus = billStatus;
    }

    @Override
    @SimplePropertyAttribute(alias="FDescription", dbType=-9)
    public String getDescription() {
        return this.description;
    }

    @Override
    public void setDescription(String description) {
        this.description = description;
    }

    @Override
    @SimplePropertyAttribute(alias="FBizDate", dbType=91)
    public Date getBizDate() {
        return this.bizDate;
    }

    @Override
    public void setBizDate(Date bizDate) {
        this.bizDate = bizDate;
    }

    @Override
    @SimplePropertyAttribute(alias="FBookedDate", dbType=91)
    public Date getBookedDate() {
        return this.bookedDate;
    }

    @Override
    public void setBookedDate(Date bookedDate) {
        this.bookedDate = bookedDate;
    }

    @SimplePropertyAttribute(alias="FCreatorId", dbType=-5)
    public Long getCreatorId() {
        return this.creatorId;
    }

    public void setCreatorId(Long creatorId) {
        this.creatorId = creatorId;
    }

    @SimplePropertyAttribute(alias="FCreateTime", dbType=91)
    public Date getCreateTime() {
        return this.createTime;
    }

    public void setCreateTime(Date createTime) {
        this.createTime = createTime;
    }

    @SimplePropertyAttribute(alias="FModifierId", dbType=-5)
    public Long getModifierId() {
        return this.modifierId;
    }

    public void setModifierId(Long modifierId) {
        this.modifierId = modifierId;
    }

    @SimplePropertyAttribute(alias="FModifyTime", dbType=91)
    public Date getModifyTime() {
        return this.modifyTime;
    }

    public void setModifyTime(Date modifyTime) {
        this.modifyTime = modifyTime;
    }

    @Override
    @SimplePropertyAttribute(alias="FSourceType", dbType=1)
    public String getSourceType() {
        return this.sourceType;
    }

    @Override
    public void setSourceType(String sourceType) {
        this.sourceType = sourceType;
    }

    @Override
    @SimplePropertyAttribute(alias="FSourceSys", dbType=12)
    public String getSourceSys() {
        return this.sourceSys;
    }

    @Override
    public void setSourceSys(String sourceSys) {
        this.sourceSys = sourceSys;
    }

    @Override
    @SimplePropertyAttribute(alias="FSourceBillType", dbType=12)
    public String getSourceBill() {
        return this.sourceBill;
    }

    @Override
    public void setSourceBill(String sourceBill) {
        this.sourceBill = sourceBill;
    }

    @Override
    @CollectionPropertyAttribute(collectionItemPropertyType=GLVoucherEntry.class)
    public List<GLVoucherEntry> getEntryRows() {
        return this.entryRows;
    }

    public void setEntryRows(List<GLVoucherEntry> entryRows) {
        this.entryRows = entryRows;
    }

    @Override
    public String getTemplateId() {
        return this.templateId;
    }

    public void setTemplateId(String templateId) {
        this.templateId = templateId;
    }

    @Override
    public String getTplGroupId() {
        return "";
    }

    public GLVoucherGroupKey getGroupKey() {
        return this.groupKey;
    }

    public void setGroupKey(GLVoucherGroupKey groupKey) {
        this.groupKey = groupKey;
    }

    @SimplePropertyAttribute(alias="FDEBITLOCAMOUNT", dbType=3)
    public BigDecimal getDebitlocamount() {
        return this.debitlocamount;
    }

    public void setDebitlocamount(BigDecimal debitlocamount) {
        this.debitlocamount = debitlocamount;
    }

    @SimplePropertyAttribute(alias="FCREDITLOCAMOUNT", dbType=3)
    public BigDecimal getCreditlocamount() {
        return this.creditlocamount;
    }

    public void setCreditlocamount(BigDecimal creditlocamount) {
        this.creditlocamount = creditlocamount;
    }

    @Override
    @SimplePropertyAttribute(alias="Fvdescription", dbType=-9)
    public String getVdescription() {
        List<GLVoucherEntry> entryRows = this.getEntryRows();
        if (!entryRows.isEmpty()) {
            this.vdescription = entryRows.get(0).getDescription();
        }
        return this.vdescription;
    }

    @Override
    public void setVdescription(String vdescription) {
        this.vdescription = vdescription;
    }

    @Override
    @SimplePropertyAttribute(alias="FATTACHMENTS", dbType=4)
    public int getAttachment() {
        return this.attachment;
    }

    @Override
    public void setAttachment(int attachment) {
        this.attachment = attachment;
    }

    @Override
    @SimplePropertyAttribute(alias="FCASHIERID", dbType=-5)
    public Long getCashier() {
        return this.cashier;
    }

    @Override
    public void setCashier(long cashier) {
        this.cashier = cashier;
    }

    @Override
    @SimplePropertyAttribute(alias="FISCHECK", dbType=1)
    public String getCheckstatus() {
        return this.checkstatus;
    }

    @Override
    public void setCheckstatus(String checkstatus) {
        this.checkstatus = checkstatus;
    }

    @Override
    public DynamicObject toDynamicObjectVoucher(ISingleTaskContext taskCtx) {
        return this.toDynamicObjectVoucher(taskCtx, "gl_voucher");
    }

    @Override
    public DynamicObject toDynamicObjectVoucher(ISingleTaskContext taskCtx, String entityName) {
        boolean isExDate;
        String key;
        Map<String, DynamicObject> dMap = taskCtx.getGlVoucherDoMap();
        if (dMap.containsKey(key = this.id + "-" + this.entryRows.size())) {
            return dMap.get(key);
        }
        ORM orm = ORM.create();
        DynamicObject voucher = null;
        DynamicObjectType newType = (DynamicObjectType)ThreadCache.get((Object)("DynamicObjectType_" + entityName), () -> {
            DynamicObjectType newType1 = null;
            try {
                DynamicObject voucher1 = orm.newDynamicObject(entityName);
                newType1 = (DynamicObjectType)voucher1.getDynamicObjectType().clone();
            }
            catch (Exception e1) {
                logger.error((Throwable)e1);
            }
            BigIntProp pid = new BigIntProp();
            pid.setAlias("fid");
            pid.setName("parentid");
            pid.setDefaultValue((Object)0L);
            if (newType1 != null) {
                EntryProp ep = (EntryProp)newType1.getProperty("entries");
                EntryType et = (EntryType)ep.getItemType();
                et.registerSimpleProperty((DynamicSimpleProperty)pid);
            }
            return newType1;
        });
        voucher = orm.newDynamicObject(newType);
        voucher.set("id", (Object)this.id);
        voucher.set("billno", (Object)this.number);
        voucher.set("book", (Object)taskCtx.getBookInfo().getBookInfo());
        voucher.set("booktype", (Object)BaseDataLoader.loadBooktype(taskCtx, this.booktypeId));
        voucher.set("org", (Object)BaseDataLoader.loadOrg(taskCtx, (Long)this.orgId));
        voucher.set("period", (Object)BaseDataLoader.loadPeriod(taskCtx, (Long)this.periodId));
        DynamicObject vtp = BusinessDataServiceHelper.newDynamicObject((String)"gl_vouchertype");
        VoucherType vt = BaseDataLoader.loadVchType(taskCtx.getBuildVchContext(), this.vchTypeId);
        vtp.set("id", (Object)vt.getId());
        vtp.set("name", (Object)vt.getName());
        vtp.set("number", (Object)vt.getNumber());
        voucher.set("vouchertype", (Object)vtp);
        DynamicObject localcur = orm.newDynamicObject("bd_currency");
        localcur.set("id", (Object)this.localcur);
        voucher.set("localcur", (Object)localcur);
        voucher.set("billstatus", (Object)this.billStatus);
        voucher.set("description", (Object)this.description);
        voucher.set("bizdate", (Object)this.bizDate);
        voucher.set("bookeddate", (Object)this.bookedDate);
        voucher.set("creator", (Object)this.creatorId);
        voucher.set("createtime", (Object)this.createTime);
        voucher.set("modifier", (Object)this.modifierId);
        voucher.set("modifytime", (Object)this.modifyTime);
        voucher.set("sourcetype", (Object)this.sourceType);
        DynamicObject sourcesys = orm.newDynamicObject("bos_devportal_bizapp");
        VoucherSource voucherSource = BaseDataLoader.loadVchSource(taskCtx.getBuildVchContext(), this.sourceSys);
        sourcesys.set("id", (Object)this.sourceSys);
        sourcesys.set("number", (Object)voucherSource.getNumber());
        voucher.set("sourcesys", (Object)sourcesys);
        voucher.set("sourcebilltype", (Object)this.sourceBill);
        voucher.set("debitlocamount", (Object)this.debitlocamount);
        voucher.set("creditlocamount", (Object)this.creditlocamount);
        voucher.set("vdescription", (Object)this.vdescription);
        voucher.set("attachment", (Object)this.attachment);
        voucher.set("sourcebill", (Object)this.sourceBillId);
        voucher.set("cashier_id", (Object)this.cashier);
        voucher.set("ischeck", (Object)this.checkstatus);
        SetExpandFieldValueUtil.setExpandFieldValue(voucher, this.expandFieldValue, this.orgId);
        IDataEntityProperty property = (IDataEntityProperty)voucher.getDataEntityType().getProperties().get((Object)"exratedate");
        boolean bl = isExDate = property != null;
        if (this.entryRows.isEmpty()) {
            return voucher;
        }
        DynamicObjectCollection entries = voucher.getDynamicObjectCollection("entries");
        DynamicObjectType entryType = entries.getDynamicObjectType();
        block4: for (GLVoucherEntry entry : this.entryRows) {
            switch (taskCtx.getZeroAmountGenEntryParam()) {
                case ALWAYS_NOT_GENERATE: {
                    if (!BigdecimalUtil.isEquals(entry.getLocalDebit(), BigDecimal.ZERO) || !BigdecimalUtil.isEquals(entry.getLocalCredit(), BigDecimal.ZERO)) break;
                    continue block4;
                }
                case ZERO_AMOUNT_NON_ZERO_QUANTITY: {
                    if (!BigdecimalUtil.isEquals(entry.getQty(), BigDecimal.ZERO) || !BigdecimalUtil.isEquals(entry.getLocalDebit(), BigDecimal.ZERO) || !BigdecimalUtil.isEquals(entry.getLocalCredit(), BigDecimal.ZERO)) break;
                    continue block4;
                }
            }
            DynamicObject entryDo = (DynamicObject)entryType.createInstance();
            entryDo.set("id", (Object)entry.getEntryId());
            if (entry.getAccountId() != 0L) {
                HashMap<Long, DynamicObject> acache = (HashMap<Long, DynamicObject>)ThreadCache.get((Object)"bd_accountview");
                if (acache == null) {
                    acache = new HashMap<Long, DynamicObject>();
                    ThreadCache.put((Object)"bd_accountview", acache);
                }
                DynamicObject account = acache.computeIfAbsent(entry.getAccountId(), k -> BusinessDataServiceHelper.loadSingleFromCache((Object)k, (String)"bd_accountview"));
                entryDo.set("account", (Object)account);
            }
            entryDo.set("parentid", (Object)this.id);
            entryDo.set("assgrp", (Object)entry.getAssgrpId());
            entryDo.set("entrydc", (Object)entry.getDcDirectory());
            entryDo.set("edescription", (Object)entry.getDescription());
            entryDo.set("creditlocal", (Object)entry.getLocalCredit());
            entryDo.set("debitlocal", (Object)entry.getLocalDebit());
            entryDo.set("localrate", (Object)entry.getLocalExchangeRate());
            entryDo.set("maincfamount", (Object)entry.getMaincfamount());
            entryDo.set("maincfitem", (Object)entry.getMaincfitemID());
            entryDo.set("maincfassgrp", (Object)entry.getMaincfassgrp());
            entryDo.set("suppcfamount", (Object)entry.getSupcfamount());
            entryDo.set("suppcfitem", (Object)entry.getSupcfitemID());
            entryDo.set("eorg", (Object)entry.getForgid());
            entryDo.set("eperiod", (Object)entry.getFperiodid());
            entryDo.set("creditori", (Object)entry.getOriCredit());
            DynamicObject currency = BusinessDataServiceHelper.newDynamicObject((String)"bd_currency");
            currency.set("id", (Object)entry.getOriCurrencyId());
            entryDo.set("currency", (Object)currency);
            entryDo.set("debitori", (Object)entry.getOriDebit());
            entryDo.set("price", (Object)entry.getPrice());
            entryDo.set("quantity", (Object)entry.getQty());
            entryDo.set("seq", (Object)entry.getSeq());
            entryDo.set("measureunit", (Object)entry.getUnitId());
            entryDo.set("expiredate", (Object)entry.getExpireDate());
            entryDo.set("businessnum", (Object)entry.getBusinessNum());
            entryDo.set("isdap", (Object)entry.isDap());
            if (entry.getComAssist() != null) {
                Set<ComAssistData> cadcol = entry.getComAssist().getResult();
                for (ComAssistData cad : cadcol) {
                    entryDo.set(cad.getFieldKey(), cad.getResult());
                }
            }
            SetExpandFieldValueUtil.setExpandFieldValue(entryDo, entry.getExpandFieldValue(), this.orgId);
            if (isExDate && BigDecimal.ONE.compareTo(entry.getLocalExchangeRate()) != 0 && voucher.getDate("exratedate") != null) {
                BigDecimal rate = this.getExchangeRate(taskCtx.getBookInfo().getExchangeTableID(), entry.getOriCurrencyId(), voucher.getDate("exratedate"));
                entryDo.set("localrate", (Object)rate);
            }
            entries.add((Object)entryDo);
        }
        dMap.put(key, voucher);
        return voucher;
    }

    @Override
    @SimplePropertyAttribute(alias="fsourcebillid", dbType=-5)
    public long getSourceBillId() {
        return this.sourceBillId;
    }

    @Override
    public void setSourceBillId(long sourceBillId) {
        this.sourceBillId = sourceBillId;
    }

    public BigDecimal getDebitlocamount_saved() {
        return this.debitlocamount_saved;
    }

    public void setDebitlocamount_saved(BigDecimal debitlocamount_saved) {
        this.debitlocamount_saved = debitlocamount_saved;
    }

    public BigDecimal getCreditlocamount_saved() {
        return this.creditlocamount_saved;
    }

    public void setCreditlocamount_saved(BigDecimal creditlocamount_saved) {
        this.creditlocamount_saved = creditlocamount_saved;
    }

    @Override
    public String getSourceBillNo() {
        return this.sourceBillNo;
    }

    @Override
    public void setSourceBillNo(String sourceBillNo) {
        this.sourceBillNo = sourceBillNo;
    }

    public Map<String, Object> getExpandFieldValue() {
        return this.expandFieldValue;
    }

    public void setExpandFieldValue(Map<String, Object> expandFieldValue) {
        this.expandFieldValue = expandFieldValue;
    }

    public void setExpandFieldValue(String fieldName, Object value) {
        this.expandFieldValue.put(fieldName, value);
    }

    private BigDecimal getExchangeRate(Long exchangeTableID, Long targetCurrencyID, Date date) {
        return GLUtil.getExchangeRate(exchangeTableID, targetCurrencyID, this.getLocalcur(), date);
    }

    @Override
    public Boolean getIssubmit() {
        return this.issubmit;
    }

    @Override
    public void setIssubmit(Boolean issubmit) {
        this.issubmit = issubmit;
    }

    public GLVoucherUnionType getUnionType() {
        return this.unionType;
    }

    public void setUnionType(GLVoucherUnionType unionType) {
        this.unionType = unionType;
    }

    @Override
    public Long getBookCyId() {
        return this.bookCyId;
    }

    @Override
    public void setBookCyId(Long BookCyId) {
        this.bookCyId = BookCyId;
    }

    @Override
    public String getAttachmentType() {
        return this.attachmentType;
    }

    @Override
    public void setAttachmentType(String attachmentType) {
        this.attachmentType = attachmentType;
    }

    public boolean isHasCashAcct() {
        return this.hasCashAcct;
    }

    public void setHasCashAcct(boolean hasCashAcct) {
        this.hasCashAcct = hasCashAcct;
    }

    public boolean isHasSyAcct() {
        return this.hasSyAcct;
    }

    public void setHasSyAcct(boolean hasSyAcct) {
        this.hasSyAcct = hasSyAcct;
    }

    public boolean isHasNcNpAcct() {
        return this.hasNcNpAcct;
    }

    public void setHasNcNpAcct(boolean hasNcNpAcct) {
        this.hasNcNpAcct = hasNcNpAcct;
    }
}

