/*
 * Decompiled with CFR 0.152.
 */
package kd.fi.ai.mservice.dao;

import java.util.ArrayList;
import java.util.Comparator;
import java.util.Date;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.function.Supplier;
import kd.bos.algo.DataSet;
import kd.bos.algo.Row;
import kd.bos.cache.ThreadCache;
import kd.bos.dataentity.ThreeTuple;
import kd.bos.dataentity.Tuple;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.entity.DynamicObjectCollection;
import kd.bos.dataentity.metadata.clr.DataEntityPropertyCollection;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.db.DB;
import kd.bos.db.DBRoute;
import kd.bos.db.SqlBuilder;
import kd.bos.entity.EntityMetadataCache;
import kd.bos.entity.MainEntityType;
import kd.bos.entity.flex.FlexEntireData;
import kd.bos.entity.flex.FlexEntityMetaUtils;
import kd.bos.entity.flex.FlexProperty;
import kd.bos.exception.KDException;
import kd.bos.ext.fi.accountref.AccountRefUtils;
import kd.bos.ext.fi.accountref.AccountVersionReplaceParam;
import kd.bos.ext.fi.ai.PresetCashItemUtil;
import kd.bos.ext.fi.ai.dap.cache.CacheKeyPrefix;
import kd.bos.ext.fi.ai.dap.cache.DapLocalCache;
import kd.bos.ext.fi.ai.dap.cache.DapLocalCache4H;
import kd.bos.ext.fi.ai.dap.cache.LocalCacheKey;
import kd.bos.ext.fi.ai.presetcf.PresetCashFlowItemParam;
import kd.bos.flex.FlexService;
import kd.bos.fs.util.StringUtils;
import kd.bos.logging.Log;
import kd.bos.logging.LogFactory;
import kd.bos.orm.ORM;
import kd.bos.orm.query.QFilter;
import kd.bos.servicehelper.BusinessDataServiceHelper;
import kd.bos.servicehelper.MetadataServiceHelper;
import kd.bos.servicehelper.QueryServiceHelper;
import kd.bos.servicehelper.basedata.BaseDataServiceHelper;
import kd.fi.ai.AccountMapType;
import kd.fi.ai.AccountMapTypeEntry;
import kd.fi.ai.AccountMapTypeFieldMapEntry;
import kd.fi.ai.AccountView;
import kd.fi.ai.AsstDimMapType;
import kd.fi.ai.AsstDimMapTypeEntry;
import kd.fi.ai.AsstactType;
import kd.fi.ai.CashFlowItem;
import kd.fi.ai.Currency;
import kd.fi.ai.ExchangeRate;
import kd.fi.ai.Org;
import kd.fi.ai.Period;
import kd.fi.ai.TreeNodeInfo;
import kd.fi.ai.VoucherSource;
import kd.fi.ai.VoucherType;
import kd.fi.ai.builder.AcctBookInfo;
import kd.fi.ai.builder.DapMasterIdCacheKey;
import kd.fi.ai.builder.IBuildVchContext;
import kd.fi.ai.builder.ISingleTaskContext;
import kd.fi.ai.cache.CacheHelper;
import kd.fi.ai.cache.CacheKey;
import kd.fi.ai.cache.CacheModule;
import kd.fi.ai.cache.DistributeCache;
import kd.fi.ai.cache.LocalCacheHelper;
import kd.fi.ai.exception.DapException;
import kd.fi.ai.util.DapUtil;
import kd.fi.ai.util.ExchangeRateUtil;
import kd.fi.ai.util.SysParamConfig;
import kd.fi.bd.business.vo.AssistEntryVO;
import kd.fi.bd.business.vo.CashFlowItemVO;
import kd.fi.bd.consts.AccountType;
import kd.fi.bd.helper.CashFlowItemHelper;
import kd.fi.v2.fah.converters.common.ObjectConverterFactory;

public class BaseDataLoader {
    private static final String SUFFIX_LONGNUMBER_ENTITYTYPE = "_longNumber_entityType";
    private static final String SUFFIX_ENTITYTYPE = "_entityType";
    private static final String PROPERTY_LONGNUMBER = "longnumber";
    private static final String PROPERTY_PARENT = "parent";
    private static final String AccountSelector = "id,number,accounttable.id,org.id,iscash,isbank,iscashequivalent,checkitementry.id,checkitementry.asstactitem,isqty,accheck,acctcurrency,currencyentry.currency,longnumber,enable,isleaf,accounttype,startdate,enddate";
    private static Log log = LogFactory.getLog(BaseDataLoader.class);

    public static AsstDimMapType loadAsstdimmaptype(IBuildVchContext ctx, Long assDimMapID) {
        LocalCacheKey cacheKey = LocalCacheKey.getCacheKey((CacheKeyPrefix)CacheKeyPrefix.VCHTEMPALTE, (Object[])new Object[]{"loadAsstdimmaptype", assDimMapID});
        AsstDimMapType asstDimMapType = (AsstDimMapType)DapLocalCache4H.get((LocalCacheKey)cacheKey, AsstDimMapType.class);
        if (asstDimMapType != null) {
            return asstDimMapType;
        }
        SqlBuilder sb = new SqlBuilder();
        long assTypeID = (Long)DB.query((DBRoute)DBRoute.of((String)"ai"), (SqlBuilder)sb.append("select a.fasstacttypeid as asstypeid from t_ai_asstdimmaptype as a where a.fid = ?", new Object[]{assDimMapID}), r -> {
            if (r.next()) {
                return r.getLong("asstypeid");
            }
            return 0L;
        });
        sb = new SqlBuilder();
        String valueType = (String)DB.query((DBRoute)DBRoute.basedata, (SqlBuilder)sb.append("select b.fvaluetype as valuetype from t_bas_flex_property b where b.fentryid = ?", new Object[]{assTypeID}), r -> {
            if (r.next()) {
                return r.getString("valuetype");
            }
            return null;
        });
        AsstDimMapType assMap = new AsstDimMapType();
        assMap.setId(assDimMapID);
        sb = new SqlBuilder();
        List fieldMapList = (List)DB.query((DBRoute)DBRoute.of((String)"ai"), (SqlBuilder)sb.append("select a.FEntryID as entryid,a.fentityid as entityid,a.ffieldkey as fieldkey,a.fdatatype as datatype from t_ai_asstfieldmapentry as a where a.fid = ?", new Object[]{assDimMapID}), r -> {
            ArrayList<AccountMapTypeFieldMapEntry> list = new ArrayList<AccountMapTypeFieldMapEntry>(2);
            while (r.next()) {
                AccountMapTypeFieldMapEntry fieldEntry = new AccountMapTypeFieldMapEntry();
                fieldEntry.setEntityid(r.getString("entityid"));
                fieldEntry.setFieldkey(r.getString("fieldkey"));
                fieldEntry.setDataType(r.getString("datatype"));
                list.add(fieldEntry);
            }
            return list;
        });
        assMap.fieldMapEntrys.addAll(fieldMapList);
        sb = new SqlBuilder();
        StringBuilder bf = new StringBuilder();
        bf.append("select ");
        for (AccountMapTypeFieldMapEntry fieldMap : assMap.fieldMapEntrys) {
            bf.append("a.f").append(fieldMap.getFieldkey()).append(" as ").append(fieldMap.getFieldkey()).append(",");
        }
        bf.append("a.fasstfield as asstfield,");
        bf.append("a.fasstfield_asst as asstfield_asst,");
        bf.append("a.fasstfield_text as asstfield_text");
        bf.append(" from t_ai_asstdimmapentry as a where a.fid=?");
        List entryList = (List)DB.query((DBRoute)DBRoute.of((String)"ai"), (SqlBuilder)sb.append(bf.toString(), new Object[]{assDimMapID}), r -> {
            ArrayList list = new ArrayList(8);
            while (r.next()) {
                HashMap<String, Object> m = new HashMap<String, Object>(8);
                for (AccountMapTypeFieldMapEntry fieldMap : assMap.fieldMapEntrys) {
                    m.put(fieldMap.getFieldkey(), r.getLong(fieldMap.getFieldkey()));
                }
                m.put("asstfield", r.getLong("asstfield"));
                m.put("asstfield_asst", r.getLong("asstfield_asst"));
                m.put("asstfield_text", r.getString("asstfield_text"));
                list.add(m);
            }
            return list;
        });
        Map<String, Map<Long, Map<String, Object>>> preQueryData = BaseDataLoader.preQueryData(entryList, assMap.fieldMapEntrys);
        for (Map entry : entryList) {
            AsstDimMapTypeEntry entryObj = new AsstDimMapTypeEntry();
            List<AccountMapTypeFieldMapEntry> fieldMaps = assMap.fieldMapEntrys;
            for (AccountMapTypeFieldMapEntry fieldMap : fieldMaps) {
                Object dataId = entry.get(fieldMap.getFieldkey());
                String billtype = "0".equals(fieldMap.getDataType()) ? fieldMap.getEntityid() : "bos_assistantdata_detail";
                entryObj.getMapIdData().put(fieldMap.getFieldkey(), dataId);
                Map<String, Object> map = preQueryData.get(billtype).get(dataId);
                if (null != map && !map.isEmpty()) {
                    dataId = map.get("masterid");
                }
                entryObj.getMapData().put(fieldMap.getFieldkey(), dataId);
            }
            if (entry.get("asstfield") != null) {
                entryObj.setAsstid(entry.get("asstfield"));
            }
            if (entry.get("asstfield_asst") != null) {
                entryObj.setAsstdataid(entry.get("asstfield_asst"));
            }
            entryObj.setText((String)entry.get("asstfield_text"));
            assMap.entrys.add(entryObj);
        }
        AsstactType asstActType = new AsstactType();
        asstActType.setValueType(valueType);
        assMap.setAsstactType(asstActType);
        DapLocalCache4H.put((LocalCacheKey)cacheKey, (Object)assMap);
        return assMap;
    }

    public static AccountMapType loadAccountmaptype(ISingleTaskContext ctx, Long acctMapID) {
        LocalCacheKey cacheKey = LocalCacheKey.getCacheKey((CacheKeyPrefix)CacheKeyPrefix.VCHTEMPALTE, (Object[])new Object[]{"loadAccountmaptype", acctMapID});
        AccountMapType accountMapType = (AccountMapType)DapLocalCache4H.get((LocalCacheKey)cacheKey, AccountMapType.class);
        if (accountMapType != null) {
            return accountMapType;
        }
        DynamicObject acctMapData = BusinessDataServiceHelper.loadSingleFromCache((Object)acctMapID, (String)"ai_accountmaptype");
        AccountMapType accMap = new AccountMapType();
        accMap.setId(acctMapData.getLong("id"));
        DynamicObjectCollection fieldmapentry = acctMapData.getDynamicObjectCollection("fieldmapentry");
        for (DynamicObject fieldMap : fieldmapentry) {
            AccountMapTypeFieldMapEntry fieldEntry = new AccountMapTypeFieldMapEntry();
            fieldEntry.setEntityid(fieldMap.getString("entityid"));
            fieldEntry.setFieldkey(fieldMap.getString("fieldkey"));
            fieldEntry.setDataType(fieldMap.getString("datatype"));
            accMap.getFieldMapEntrys().add(fieldEntry);
        }
        DynamicObjectCollection entryentity = acctMapData.getDynamicObjectCollection("entryentity");
        Map<String, Map<Long, Map<String, Object>>> preQueryData = BaseDataLoader.preQueryData(entryentity, accMap.getFieldMapEntrys());
        for (DynamicObject entry : entryentity) {
            AccountMapTypeEntry entryObj = new AccountMapTypeEntry();
            List<AccountMapTypeFieldMapEntry> fieldMaps = accMap.getFieldMapEntrys();
            int index = 0;
            boolean defFlag = true;
            for (AccountMapTypeFieldMapEntry fieldMap : fieldMaps) {
                Object dataId = entry.get(fieldMap.getFieldkey().replace("show", "") + "_id");
                String billtype = "0".equals(fieldMap.getDataType()) ? fieldMap.getEntityid() : "bos_assistantdata_detail";
                boolean isTree = BaseDataLoader.entityHasParent(ctx, billtype);
                boolean hasLongNum = BaseDataLoader.entityHasLongNumber(ctx, billtype);
                Map<Long, Map<String, Object>> map2 = preQueryData.get(billtype);
                Map<String, Object> map = map2.get(dataId);
                if (map == null) {
                    index = index == 0 ? 0 : index;
                    dataId = 0L;
                } else {
                    Object mid;
                    if (index == 0) {
                        Integer level = ObjectConverterFactory.getInteger(map.get("level"), -1);
                        index = isTree && level != null && -1 != level ? level : 0;
                    }
                    if ((mid = map.get("masterid")) != null && 0L != Long.parseLong(mid.toString())) {
                        dataId = mid;
                    }
                    defFlag = false;
                }
                Boolean isLeaf = Boolean.TRUE;
                String longNumber = "";
                if (map != null) {
                    isLeaf = !isTree || map.get("isleaf") == null ? Boolean.TRUE : (Boolean)map.get("isleaf");
                    longNumber = !hasLongNum || map.get(PROPERTY_LONGNUMBER) == null ? "" : (String)map.get(PROPERTY_LONGNUMBER);
                }
                ThreeTuple triple = new ThreeTuple(dataId, (Object)isLeaf, (Object)longNumber);
                entryObj.getMapData().put(fieldMap.getFieldkey(), (Tuple<Object, Boolean>)triple);
            }
            entryObj.setSortIndex(index);
            entryObj.setAccountid(entry.getLong("accfield_id"));
            accMap.getEntrys().add(entryObj);
            if (!defFlag) continue;
            accMap.setDefaultAccount(entry.getLong("accfield_id"));
        }
        accMap.getEntrys().sort(Comparator.comparing(AccountMapTypeEntry::getSortIndex).reversed());
        DapLocalCache4H.put((LocalCacheKey)cacheKey, (Object)accMap);
        return accMap;
    }

    public static Long getBaseDataByMasterId(String entityKey, Long acctMapID, long orgId) {
        CacheKey k = CacheKey.getCacheKey(CacheModule.aiBuildVchWizard, "getBaseDataByMasterId", entityKey, acctMapID, orgId);
        Long bmID = LocalCacheHelper.get(k, Long.class);
        if (bmID != null) {
            return bmID;
        }
        DynamicObject baseDataId = BusinessDataServiceHelper.loadSingleFromCache((Object)acctMapID, (String)entityKey, (String)"id, masterid");
        if (baseDataId != null) {
            DynamicObject baseFilter;
            ArrayList<QFilter> qfilters = new ArrayList<QFilter>(3);
            qfilters.add(new QFilter("masterid", "=", (Object)baseDataId.getLong("masterid")));
            QFilter qFilter = (QFilter)ThreadCache.get((Object)("BaseDataFilter" + entityKey + orgId), () -> BaseDataServiceHelper.getBaseDataFilter((String)entityKey, (Long)orgId));
            if (qFilter != null && orgId != 0L) {
                qfilters.add(qFilter);
            }
            if ((baseFilter = BusinessDataServiceHelper.loadSingleFromCache((String)entityKey, (String)"id, masterid", (QFilter[])qfilters.toArray(new QFilter[0]))) != null) {
                long long1 = baseFilter.getLong("id");
                LocalCacheHelper.put(k, long1);
                return long1;
            }
        }
        LocalCacheHelper.put(k, acctMapID);
        return acctMapID;
    }

    public static boolean entityHasLongNumber(ISingleTaskContext taskContext, String entityKey) {
        Map<String, Boolean> treeEntityMap = taskContext.getTreeEntityMap();
        if (treeEntityMap.containsKey(entityKey + PROPERTY_LONGNUMBER)) {
            return treeEntityMap.get(entityKey + PROPERTY_LONGNUMBER);
        }
        boolean containLongNumber = false;
        DistributeCache cache = CacheHelper.getDistributeCache(CacheModule.accSys);
        String dataCache = cache.get(entityKey + SUFFIX_LONGNUMBER_ENTITYTYPE);
        if (dataCache != null) {
            containLongNumber = Boolean.parseBoolean(dataCache);
        } else {
            boolean containParent = false;
            MainEntityType mainEntityType = MetadataServiceHelper.getDataEntityType((String)entityKey);
            DataEntityPropertyCollection properties = mainEntityType.getProperties();
            if (properties.get((Object)PROPERTY_PARENT) != null && (containParent = StringUtils.isNotEmpty((String)mainEntityType.getProperty(PROPERTY_PARENT).getAlias())) && properties.get((Object)PROPERTY_LONGNUMBER) != null) {
                containLongNumber = StringUtils.isNotEmpty((String)mainEntityType.getProperty(PROPERTY_LONGNUMBER).getAlias());
            }
            cache.put(entityKey + SUFFIX_LONGNUMBER_ENTITYTYPE, containLongNumber + "");
            cache.put(entityKey + SUFFIX_ENTITYTYPE, containParent + "");
            treeEntityMap.put(entityKey, containParent);
        }
        treeEntityMap.put(entityKey + PROPERTY_LONGNUMBER, containLongNumber);
        return containLongNumber;
    }

    public static boolean entityHasParent(ISingleTaskContext taskContext, String entityKey) {
        Map<String, Boolean> treeEntityMap = taskContext.getTreeEntityMap();
        if (treeEntityMap.containsKey(entityKey)) {
            return treeEntityMap.get(entityKey);
        }
        boolean containParent = false;
        DistributeCache cache = CacheHelper.getDistributeCache(CacheModule.accSys);
        String dataCache = cache.get(entityKey + SUFFIX_ENTITYTYPE);
        if (dataCache != null) {
            containParent = Boolean.parseBoolean(dataCache);
        } else {
            boolean containLongNumber = false;
            MainEntityType type = MetadataServiceHelper.getDataEntityType((String)entityKey);
            if (type.getAllFields().containsKey(PROPERTY_PARENT) && (containParent = StringUtils.isNotEmpty((String)type.getProperty(PROPERTY_PARENT).getAlias())) && type.getAllFields().containsKey(PROPERTY_LONGNUMBER)) {
                containLongNumber = StringUtils.isNotEmpty((String)type.getProperty(PROPERTY_LONGNUMBER).getAlias());
            }
            cache.put(entityKey + SUFFIX_ENTITYTYPE, containParent + "");
            cache.put(entityKey + SUFFIX_LONGNUMBER_ENTITYTYPE, containLongNumber + "");
            treeEntityMap.put(entityKey + PROPERTY_LONGNUMBER, containLongNumber);
        }
        treeEntityMap.put(entityKey, containParent);
        return containParent;
    }

    private static int getDataLevel(Object id, String entryid) {
        int result = 0;
        if (id == null || entryid == null) {
            return result;
        }
        DynamicObject singleData = BusinessDataServiceHelper.loadSingleFromCache((Object)id, (String)entryid, (String)"level");
        try {
            result = singleData.getInt("level");
        }
        catch (Exception e) {
            log.info("##");
        }
        return result;
    }

    public static Object loadBaseDataMappingData(IBuildVchContext ctx, Long mappingID, Object srcID) {
        String key;
        Map<String, Object> accountmaptypeCache = ctx.getBaseDataMappingDataCache();
        if (accountmaptypeCache.containsKey(key = "" + mappingID + srcID)) {
            return accountmaptypeCache.get(key);
        }
        Object destID = DapUtil.getBaseDataMappingDataID(mappingID, srcID);
        accountmaptypeCache.put(key, destID);
        return destID;
    }

    @Deprecated
    public static AsstactType loadAsstactType(IBuildVchContext ctx, Long asstTypeId) {
        Map<Long, AsstactType> asstTypes = ctx.getAsstTypes();
        AsstactType at = null;
        if (asstTypes.containsKey(asstTypeId)) {
            at = asstTypes.get(asstTypeId);
        } else {
            DynamicObject asstactType = BusinessDataServiceHelper.loadSingleFromCache((Object)asstTypeId, (String)"bd_asstacttype", (String)"id,name,flexfield,valuetype,valuesource.id,assistanttype.id");
            if (asstactType == null) {
                throw new DapException(String.format(ResManager.loadKDString((String)"ID\u4e3a\u201c%1$s\u201d\u7684\u6838\u7b97\u7ef4\u5ea6\u4e0d\u5b58\u5728\uff0c\u8bf7\u68c0\u67e5\u79d1\u76ee\u6216\u6838\u7b97\u7ef4\u5ea6\u662f\u5426\u5b58\u5728\u4fee\u6539\u3002", (String)"BaseDataLoader_0", (String)"fi-ai-common", (Object[])new Object[0]), asstTypeId));
            }
            at = new AsstactType();
            at.setName(asstactType.getString("name"));
            at.setFlexName(asstactType.getString("flexfield"));
            at.setValueType(asstactType.getString("valuetype"));
            at.setValuesourceID(asstactType.getString("valuesource.id"));
            Long aid = asstactType.get("assistanttype.id") != null ? Long.parseLong(asstactType.getString("assistanttype.id")) : 0L;
            at.setAssistanttypeID(aid);
            asstTypes.put(asstTypeId, at);
        }
        return at;
    }

    @Deprecated
    public static AsstactType loadAsstactType(IBuildVchContext ctx, String asstTypeId) {
        Map<String, AsstactType> asstTypes = ctx.getAsstTypesFromString();
        AsstactType at = null;
        if (asstTypes.containsKey(asstTypeId)) {
            at = asstTypes.get(asstTypeId);
        } else {
            DynamicObject asstactType = BusinessDataServiceHelper.loadSingleFromCache((Object)Long.parseLong(asstTypeId), (String)"bd_asstacttype", (String)"id,name,flexfield,valuetype,valuesource.id,assistanttype.id");
            if (asstactType == null) {
                throw new DapException(String.format(ResManager.loadKDString((String)"ID\u4e3a\u201c%1$s\u201d\u7684\u6838\u7b97\u7ef4\u5ea6\u4e0d\u5b58\u5728\uff0c\u8bf7\u68c0\u67e5\u79d1\u76ee\u6216\u6838\u7b97\u7ef4\u5ea6\u662f\u5426\u5b58\u5728\u4fee\u6539\u3002", (String)"BaseDataLoader_0", (String)"fi-ai-common", (Object[])new Object[0]), asstTypeId));
            }
            at = new AsstactType();
            at.setName(asstactType.getString("name"));
            at.setFlexName(asstactType.getString("flexfield"));
            at.setValueType(asstactType.getString("valuetype"));
            at.setValuesourceID(asstactType.getString("valuesource.id"));
            Long aid = asstactType.get("assistanttype.id") != null ? Long.parseLong(asstactType.getString("assistanttype.id")) : 0L;
            at.setAssistanttypeID(aid);
            asstTypes.put(asstTypeId, at);
        }
        return at;
    }

    public static AsstactType loadAsstactType(IBuildVchContext ctx, String asstTypeId, Supplier<String> nullTip) {
        Map<String, AsstactType> asstTypes = ctx.getAsstTypesFromString();
        AsstactType at = null;
        if (asstTypes.containsKey(asstTypeId)) {
            at = asstTypes.get(asstTypeId);
        } else {
            DynamicObject asstactType = BusinessDataServiceHelper.loadSingleFromCache((Object)Long.parseLong(asstTypeId), (String)"bd_asstacttype", (String)"id,name,flexfield,valuetype,valuesource.id,assistanttype.id");
            if (asstactType == null) {
                throw new DapException(nullTip.get());
            }
            at = new AsstactType();
            at.setName(asstactType.getString("name"));
            at.setFlexName(asstactType.getString("flexfield"));
            at.setValueType(asstactType.getString("valuetype"));
            at.setValuesourceID(asstactType.getString("valuesource.id"));
            Long aid = asstactType.get("assistanttype.id") != null ? Long.parseLong(asstactType.getString("assistanttype.id")) : 0L;
            at.setAssistanttypeID(aid);
            asstTypes.put(asstTypeId, at);
        }
        return at;
    }

    public static AsstactType loadBizAsstactType(IBuildVchContext ctx, Long asstTypeId) {
        Map<Long, AsstactType> asstTypes = ctx.getAsstBizTypes();
        AsstactType at = null;
        if (asstTypes.containsKey(asstTypeId)) {
            at = asstTypes.get(asstTypeId);
        } else {
            DynamicObject asstactType = BusinessDataServiceHelper.loadSingleFromCache((Object)asstTypeId, (String)"ai_asstacttype", (String)"id,name,flexfiled,datatype,valuesource.id,assistanttype.id,percision,dateformat");
            at = new AsstactType();
            at.setName(asstactType.getString("name"));
            at.setFlexName(asstactType.getString("flexfiled"));
            at.setValueType(asstactType.getString("datatype"));
            at.setValuesourceID(asstactType.getString("valuesource.id"));
            at.setAssistanttypeID(asstactType.getLong("assistanttype.id"));
            at.setPercision(asstactType.getInt("percision"));
            at.setShowformat(asstactType.getString("dateformat"));
            asstTypes.put(asstTypeId, at);
        }
        return at;
    }

    public static VoucherType loadVchType(IBuildVchContext ctx, Long vchtypeID) {
        Map<Long, VoucherType> vchtypeCache = ctx.getVchTypeCache();
        if (vchtypeCache.containsKey(vchtypeID)) {
            return vchtypeCache.get(vchtypeID);
        }
        DynamicObject vt = BusinessDataServiceHelper.loadSingleFromCache((Object)vchtypeID, (String)"gl_vouchertype", (String)"id,name,number,org.id");
        VoucherType v = new VoucherType();
        v.setId(vchtypeID);
        v.setName(vt.getString("name"));
        v.setOrgid(vt.getLong("org.id"));
        v.setNumber(vt.getString("number"));
        vchtypeCache.put(vchtypeID, v);
        String key = v.getName() + v.getOrgid();
        ctx.getVchTypeNameOrgCache().put(key, v);
        return v;
    }

    public static VoucherType loadVchTypeByNameAndOrg(IBuildVchContext ctx, String name, Long orgID) {
        String key;
        Map<String, VoucherType> vchtypeCache = ctx.getVchTypeNameOrgCache();
        if (vchtypeCache.containsKey(key = name + orgID)) {
            return vchtypeCache.get(key);
        }
        QFilter[] filters = new QFilter[]{new QFilter("name", "=", (Object)name), (QFilter)ThreadCache.get((Object)("BaseDataFiltergl_vouchertype" + orgID), () -> BaseDataServiceHelper.getBaseDataFilter((String)"gl_vouchertype", (Long)orgID)), new QFilter("enable", "=", (Object)Character.valueOf('1'))};
        DynamicObject vt = BusinessDataServiceHelper.loadSingleFromCache((String)"gl_vouchertype", (String)"id,name,number,org.id", (QFilter[])filters);
        if (vt != null) {
            VoucherType v = new VoucherType();
            v.setId(vt.getLong("id"));
            v.setName(vt.getString("name"));
            v.setNumber(vt.getString("number"));
            v.setOrgid(vt.getLong("org.id"));
            vchtypeCache.put(key, v);
            ctx.getVchTypeCache().put(vt.getLong("id"), v);
            return v;
        }
        vchtypeCache.put(key, null);
        return null;
    }

    public static AccountView loadAccount(IBuildVchContext ctx, Long acctID) {
        Map<Long, AccountView> accounts = ctx.getAccounts();
        AccountView at = new AccountView();
        if (acctID == 0L) {
            return at;
        }
        if (accounts.containsKey(acctID)) {
            at = accounts.get(acctID);
        } else {
            DynamicObject accountview = BusinessDataServiceHelper.loadSingleFromCache((Object)acctID, (String)"bd_accountview", (String)AccountSelector);
            if (accountview != null) {
                at = BaseDataLoader.buildAccountView(acctID, accountview);
                accounts.put(acctID, at);
            }
        }
        return at;
    }

    private static AccountView buildAccountView(Long acctID, DynamicObject accountview) {
        AccountView at = new AccountView();
        at.setId(acctID);
        at.setOrgid(accountview.getLong("org.id"));
        at.setAcctTableId(accountview.getLong("accounttable.id"));
        at.setNumber(accountview.getString("number"));
        at.setIsbank(accountview.getBoolean("isbank"));
        at.setIscash(accountview.getBoolean("iscash"));
        at.setIscashequivalent(accountview.getBoolean("iscashequivalent"));
        at.setIsqty(accountview.getBoolean("isqty"));
        at.setAccheck(accountview.getBoolean("accheck"));
        at.setLongNumber(accountview.getString(PROPERTY_LONGNUMBER));
        at.setEnable(accountview.getBoolean("enable"));
        at.setIsleft(accountview.getBoolean("isleaf"));
        at.setIssunyi(accountview.get("accounttype.accounttype").equals("4"));
        at.setBudgetType(AccountType.isBudgetProp((String)accountview.getString("accounttype.accounttype")));
        DynamicObjectCollection checkitementry = accountview.getDynamicObjectCollection("checkitementry");
        for (DynamicObject assitem : checkitementry) {
            DynamicObject asstactitem = (DynamicObject)assitem.get("asstactitem");
            if (asstactitem == null) continue;
            String flexField = asstactitem.getString("flexfield");
            at.getAsstactitemFlexFields().add(flexField);
        }
        at.setAcctCurrency(accountview.getString("acctcurrency"));
        DynamicObjectCollection currencyentry = accountview.getDynamicObjectCollection("currencyentry");
        for (DynamicObject currencyRow : currencyentry) {
            DynamicObject currency = (DynamicObject)currencyRow.get("currency");
            if (currency == null) continue;
            long currencyId = currency.getLong("id");
            at.getAcctCurrencySet().add(currencyId);
        }
        return at;
    }

    public static AccountView loadAccountByNumAndOrg(IBuildVchContext ctx, String number, Long orgID, Long accTableID, Date date) {
        Map<String, AccountView> accounts = ctx.getAccountNumAndOrgCache();
        AccountView at = null;
        String key = number + orgID + accTableID;
        if (accounts.containsKey(key)) {
            at = accounts.get(key);
        } else {
            long periodTypeId = ctx.getBooks().values().stream().findFirst().get().getPeriodTypeId();
            long bookTypeId = ctx.getBooks().values().stream().findFirst().get().getBookTypeId();
            Date endDateForPeriod = BaseDataLoader.getEndDateForPeriod(date, periodTypeId);
            QFilter[] filters = new QFilter[]{new QFilter("number", "=", (Object)number), new QFilter("accounttable", "=", (Object)accTableID), (QFilter)ThreadCache.get((Object)("BaseDataFilterbd_accountview" + orgID), () -> BaseDataServiceHelper.getBaseDataFilter((String)"bd_accountview", (Long)orgID)), new QFilter("enddate", ">", (Object)endDateForPeriod).and(new QFilter("startdate", "<=", (Object)endDateForPeriod))};
            DynamicObject accountview = BusinessDataServiceHelper.loadSingleFromCache((String)"bd_accountview", (String)AccountSelector, (QFilter[])filters);
            if (accountview != null) {
                at = BaseDataLoader.buildAccountView(accountview.getLong("id"), accountview);
                ctx.getAccounts().put(accountview.getLong("id"), at);
                accounts.put(key, at);
            } else {
                filters = new QFilter[]{new QFilter("number", "=", (Object)number), new QFilter("accounttable", "=", (Object)accTableID), (QFilter)ThreadCache.get((Object)("BaseDataFilterbd_accountview" + orgID), () -> BaseDataServiceHelper.getBaseDataFilter((String)"bd_accountview", (Long)orgID))};
                accountview = BusinessDataServiceHelper.loadSingle((String)"bd_accountview", (String)AccountSelector, (QFilter[])filters);
                if (accountview != null) {
                    AccountVersionReplaceParam rep = new AccountVersionReplaceParam(orgID.longValue(), accountview.getLong("masterid"), 0L, 0L, "", BaseDataLoader.getPeriod(endDateForPeriod, periodTypeId), bookTypeId, accountview, 0L);
                    DynamicObject newAccount = AccountRefUtils.getCurAccountForDap((AccountVersionReplaceParam)rep);
                    at = BaseDataLoader.buildAccountView(newAccount.getLong("id"), newAccount);
                    ctx.getAccounts().put(newAccount.getLong("id"), at);
                    accounts.put(key, at);
                }
            }
        }
        return at;
    }

    private static DynamicObject getPeriod(Date date, Long periodType) {
        QFilter f = new QFilter("beginDate", "<=", (Object)date);
        QFilter g = new QFilter("enddate", ">=", (Object)date);
        QFilter t = new QFilter("periodtype", "=", (Object)periodType);
        DynamicObject period = BusinessDataServiceHelper.loadSingleFromCache((String)"bd_period", (String)"id,enddate", (QFilter[])new QFilter[]{f, g, t});
        if (period != null) {
            Long periodId = period.getLong("id");
            return BusinessDataServiceHelper.loadSingleFromCache((Object)periodId, (String)"bd_period");
        }
        return null;
    }

    private static Date getEndDateForPeriod(Date date, Long periodType) {
        String key = "basedataloader_getperiod" + periodType + "_" + date.getTime();
        if (ThreadCache.exists((Object)key)) {
            Object enddate = ThreadCache.get((Object)key);
            return enddate != null ? (Date)enddate : null;
        }
        QFilter f = new QFilter("beginDate", "<=", (Object)date);
        QFilter g = new QFilter("enddate", ">=", (Object)date);
        QFilter t = new QFilter("periodtype", "=", (Object)periodType);
        DynamicObject period = BusinessDataServiceHelper.loadSingleFromCache((String)"bd_period", (String)"id,enddate", (QFilter[])new QFilter[]{f, g, t});
        if (period != null) {
            Date currendDate = period.getDate("enddate");
            ThreadCache.put((Object)key, (Object)currendDate);
            return currendDate;
        }
        return null;
    }

    public static DynamicObject loadOrg(ISingleTaskContext ctx, Long orgID) {
        Map<Long, DynamicObject> orgCache = ctx.getOrgCache();
        if (orgCache.containsKey(orgID)) {
            return orgCache.get(orgID);
        }
        Org org = BaseDataLoader.loadOrg(ctx.getBuildVchContext(), orgID);
        if (org == null) {
            orgCache.put(orgID, null);
            return null;
        }
        DynamicObject orgdo = ORM.create().newDynamicObject("bos_org");
        orgdo.set("id", (Object)org.getId());
        orgdo.set("name", (Object)org.getName());
        orgdo.set("number", (Object)org.getNumber());
        orgdo.set("simplename", (Object)org.getSimplename());
        orgdo.set("fcomment", (Object)org.getFcomment());
        orgCache.put(orgID, orgdo);
        return orgdo;
    }

    public static Org loadOrg(IBuildVchContext ctx, Long orgID) {
        Map<Long, Org> orgCache = ctx.getOrgCache();
        if (orgCache.containsKey(orgID)) {
            return orgCache.get(orgID);
        }
        DynamicObject orgDo = BusinessDataServiceHelper.loadSingleFromCache((Object)orgID, (String)"bos_org", (String)"id,name,number,simplename,fcomment");
        if (orgDo == null) {
            orgCache.put(orgID, null);
            return null;
        }
        Org org = new Org();
        org.setId(orgID);
        org.setName(orgDo.getString("name"));
        org.setNumber(orgDo.getString("number"));
        org.setSimplename(orgDo.getString("simplename"));
        org.setFcomment(orgDo.getString("fcomment"));
        orgCache.put(orgID, org);
        return org;
    }

    public static DynamicObject loadPeriod(ISingleTaskContext ctx, Long periodID) {
        Map<Long, DynamicObject> periodCache = ctx.getPeriodCache();
        if (periodCache.containsKey(periodID)) {
            return periodCache.get(periodID);
        }
        Period period = BaseDataLoader.loadPeriod(ctx.getBuildVchContext(), periodID);
        if (period == null) {
            periodCache.put(periodID, null);
            return null;
        }
        DynamicObject periodDo = ORM.create().newDynamicObject("bd_period");
        periodDo.set("id", (Object)period.getId());
        periodDo.set("name", (Object)period.getName());
        periodDo.set("number", (Object)period.getNumber());
        periodDo.set("periodnumber", (Object)period.getPeriodnumber());
        periodDo.set("periodyear", (Object)period.getPeriodyear());
        periodDo.set("periodquarter", (Object)period.getPeriodquarter());
        periodDo.set("beginDate", (Object)period.getBegindate());
        periodDo.set("enddate", (Object)period.getEnddate());
        DynamicObject periodtype = ORM.create().newDynamicObject("bd_period_type");
        periodtype.set("id", (Object)period.getPeriodtypeid());
        periodDo.set("periodtype", (Object)periodtype);
        periodCache.put(periodID, periodDo);
        return periodDo;
    }

    public static Period loadPeriod(IBuildVchContext ctx, Long periodID) {
        Map<Long, Period> periodCache = ctx.getPeriodCache();
        if (periodCache.containsKey(periodID)) {
            return periodCache.get(periodID);
        }
        DynamicObject periodDo = BusinessDataServiceHelper.loadSingleFromCache((Object)periodID, (String)"bd_period", (String)"id,name,number,periodyear,periodquarter,periodnumber,beginDate,enddate,periodtype.id");
        if (periodDo == null) {
            periodCache.put(periodID, null);
            return null;
        }
        Period period = new Period();
        period.setId(periodID);
        period.setName(periodDo.getString("name"));
        period.setNumber(periodDo.getString("number"));
        period.setPeriodnumber(periodDo.getInt("periodnumber"));
        period.setPeriodyear(periodDo.getInt("periodyear"));
        period.setPeriodquarter(periodDo.getInt("periodquarter"));
        period.setBegindate(periodDo.getDate("beginDate"));
        period.setEnddate(periodDo.getDate("enddate"));
        period.setPeriodtypeid(periodDo.getLong("periodtype.id"));
        periodCache.put(periodID, period);
        return period;
    }

    public static Object loadAcctItemMasterID(IBuildVchContext ctx, Object acctItemPK, String entityKey, long orgId) {
        return BaseDataLoader.loadAcctItemMasterID(ctx, acctItemPK, entityKey, orgId, 0L);
    }

    public static Object loadAcctItemMasterID(IBuildVchContext ctx, Object acctItemPK, String entityKey, long orgId, Long groupId) {
        if (BaseDataLoader.isV6015()) {
            return BaseDataLoader.loadAcctItemMasterIDV6015(ctx, acctItemPK, entityKey, orgId, groupId);
        }
        return BaseDataLoader.loadAcctItemMasterIDV6016(ctx, acctItemPK, entityKey, orgId, groupId);
    }

    public static Object loadAcctItemMasterIDV6015(IBuildVchContext ctx, Object acctItemPK, String entityKey, long orgId, Long asstypeId) {
        if (entityKey == null || acctItemPK == null || acctItemPK instanceof String && StringUtils.isBlank((String)((String)acctItemPK))) {
            return null;
        }
        Map<String, Object> masterCache = ctx.getAcctItemMasterIDCache();
        String key = entityKey + orgId;
        if ("bos_assistantdata_detail".equals(entityKey)) {
            key = key + asstypeId;
        }
        if (masterCache.containsKey(key = key + acctItemPK)) {
            return masterCache.get(key) == null ? Long.valueOf(0L) : masterCache.get(key);
        }
        try {
            DynamicObject baseData;
            long pk;
            if (acctItemPK instanceof Long && (pk = ((Long)acctItemPK).longValue()) == 0L) {
                return 0L;
            }
            if ("bd_accountbanks".equalsIgnoreCase(entityKey) || "cas_accountcash".equalsIgnoreCase(entityKey) || "am_accountbank".equalsIgnoreCase(entityKey)) {
                if (QueryServiceHelper.exists((String)entityKey, (Object)acctItemPK.toString())) {
                    masterCache.put(key, acctItemPK);
                    return acctItemPK;
                }
                masterCache.put(key, 0L);
                return 0L;
            }
            QFilter filter = new QFilter("id", "=", (Object)Long.parseLong(acctItemPK.toString()));
            if ("bos_assistantdata_detail".equals(entityKey) && null != asstypeId) {
                filter.and(new QFilter("group", "=", (Object)asstypeId));
            }
            if ((baseData = BusinessDataServiceHelper.loadSingleFromCache((String)entityKey, (String)"id,masterid", (QFilter[])filter.toArray())) != null) {
                ArrayList<QFilter> qfilters = new ArrayList<QFilter>(3);
                qfilters.add(new QFilter("masterid", "=", (Object)baseData.getLong("masterid")));
                QFilter qFilter = (QFilter)ThreadCache.get((Object)("BaseDataFilter" + entityKey + orgId), () -> BaseDataServiceHelper.getBaseDataFilter((String)entityKey, (Long)orgId));
                if (qFilter != null && orgId != 0L) {
                    qfilters.add(qFilter);
                }
                if ((baseData = BusinessDataServiceHelper.loadSingleFromCache((String)entityKey, (String)"id,masterid", (QFilter[])qfilters.toArray(new QFilter[0]))) == null) {
                    masterCache.put(key, null);
                    return null;
                }
                masterCache.put(key, baseData.get("masterid"));
                return baseData.get("masterid");
            }
            masterCache.put(key, null);
            return null;
        }
        catch (Exception e) {
            masterCache.put(key, null);
            log.info("##");
            return null;
        }
    }

    public static Object loadAcctItemMasterIDV6016(IBuildVchContext ctx, Object acctItemPK, String entityKey, long orgId, Long groupId) {
        String key;
        if (entityKey == null || entityKey.isEmpty() || acctItemPK == null || acctItemPK instanceof String && StringUtils.isBlank((String)((String)acctItemPK))) {
            return null;
        }
        Map<String, Long> masterCache = ctx.getNewAcctItemMasterIDCache();
        DapMasterIdCacheKey cacheKey = new DapMasterIdCacheKey().setEntityKey(entityKey).setId(Long.parseLong(acctItemPK.toString())).setOrgId(orgId);
        if ("bos_assistantdata_detail".equals(entityKey) && null != groupId) {
            cacheKey.setGroupId(groupId);
        }
        if (masterCache.containsKey(key = cacheKey.toString())) {
            return masterCache.get(key) == null ? Long.valueOf(0L) : masterCache.get(key);
        }
        try {
            DynamicObject baseData;
            long pk;
            if (acctItemPK instanceof Long && (pk = ((Long)acctItemPK).longValue()) == 0L) {
                return 0L;
            }
            if ("bd_accountbanks".equalsIgnoreCase(entityKey) || "cas_accountcash".equalsIgnoreCase(entityKey) || "am_accountbank".equalsIgnoreCase(entityKey)) {
                if (QueryServiceHelper.exists((String)entityKey, (Object)acctItemPK.toString())) {
                    masterCache.put(key, Long.parseLong(acctItemPK.toString()));
                    return acctItemPK;
                }
                masterCache.put(key, 0L);
                return 0L;
            }
            QFilter filter = new QFilter("id", "=", (Object)Long.parseLong(acctItemPK.toString()));
            if ("bos_assistantdata_detail".equals(entityKey) && null != groupId) {
                filter.and(new QFilter("group", "=", (Object)groupId));
            }
            if ((baseData = BusinessDataServiceHelper.loadSingleFromCache((String)entityKey, (String)"id,masterid", (QFilter[])filter.toArray())) != null) {
                ArrayList<QFilter> qfilters = new ArrayList<QFilter>(3);
                qfilters.add(new QFilter("masterid", "=", (Object)baseData.getLong("masterid")));
                QFilter qFilter = (QFilter)ThreadCache.get((Object)("BaseDataFilter" + entityKey + orgId), () -> BaseDataServiceHelper.getBaseDataFilter((String)entityKey, (Long)orgId));
                if (qFilter != null && orgId != 0L) {
                    qfilters.add(qFilter);
                }
                if ((baseData = BusinessDataServiceHelper.loadSingleFromCache((String)entityKey, (String)"id,masterid", (QFilter[])qfilters.toArray(new QFilter[0]))) == null) {
                    masterCache.put(key, null);
                    return null;
                }
                masterCache.put(key, baseData.getLong("masterid"));
                return baseData.get("masterid");
            }
            masterCache.put(key, null);
            return null;
        }
        catch (Exception e) {
            masterCache.put(key, null);
            log.info("##");
            return null;
        }
    }

    public static Object loadAcctFactorMasterID(IBuildVchContext ctx, Object acctItemPK, String entityKey, long orgId, Long groupId) {
        String key;
        Long cacheMID;
        if (entityKey == null || entityKey.isEmpty() || acctItemPK == null) {
            return 0L;
        }
        long pk = ObjectConverterFactory.getLong(acctItemPK, -1L);
        Map<String, Long> masterCache = ctx.getAcctFactorMasterIDCache();
        DapMasterIdCacheKey cacheKey = new DapMasterIdCacheKey().setEntityKey(entityKey).setId(pk).setOrgId(orgId);
        if ("bos_assistantdata_detail".equals(entityKey) && null != groupId) {
            cacheKey.setGroupId(groupId);
        }
        if ((cacheMID = masterCache.get(key = cacheKey.toString())) == null) {
            try {
                if (pk <= 0L) {
                    return 0L;
                }
                cacheMID = 0L;
                if ("bd_accountbanks".equalsIgnoreCase(entityKey) || "cas_accountcash".equalsIgnoreCase(entityKey) || "am_accountbank".equalsIgnoreCase(entityKey)) {
                    if (QueryServiceHelper.exists((String)entityKey, (Object)pk)) {
                        cacheMID = pk;
                    }
                } else {
                    DynamicObject baseData;
                    QFilter filter = new QFilter("id", "=", (Object)pk);
                    if ("bos_assistantdata_detail".equals(entityKey) && null != groupId) {
                        filter.and(new QFilter("group", "=", (Object)groupId));
                    }
                    if ((baseData = QueryServiceHelper.queryOne((String)entityKey, (String)"id,masterid", (QFilter[])filter.toArray())) != null) {
                        cacheMID = baseData.getLong("masterid");
                    }
                }
                masterCache.put(key, cacheMID);
            }
            catch (Exception e) {
                cacheMID = 0L;
                masterCache.put(key, cacheMID);
                log.info("##");
            }
        }
        return cacheMID;
    }

    public static String loadAcctMapLongNumber(ISingleTaskContext taskContext, String entityKey, Long masterId, Long groupId) {
        if (BaseDataLoader.isV6015()) {
            return BaseDataLoader.loadAcctMapLongNumberV6015(taskContext, entityKey, masterId, groupId);
        }
        return BaseDataLoader.loadAcctMapLongNumberV6016(taskContext, entityKey, masterId, groupId);
    }

    public static String loadAcctMapLongNumberV6015(ISingleTaskContext taskContext, String entityKey, Long masterId, Long groupId) {
        if (entityKey == null || masterId == null || masterId.equals(0L) || !BaseDataLoader.entityHasLongNumber(taskContext, entityKey)) {
            return "";
        }
        long acctOrgId = taskContext.getBookInfo().getAcctOrgId();
        StringBuilder cacheKey = new StringBuilder();
        cacheKey.append(entityKey).append(acctOrgId);
        if (entityKey.equals("bos_assistantdata_detail")) {
            cacheKey.append(groupId);
        }
        cacheKey.append(masterId);
        Map<String, String> longNumberCache = taskContext.getMappingTreeFactorLongNumber();
        String longNumber = longNumberCache.get(cacheKey.toString());
        if (longNumber == null) {
            longNumber = "";
            DynamicObject baseData = QueryServiceHelper.queryOne((String)entityKey, (String)"id,masterid,longnumber", (QFilter[])new QFilter("masterid", "=", (Object)masterId).toArray());
            if (baseData != null) {
                longNumber = baseData.getString(PROPERTY_LONGNUMBER);
                longNumber = longNumber == null ? "" : longNumber;
            }
            longNumberCache.put(cacheKey.toString(), longNumber);
        }
        return longNumber;
    }

    public static String loadAcctMapLongNumberV6016(ISingleTaskContext taskContext, String entityKey, Long masterId, Long groupId) {
        Map<String, String> longNumberCache;
        String longNumber;
        if (entityKey == null || entityKey.isEmpty() || masterId == null || masterId.equals(0L) || !BaseDataLoader.entityHasLongNumber(taskContext, entityKey)) {
            return "";
        }
        long acctOrgId = taskContext.getBookInfo().getAcctOrgId();
        DapMasterIdCacheKey cacheKey = new DapMasterIdCacheKey().setEntityKey(entityKey).setMasterId(masterId).setOrgId(acctOrgId);
        if ("bos_assistantdata_detail".equals(entityKey) && null != groupId) {
            cacheKey.setGroupId(groupId);
        }
        if ((longNumber = (longNumberCache = taskContext.getBuildVchContext().getMappingTreeFactorLongNumber()).get(cacheKey.toString())) == null) {
            longNumber = "";
            DynamicObject baseData = QueryServiceHelper.queryOne((String)entityKey, (String)"id,masterid,longnumber", (QFilter[])new QFilter("masterid", "=", (Object)masterId).toArray());
            if (baseData != null) {
                longNumber = baseData.getString(PROPERTY_LONGNUMBER);
                longNumber = longNumber == null ? "" : longNumber;
            }
            longNumberCache.put(cacheKey.toString(), longNumber);
        }
        return longNumber;
    }

    public static Long loadGrpID(IBuildVchContext ctx, FlexEntireData flexEntireData) {
        BaseDataLoader.doubleCheck(flexEntireData);
        Map<String, Long> grpCache = ctx.getGrpCache();
        String key = flexEntireData.concatFlexData();
        if (grpCache.containsKey(key)) {
            return grpCache.get(key);
        }
        MainEntityType mainEntity = new MainEntityType();
        mainEntity.setAlias("T_GL_ASSIST");
        mainEntity.setDBRouteKey("gl");
        Long assgrpid = null;
        try {
            assgrpid = FlexService.saveFlexData((MainEntityType)mainEntity, (FlexEntireData)flexEntireData);
        }
        catch (KDException e) {
            assgrpid = FlexService.saveFlexData((MainEntityType)mainEntity, (FlexEntireData)flexEntireData);
        }
        grpCache.put(key, assgrpid);
        return assgrpid;
    }

    @Deprecated
    public static Long loadPresetCfItemID(IBuildVchContext ctx, long orgid, long accid, long currencyid, long assgrpid, int dc) {
        String key;
        Map<String, Long> grpCache = BaseDataLoader.getPreCfItemCache(ctx);
        if (grpCache.containsKey(key = "" + orgid + accid + currencyid + assgrpid)) {
            return grpCache.get(key);
        }
        Long cfItemID = 0L;
        if (accid != 0L) {
            String direction = dc == 1 ? "debitlocal" : "creditlocal";
            Map cash = PresetCashItemUtil.getCashFlowItemIds((DynamicObject)BusinessDataServiceHelper.loadSingleFromCache((Object)accid, (String)"bd_accountview"), (long)assgrpid, (String)direction, (long)orgid);
            cfItemID = (Long)cash.get("mainitem");
        }
        return cfItemID;
    }

    public static Map<String, Long> batchLoadPresetCfItemID(IBuildVchContext ctx, long orgId, long accttabId, Set<PresetCashFlowItemParam> paramList) {
        Map<String, Long> grpCache = BaseDataLoader.getPreCfItemCache(ctx);
        Iterator<PresetCashFlowItemParam> listIt = paramList.iterator();
        while (listIt.hasNext()) {
            PresetCashFlowItemParam item = listIt.next();
            String key = "" + orgId + item.getAcctId() + item.getAssgrp() + item.getDc() + item.getItemType();
            if (!grpCache.containsKey(key)) continue;
            listIt.remove();
        }
        if (paramList.size() > 0) {
            long periodId = ctx.getBooks().values().stream().findFirst().get().getSelectPeriodId();
            Map cashFlowItems = PresetCashItemUtil.batchGetCashFlowItemIds(new ArrayList<PresetCashFlowItemParam>(paramList), (long)orgId, (long)accttabId, (long)periodId);
            for (PresetCashFlowItemParam item : paramList) {
                String key = "" + orgId + item.getAcctId() + item.getAssgrp() + item.getDc() + item.getItemType();
                Long v = (Long)cashFlowItems.get(item);
                if (v == null) {
                    v = 0L;
                }
                grpCache.put(key, v);
            }
        }
        return grpCache;
    }

    public static Map<String, Long> getPreCfItemCache(IBuildVchContext ctx) {
        return (Map)ThreadCache.get((Object)"PreCfItemCache", HashMap::new);
    }

    public static Long loadPresetCfItemFromCache(IBuildVchContext ctx, long orgId, long accid, long assgrpid, int dc, String type) {
        String key;
        Map<String, Long> grpCache = BaseDataLoader.getPreCfItemCache(ctx);
        return grpCache.get(key = "" + orgId + accid + assgrpid + dc + type) == null ? Long.valueOf(0L) : grpCache.get(key);
    }

    public static CashFlowItem loadCashflowItem(IBuildVchContext ctx, Long cfiID) {
        if (cfiID == 0L) {
            return null;
        }
        return BaseDataLoader.loadVersionCashFlowItemById(ctx, cfiID);
    }

    public static CashFlowItem loadCashFlowItemByNumAndOrg(IBuildVchContext ctx, String number, Long orgID) {
        Map<String, CashFlowItem> numOrgCache = ctx.getCashflowItemNumAndOrgCache();
        CashFlowItem at = null;
        String key = number + orgID;
        if (numOrgCache.containsKey(key)) {
            at = numOrgCache.get(key);
        } else {
            long periodId = ctx.getBooks().values().stream().findFirst().get().getSelectPeriodId();
            CashFlowItemVO cashflowItem = (CashFlowItemVO)CashFlowItemHelper.loadForVersion((String[])new String[]{number}, (Long)orgID, (Long)periodId, CashFlowItemVO::getLeaf).get(number);
            if (cashflowItem != null) {
                at = new CashFlowItem();
                at.setId(cashflowItem.getId());
                at.setDirection(cashflowItem.getDirection());
                at.setIsdealactivity(cashflowItem.getDealActivity());
                at.setSupItem(cashflowItem.getScheduleItem());
                List checkitementry = cashflowItem.getAssistEntryVOS();
                for (AssistEntryVO assitem : checkitementry) {
                    long assistTypeId = assitem.getAssistTypeId();
                    AsstactType asstactType = BaseDataLoader.loadAsstactType(ctx, assistTypeId);
                    if (asstactType == null) continue;
                    String flexField = asstactType.getFlexName();
                    at.asstactitemFlexFields.add(flexField);
                }
                ctx.getCashflowItems().put(cashflowItem.getId(), at);
            }
            numOrgCache.put(key, at);
        }
        return at;
    }

    public static CashFlowItem loadVersionCashFlowItemById(IBuildVchContext ctx, long cashItemId) {
        Map<Long, CashFlowItem> idCache = ctx.getCashflowItems();
        CashFlowItem at = null;
        if (idCache.containsKey(cashItemId)) {
            at = idCache.get(cashItemId);
        } else {
            AcctBookInfo acctBookInfo = ctx.getBooks().values().stream().findFirst().get();
            long orgID = acctBookInfo.getAcctOrgId();
            long periodId = acctBookInfo.getSelectPeriodId();
            CashFlowItemVO cashFlowItemVO = (CashFlowItemVO)CashFlowItemHelper.loadForVersion((Long[])new Long[]{cashItemId}, (Long)orgID, (Long)periodId, CashFlowItemVO::getLeaf).get(cashItemId);
            if (cashFlowItemVO != null) {
                at = new CashFlowItem();
                at.setId(cashFlowItemVO.getId());
                at.setDirection(cashFlowItemVO.getDirection());
                at.setIsdealactivity(cashFlowItemVO.getDealActivity());
                at.setSupItem(cashFlowItemVO.getScheduleItem());
                List checkitementry = cashFlowItemVO.getAssistEntryVOS();
                for (AssistEntryVO assitem : checkitementry) {
                    long assistTypeId = assitem.getAssistTypeId();
                    AsstactType asstactType = BaseDataLoader.loadAsstactType(ctx, assistTypeId);
                    if (asstactType == null) continue;
                    String flexField = asstactType.getFlexName();
                    at.asstactitemFlexFields.add(flexField);
                }
            }
            idCache.put(cashItemId, at);
        }
        return at;
    }

    public static List<Object> loadBaseDataSubs(IBuildVchContext ctx, String entityKey, Object basedataID) {
        Map<Object, List<Object>> cfis = ctx.getBasedataSubs();
        ArrayList<Object> allNodes = null;
        String key = entityKey + basedataID;
        if (cfis.containsKey(key)) {
            allNodes = cfis.get(key);
        } else {
            allNodes = new ArrayList();
            List realIds = QueryServiceHelper.queryPrimaryKeys((String)entityKey, (QFilter[])new QFilter("masterid", "=", basedataID).toArray(), null, (int)-1);
            BaseDataLoader.getAllLeavesFromMasterid(entityKey, allNodes, realIds, 100);
            cfis.put(key, allNodes);
        }
        return allNodes;
    }

    private static void getAllLeaves(String entityname, List<Object> allNodes, List<Object> parentIds) {
        List ids = QueryServiceHelper.queryPrimaryKeys((String)entityname, (QFilter[])new QFilter(PROPERTY_PARENT, "in", parentIds).toArray(), null, (int)-1);
        if (!ids.isEmpty()) {
            allNodes.addAll(ids);
            BaseDataLoader.getAllLeaves(entityname, allNodes, ids);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static void getAllLeavesFromMasterid(String entityname, List<Object> allNodes, List<Object> parentIds, int Max_run) {
        if (Max_run <= 0) {
            return;
        }
        ArrayList masterids = new ArrayList();
        ArrayList<Object> ids = new ArrayList<Object>();
        try (DataSet ds = QueryServiceHelper.queryDataSet((String)"kd.fi.ai.mservice.dao.BaseDataLoader", (String)entityname, (String)"masterid,id", (QFilter[])new QFilter(PROPERTY_PARENT, "in", parentIds).toArray(), null);){
            ds.forEach(row -> {
                masterids.add(row.get("masterid"));
                ids.add(row.get("id"));
            });
        }
        if (!ids.isEmpty()) {
            allNodes.addAll(masterids);
            BaseDataLoader.getAllLeavesFromMasterid(entityname, allNodes, ids, --Max_run);
        }
    }

    public static ExchangeRate loadExchangeRateEntity(IBuildVchContext ctx, long exchangeTableID, long cyFromId, long cyToId, Date date) {
        Map<String, ExchangeRate> rateCache = ctx.getExchangeRateCache();
        ExchangeRate rate = null;
        StringBuilder keyBuilder = new StringBuilder();
        keyBuilder.append(exchangeTableID).append(cyFromId).append(cyToId).append(date.getTime());
        String key = keyBuilder.toString();
        if (rateCache.containsKey(key)) {
            rate = rateCache.get(key);
        } else {
            rate = ExchangeRateUtil.getNewExchangeRateEntity(exchangeTableID, cyFromId, cyToId, date);
            rateCache.put(key, rate);
        }
        return rate;
    }

    public static Currency loadCurrency(IBuildVchContext ctx, Long currencyID) {
        Map<Long, Currency> currencys = ctx.getCurrencys();
        Currency at = new Currency();
        if (currencyID == 0L) {
            return at;
        }
        if (currencys.containsKey(currencyID)) {
            at = currencys.get(currencyID);
        } else {
            String select = "id,amtprecision,priceprecision";
            DynamicObject cy = BusinessDataServiceHelper.loadSingleFromCache((Object)currencyID, (String)"bd_currency", (String)select);
            if (cy != null) {
                at.setId(currencyID);
                at.setAmtprecision(cy.getInt("amtprecision"));
                at.setPriceprecision(cy.getInt("priceprecision"));
                currencys.put(currencyID, at);
            }
        }
        return at;
    }

    private static Map<String, Map<Long, Map<String, Object>>> preQueryData(DynamicObjectCollection entryentity, List<AccountMapTypeFieldMapEntry> fieldMaps) {
        if (entryentity == null || entryentity.isEmpty() || fieldMaps == null || fieldMaps.isEmpty()) {
            return new HashMap<String, Map<Long, Map<String, Object>>>(1);
        }
        HashMap<String, Map<Long, Map<String, Object>>> result = new HashMap<String, Map<Long, Map<String, Object>>>(fieldMaps.size());
        HashMap groupType = new HashMap(fieldMaps.size());
        for (AccountMapTypeFieldMapEntry fieldMap : fieldMaps) {
            HashSet<Long> gt = new HashSet<Long>(entryentity.size());
            String billtype = "0".equals(fieldMap.getDataType()) ? fieldMap.getEntityid() : "bos_assistantdata_detail";
            for (DynamicObject entry : entryentity) {
                Object dataId = entry.get(fieldMap.getFieldkey().replace("show", "") + "_id");
                Long cc = dataId != null ? Long.parseLong(dataId.toString()) : 0L;
                gt.add(cc);
            }
            if (groupType.get(billtype) != null) {
                ((Set)groupType.get(billtype)).addAll(gt);
                continue;
            }
            groupType.put(billtype, gt);
        }
        HashSet<String> params = new HashSet<String>();
        params.add("masterid");
        params.add("level");
        params.add("isleaf");
        params.add(PROPERTY_LONGNUMBER);
        for (Map.Entry gType : groupType.entrySet()) {
            Map<Long, Map<String, Object>> batchQueryData = BaseDataLoader.batchQueryData((String)gType.getKey(), (Set)gType.getValue(), params);
            result.put((String)gType.getKey(), batchQueryData);
        }
        return result;
    }

    private static Map<String, Map<Long, Map<String, Object>>> preQueryData(List<Map<String, Object>> entryentity, List<AccountMapTypeFieldMapEntry> fieldMaps) {
        if (entryentity == null || entryentity.isEmpty() || fieldMaps == null || fieldMaps.isEmpty()) {
            return new HashMap<String, Map<Long, Map<String, Object>>>(1);
        }
        HashMap<String, Map<Long, Map<String, Object>>> result = new HashMap<String, Map<Long, Map<String, Object>>>(fieldMaps.size());
        HashMap groupType = new HashMap(fieldMaps.size());
        for (AccountMapTypeFieldMapEntry fieldMap : fieldMaps) {
            HashSet<Long> gt = new HashSet<Long>(entryentity.size());
            String billtype = "0".equals(fieldMap.getDataType()) ? fieldMap.getEntityid() : "bos_assistantdata_detail";
            for (Map<String, Object> entry : entryentity) {
                Object dataId = entry.get(fieldMap.getFieldkey().replace("show", ""));
                Long cc = dataId != null ? Long.parseLong(dataId.toString()) : 0L;
                gt.add(cc);
            }
            if (groupType.get(billtype) != null) {
                ((Set)groupType.get(billtype)).addAll(gt);
                continue;
            }
            groupType.put(billtype, gt);
        }
        HashSet<String> params = new HashSet<String>();
        params.add("masterid");
        params.add("level");
        params.add("isleaf");
        for (Map.Entry gType : groupType.entrySet()) {
            Map<Long, Map<String, Object>> batchQueryData = BaseDataLoader.batchQueryData((String)gType.getKey(), (Set)gType.getValue(), params);
            result.put((String)gType.getKey(), batchQueryData);
        }
        return result;
    }

    private static Map<Long, Map<String, Object>> batchQueryData(String billType, Set<Long> dataIds, Set<String> params) {
        if (StringUtils.isBlank((String)billType) || dataIds == null || dataIds.isEmpty() || params == null || params.isEmpty()) {
            return new HashMap<Long, Map<String, Object>>(1);
        }
        params.add("id");
        MainEntityType dataEntityType = EntityMetadataCache.getDataEntityType((String)billType);
        DataEntityPropertyCollection properties = dataEntityType.getProperties();
        LinkedList<String> paramsCopy = new LinkedList<String>();
        StringBuilder selectFields = new StringBuilder();
        int newSize = 0;
        for (String param : params) {
            if (properties.get((Object)param) == null) continue;
            paramsCopy.add(param);
            ++newSize;
            selectFields.append(param).append(",");
        }
        selectFields.deleteCharAt(selectFields.lastIndexOf(","));
        BaseDataLoader.loadAllBaseDataTree(billType);
        HashMap<Long, Map<String, Object>> result = new HashMap<Long, Map<String, Object>>(dataIds.size());
        try (DataSet queryDataSet = QueryServiceHelper.queryDataSet((String)"kd.fi.ai.mservice.dao.BaseDataLoader", (String)billType, (String)selectFields.toString(), (QFilter[])new QFilter("id", "in", dataIds).toArray(), null);){
            Iterator iterator = queryDataSet.iterator();
            while (iterator.hasNext()) {
                HashMap<String, Object> rr = new HashMap<String, Object>(newSize);
                Row row = (Row)iterator.next();
                for (String p : paramsCopy) {
                    Object data = null;
                    data = row.get(p);
                    rr.put(p, data);
                }
                Long id = row.getLong("id");
                result.put(id, rr);
            }
        }
        return result;
    }

    public static DynamicObject loadBooktype(ISingleTaskContext ctx, Long booktypeId) {
        Map<Long, DynamicObject> bookTypeCache = ctx.getBooktypeCache();
        if (bookTypeCache.containsKey(booktypeId)) {
            return bookTypeCache.get(booktypeId);
        }
        DynamicObject btDo = BusinessDataServiceHelper.loadSingleFromCache((Object)booktypeId, (String)"bd_accountbookstype", (String)"id,name,number,accounttype");
        if (btDo == null) {
            bookTypeCache.put(booktypeId, null);
            return null;
        }
        DynamicObject booktypeDo = ORM.create().newDynamicObject("bd_accountbookstype");
        booktypeDo.set("id", (Object)booktypeId);
        booktypeDo.set("name", (Object)btDo.getString("name"));
        booktypeDo.set("number", (Object)btDo.getString("number"));
        booktypeDo.set("accounttype", (Object)btDo.getString("accounttype"));
        bookTypeCache.put(booktypeId, booktypeDo);
        return booktypeDo;
    }

    public static FlexEntireData.FlexData createSinlgeFlexData(FlexEntireData flexEntireData, FlexProperty flexProperty, Object value) {
        Boolean isTextValue = "3".equals(flexProperty.getValueType());
        if (isTextValue.booleanValue()) {
            FlexEntireData flexEntireData2 = flexEntireData;
            flexEntireData2.getClass();
            FlexEntireData.FlexData flexData = new FlexEntireData.FlexData(flexEntireData2, flexProperty, (Object)String.valueOf(value));
            FlexEntireData.FlexFieldDataType flexFieldDataType = FlexEntireData.FlexFieldDataType.STRING;
            flexData.setDbType(flexFieldDataType);
            return flexData;
        }
        FlexEntireData flexEntireData3 = flexEntireData;
        flexEntireData3.getClass();
        FlexEntireData.FlexData flexData = new FlexEntireData.FlexData(flexEntireData3, flexProperty, (Object)Long.parseLong(value.toString()));
        FlexEntireData.FlexFieldDataType flexFieldDataType = FlexEntireData.FlexFieldDataType.LONG;
        flexData.setDbType(flexFieldDataType);
        return flexData;
    }

    public static FlexProperty getFlexProperty(String flexField) {
        return FlexEntityMetaUtils.getFlexProperty((String)flexField);
    }

    private static void doubleCheck(FlexEntireData flexEntireData) {
        List flexDatas = flexEntireData.getFlexDatas();
        ArrayList<FlexEntireData.FlexData> newFlexDatas = new ArrayList<FlexEntireData.FlexData>(flexDatas.size());
        for (FlexEntireData.FlexData fd : flexDatas) {
            FlexProperty flexProperty;
            if (fd == null || (flexProperty = (FlexProperty)ThreadCache.get((Object)("FlexProperty" + fd.getPropId()), () -> BaseDataLoader.getFlexProperty(fd.getPropId()))) == null || fd.getValue() == null || fd.getValue().equals("")) continue;
            newFlexDatas.add(BaseDataLoader.createSinlgeFlexData(flexEntireData, flexProperty, fd.getValue()));
        }
        flexEntireData.setFlexDatas(newFlexDatas);
    }

    public static FlexEntireData checkFlexEntireData(FlexEntireData flexEntireData) {
        BaseDataLoader.doubleCheck(flexEntireData);
        return flexEntireData;
    }

    public static long getBasedataCount(String entityKey) {
        LocalCacheKey cacheKey = LocalCacheKey.getCacheKey((CacheKeyPrefix)CacheKeyPrefix.GENERATE_VOUCHER_INFO, (Object[])new Object[]{"getBasedataCount", entityKey});
        Long c = DapLocalCache.get(cacheKey, Long.class);
        if (c != null) {
            return c;
        }
        MainEntityType type = EntityMetadataCache.getDataEntityType((String)entityKey);
        c = (Long)DB.query((DBRoute)DBRoute.of((String)type.getDBRouteKey()), (String)("select count(1) as c from " + type.getAlias() + " where 1=1"), r -> {
            if (r.next()) {
                return r.getLong("c");
            }
            return 0L;
        });
        DapLocalCache.put(cacheKey, c);
        return c;
    }

    public static Map<Long, TreeNodeInfo> loadAllBaseDataTree(String entityKey) {
        MainEntityType dataEntityType = EntityMetadataCache.getDataEntityType((String)entityKey);
        DataEntityPropertyCollection properties = dataEntityType.getProperties();
        if (properties.get((Object)"isleaf") != null && properties.get((Object)PROPERTY_PARENT) != null && properties.get((Object)"masterid") != null) {
            long count = BaseDataLoader.getBasedataCount(entityKey);
            if (count > 100000L) {
                return null;
            }
            CacheKey k = CacheKey.getCacheKey(CacheModule.accSys, "loadAllBaseDataTree", entityKey);
            HashMap<Long, TreeNodeInfo> allData = LocalCacheHelper.get(k, Map.class);
            if (allData != null) {
                if (allData.size() == 0) {
                    return null;
                }
                return allData;
            }
            allData = new HashMap<Long, TreeNodeInfo>(128);
            try (DataSet queryDataSet = QueryServiceHelper.queryDataSet((String)"kd.fi.ai.mservice.dao.BaseDataLoader", (String)entityKey, (String)"id,masterid,isleaf,parent", (QFilter[])new QFilter("1", "=", (Object)1).toArray(), null);){
                for (Row row : queryDataSet) {
                    TreeNodeInfo node = new TreeNodeInfo();
                    node.setLeaf(row.getBoolean("isleaf"));
                    node.setMasterid(row.getLong("masterid"));
                    node.setParentid(row.getLong(PROPERTY_PARENT));
                    allData.put(row.getLong("id"), node);
                }
            }
            LocalCacheHelper.put(k, allData);
            if (allData.size() == 0) {
                return null;
            }
            return allData;
        }
        return null;
    }

    public static VoucherSource loadVchSource(IBuildVchContext ctx, String sourceSys) {
        Map<String, VoucherSource> voucherSourceCache = ctx.getVoucherSource();
        if (voucherSourceCache.containsKey(sourceSys)) {
            return voucherSourceCache.get(sourceSys);
        }
        DynamicObject vt = BusinessDataServiceHelper.loadSingleFromCache((Object)sourceSys, (String)"bos_devportal_bizapp", (String)"id,number");
        if (vt == null) {
            voucherSourceCache.put(sourceSys, null);
            return null;
        }
        VoucherSource v = new VoucherSource();
        v.setId(sourceSys);
        v.setNumber(vt.getString("number"));
        voucherSourceCache.put(sourceSys, v);
        return v;
    }

    public static boolean isV6015() {
        Boolean isV6015 = (Boolean)ThreadCache.get((Object)"BaseDataLoader.isV6015", () -> null);
        if (isV6015 == null) {
            isV6015 = "6.0.15".equals(SysParamConfig.get("DAP_APP_VERSION", "6.0.16"));
            ThreadCache.put((Object)"BaseDataLoader.isV6015", (Object)isV6015);
        }
        return isV6015;
    }
}

