/*
 * Decompiled with CFR 0.152.
 */
package kd.fi.ai.mservice.dao;

import java.util.HashMap;
import java.util.Map;
import kd.bos.cache.ThreadCache;
import kd.bos.db.DB;
import kd.bos.db.DBRoute;
import kd.bos.servicehelper.org.OrgUnitServiceHelper;
import kd.fi.ai.enums.BosOrgBizTypeEnum;

public class OrgBizTypeDao {
    public static boolean checkOrgType(Map<String, Boolean> typeCache, Object acctItem, String orgTypeNum, String billType) {
        boolean isLong = acctItem instanceof Long;
        boolean checkResult = true;
        if (isLong && "bos_adminorg".equals(billType)) {
            String cacheKey = acctItem + BosOrgBizTypeEnum.ADMINISTRATIVE.getNumber();
            checkResult = typeCache.computeIfAbsent(cacheKey, key -> OrgUnitServiceHelper.checkOrgFunction((Long)((Long)acctItem), (String)BosOrgBizTypeEnum.ADMINISTRATIVE.getNumber()));
        } else if (isLong && "bos_org".equals(billType)) {
            String finalOrgTypeNum = orgTypeNum == null || orgTypeNum.isEmpty() ? BosOrgBizTypeEnum.BOS_ORG.getNumber() : orgTypeNum;
            String cacheKey = acctItem + finalOrgTypeNum;
            checkResult = typeCache.computeIfAbsent(cacheKey, key -> OrgUnitServiceHelper.checkOrgFunction((Long)((Long)acctItem), (String)finalOrgTypeNum));
        }
        return checkResult;
    }

    public static String getOryTypeNameById(Long orgTypeId, String billType) {
        String orgType = "";
        if (orgTypeId != null && orgTypeId != 0L) {
            Map orgTypeNames = (Map)ThreadCache.get((Object)"orgbiztype_name", () -> new HashMap(4));
            orgType = orgTypeNames.computeIfAbsent(String.valueOf(orgTypeId), id -> {
                String sql = "select fname from t_org_bizlist where fid=" + id;
                return (String)DB.query((DBRoute)DBRoute.basedata, (String)sql, result -> {
                    if (result.next()) {
                        return result.getString("fname");
                    }
                    return "";
                });
            });
        } else if ("bos_adminorg".equals(billType)) {
            orgType = BosOrgBizTypeEnum.ADMINISTRATIVE.getName();
        } else if ("bos_org".equals(billType)) {
            orgType = BosOrgBizTypeEnum.BOS_ORG.getName();
        }
        return orgType;
    }
}

