/*
 * Decompiled with CFR 0.152.
 */
package kd.fi.ai.util;

import java.util.ArrayList;
import java.util.HashSet;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.entity.DynamicObjectCollection;
import kd.bos.orm.query.QFilter;
import kd.bos.servicehelper.BusinessDataServiceHelper;
import kd.bos.servicehelper.QueryServiceHelper;
import kd.bos.servicehelper.basedata.BaseDataServiceHelper;

public class AsstConditionUtil {
    private AsstConditionUtil() {
        throw new IllegalStateException("Utility class");
    }

    public static boolean isCommitCondition(String baseEntityKey, Long orgId, Long bookTypeId, Object acctItem) {
        HashSet<Long> accountingSysIds = new HashSet<Long>();
        ArrayList<QFilter> qFilters = new ArrayList<QFilter>();
        if (orgId == 0L) {
            return false;
        }
        QFilter filter = BaseDataServiceHelper.getBaseDataFilter((String)baseEntityKey, (Long)orgId);
        if (filter != null) {
            qFilters.add(filter);
        }
        qFilters.add(new QFilter("status", "=", (Object)"C"));
        qFilters.add(new QFilter("enable", "=", (Object)"1"));
        ArrayList<QFilter> booksQfilters = new ArrayList<QFilter>();
        booksQfilters.add(new QFilter("org", "=", (Object)orgId));
        if (bookTypeId != 0L) {
            booksQfilters.add(new QFilter("bookstype", "=", (Object)bookTypeId));
        }
        DynamicObjectCollection books = QueryServiceHelper.query((String)"gl_accountbook", (String)"accountingsys.id id", (QFilter[])booksQfilters.toArray(new QFilter[0]));
        for (Object book : books) {
            accountingSysIds.add(book.getLong("id"));
        }
        HashSet<Long> orgIdSet = new HashSet<Long>(16);
        for (Long accountingSysId : accountingSysIds) {
            DynamicObject accountingsys = BusinessDataServiceHelper.loadSingleFromCache((Object)accountingSysId, (String)"bd_accountingsys", (String)"bizorgentry.bizacctorg,bizorgentry.bizorg");
            DynamicObjectCollection bizOrgEntry = accountingsys.getDynamicObjectCollection("bizorgentry");
            orgIdSet.add(orgId);
            for (DynamicObject bizOrgRow : bizOrgEntry) {
                if (orgId == null || !orgId.equals(bizOrgRow.getLong("bizacctorg.id"))) continue;
                orgIdSet.add(bizOrgRow.getLong("bizorg.id"));
            }
        }
        QFilter orgFilter = new QFilter("openorg", "in", orgIdSet);
        boolean hasOrgFilterFlag = false;
        for (QFilter qFilter : qFilters) {
            if (!"id".equals(qFilter.getProperty())) continue;
            qFilter.or(orgFilter);
            hasOrgFilterFlag = true;
            break;
        }
        if (!hasOrgFilterFlag) {
            qFilters.add(orgFilter);
        }
        if (baseEntityKey.equals("cas_accountcash")) {
            qFilters.add(new QFilter("closestatus", "=", (Object)"0"));
        } else {
            qFilters.add(new QFilter("acctstatus", "=", (Object)"normal"));
        }
        qFilters.add(new QFilter("id", "=", acctItem));
        return QueryServiceHelper.exists((String)baseEntityKey, (QFilter[])qFilters.toArray(new QFilter[0]));
    }

    public static boolean isBank(String entityName) {
        return "bd_accountbanks".equals(entityName) || "cas_accountcash".equals(entityName) || "am_accountbank".equals(entityName);
    }
}

