/*
 * Decompiled with CFR 0.152.
 */
package kd.fi.ai.util;

import java.util.ArrayList;
import java.util.Collection;
import java.util.Comparator;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.Stack;
import java.util.function.Supplier;
import kd.bos.dataentity.metadata.IDataEntityProperty;
import kd.bos.dataentity.metadata.IDataEntityType;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.dataentity.serialization.SerializationUtils;
import kd.bos.dataentity.utils.StringUtils;
import kd.bos.entity.EntityMetadataCache;
import kd.bos.entity.EntityType;
import kd.bos.entity.EntryType;
import kd.bos.entity.MainEntityType;
import kd.bos.entity.botp.CRCondition;
import kd.bos.entity.filter.FilterBuilder;
import kd.bos.entity.filter.FilterCondition;
import kd.bos.entity.property.BasedataProp;
import kd.bos.entity.tree.TreeNode;
import kd.bos.formula.FormulaEngine;
import kd.bos.servicehelper.MetadataServiceHelper;
import kd.fi.ai.ExpressionType;
import kd.fi.ai.VchExpireDate;
import kd.fi.ai.enums.Token;
import kd.fi.ai.util.AiEventMetaUtil;
import kd.fi.ai.util.EntityFieldTreeOption;
import kd.fi.ai.util.EntityFieldTreeResult;
import kd.fi.ai.util.EntityTreeUtil;
import org.apache.commons.collections4.CollectionUtils;

public class BuildTree {
    public static TreeNode buildTree(MainEntityType srcMainET, String key, ExpressionType type, boolean readChildEntity, Class<?> cls, boolean IncludeID, boolean isAddDate) {
        return BuildTree.buildTree(srcMainET, key, type, readChildEntity, cls, IncludeID, isAddDate, null);
    }

    public static TreeNode buildTree(MainEntityType srcMainET, String key, ExpressionType type, boolean readChildEntity, Class<?> cls, boolean IncludeID) {
        return BuildTree.buildTree(srcMainET, key, type, readChildEntity, cls, IncludeID, true, null);
    }

    public static TreeNode buildTree(MainEntityType srcMainET, String key, ExpressionType type, boolean readChildEntity, Class<?> cls, boolean IncludeID, Set<String> entrySet) {
        return BuildTree.buildTree(srcMainET, key, type, readChildEntity, cls, IncludeID, true, entrySet);
    }

    private static TreeNode buildTree(MainEntityType srcMainET, String key, ExpressionType type, boolean readChildEntity, Class<?> cls, boolean IncludeID, boolean isAddDate, Set<String> entrySet) {
        return BuildTree.entityBuildTree(srcMainET, type, readChildEntity, cls, IncludeID, isAddDate, entrySet);
    }

    private static TreeNode entityBuildTree(MainEntityType srcMainET, ExpressionType type, boolean readChildEntity, Class<?> cls, boolean IncludeID, boolean isAddDate, Set<String> entrySet) {
        EntityFieldTreeOption option = EntityFieldTreeOption.create();
        option.setEntityType((IDataEntityType)srcMainET);
        option.setReadEntryEntity(readChildEntity);
        option.setExprType(type);
        option.setFieldType(cls);
        option.setIncludeID(IncludeID);
        option.setEntrySet(entrySet);
        option.setAddDate(isAddDate);
        EntityFieldTreeResult result = EntityTreeUtil.getEntityFieldNodes(option);
        return EntityTreeUtil.buildBillTree(result.getNodes());
    }

    public static TreeNode buildSimpleTree(MainEntityType srcMainET, String key, ExpressionType type, boolean readChildEntity, Class<?> cls, boolean IncludeID) {
        return BuildTree.buildSimpleTree(srcMainET, key, type, readChildEntity, cls, IncludeID, null, true);
    }

    public static TreeNode buildSimpleTree(MainEntityType srcMainET, String key, ExpressionType type, boolean readChildEntity, Class<?> cls, boolean IncludeID, Set<String> entrySet, boolean addSpecialNodes) {
        EntityFieldTreeOption option = EntityFieldTreeOption.create();
        option.setEntityType((IDataEntityType)srcMainET);
        option.setReadEntryEntity(readChildEntity);
        option.setExprType(type);
        option.setFieldType(cls);
        option.setIncludeID(IncludeID);
        option.setEntrySet(entrySet);
        if (!addSpecialNodes) {
            option.setAddDate(false);
        }
        EntityFieldTreeResult result = EntityTreeUtil.getEntitySimNodes(option);
        return EntityTreeUtil.buildBillTree(result.getNodes());
    }

    public static List<TreeNode> buildSimpleLevelTree(MainEntityType srcMainET, String key, ExpressionType type, boolean readChildEntity, Class<?> cls, boolean IncludeID, String nodeId) {
        EntityFieldTreeOption option = EntityFieldTreeOption.create();
        option.setEntityType((IDataEntityType)srcMainET);
        option.setReadEntryEntity(readChildEntity);
        option.setExprType(type);
        option.setFieldType(cls);
        option.setIncludeID(IncludeID);
        option.setNodeId(nodeId);
        EntityFieldTreeResult result = EntityTreeUtil.getEntitySimLevelNodes(option);
        List<TreeNode> nodes = result.getNodes();
        return nodes;
    }

    public static MainEntityType getMainType(String isEvent, String id) {
        MainEntityType srcMainET = new MainEntityType();
        srcMainET = StringUtils.isNotBlank((CharSequence)isEvent) ? AiEventMetaUtil.getEntityType(Long.parseLong(id)) : MetadataServiceHelper.getDataEntityType((String)id);
        return srcMainET;
    }

    public static MainEntityType getMainEntityType(String sourceBill, boolean isEvent) {
        MainEntityType srcMainEntityType = null;
        if (StringUtils.isEmpty((CharSequence)sourceBill)) {
            return srcMainEntityType;
        }
        srcMainEntityType = isEvent ? AiEventMetaUtil.getEntityType(Long.valueOf(sourceBill)) : EntityMetadataCache.getDataEntityType((String)sourceBill);
        return srcMainEntityType;
    }

    public static TreeNode searchTree(String searchText, TreeNode rootNode) {
        if (StringUtils.isNotBlank((CharSequence)searchText) && CollectionUtils.isNotEmpty((Collection)rootNode.getChildren())) {
            rootNode.setChildren(BuildTree.getContains(rootNode.getChildren(), searchText));
        }
        return rootNode;
    }

    private static List<TreeNode> getContains(List<TreeNode> childrens, String searchText) {
        Iterator<TreeNode> iterator = childrens.iterator();
        while (iterator.hasNext()) {
            TreeNode treeNode = iterator.next();
            if (CollectionUtils.isNotEmpty((Collection)treeNode.getChildren())) {
                treeNode.setChildren(BuildTree.getContains(treeNode.getChildren(), searchText));
            }
            if (!CollectionUtils.isEmpty((Collection)treeNode.getChildren()) || treeNode.getText().contains(searchText)) continue;
            iterator.remove();
        }
        return childrens;
    }

    public static String getLongName(String nodeID, String json) {
        TreeNode parent;
        TreeNode rootNode = new TreeNode();
        rootNode = (TreeNode)SerializationUtils.fromJsonString((String)json, TreeNode.class);
        TreeNode parentNode = rootNode.getTreeNode(nodeID, 6);
        if (null == parentNode) {
            return null;
        }
        Stack<String> stack = new Stack<String>();
        stack.push(parentNode.getText());
        while (StringUtils.isNotEmpty((CharSequence)parentNode.getParentid()) && !StringUtils.isEmpty((CharSequence)(parent = rootNode.getTreeNode(parentNode.getParentid(), 5)).getParentid())) {
            parentNode = parent;
            stack.push(parentNode.getText());
        }
        int size = stack.size();
        StringBuilder builder = new StringBuilder();
        for (int j = 0; j < size; ++j) {
            builder.append((String)stack.pop()).append(".");
        }
        String varCaption = builder.substring(0, builder.length() - 1);
        return varCaption;
    }

    private static String getSpecialFieldName(String expr) {
        String tansExpr = null;
        if ("Dapfield_newdate".equalsIgnoreCase(expr)) {
            tansExpr = VchExpireDate.newDateAlias();
        } else if ("Dapfield_firstdate".equalsIgnoreCase(expr)) {
            tansExpr = VchExpireDate.firstDateAlias();
        } else if ("Dapfield_lastdate".equalsIgnoreCase(expr)) {
            tansExpr = VchExpireDate.lastDateAlias();
        } else if ("sscApproveMsg".equalsIgnoreCase(expr)) {
            tansExpr = ResManager.loadKDString((String)"\u5171\u4eab\u5ba1\u6279\u4fe1\u606f", (String)"BuildTree_1", (String)"fi-ai-common", (Object[])new Object[0]);
        } else if ("sscInnerMsg".equalsIgnoreCase(expr)) {
            tansExpr = ResManager.loadKDString((String)"\u5171\u4eab\u5185\u90e8\u8bf4\u660e", (String)"BuildTree_2", (String)"fi-ai-common", (Object[])new Object[0]);
        } else if ("@autoCal".equalsIgnoreCase(expr)) {
            return ResManager.loadKDString((String)"\u7cfb\u7edf\u81ea\u52a8\u8ba1\u7b97", (String)"BuildTree_0", (String)"fi-ai-common", (Object[])new Object[0]);
        }
        return tansExpr;
    }

    public static String getLongName(String nodeID, MainEntityType meta) {
        String varCaption;
        if (meta == null || StringUtils.isEmpty((CharSequence)nodeID)) {
            return "";
        }
        if (nodeID.startsWith("{")) {
            nodeID = nodeID.substring(1, nodeID.length() - 1);
        }
        if ((varCaption = BuildTree.getSpecialFieldName(nodeID)) == null) {
            String[] props = nodeID.split("\\.");
            StringBuilder builder = new StringBuilder();
            IDataEntityProperty directProp = (IDataEntityProperty)meta.getAllFields().get(props[0]);
            if (directProp == null) {
                return "";
            }
            IDataEntityType parent = directProp.getParent();
            if (parent instanceof EntryType) {
                EntryType pe = (EntryType)parent;
                builder.append(pe.getDisplayName()).append(".");
            }
            builder.append(directProp.getDisplayName()).append(".");
            if (props.length > 1) {
                BasedataProp baseP;
                MainEntityType type;
                for (int j = 1; j < props.length && directProp instanceof BasedataProp && (type = EntityMetadataCache.getDataEntityType((String)(baseP = (BasedataProp)directProp).getBaseEntityId())) != null; ++j) {
                    directProp = (IDataEntityProperty)type.getAllFields().get(props[j]);
                    if (directProp == null) {
                        Map allEntry = type.getAllEntities();
                        if (allEntry == null || !allEntry.containsKey(props[j])) break;
                        EntityType et = (EntityType)allEntry.get(props[j]);
                        builder.append(et.getDisplayName()).append(".");
                        if (j + 1 >= props.length || (directProp = (IDataEntityProperty)et.getFields().get(props[++j])) == null) continue;
                        builder.append(directProp.getDisplayName()).append(".");
                        continue;
                    }
                    builder.append(directProp.getDisplayName()).append(".");
                }
            }
            varCaption = builder.substring(0, builder.length() - 1);
        }
        return varCaption;
    }

    public static String tranExpression(String expression, MainEntityType meta) {
        if (meta == null) {
            return expression;
        }
        if (StringUtils.isBlank((CharSequence)expression)) {
            return "";
        }
        if ("@autoCal".equalsIgnoreCase(expression)) {
            return ResManager.loadKDString((String)"\u7cfb\u7edf\u81ea\u52a8\u8ba1\u7b97", (String)"BuildTree_0", (String)"fi-ai-common", (Object[])new Object[0]);
        }
        String expressionDesc = expression;
        String[] vars = new String[]{};
        try {
            int endIndex = expression.indexOf(123);
            vars = endIndex != -1 ? BuildTree.extractVariables(expression) : FormulaEngine.extractVariables((String)expression);
        }
        catch (Throwable e) {
            return expression;
        }
        if (vars.length == 0 || StringUtils.isBlank((CharSequence)vars[0])) {
            return expressionDesc;
        }
        ArrayList<String> orderVars = new ArrayList<String>(vars.length);
        for (String string : vars) {
            orderVars.add(string);
        }
        orderVars.sort(new Comparator<String>(){

            @Override
            public int compare(String o1, String o2) {
                if (o1.length() > o2.length()) {
                    return -1;
                }
                if (o1.length() < o2.length()) {
                    return 1;
                }
                return o2.compareTo(o1);
            }
        });
        HashMap<String, String> tmpVariables = new HashMap<String, String>(orderVars.size());
        int i = 1;
        Iterator<Object> iterator = orderVars.iterator();
        while (iterator.hasNext()) {
            String string;
            String paramVar = string = (String)iterator.next();
            int endIndex = expression.indexOf(123);
            if (endIndex != -1) {
                paramVar = "{" + string + "}";
            }
            String tempVariable = String.format("###%s###", String.valueOf(i));
            String varCaption = BuildTree.getLongName(paramVar, meta);
            if (StringUtils.isEmpty((CharSequence)varCaption)) {
                varCaption = string;
            }
            if (StringUtils.isNotBlank((CharSequence)string)) {
                tmpVariables.put(tempVariable, varCaption);
                expressionDesc = expressionDesc.replace(string, tempVariable);
            }
            ++i;
        }
        for (Map.Entry entry : tmpVariables.entrySet()) {
            expressionDesc = expressionDesc.replace((CharSequence)entry.getKey(), (CharSequence)entry.getValue());
        }
        return expressionDesc;
    }

    public static String tranExpression(String expression, String json) {
        if (StringUtils.isBlank((CharSequence)expression)) {
            return "";
        }
        if ("@autoCal".equalsIgnoreCase(expression)) {
            return ResManager.loadKDString((String)"\u7cfb\u7edf\u81ea\u52a8\u8ba1\u7b97", (String)"BuildTree_0", (String)"fi-ai-common", (Object[])new Object[0]);
        }
        String expressionDesc = expression;
        String[] vars = new String[]{};
        try {
            int endIndex = expression.indexOf(123);
            vars = endIndex != -1 ? BuildTree.extractVariables(expression) : FormulaEngine.extractVariables((String)expression);
        }
        catch (Throwable e) {
            return expression;
        }
        if (vars.length == 0 || StringUtils.isBlank((CharSequence)vars[0])) {
            return expressionDesc;
        }
        ArrayList<String> orderVars = new ArrayList<String>(vars.length);
        for (String string : vars) {
            orderVars.add(string);
        }
        orderVars.sort(new Comparator<String>(){

            @Override
            public int compare(String o1, String o2) {
                if (o1.length() > o2.length()) {
                    return -1;
                }
                if (o1.length() < o2.length()) {
                    return 1;
                }
                return o2.compareTo(o1);
            }
        });
        HashMap<String, String> tmpVariables = new HashMap<String, String>(orderVars.size());
        int i = 1;
        Iterator<Object> iterator = orderVars.iterator();
        while (iterator.hasNext()) {
            String string;
            String paramVar = string = (String)iterator.next();
            int endIndex = expression.indexOf(123);
            if (endIndex != -1) {
                paramVar = "{" + string + "}";
            }
            String tempVariable = String.format("###%s###", String.valueOf(i));
            String varCaption = BuildTree.getLongName(paramVar, json);
            if (null == varCaption) {
                varCaption = string;
            }
            if (StringUtils.isNotBlank((CharSequence)string)) {
                tmpVariables.put(tempVariable, varCaption);
                expressionDesc = expressionDesc.replace(string, tempVariable);
            }
            ++i;
        }
        for (Map.Entry entry : tmpVariables.entrySet()) {
            expressionDesc = expressionDesc.replace((CharSequence)entry.getKey(), (CharSequence)entry.getValue());
        }
        return expressionDesc;
    }

    public static String[] extractVariables(String expression) {
        ArrayList<String> variables = new ArrayList<String>();
        int len = expression.length();
        Token token = Token.Text;
        for (int pos = 0; pos < len; ++pos) {
            char c = expression.charAt(pos);
            switch (c) {
                case '{': {
                    boolean condition = pos + 1 < len && expression.charAt(pos + 1) == '{';
                    Token token2 = token = condition ? Token.Escape : Token.Variable;
                }
            }
            if (token != Token.Variable) continue;
            int endIndex = expression.indexOf(125, pos + 1);
            if (endIndex == -1) break;
            String variableName = expression.substring(pos + 1, endIndex);
            variables.add(variableName);
            pos = endIndex;
            token = Token.Text;
        }
        return variables.toArray(new String[variables.size()]);
    }

    public static String tranVchTplFormula(CRCondition condition, String entityNumber, boolean isEvent) {
        if (condition == null || StringUtils.isEmpty((CharSequence)entityNumber)) {
            return "";
        }
        MainEntityType mainType = isEvent ? AiEventMetaUtil.getEntityType(Long.valueOf(entityNumber)) : EntityMetadataCache.getDataEntityType((String)entityNumber);
        return BuildTree.tranVchTplFormula(condition, mainType);
    }

    public static String tranVchTplFormula(CRCondition condition, MainEntityType mainType) {
        String tranExpr;
        FilterBuilder filterBuilder;
        String[] scripts;
        if (condition == null || mainType == null) {
            return "";
        }
        ArrayList<String> desc = new ArrayList<String>(2);
        FilterCondition filterCondition = condition.getFilterCondition();
        if (filterCondition != null && !filterCondition.getFilterRow().isEmpty() && StringUtils.isNotBlank((CharSequence)(scripts = (filterBuilder = new FilterBuilder(mainType, filterCondition)).buildFilterScript())[1])) {
            desc.add(scripts[1]);
        }
        if (StringUtils.isNotEmpty((CharSequence)condition.getExpression()) && StringUtils.isNotBlank((CharSequence)(tranExpr = BuildTree.tranExpression(condition.getExpression(), mainType)))) {
            desc.add(tranExpr);
        }
        tranExpr = desc.size() >= 2 ? String.format(ResManager.loadKDString((String)"%1$s \u4e14 %2$s", (String)"BuildTree_3", (String)"fi-ai-common", (Object[])new Object[0]), desc.get(0), desc.get(1)) : (desc.size() == 1 ? (String)desc.get(0) : "");
        return tranExpr == null ? "" : tranExpr;
    }

    public static String multiLangDesc(String description, String transDesc, Supplier<String> transFunc) {
        return StringUtils.isBlank((CharSequence)description) || description.equals(transDesc) ? transFunc.get() : description;
    }

    public static String multiLangDesc(String description, Supplier<String> transFunc) {
        return StringUtils.isBlank((CharSequence)description) ? transFunc.get() : description;
    }

    public static String multiLangDesc(String description, String expression, MainEntityType mainType) {
        return description == null || description.equals(BuildTree.tranExpression(expression, mainType)) ? "" : description;
    }
}

