/*
 * Decompiled with CFR 0.152.
 */
package kd.fi.ai.util;

import java.util.ArrayList;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.entity.DynamicObjectCollection;
import kd.bos.dataentity.utils.StringUtils;
import kd.bos.entity.EntityMetadataCache;
import kd.bos.entity.MainEntityType;
import kd.bos.entity.operate.Operations;
import kd.bos.entity.property.BillStatusProp;
import kd.bos.form.FormShowParameter;
import kd.bos.form.IPageCache;
import kd.bos.form.ShowFormHelper;
import kd.bos.list.ListFilterParameter;
import kd.bos.list.ListShowParameter;
import kd.bos.orm.query.QFilter;
import kd.bos.servicehelper.BusinessDataServiceHelper;
import kd.bos.servicehelper.QueryServiceHelper;
import kd.bos.servicehelper.basedata.BaseDataServiceHelper;

public class CreateFormList {
    private CreateFormList() {
    }

    public static FormShowParameter createShowListForm(String entityID, IPageCache pageCache) {
        QFilter idsQF;
        ListShowParameter formShowParameter = null;
        switch (entityID) {
            case "bos_adminorg": {
                formShowParameter = (ListShowParameter)CreateFormList.createOrgShowListForm("bos_org", "01", "\u884c\u653f\u804c\u80fd");
                break;
            }
            default: {
                formShowParameter = ShowFormHelper.createShowListForm((String)entityID, (boolean)false);
            }
        }
        QFilter filter = CreateFormList.getStatusFilter(entityID);
        if (filter != null) {
            List qFilters = formShowParameter.getListFilterParameter().getQFilters();
            qFilters.add(filter);
        }
        if ((idsQF = CreateFormList.getBaseDateIds(entityID, pageCache.get("orgid"))) != null) {
            List qFilters = formShowParameter.getListFilterParameter().getQFilters();
            qFilters.add(idsQF);
        }
        return formShowParameter;
    }

    private static QFilter getBaseDateIds(String entityID, String orgid) {
        if (StringUtils.isNotBlank((CharSequence)orgid)) {
            return BaseDataServiceHelper.getBaseDataFilter((String)entityID, (Long)Long.parseLong(orgid));
        }
        return null;
    }

    public static FormShowParameter createBankShowListForm(String entityID, IPageCache pageCache) {
        ListShowParameter para = ShowFormHelper.createShowListForm((String)entityID, (boolean)false);
        ListFilterParameter listFilterParameter = para.getListFilterParameter();
        List<QFilter> qFilters = listFilterParameter.getQFilters();
        qFilters = CreateFormList.getOtherQfilters(entityID, qFilters, pageCache);
        return para;
    }

    private static List<QFilter> getOtherQfilters(String entityID, List<QFilter> qFilters, IPageCache pageCache) {
        Long orgId = 0L;
        Long bookTypeId = 0L;
        String orgidStr = pageCache.get("orgid");
        String bookTypeStr = pageCache.get("booktype");
        if (!"null".equals(orgidStr) && !StringUtils.isEmpty((CharSequence)orgidStr)) {
            orgId = Long.parseLong(orgidStr);
        }
        if (!"null".equals(bookTypeStr) && !StringUtils.isEmpty((CharSequence)bookTypeStr)) {
            bookTypeId = Long.parseLong(bookTypeStr);
        }
        HashSet<Long> accountingSysIds = new HashSet<Long>();
        if (orgId == 0L) {
            return qFilters;
        }
        QFilter filter = BaseDataServiceHelper.getBaseDataFilter((String)entityID, (Long)orgId);
        if (filter != null) {
            qFilters.add(filter);
        }
        qFilters.add(new QFilter("status", "=", (Object)"C"));
        qFilters.add(new QFilter("enable", "=", (Object)"1"));
        ArrayList<QFilter> booksQfilters = new ArrayList<QFilter>();
        booksQfilters.add(new QFilter("org", "=", (Object)orgId));
        if (bookTypeId != 0L) {
            booksQfilters.add(new QFilter("bookstype", "=", (Object)bookTypeId));
        }
        DynamicObjectCollection books = QueryServiceHelper.query((String)"gl_accountbook", (String)"accountingsys.id id", (QFilter[])booksQfilters.toArray(new QFilter[0]));
        for (Object book : books) {
            accountingSysIds.add(book.getLong("id"));
        }
        HashSet<Long> orgIdSet = new HashSet<Long>(16);
        for (Long accountingSysId : accountingSysIds) {
            DynamicObject accountingsys = BusinessDataServiceHelper.loadSingleFromCache((Object)accountingSysId, (String)"bd_accountingsys", (String)"bizorgentry.bizacctorg,bizorgentry.bizorg");
            DynamicObjectCollection bizOrgEntry = accountingsys.getDynamicObjectCollection("bizorgentry");
            orgIdSet.add(orgId);
            for (DynamicObject bizOrgRow : bizOrgEntry) {
                if (orgId == null || !orgId.equals(bizOrgRow.getLong("bizacctorg.id"))) continue;
                orgIdSet.add(bizOrgRow.getLong("bizorg.id"));
            }
        }
        QFilter orgFilter = new QFilter("openorg", "in", orgIdSet);
        boolean hasOrgFilterFlag = false;
        for (QFilter qFilter : qFilters) {
            if (!"id".equals(qFilter.getProperty())) continue;
            qFilter.or(orgFilter);
            hasOrgFilterFlag = true;
            break;
        }
        if (!hasOrgFilterFlag) {
            qFilters.add(orgFilter);
        }
        if (entityID.equals("cas_accountcash")) {
            qFilters.add(new QFilter("closestatus", "=", (Object)"0"));
        } else {
            qFilters.add(new QFilter("acctstatus", "=", (Object)"normal"));
        }
        return qFilters;
    }

    public static FormShowParameter createOrgShowListForm(String entityID, String orgFunc, String orgPropName) {
        ListShowParameter para = ShowFormHelper.createShowListForm((String)entityID, (boolean)false, (int)1);
        para.setCustomParam("islockfunc", (Object)Boolean.TRUE);
        para.setCustomParam("orgFuncId", (Object)orgFunc);
        para.setCustomParam("entityId", (Object)entityID);
        boolean isOrgBaseAdmin = true;
        para.setCustomParam("isOrgBaseAdmin", (Object)isOrgBaseAdmin);
        para.setCustomParam("orgPropName", (Object)orgPropName);
        return para;
    }

    private static QFilter getStatusFilter(String baseEntityId) {
        MainEntityType dataEntityType;
        BillStatusProp statusProperty;
        String statusFieldKey;
        Map opParam;
        Map opMeta;
        QFilter filter = null;
        Operations ops = EntityMetadataCache.getDataEntityOperations((String)baseEntityId);
        if (ops != null && StringUtils.isNotBlank((CharSequence)ops.getAudit()) && (opMeta = EntityMetadataCache.getDataEntityOperate((String)baseEntityId, (String)ops.getAudit())) != null && opMeta.containsKey("parameter") && (opParam = (Map)opMeta.get("parameter")) != null && opParam.containsKey("statusProp") && opParam.containsKey("value") && StringUtils.isNotBlank((CharSequence)(statusFieldKey = (String)opParam.get("statusProp"))) && (statusProperty = (BillStatusProp)(dataEntityType = EntityMetadataCache.getDataEntityType((String)baseEntityId)).getProperty(statusFieldKey)) != null && StringUtils.isNotBlank((CharSequence)statusProperty.getAlias())) {
            String val = (String)opParam.get("value");
            filter = new QFilter(statusFieldKey, "=", (Object)val);
        }
        return filter;
    }
}

