/*
 * Decompiled with CFR 0.152.
 */
package kd.fi.ai.util;

import java.io.BufferedInputStream;
import java.io.BufferedOutputStream;
import java.io.ByteArrayOutputStream;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.io.OutputStreamWriter;
import java.net.MalformedURLException;
import java.net.URL;
import java.util.HashMap;
import java.util.LinkedHashMap;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import java.util.zip.ZipEntry;
import java.util.zip.ZipInputStream;
import java.util.zip.ZipOutputStream;
import kd.bos.cache.CacheFactory;
import kd.bos.cache.tempfile.TempFileCacheDownloadable;
import kd.bos.context.RequestContext;
import kd.bos.dataentity.OperateOption;
import kd.bos.dataentity.TypesContainer;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.entity.DynamicObjectCollection;
import kd.bos.dataentity.entity.ILocaleString;
import kd.bos.dataentity.entity.ILocaleValue;
import kd.bos.dataentity.entity.LocaleString;
import kd.bos.dataentity.metadata.IDataEntityProperty;
import kd.bos.dataentity.metadata.clr.DataEntityPropertyCollection;
import kd.bos.dataentity.metadata.dynamicobject.DynamicLocaleProperty;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.dataentity.serialization.SerializationUtils;
import kd.bos.dataentity.utils.StringUtils;
import kd.bos.entity.EntityMetadataCache;
import kd.bos.entity.EntityType;
import kd.bos.entity.MainEntityType;
import kd.bos.entity.operate.result.OperationResult;
import kd.bos.entity.property.BasedataProp;
import kd.bos.entity.property.MulBasedataProp;
import kd.bos.entity.property.MuliLangTextProp;
import kd.bos.logging.Log;
import kd.bos.logging.LogFactory;
import kd.bos.orm.ORM;
import kd.bos.orm.query.QFilter;
import kd.bos.servicehelper.BusinessDataServiceHelper;
import kd.bos.servicehelper.QueryServiceHelper;
import kd.bos.servicehelper.operation.OperationServiceHelper;
import kd.bos.util.ConfigurationUtil;
import kd.fi.ai.VCHTemplate;
import kd.fi.ai.VchExpireDate;
import kd.fi.ai.VchFormulaFilterSetRow;
import kd.fi.ai.VchTplExpression;
import kd.fi.ai.VchTplVoucherType;
import kd.fi.ai.convert.VchTemplateConvertHelper;
import kd.fi.ai.util.AiEventMetaUtil;
import kd.fi.ai.util.ThrowableHelper;
import org.apache.commons.io.FilenameUtils;

public class DapFileUtil {
    private static Log log = LogFactory.getLog(DapFileUtil.class);
    private static ThreadLocal<Long> orgId = new ThreadLocal();

    public static Long getOrgId() {
        return orgId.get();
    }

    public static void setOrgId(Long orgID) {
        orgId.set(orgID);
    }

    public static Map<String, String> exportTemplate(String exportPath, long[] templateIds) {
        HashMap<String, String> exportResult = new HashMap<String, String>();
        for (long templateId : templateIds) {
            DapFileUtil.exportTemplateFile(exportPath, templateId, exportResult);
        }
        if (exportResult.get("warning") != null) {
            return exportResult;
        }
        if (exportResult.get("error") != null) {
            return exportResult;
        }
        String zipPath = exportPath + File.separator + "vouchertemplate";
        File zipFilePath = new File(FilenameUtils.getFullPath((String)zipPath), FilenameUtils.getName((String)zipPath));
        String[] files = new String[1];
        if (zipFilePath.exists()) {
            files[0] = zipPath;
        }
        String localPath = exportPath + File.separator + templateIds[0] + ".zip";
        File zipFile = new File(FilenameUtils.getFullPath((String)localPath), FilenameUtils.getName((String)localPath));
        try (ZipOutputStream out = new ZipOutputStream(new BufferedOutputStream(new FileOutputStream(zipFile)));){
            DapFileUtil.zipFile(files, out);
        }
        catch (IOException e) {
            throw new RuntimeException(e);
        }
        if (zipFile.exists()) {
            exportResult.put("fileName", zipFile.getPath());
        }
        DapFileUtil.deleteFile(zipPath);
        exportResult.put("success", ResManager.loadKDString((String)"\u5907\u4efd\u6210\u529f", (String)"DapFileUtil_0", (String)"fi-ai-common", (Object[])new Object[0]));
        return exportResult;
    }

    public static void exportTemplateFile(String exportPath, long templateId, Map<String, String> checkInMsg) {
        DynamicObject vchTpl = BusinessDataServiceHelper.loadSingle((Object)templateId, (String)"ai_vchtemplate");
        String name = vchTpl.getString("number");
        if (name.contains("/")) {
            checkInMsg.put("warning", ResManager.loadKDString((String)"\u9009\u4e2d\u7684\u6a21\u677f\u7f16\u7801\u4e2d\u542b\u6709\u201c/\u201d\uff0c\u8bf7\u4fee\u6539\u540e\u5bfc\u51fa\u3002", (String)"DapFileUtil_8", (String)"fi-ai-common", (Object[])new Object[0]));
            return;
        }
        String xml = VchTemplateConvertHelper.convertToXML("ai_vchtemplate", vchTpl);
        DapFileUtil.saveTplFile(exportPath, vchTpl.getString("number") + ".xml", xml, checkInMsg);
    }

    private static String saveTplFile(String exportPath, String fileName, String fileContext, Map<String, String> checkInMsg) {
        try {
            File file;
            String fullPath = DapFileUtil.getFullPath(exportPath, fileName);
            String[] abovePath = fullPath.split(fileName);
            File fileAbovePath = new File(FilenameUtils.getFullPath((String)abovePath[0]), FilenameUtils.getName((String)abovePath[0]));
            if (!fileAbovePath.exists()) {
                fileAbovePath.mkdirs();
            }
            if ((file = new File(FilenameUtils.getFullPath((String)fullPath), FilenameUtils.getName((String)fullPath))).exists() && !file.delete()) {
                throw new RuntimeException(String.format(ResManager.loadKDString((String)"\u5bfc\u51fa\u51fa\u9519\uff1a\u521b\u5efa\u5bfc\u51fa\u4e34\u65f6\u6587\u4ef6\u201c%s\u201d\u65f6\uff0c\u5df2\u5b58\u5728\u540c\u540d\u6587\u4ef6\u4e14\u65e0\u6cd5\u5220\u9664\uff0c\u8bf7\u5220\u9664\u8be5\u6587\u4ef6\u3002", (String)"DapFileUtil_1", (String)"fi-ai-common", (Object[])new Object[0]), fullPath));
            }
            if (!file.createNewFile()) {
                throw new RuntimeException(String.format(ResManager.loadKDString((String)"\u521b\u5efa\u6587\u4ef6\u51fa\u9519\uff0c\u6587\u4ef6\u201c%s\u201d\u4e0d\u5408\u6cd5\u3002", (String)"DapFileUtil_2", (String)"fi-ai-common", (Object[])new Object[0]), fullPath));
            }
            try (OutputStreamWriter writer = new OutputStreamWriter((OutputStream)new FileOutputStream(file), "UTF-8");){
                writer.write(fileContext);
            }
            return fullPath;
        }
        catch (IOException e) {
            log.error((Throwable)e);
            checkInMsg.put("error", String.format(ResManager.loadKDString((String)"\u6587\u4ef6\u201c%1$s\u201d\u751f\u6210\u65f6\u51fa\u73b0\u9519\u8bef\uff1a\u201c%2$s\u201d\u3002", (String)"DapFileUtil_5", (String)"fi-ai-common", (Object[])new Object[0]), fileName, e.getMessage()));
            return "";
        }
    }

    private static String getFullPath(String exportPath, String filename) {
        String fullPath = String.format("%s/vouchertemplate/%s", exportPath, filename);
        return fullPath;
    }

    private static void zipFile(String[] files, ZipOutputStream out) {
        try {
            for (String fileName : files) {
                File file = new File(FilenameUtils.getFullPath((String)fileName), FilenameUtils.getName((String)fileName));
                String path = file.getAbsolutePath();
                if (file.isDirectory()) {
                    File[] listFiles = file.listFiles();
                    String[] tempFiles = new String[listFiles.length];
                    int i = 0;
                    for (File tempFile : listFiles) {
                        tempFiles[i++] = tempFile.getAbsolutePath();
                    }
                    DapFileUtil.zipFile(tempFiles, out);
                    continue;
                }
                int t = -1;
                if (path.contains("vouchertemplate")) {
                    t = path.indexOf("vouchertemplate");
                }
                if (t == -1) {
                    return;
                }
                path = path.substring(t, path.length());
                try (BufferedInputStream in = new BufferedInputStream(new FileInputStream(file));){
                    ZipEntry entry = new ZipEntry(path);
                    entry.setMethod(8);
                    out.putNextEntry(entry);
                    int n = 0;
                    byte[] buf = new byte[1024];
                    while ((n = in.read(buf)) != -1) {
                        out.write(buf, 0, n);
                    }
                    out.closeEntry();
                }
            }
        }
        catch (Exception e) {
            log.error((Throwable)e);
        }
    }

    public static void deleteKd(File file) {
        if (!file.isDirectory()) {
            if (!file.delete()) {
                throw new RuntimeException(String.format(ResManager.loadKDString((String)"\u5220\u9664\u6587\u4ef6\u51fa\u9519\uff0c\u539f\u6587\u4ef6\u201c%s\u201d\u65e0\u6cd5\u5220\u9664\u3002", (String)"DapFileUtil_6", (String)"fi-ai-common", (Object[])new Object[0]), file.getAbsolutePath()));
            }
        } else if (file.isDirectory()) {
            File[] fileList = file.listFiles();
            for (int i = 0; i < fileList.length; ++i) {
                File delfile = fileList[i];
                if (!delfile.isDirectory()) {
                    if (delfile.delete()) continue;
                    throw new RuntimeException(String.format(ResManager.loadKDString((String)"\u5220\u9664\u6587\u4ef6\u51fa\u9519\uff0c\u539f\u6587\u4ef6\u201c%s\u201d\u65e0\u6cd5\u5220\u9664\u3002", (String)"DapFileUtil_6", (String)"fi-ai-common", (Object[])new Object[0]), delfile.getAbsolutePath()));
                }
                if (!delfile.isDirectory()) continue;
                DapFileUtil.deleteKd(fileList[i]);
            }
            if (!file.delete()) {
                throw new RuntimeException(String.format(ResManager.loadKDString((String)"\u5220\u9664\u6587\u4ef6\u51fa\u9519\uff0c\u539f\u6587\u4ef6\u201c%s\u201d\u65e0\u6cd5\u5220\u9664\u3002", (String)"DapFileUtil_6", (String)"fi-ai-common", (Object[])new Object[0]), file.getAbsolutePath()));
            }
        }
    }

    public static void deleteFile(String deletePath) {
        File file = new File(FilenameUtils.getFullPath((String)deletePath), FilenameUtils.getName((String)deletePath));
        DapFileUtil.deleteKd(file);
    }

    public static Map<String, String> uploadRule(String fileUrl, Long orgID) {
        return DapFileUtil.uploadRule(fileUrl, orgID, false);
    }

    public static Map<String, String> uploadRule(String fileUrl, Long orgID, boolean isUpdate) {
        HashMap<String, String> result = new HashMap<String, String>();
        TempFileCacheDownloadable downLoad = (TempFileCacheDownloadable)CacheFactory.getCommonCacheFactory().getTempFileCache();
        TempFileCacheDownloadable.Content zipContent = null;
        try {
            String[] queryParams = new URL(fileUrl).getQuery().split("&");
            HashMap<String, String> downloadFileParams = new HashMap<String, String>(queryParams.length);
            for (String queryParam : queryParams) {
                String[] p = queryParam.split("=");
                downloadFileParams.put(p[0], p[1]);
            }
            zipContent = downLoad.get((String)downloadFileParams.get("configKey"), (String)downloadFileParams.get("id"));
        }
        catch (MalformedURLException exp) {
            log.error((Throwable)exp);
            result.put("ERROR", exp.getMessage());
        }
        if (zipContent == null) {
            return result;
        }
        InputStream inputStream = zipContent.getInputStream();
        return DapFileUtil.inportVchZipfile(orgID, result, inputStream);
    }

    /*
     * Enabled aggressive exception aggregation
     */
    public static Map<String, String> inportVchZipfile(Long orgID, Map<String, String> result, InputStream inputStream) {
        String jsonFileSuffix = ".xml";
        int limitsiz = 0x500000;
        orgId.set(orgID);
        try (InputStream inStream = inputStream;
             ZipInputStream zipIn = new ZipInputStream(inStream);){
            ZipEntry zipEntry = null;
            while (true) {
                if ((zipEntry = zipIn.getNextEntry()) != null) {
                    if (zipEntry.isDirectory()) continue;
                    String metaName = zipEntry.getName();
                    int readLength = 0;
                    int len = 0;
                    byte[] buf = new byte[limitsiz];
                    if (!metaName.endsWith(jsonFileSuffix)) continue;
                    while ((readLength = zipIn.read()) != -1) {
                        buf[len] = (byte)readLength;
                        ++len;
                    }
                    String content = new String(buf, 0, len);
                    DynamicObject template = (DynamicObject)VchTemplateConvertHelper.formatXML("ai_vchtemplate", content);
                    if (template == null) continue;
                    DataEntityPropertyCollection properties = template.getDynamicObjectType().getProperties();
                    DynamicObject newTemp = DapFileUtil.createDynamicObject(template);
                    for (IDataEntityProperty prop : properties) {
                        if (template.getDynamicObjectType().getPrimaryKey().equals(prop) || prop instanceof DynamicLocaleProperty || prop.getName().contains("_id")) continue;
                        if (prop instanceof MuliLangTextProp) {
                            ILocaleString value = (ILocaleString)template.get(prop);
                            LocaleString newLoc = (LocaleString)TypesContainer.createInstance(LocaleString.class);
                            newLoc.setLocaleValue_en(value.getLocaleValue_en());
                            newLoc.setLocaleValue_zh_CN(value.getLocaleValue_zh_CN());
                            newLoc.setLocaleValue_zh_TW(value.getLocaleValue_zh_TW());
                            newTemp.set(prop, (Object)newLoc);
                            continue;
                        }
                        if (prop instanceof BasedataProp) {
                            DynamicObject propDObject = BusinessDataServiceHelper.newDynamicObject((String)((BasedataProp)prop).getBaseEntityId());
                            if (prop.getName().equals("fsourcebill")) {
                                propDObject.set("number", template.get(prop));
                            } else {
                                propDObject.set("id", template.get(prop));
                            }
                            newTemp.set(prop.getName() + "_id", template.get(prop));
                            newTemp.set(prop, (Object)propDObject);
                            continue;
                        }
                        if (prop instanceof MulBasedataProp) {
                            DynamicObjectCollection m = (DynamicObjectCollection)template.get(prop);
                            for (DynamicObject d : m) {
                                d.set("pkid", null);
                                Object baseid = d.get("fbasedataid_id");
                                d.set("fbasedataid_id", null);
                                d.set("fbasedataid_id", baseid);
                                Object basedata = d.get("fbasedataid");
                                d.set("fbasedataid", null);
                                d.set("fbasedataid", basedata);
                            }
                            newTemp.set(prop, (Object)m);
                            continue;
                        }
                        newTemp.set(prop, template.get(prop));
                    }
                    newTemp.set("ctrlstrategy", (Object)"");
                    StringBuffer billno = new StringBuffer(newTemp.getString("number"));
                    while (QueryServiceHelper.exists((String)"ai_vchtemplate", (QFilter[])new QFilter[]{new QFilter("number", "=", (Object)billno.toString())})) {
                        billno.append("#");
                    }
                    newTemp.set("number", (Object)billno.toString());
                    DapFileUtil.setOtherFields(newTemp);
                    DynamicObject org = BusinessDataServiceHelper.newDynamicObject((String)"bos_org");
                    org.set("id", (Object)orgID);
                    newTemp.set("createorg", (Object)org);
                    newTemp.set("org", (Object)org);
                    OperationResult operationResult = OperationServiceHelper.executeOperate((String)"save", (String)"ai_vchtemplate", (DynamicObject[])new DynamicObject[]{newTemp}, (OperateOption)OperateOption.create());
                    if (operationResult.isSuccess()) continue;
                    result.put("ERROR", String.format(ResManager.loadKDString((String)"\u5bfc\u5165\u5931\u8d25\uff0c\u539f\u56e0\uff1a\u201c%s\u201d\u3002", (String)"DapFileUtil_10", (String)"fi-ai-common", (Object[])new Object[0]), operationResult.getAllErrorOrValidateInfo()));
                    Map<String, String> map = result;
                    return map;
                    continue;
                }
                break;
            }
        }
        catch (Exception e) {
            log.error((Throwable)e);
            result.put("ERROR", StringUtils.isNotBlank((CharSequence)e.getMessage()) ? e.getMessage() : ThrowableHelper.toString(e));
        }
        result.put("SUCCESS", ResManager.loadKDString((String)"\u6062\u590d\u6210\u529f\u3002", (String)"DapFileUtil_7", (String)"fi-ai-common", (Object[])new Object[0]));
        return result;
    }

    private static DynamicObject createDynamicObject(DynamicObject template) {
        ORM orm = ORM.create();
        return orm.newDynamicObject(template.getDynamicObjectType());
    }

    private static void createNewBillNo(DynamicObject newTemp) {
        String billno = newTemp.getString("number");
        if (QueryServiceHelper.exists((String)"ai_vchtemplate", (QFilter[])new QFilter[]{new QFilter("number", "=", (Object)billno)})) {
            newTemp.set("number", (Object)(billno + "#"));
            DapFileUtil.createNewBillNo(newTemp);
        }
    }

    private static void setOtherFields(DynamicObject newTemp) {
        String toJson = newTemp.getString("fxml");
        if (StringUtils.isNotBlank((CharSequence)toJson)) {
            ILocaleValue langJsons = (ILocaleValue)newTemp.get("fxmllang");
            VCHTemplate vchTemplate = VCHTemplate.deserializeFromString(toJson, (Map<String, String>)langJsons);
            MainEntityType srcMainET = null;
            boolean isEvent = "ai_eventclass".equals(newTemp.getString("fsourcebill"));
            try {
                if (isEvent) {
                    srcMainET = AiEventMetaUtil.getEntityType(newTemp.getLong("eventclass"));
                } else {
                    String fsourcebill = newTemp.getString("fsourcebill_id");
                    srcMainET = EntityMetadataCache.getDataEntityType((String)fsourcebill);
                }
            }
            catch (Exception e) {
                log.error("\u83b7\u53d6\u5b9e\u4f53\u5143\u6570\u636e\u51fa\u9519", (Throwable)e);
            }
            if (null != srcMainET) {
                String vchTypeDesc = DapFileUtil.getVchGrpDescFromDeserializeVchTemp(vchTemplate);
                newTemp.set("fvchtypedesc", (Object)vchTypeDesc);
                newTemp.set("facctorgid", (Object)vchTemplate.getAcctOrgSet());
                String fvoucherdatedesc = "";
                VchExpireDate vchDateSetBox = vchTemplate.getVchDateSet2();
                if (vchDateSetBox != null) {
                    fvoucherdatedesc = DapFileUtil.getDateNumber(vchDateSetBox, vchDateSetBox.getDescriptionString());
                } else if (vchTemplate.getVchDateSet() != null) {
                    fvoucherdatedesc = vchTemplate.getVchDateSet();
                }
                newTemp.set("fvoucherdatedesc", (Object)fvoucherdatedesc);
                String fbizdatedesc = "";
                VchExpireDate bizDateSetBox = vchTemplate.getBizDateSet2();
                if (vchDateSetBox != null) {
                    fbizdatedesc = DapFileUtil.getDateNumber(bizDateSetBox, bizDateSetBox.getDescriptionString());
                } else if (vchTemplate.getBizDateSet() != null) {
                    fbizdatedesc = vchTemplate.getBizDateSet();
                }
                newTemp.set("fbizdatedesc", (Object)fbizdatedesc);
            }
        }
    }

    private static String getDateNumber(VchExpireDate vchDateSet2, String value) {
        if (null != vchDateSet2) {
            String jsonStr;
            List<VchFormulaFilterSetRow> itemList = vchDateSet2.getItems();
            LinkedList list = new LinkedList();
            for (VchFormulaFilterSetRow item : itemList) {
                LinkedHashMap<String, String> map = new LinkedHashMap<String, String>();
                VchTplExpression fieldExp = item.getFieldExp();
                map.put("ExprTran", fieldExp.getExprTran());
                map.put("Expression", fieldExp.getExpression());
                map.put("Description", fieldExp.getDescription().toString());
                list.add(map);
            }
            if (!list.isEmpty() && (jsonStr = SerializationUtils.toJsonString(list)).length() < 500) {
                return jsonStr;
            }
        }
        return value;
    }

    private static String getFieldName(MainEntityType entity, String fieldKey) {
        String fieldName = "";
        for (IDataEntityProperty prop : entity.getProperties()) {
            if (!fieldKey.equalsIgnoreCase(prop.getName())) continue;
            fieldName = DapFileUtil.buildPropCaption(prop);
            break;
        }
        if ("newdate".equalsIgnoreCase(fieldKey) && "".equals(fieldName)) {
            return VchExpireDate.newDateAlias();
        }
        if ("lastdate".equalsIgnoreCase(fieldKey) && "".equals(fieldName)) {
            return VchExpireDate.lastDateAlias();
        }
        return fieldName;
    }

    private static String buildPropCaption(IDataEntityProperty prop) {
        EntityType parentType = (EntityType)prop.getParent();
        String parentName = ResManager.loadKDString((String)"\u5355\u636e\u4f53", (String)"DapFileUtil_11", (String)"fi-ai-common", (Object[])new Object[0]);
        if (parentType.getDisplayName() != null) {
            parentName = parentType.getDisplayName().toString();
        }
        String propName = prop.getDisplayName() != null ? prop.getDisplayName().toString() : DapFileUtil.getFieldSelector(prop);
        String caption = String.format("%s.%s", parentName, propName);
        return caption;
    }

    private static String getFieldSelector(IDataEntityProperty rateProp) {
        String selector = rateProp.getName();
        if (rateProp.getParent() != null && rateProp.getParent().getParent() != null && rateProp.getParent().getParent().getParent() != null && rateProp.getParent().getParent().getParent().getParent() == null) {
            selector = rateProp.getParent().getParent().getName() + "." + rateProp.getParent().getName() + "." + selector;
        }
        return selector;
    }

    private static String getVchGrpDescFromDeserializeVchTemp(VCHTemplate vchTemplate) {
        StringBuilder grpDesc = new StringBuilder();
        try {
            for (VchTplVoucherType vchTempGrp : vchTemplate.getVchTypesSet().getItems()) {
                grpDesc.append(vchTempGrp.getVchGrpId()).append('/');
            }
            if (grpDesc.length() > 0 && grpDesc.length() < 500) {
                grpDesc.deleteCharAt(grpDesc.length() - 1);
            }
        }
        catch (Exception e) {
            log.error(" #################### \u4e1a\u52a1\u5355\u636e\u751f\u6210\u51ed\u8bc1\u63a7\u5236, ", (Throwable)e);
            grpDesc.append(ResManager.loadKDString((String)"\u83b7\u53d6\u51ed\u8bc1\u5b57\u53f7\u51fa\u9519\uff0c\u8bf7\u68c0\u67e5\u51ed\u8bc1\u6a21\u677f\u8bbe\u7f6e\u3002", (String)"DapFileUtil_9", (String)"fi-ai-common", (Object[])new Object[0]));
        }
        return grpDesc.toString();
    }

    public static void deleteFile(File file) {
        if (!file.delete() && file.isDirectory()) {
            File[] fileList = file.listFiles();
            for (int i = 0; i < fileList.length; ++i) {
                File delfile = fileList[i];
                if (delfile.delete() || !delfile.isDirectory()) continue;
                DapFileUtil.deleteKd(fileList[i]);
            }
        }
    }

    public static String genLocalPath() {
        String property = ConfigurationUtil.getString((String)"user.home");
        return property + File.separator + "KINGDEEDOWNLOAD" + File.separator + RequestContext.get().getAccountId() + RequestContext.get().getUserId();
    }

    public static File genFileByLocalPath() {
        String localPath = DapFileUtil.genLocalPath();
        File file = new File(FilenameUtils.getFullPath((String)localPath), FilenameUtils.getName((String)localPath));
        if (!file.exists()) {
            file.mkdirs();
        }
        return file;
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public static byte[] inputStreamToByteArray(InputStream inputStream) {
        try (ByteArrayOutputStream byteArrayOutputStream = new ByteArrayOutputStream();){
            int num;
            byte[] buffer = new byte[1024];
            while ((num = inputStream.read(buffer)) != -1) {
                byteArrayOutputStream.write(buffer, 0, num);
            }
            byteArrayOutputStream.flush();
            byte[] byArray = byteArrayOutputStream.toByteArray();
            return byArray;
        }
        catch (IOException iOException) {
            return new byte[0];
        }
    }
}

