/*
 * Decompiled with CFR 0.152.
 */
package kd.fi.ai.util;

import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import java.util.ArrayList;
import java.util.Comparator;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import kd.bos.algo.DataSet;
import kd.bos.algo.Row;
import kd.bos.dataentity.TypesContainer;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.entity.DynamicObjectCollection;
import kd.bos.dataentity.entity.LocaleString;
import kd.bos.dataentity.metadata.IDataEntityProperty;
import kd.bos.dataentity.metadata.IDataEntityType;
import kd.bos.dataentity.metadata.dynamicobject.DynamicProperty;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.dataentity.utils.StringUtils;
import kd.bos.db.DB;
import kd.bos.db.DBRoute;
import kd.bos.entity.EntityMetadataCache;
import kd.bos.entity.EntityType;
import kd.bos.entity.MainEntityType;
import kd.bos.entity.property.AssistantProp;
import kd.bos.entity.property.BasedataProp;
import kd.bos.entity.property.EntryProp;
import kd.bos.entity.property.FlexProp;
import kd.bos.entity.property.IFieldHandle;
import kd.bos.entity.property.ItemClassProp;
import kd.bos.entity.property.ItemClassTypeProp;
import kd.bos.entity.property.SubEntryProp;
import kd.bos.form.field.ComboItem;
import kd.bos.logging.Log;
import kd.bos.logging.LogFactory;
import kd.bos.orm.query.QFilter;
import kd.bos.servicehelper.BusinessDataServiceHelper;
import kd.bos.servicehelper.QueryServiceHelper;
import kd.fi.ai.AcctBook;
import kd.fi.ai.util.AiEventMetaUtil;

public class DapUtil {
    private static Log log = LogFactory.getLog(DapUtil.class);
    public static final String BD_ACCOUNTINGSYS = "bd_accountingsys";

    public static Set<Long> getAcctOrgIncludeSelf(long bizOrgID) {
        Set<Long> accOrgs;
        Set<Long> newSet = DapUtil.getOrgFromAccountingSysAndBook(bizOrgID);
        if (newSet.size() == 0 && !DapUtil.stopBizRelation() && (accOrgs = DapUtil.getAcctOrgIds(bizOrgID)).size() > 0) {
            newSet = DapUtil.filterByAcctBook(accOrgs);
        }
        return newSet;
    }

    public static Set<AcctBook> getAcctBookIncludeSelf(long bizOrgID, String orgField) {
        Set<Long> accOrgs;
        HashSet<AcctBook> bookSet = new HashSet<AcctBook>(16);
        DapUtil.getOrgFromAccountingSysAndBook(bizOrgID, bookSet, orgField);
        if (bookSet.size() == 0 && !DapUtil.stopBizRelation() && (accOrgs = DapUtil.getAcctOrgIds(bizOrgID)).size() > 0) {
            Set<Long> newSet = DapUtil.filterByAcctBook(accOrgs);
            for (Long acctOrgID : newSet) {
                bookSet.add(new AcctBook(acctOrgID, 0L, 0L, bizOrgID, orgField));
            }
        }
        return bookSet;
    }

    private static void getOrgFromAccountingSysAndBook(long bizOrgID, Set<AcctBook> bookSet, String orgField) {
        HashSet<Long> orgIds = new HashSet<Long>(16);
        HashMap<Long, Set> sysAndOrgCache = new HashMap<Long, Set>(8);
        String selectFields = "id,bizorgentry.bizorg bizorg,bizorgentry.bizacctorg bizacctorg";
        QFilter orgqf = new QFilter("bizorgentry.bizorg", "=", (Object)bizOrgID);
        DynamicObjectCollection bizColl = QueryServiceHelper.query((String)BD_ACCOUNTINGSYS, (String)selectFields, (QFilter[])new QFilter[]{orgqf});
        for (DynamicObject bc : bizColl) {
            orgIds.add(bc.getLong("bizacctorg"));
            sysAndOrgCache.computeIfAbsent(bc.getLong("id"), v -> new HashSet()).add(bc.getLong("bizacctorg"));
        }
        QFilter h = new QFilter("org", "in", orgIds);
        QFilter g = new QFilter("isbizunit", "=", (Object)Boolean.TRUE);
        QFilter a = new QFilter("accountingsys", "in", sysAndOrgCache.keySet());
        DynamicObjectCollection coll = QueryServiceHelper.query((String)"gl_accountbook", (String)"org.id,id,bookstype.id,accountingsys.id", (QFilter[])new QFilter[]{h, g, a});
        for (DynamicObject book : coll) {
            long orgId = book.getLong("org.id");
            long bookId = book.getLong("id");
            long bookTypeId = book.getLong("bookstype.id");
            Set set = (Set)sysAndOrgCache.get(book.getLong("accountingsys.id"));
            if (set == null || !set.contains(orgId)) continue;
            bookSet.add(new AcctBook(orgId, bookTypeId, bookId, bizOrgID, orgField));
        }
    }

    private static Set<Long> getOrgFromAccountingSysAndBook(long bizOrgID) {
        HashSet<Long> orgIds = new HashSet<Long>(16);
        HashSet<Long> sysIds = new HashSet<Long>(16);
        String selectFields = "id,bizorgentry.bizorg bizorg,bizorgentry.bizacctorg bizacctorg";
        QFilter orgqf = new QFilter("bizorgentry.bizorg", "=", (Object)bizOrgID);
        DynamicObjectCollection bizColl = QueryServiceHelper.query((String)BD_ACCOUNTINGSYS, (String)selectFields, (QFilter[])new QFilter[]{orgqf});
        for (DynamicObject bc : bizColl) {
            orgIds.add(bc.getLong("bizacctorg"));
            sysIds.add(bc.getLong("id"));
        }
        QFilter h = new QFilter("org", "in", orgIds);
        QFilter g = new QFilter("isbizunit", "=", (Object)Boolean.TRUE);
        QFilter a = new QFilter("accountingsys", "in", sysIds);
        DynamicObjectCollection coll = QueryServiceHelper.query((String)"gl_accountbook", (String)"org.id", (QFilter[])new QFilter[]{h, g, a});
        HashSet<Long> newSet = new HashSet<Long>();
        for (DynamicObject book : coll) {
            newSet.add(book.getLong("org.id"));
        }
        return newSet;
    }

    private static boolean stopBizRelation() {
        QFilter filter = new QFilter("number", "=", (Object)"2012@2013");
        return QueryServiceHelper.exists((String)"ai_basedatamapping", (QFilter[])new QFilter[]{filter});
    }

    private static Set<Long> filterByAcctBook(Set<Long> set) {
        QFilter h = new QFilter("org", "in", set);
        QFilter g = new QFilter("isbizunit", "=", (Object)Boolean.TRUE);
        DynamicObjectCollection coll = QueryServiceHelper.query((String)"gl_accountbook", (String)"org.id", (QFilter[])new QFilter[]{h, g});
        HashSet<Long> newSet = new HashSet<Long>();
        for (DynamicObject book : coll) {
            newSet.add(book.getLong("org.id"));
        }
        return newSet;
    }

    public static Set<Long> getBizOrgIds(long acctOrgId) {
        HashSet<Long> set = new HashSet<Long>();
        set.add(acctOrgId);
        QFilter k = new QFilter("typerelation.totype", "=", (Object)"10");
        QFilter j = new QFilter("toorg", "=", (Object)acctOrgId);
        DynamicObjectCollection bizOrgColl = QueryServiceHelper.query((String)"bos_org_orgrelation", (String)"fromorg,toorg,id", (QFilter[])new QFilter[]{j, k});
        if (null == bizOrgColl || bizOrgColl.size() == 0) {
            return set;
        }
        for (DynamicObject accsys : bizOrgColl) {
            set.add(accsys.getLong("fromorg"));
        }
        return set;
    }

    private static Set<Long> getAcctOrgIds(long bizOrgID) {
        HashSet<Long> set = new HashSet<Long>();
        QFilter k = new QFilter("typerelation.totype", "=", (Object)"10");
        QFilter j = new QFilter("fromorg", "=", (Object)bizOrgID);
        DynamicObjectCollection bizOrgColl = QueryServiceHelper.query((String)"bos_org_orgrelation", (String)"fromorg,toorg,id", (QFilter[])new QFilter[]{j, k});
        if (null == bizOrgColl || bizOrgColl.size() == 0) {
            return set;
        }
        for (DynamicObject accsys : bizOrgColl) {
            set.add(accsys.getLong("toorg"));
        }
        return set;
    }

    public static List<String> getDapBillEntitys() {
        QFilter typeQF = new QFilter("billentity", "!=", (Object)"ai_eventclass");
        QFilter dapQF = new QFilter("isdap", "=", (Object)Boolean.TRUE);
        DynamicObject[] dapconfigs = BusinessDataServiceHelper.load((String)"ai_dapconfig", (String)"id,isdap,billentity", (QFilter[])new QFilter[]{typeQF, dapQF});
        ArrayList<String> bills = new ArrayList<String>(dapconfigs.length);
        for (DynamicObject config : dapconfigs) {
            bills.add(config.getString("billentity.id"));
        }
        return bills;
    }

    public static Set<String> getBillPropEntitys(String entityKey) {
        MainEntityType entityType = EntityMetadataCache.getDataEntityType((String)entityKey);
        HashSet<String> es = new HashSet<String>();
        DapUtil.searchPropEntity(es, (EntityType)entityType, null, true, true);
        return es;
    }

    private static void searchPropEntity(Set<String> entityIds, EntityType entityType, String parentKey, boolean searchSubEntity, boolean searchSubEntry) {
        for (IDataEntityProperty prop : entityType.getProperties()) {
            if (prop instanceof EntryProp) {
                if (prop instanceof SubEntryProp && !searchSubEntry || !(prop instanceof SubEntryProp) && parentKey != null) continue;
                EntityType subEntityType = (EntityType)((EntryProp)prop).getItemType();
                String parentKeySub = null;
                if (prop instanceof SubEntryProp) {
                    parentKeySub = prop.getParent().getName() + "." + prop.getName();
                } else if (parentKey != null) {
                    parentKeySub = parentKey + "." + prop.getName();
                }
                DapUtil.searchPropEntity(entityIds, subEntityType, parentKeySub, true, searchSubEntry);
                continue;
            }
            if (!(prop instanceof BasedataProp)) continue;
            BasedataProp bdProp = (BasedataProp)prop;
            if (StringUtils.isNotEmpty((CharSequence)prop.getAlias())) {
                entityIds.add(bdProp.getBaseEntityId());
            }
            if (!searchSubEntity || bdProp instanceof FlexProp) continue;
            DapUtil.searchPropEntity(entityIds, (EntityType)EntityMetadataCache.getDataEntityType((String)bdProp.getComplexType().getName()), bdProp.getName(), false, false);
        }
    }

    public static Object getBaseDataMappingDataID(Long mappingid, Object srcID) {
        DynamicObject mapping = BusinessDataServiceHelper.loadSingle((Object)mappingid, (String)"ai_basedatamapping");
        DynamicObjectCollection fieldentry = mapping.getDynamicObjectCollection("fieldmapentry");
        String srcEntityKey = ((DynamicObject)fieldentry.get(0)).getString("entityid");
        String srcField = "f" + ((DynamicObject)fieldentry.get(0)).getString("fieldkey");
        String destEntityKey = mapping.getDynamicObject("destbasedata").getPkValue().toString();
        String mapType = mapping.getString("type");
        if (StringUtils.isBlank((CharSequence)mapType)) {
            throw new RuntimeException(ResManager.loadKDString((String)"\u6570\u636e\u6620\u5c04\u5173\u7cfb\u6570\u636e\u9519\u8bef\uff0c\u8bf7\u91cd\u65b0\u4fdd\u5b58\u6570\u636e\u6620\u5c04\u5173\u7cfb\u3002", (String)"DapUtil_0", (String)"fi-ai-common", (Object[])new Object[0]));
        }
        if ("plugin".equalsIgnoreCase(mapType)) {
            String mappingplugin = mapping.getString("mappingplugin");
            try {
                Object mapIns = TypesContainer.createInstance((String)mappingplugin);
                Method getMe = mapIns.getClass().getMethod("getMappingBaseDataID", Object.class);
                Object destID = getMe.invoke(mapIns, srcID);
                Long destIDL = (Long)destID;
                if (destID != null && destIDL != 0L) {
                    return destIDL;
                }
            }
            catch (IllegalAccessException | IllegalArgumentException | NoSuchMethodException | SecurityException | InvocationTargetException e) {
                log.error((Throwable)e);
            }
        } else {
            QFilter[] filters;
            DynamicObject destObj;
            DynamicObject srcObj;
            boolean bynumber = mapping.getBoolean("bynumber");
            boolean byname = mapping.getBoolean("byname");
            boolean bycustom = mapping.getBoolean("bycustom");
            if (bycustom) {
                String selectSql = "select " + srcField + " as src,fdestdatamapping as tar from t_ai_basedatamappingentry where fid = " + mappingid;
                try (DataSet queryDataSet = DB.queryDataSet((String)"kd.fi.ai.util.DapUtil", (DBRoute)DBRoute.of((String)"fi"), (String)selectSql);){
                    for (Row row : queryDataSet) {
                        Object src = row.get("src");
                        if (src == null || !src.equals(srcID)) continue;
                        Object object = row.get("tar");
                        return object;
                    }
                }
            }
            ArrayList<QFilter> filter = new ArrayList<QFilter>();
            if (bynumber) {
                srcObj = BusinessDataServiceHelper.loadSingle((Object)srcID, (String)srcEntityKey);
                String srcNumber = srcObj.getString("number");
                QFilter numberFilter = new QFilter("number", "=", (Object)srcNumber);
                filter.add(numberFilter);
            }
            if (byname) {
                srcObj = BusinessDataServiceHelper.loadSingle((Object)srcID, (String)srcEntityKey);
                String srcName = srcObj.getString("name");
                QFilter nameFilter = new QFilter("name", "=", (Object)srcName);
                filter.add(nameFilter);
            }
            if (filter.size() > 0 && (destObj = BusinessDataServiceHelper.loadSingle((String)destEntityKey, (String)"id", (QFilter[])(filters = filter.toArray(new QFilter[filter.size()])))) != null) {
                return destObj.getPkValue();
            }
        }
        return null;
    }

    public static Set<String> getVchFields(IDataEntityType entityType) {
        HashSet<String> fields = new HashSet<String>();
        for (IDataEntityProperty property : entityType.getProperties()) {
            if (property instanceof EntryProp || property instanceof SubEntryProp) {
                EntityType childEntity = (EntityType)((EntryProp)property).getItemType();
                fields.addAll(DapUtil.getVchFields((IDataEntityType)childEntity));
                continue;
            }
            if (!(property instanceof IFieldHandle)) continue;
            fields.add(property.getName());
        }
        return fields;
    }

    public static List<ComboItem> buildPropComboItems(Set<String> entityIds, MainEntityType srcMainEntityType, boolean searchSubEntity, boolean searchSubEntry, boolean searchSubEntrySubEntitySub) {
        return DapUtil.buildPropComboItems(entityIds, srcMainEntityType, searchSubEntity, searchSubEntry, searchSubEntrySubEntitySub, null);
    }

    public static List<ComboItem> buildPropComboItems(Set<String> entityIds, MainEntityType srcMainEntityType, boolean searchSubEntity, boolean searchSubEntry, boolean searchSubEntrySubEntitySub, String assisantGroup) {
        ArrayList<ComboItem> items = new ArrayList<ComboItem>();
        ComboItem blankItem = new ComboItem();
        blankItem.setValue("");
        blankItem.setCaption(new LocaleString());
        items.add(blankItem);
        DapUtil.searchBDField(entityIds, (EntityType)srcMainEntityType, items, null, null, searchSubEntity, searchSubEntry, searchSubEntrySubEntitySub, assisantGroup);
        items.sort(new Comparator<ComboItem>(){

            @Override
            public int compare(ComboItem arg0, ComboItem arg1) {
                String arg0Str = arg0.getValue();
                String arg1Str = arg1.getValue();
                if ("".equals(arg0Str)) {
                    return -1;
                }
                if ("".equals(arg1Str)) {
                    return 1;
                }
                if (arg0Str.indexOf(46) >= 0 && arg1Str.indexOf(46) < 0) {
                    return 1;
                }
                if (arg0Str.indexOf(46) < 0 && arg1Str.indexOf(46) >= 0) {
                    return -1;
                }
                return arg1.getValue().compareTo(arg0.getValue());
            }
        });
        return items;
    }

    public static Map<String, ComboItem> buildPropComboItemsByItemClass(Set<String> entityIds, MainEntityType entityType, String parentName, String parentKey, boolean searchSubEntity, boolean searchSubEntry, boolean searchSubEntrySubEntitySub) {
        HashMap<String, ComboItem> result = new HashMap<String, ComboItem>();
        HashMap<String, ComboItem> itemProps = new HashMap<String, ComboItem>();
        HashMap<String, String> itemTypes = new HashMap<String, String>();
        DapUtil.searchBDFieldByItemClass(entityIds, (EntityType)entityType, itemProps, itemTypes, parentName, parentKey, searchSubEntity, searchSubEntry, searchSubEntrySubEntitySub);
        String filter = null;
        for (Map.Entry entry : itemProps.entrySet()) {
            String itemType = (String)entry.getKey();
            if (!itemTypes.containsKey(itemType)) continue;
            filter = itemType + "==" + (String)itemTypes.get(itemType);
            result.put(filter, (ComboItem)entry.getValue());
        }
        return result;
    }

    private static void searchBDFieldByItemClass(Set<String> entityIds, EntityType entityType, Map<String, ComboItem> itemProps, Map<String, String> itemTypes, String parentName, String parentKey, boolean searchSubEntity, boolean searchSubEntry, boolean searchSubEntrySubEntitySub) {
        for (IDataEntityProperty prop : entityType.getProperties()) {
            String typeId2;
            if (prop instanceof EntryProp) {
                if (prop instanceof SubEntryProp && !searchSubEntry || !(prop instanceof SubEntryProp) && parentKey != null) continue;
                EntityType subEntityType = (EntityType)((EntryProp)prop).getItemType();
                Object parentKeySub = null;
                String parentNameSub = subEntityType.getDisplayName().toString();
                if (prop instanceof SubEntryProp) {
                    parentKeySub = prop.getParent().getName() + "." + prop.getName();
                    parentNameSub = parentName + "." + parentNameSub;
                } else if (parentKey != null) {
                    parentKeySub = parentKey + "." + prop.getName();
                    parentNameSub = parentName + "." + parentNameSub;
                } else {
                    parentKeySub = prop.getName();
                }
                DapUtil.searchBDFieldByItemClass(entityIds, subEntityType, itemProps, itemTypes, parentNameSub, (String)parentKeySub, searchSubEntrySubEntitySub, searchSubEntry, searchSubEntrySubEntitySub);
                continue;
            }
            if (prop instanceof ItemClassTypeProp) {
                ItemClassTypeProp typeProp = (ItemClassTypeProp)prop;
                for (String typeId2 : typeProp.getBaseEntityIds()) {
                    if (!entityIds.contains(typeId2)) continue;
                    itemTypes.put(typeProp.getName(), typeId2);
                }
                continue;
            }
            if (!(prop instanceof ItemClassProp)) continue;
            ItemClassProp itemProp = (ItemClassProp)prop;
            String parentNameNext = parentName + "." + itemProp.getDisplayName().toString();
            if (parentName == null) {
                parentNameNext = itemProp.getDisplayName().toString();
            }
            typeId2 = itemProp.getTypePropName();
            ComboItem item = new ComboItem();
            if (parentKey != null) {
                item.setValue(parentKey + "." + itemProp.getName());
            } else {
                item.setValue(itemProp.getName());
            }
            if (parentName != null) {
                item.setCaption(new LocaleString(parentNameNext));
            } else {
                parentNameNext = entityType.getDisplayName().toString() + "." + itemProp.getDisplayName().toString();
                item.setCaption(new LocaleString(parentNameNext));
            }
            itemProps.put(typeId2, item);
        }
    }

    private static void searchBDField(Set<String> entityIds, EntityType entityType, List<ComboItem> items, String parentName, String parentKey, boolean searchSubEntity, boolean searchSubEntry, boolean searchSubEntrySubEntitySub) {
        DapUtil.searchBDField(entityIds, entityType, items, parentName, parentKey, searchSubEntity, searchSubEntry, searchSubEntrySubEntitySub, null);
    }

    private static void searchBDField(Set<String> entityIds, EntityType entityType, List<ComboItem> items, String parentName, String parentKey, boolean searchSubEntity, boolean searchSubEntry, boolean searchSubEntrySubEntitySub, String assisantGroup) {
        for (IDataEntityProperty prop : entityType.getProperties()) {
            if (prop instanceof EntryProp) {
                if (prop instanceof SubEntryProp && !searchSubEntry || !(prop instanceof SubEntryProp) && parentKey != null) continue;
                EntityType subEntityType = (EntityType)((EntryProp)prop).getItemType();
                String parentKeySub = null;
                String parentNameSub = subEntityType.getDisplayName().toString();
                if (prop instanceof SubEntryProp) {
                    parentKeySub = prop.getParent().getName() + "." + prop.getName();
                    parentNameSub = parentName + "." + parentNameSub;
                } else if (parentKey != null) {
                    parentKeySub = parentKey + "." + prop.getName();
                    parentNameSub = parentName + "." + parentNameSub;
                } else {
                    parentKeySub = prop.getName();
                }
                DapUtil.searchBDField(entityIds, subEntityType, items, parentNameSub, parentKeySub, searchSubEntrySubEntitySub, searchSubEntry, searchSubEntrySubEntitySub, assisantGroup);
                continue;
            }
            if (!(prop instanceof BasedataProp)) continue;
            BasedataProp bdProp = (BasedataProp)prop;
            String parentNameNext = parentName + "." + bdProp.getDisplayName().toString();
            if (parentName == null) {
                parentNameNext = bdProp.getDisplayName().toString();
            }
            if (entityIds.contains(bdProp.getBaseEntityId()) && StringUtils.isNotEmpty((CharSequence)prop.getAlias())) {
                ComboItem item = new ComboItem();
                if (parentKey != null) {
                    item.setValue(parentKey + "." + bdProp.getName());
                } else {
                    item.setValue(bdProp.getName());
                }
                if (parentName != null) {
                    item.setCaption(new LocaleString(parentNameNext));
                } else {
                    parentNameNext = entityType.getDisplayName().toString() + "." + bdProp.getDisplayName().toString();
                    item.setCaption(new LocaleString(parentNameNext));
                }
                if (!(prop instanceof AssistantProp)) {
                    items.add(item);
                } else if (!StringUtils.isEmpty((CharSequence)assisantGroup) && assisantGroup.equals(((AssistantProp)prop).getAsstTypeId())) {
                    items.add(item);
                }
                if (!(prop instanceof AssistantProp) || !entityIds.contains(((AssistantProp)prop).getAsstTypeId())) continue;
                items.add(item);
                continue;
            }
            if (!searchSubEntity || !StringUtils.isNotEmpty((CharSequence)prop.getAlias()) || bdProp instanceof FlexProp) continue;
            DapUtil.searchBDField(entityIds, (EntityType)EntityMetadataCache.getDataEntityType((String)bdProp.getComplexType().getName()), items, parentNameNext, bdProp.getName(), false, false, false, assisantGroup);
        }
    }

    public static Set<String> getBaseDateForMenu() {
        String select = "FFORMID";
        String selectSql = "select " + select + " from t_meta_menuruntime WHERE FFORMID != ?";
        DataSet queryDataSet = DB.queryDataSet((String)(DapUtil.class.getName() + "query"), (DBRoute)DBRoute.meta, (String)selectSql, (Object[])new Object[]{Character.valueOf(' ')});
        HashSet<String> formnumber = new HashSet<String>(16);
        while (queryDataSet.hasNext()) {
            Row row = queryDataSet.next();
            formnumber.add(row.getString(select));
        }
        formnumber.removeIf(app -> "null".equals(app));
        return formnumber;
    }

    public static void removeItemClassPropComboItem(List<ComboItem> items, MainEntityType srcMainET) {
        Iterator<ComboItem> itemIter = items.iterator();
        while (itemIter.hasNext()) {
            ComboItem comboItem = itemIter.next();
            String propName = comboItem.getValue();
            DynamicProperty prop = srcMainET.getProperty(propName);
            if (!(prop instanceof ItemClassProp)) continue;
            itemIter.remove();
        }
    }

    public static MainEntityType getEntityTypeByNumber(Object number) {
        MainEntityType srcMainET = null;
        if (number != null) {
            String entityNumber = number.toString();
            srcMainET = DapUtil.isNumeric(entityNumber) ? AiEventMetaUtil.getEntityType(Long.valueOf(entityNumber)) : EntityMetadataCache.getDataEntityType((String)entityNumber);
        }
        return srcMainET;
    }

    public static boolean isNumeric(String str) {
        Pattern pattern = Pattern.compile("[0-9]*");
        Matcher isNum = pattern.matcher(str);
        return isNum.matches();
    }
}

