/*
 * Decompiled with CFR 0.152.
 */
package kd.fi.ai.util;

import java.util.ArrayList;
import java.util.Map;
import java.util.Set;
import kd.bos.dataentity.metadata.IDataEntityProperty;
import kd.bos.dataentity.metadata.IDataEntityType;
import kd.bos.dataentity.metadata.dynamicobject.DynamicProperty;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.dataentity.utils.StringUtils;
import kd.bos.entity.EntityType;
import kd.bos.entity.LinkEntryType;
import kd.bos.entity.MainEntityType;
import kd.bos.entity.property.BasedataProp;
import kd.bos.entity.property.BigIntProp;
import kd.bos.entity.property.DateTimeProp;
import kd.bos.entity.property.DecimalProp;
import kd.bos.entity.property.EntryProp;
import kd.bos.entity.property.FlexProp;
import kd.bos.entity.tree.TreeNode;
import kd.bos.exception.KDException;
import kd.bos.logging.Log;
import kd.bos.logging.LogFactory;
import kd.bos.servicehelper.MetadataServiceHelper;
import kd.fi.ai.ExpressionType;
import kd.fi.ai.VchExpireDate;
import kd.fi.ai.util.EntityFieldTreeOption;
import kd.fi.ai.util.EntityFieldTreeResult;

class EntityFieldNodeHandle {
    private static Log log = LogFactory.getLog(EntityFieldNodeHandle.class);
    private EntityFieldTreeOption option;
    private EntityFieldTreeResult result = new EntityFieldTreeResult();

    public EntityFieldNodeHandle(EntityFieldTreeOption option) {
        this.option = option;
    }

    public EntityFieldTreeResult getSimNodes() {
        MainEntityType srcMainET = (MainEntityType)this.option.getEntityType();
        Map allEntities = srcMainET.getAllEntities();
        TreeNode parentNode = new TreeNode("", srcMainET.getName(), srcMainET.getDisplayName().toString());
        this.result.getNodes().add(parentNode);
        boolean readEntity = this.option.isReadEntryEntity();
        Set<String> entrySet = this.option.getEntrySet();
        boolean needEntryFilter = null != entrySet && !entrySet.isEmpty();
        for (EntityType entityType : allEntities.values()) {
            String entityNodeId;
            if (!readEntity && !(entityType instanceof MainEntityType) || entityType instanceof LinkEntryType || needEntryFilter && !entrySet.contains(entityType.getName()) || (entityNodeId = entityType.getName()).contains("name$version")) continue;
            String entityNodeName = "";
            if (entityType instanceof MainEntityType) {
                entityNodeName = ResManager.loadKDString((String)"\u5355\u636e\u5934", (String)"EntityTreeUtil_3", (String)"fi-ai-common", (Object[])new Object[0]);
                entityNodeId = "billhead";
            } else if (entityType.getDisplayName() != null) {
                entityNodeName = entityType.getDisplayName().toString();
            }
            TreeNode entityNode = new TreeNode(srcMainET.getName(), entityNodeId, entityNodeName);
            if (!entityType.getFields().values().isEmpty()) {
                entityNode.addChildren(new ArrayList());
            }
            this.result.getNodes().add(entityNode);
        }
        this.addSpecialNodes();
        return this.result;
    }

    public EntityFieldTreeResult getSimLevelNodes() {
        String nodeId = this.option.getNodeId();
        String[] nodeIdSplits = nodeId.replace("{", "").replace("}", "").split("#");
        MainEntityType srcMainET = (MainEntityType)this.option.getEntityType();
        if (nodeIdSplits.length > 1) {
            String field = nodeIdSplits[nodeIdSplits.length - 1];
            IDataEntityProperty property = srcMainET.findProperty(field);
            if (property instanceof BasedataProp) {
                BasedataProp bdProp = (BasedataProp)property;
                IDataEntityType bdType = bdProp.getComplexType();
                if (!(property instanceof FlexProp)) {
                    try {
                        bdType = MetadataServiceHelper.getDataEntityType((String)bdType.getName());
                    }
                    catch (KDException ex) {
                        ex.printStackTrace();
                    }
                }
                this.buildBDFldRefPropNodesByNodeId(bdType, nodeId, bdProp.getName(), true, true);
            }
        } else {
            Map allEntities = srcMainET.getAllEntities();
            for (EntityType entityType : allEntities.values()) {
                String field;
                if (entityType instanceof LinkEntryType || !"billhead".equals(field = nodeIdSplits[0]) && !field.equals(entityType.getName())) continue;
                for (IDataEntityProperty property : entityType.getFields().values()) {
                    TreeNode fldNode = this.buildFldTreeNodeByParent(property, field, null);
                    if (null == fldNode) continue;
                    this.result.getNodes().add(fldNode);
                    if (!(property instanceof BasedataProp)) continue;
                    fldNode.addChildren(new ArrayList());
                }
            }
        }
        return this.result;
    }

    public EntityFieldTreeResult getNodes() {
        try {
            boolean includeHead = this.option.isIncludeHead();
            boolean includeParentID = this.option.isIncludeParentID();
            boolean readEntity = this.option.isReadEntryEntity();
            Set<String> entrySet = this.option.getEntrySet();
            boolean needEntryFilter = null != entrySet && !entrySet.isEmpty();
            String parentId = "";
            MainEntityType srcMainET = (MainEntityType)this.option.getEntityType();
            Map allEntities = srcMainET.getAllEntities();
            TreeNode parentNode = new TreeNode("", srcMainET.getName(), srcMainET.getDisplayName().toString());
            this.result.getNodes().add(parentNode);
            for (EntityType entityType : allEntities.values()) {
                String entityNodeId;
                if (!readEntity && !(entityType instanceof MainEntityType) || entityType instanceof LinkEntryType || needEntryFilter && !entrySet.contains(entityType.getName()) || (entityNodeId = entityType.getName()).contains("name$version")) continue;
                String entityNodeName = "";
                if (entityType instanceof MainEntityType) {
                    entityNodeName = ResManager.loadKDString((String)"\u5355\u636e\u5934", (String)"EntityTreeUtil_3", (String)"fi-ai-common", (Object[])new Object[0]);
                    if (!includeParentID) {
                        entityNodeId = "billhead";
                    } else {
                        parentId = entityNodeId = entityNodeId + ".billhead";
                    }
                } else if (entityType.getDisplayName() != null) {
                    entityNodeName = entityType.getDisplayName().toString();
                    if (includeParentID) {
                        entityNodeId = parentId + "." + entityNodeId;
                    }
                }
                TreeNode entityNode = new TreeNode(srcMainET.getName(), entityNodeId, entityNodeName);
                boolean addEntiNode = false;
                for (IDataEntityProperty property : entityType.getFields().values()) {
                    if (property instanceof BasedataProp && DecimalProp.class.equals(this.option.getFieldType()) && StringUtils.isNotEmpty((CharSequence)entityType.getAlias())) {
                        String pfx;
                        TreeNode entitySubNode;
                        BasedataProp bdProp = (BasedataProp)property;
                        IDataEntityType bdType = bdProp.getComplexType();
                        boolean flag = this.buildDecimalTreeNodes(bdType, entityNode, entitySubNode = new TreeNode(entityNode.getId(), property.getName(), ((BasedataProp)property).getDisplayName().toString()), pfx = property.getName());
                        if (!flag) continue;
                        addEntiNode = true;
                        this.result.getNodes().add(entitySubNode);
                        continue;
                    }
                    TreeNode fldNode = this.buildFldTreeNode(property, entityNode, null);
                    if (null == fldNode) continue;
                    addEntiNode = true;
                    this.result.getNodes().add(fldNode);
                    if (!(property instanceof BasedataProp)) continue;
                    BasedataProp bdProp = (BasedataProp)property;
                    IDataEntityType bdType = bdProp.getComplexType();
                    if (!(property instanceof FlexProp)) {
                        try {
                            bdType = MetadataServiceHelper.getDataEntityType((String)bdType.getName());
                        }
                        catch (KDException ex) {
                            ex.printStackTrace();
                        }
                    }
                    this.buildBDFldRefPropNodes(bdType, fldNode, bdProp.getName(), true);
                }
                if (!includeHead || !addEntiNode) continue;
                this.result.getNodes().add(entityNode);
            }
        }
        catch (Exception e) {
            log.error((Throwable)e);
        }
        this.addSpecialNodes();
        return this.result;
    }

    private void addSpecialNodes() {
        if (!this.option.isAddDate()) {
            return;
        }
        if (this.option.getExprType() == ExpressionType.DynamicText) {
            TreeNode sscApproveMsg = new TreeNode(this.option.getEntityType().getName(), "{sscApproveMsg}", ResManager.loadKDString((String)"\u5171\u4eab\u5ba1\u6279\u4fe1\u606f", (String)"EntityTreeUtil_1", (String)"fi-ai-common", (Object[])new Object[0]));
            TreeNode sscInnerMsg = new TreeNode(this.option.getEntityType().getName(), "{sscInnerMsg}", ResManager.loadKDString((String)"\u5171\u4eab\u5185\u90e8\u8bf4\u660e", (String)"EntityTreeUtil_2", (String)"fi-ai-common", (Object[])new Object[0]));
            this.result.getNodes().add(sscApproveMsg);
            this.result.getNodes().add(sscInnerMsg);
            TreeNode newdate = new TreeNode(this.option.getEntityType().getName(), "{Dapfield_newdate}", VchExpireDate.newDateAlias());
            TreeNode lastdate = new TreeNode(this.option.getEntityType().getName(), "{Dapfield_lastdate}", VchExpireDate.lastDateAlias());
            TreeNode firstdate = new TreeNode(this.option.getEntityType().getName(), "{Dapfield_firstdate}", VchExpireDate.firstDateAlias());
            this.result.getNodes().add(newdate);
            this.result.getNodes().add(lastdate);
            this.result.getNodes().add(firstdate);
        } else if (this.option.getFieldType() == DateTimeProp.class || this.option.getFieldType() == null) {
            TreeNode newdate = new TreeNode(this.option.getEntityType().getName(), "Dapfield_newdate", VchExpireDate.newDateAlias());
            TreeNode lastdate = new TreeNode(this.option.getEntityType().getName(), "Dapfield_lastdate", VchExpireDate.lastDateAlias());
            TreeNode firstdate = new TreeNode(this.option.getEntityType().getName(), "Dapfield_firstdate", VchExpireDate.firstDateAlias());
            this.result.getNodes().add(newdate);
            this.result.getNodes().add(lastdate);
            this.result.getNodes().add(firstdate);
        }
    }

    private boolean buildDecimalTreeNodes(IDataEntityType entityType, TreeNode parentNode, TreeNode currentEntityNode, String prefix) throws CloneNotSupportedException {
        boolean flag = false;
        for (IDataEntityProperty property : entityType.getProperties()) {
            TreeNode fldNode = new TreeNode();
            fldNode = this.option.isIncludeHead() ? this.buildFldTreeNode(property, currentEntityNode, prefix) : this.buildFldTreeNode(property, currentEntityNode, prefix, parentNode.getText());
            if (fldNode == null) continue;
            this.result.getNodes().add(fldNode);
            flag = true;
            if (!(property instanceof BasedataProp)) continue;
            BasedataProp bdProp = (BasedataProp)property;
            IDataEntityType bdType = bdProp.getComplexType();
            if (!(property instanceof FlexProp)) {
                try {
                    bdType = MetadataServiceHelper.getDataEntityType((String)bdType.getName());
                }
                catch (KDException ex) {
                    ex.printStackTrace();
                }
            }
            this.buildBDFldRefPropNodes(bdType, fldNode, bdProp.getName(), true);
        }
        return flag;
    }

    private void buildBDFldRefPropNodesByNodeId(IDataEntityType bdType, String nodeId, String prefix, boolean loadSubBaseMeta, boolean loadSubData) {
        for (IDataEntityProperty property : bdType.getProperties()) {
            TreeNode fldNode;
            if (property instanceof EntryProp || (fldNode = this.buildFldTreeNodeByParent(property, nodeId, prefix)) == null) continue;
            this.result.getNodes().add(fldNode);
            if (!loadSubData || !(property instanceof BasedataProp)) continue;
            BasedataProp bdProp2 = (BasedataProp)property;
            IDataEntityType bdType2 = bdProp2.getComplexType();
            if (loadSubBaseMeta && !(property instanceof FlexProp)) {
                try {
                    bdType2 = MetadataServiceHelper.getDataEntityType((String)bdType2.getName());
                }
                catch (KDException ex) {
                    ex.printStackTrace();
                }
            }
            String prefix2 = prefix + "." + bdProp2.getName();
            this.buildBDFldRefPropNodesByNode(bdType2, fldNode, prefix2, true, true);
        }
    }

    private void buildBDFldRefPropNodesByNode(IDataEntityType bdType, TreeNode bdFldNode, String prefix, boolean loadSubBaseMeta, boolean loadSubData) {
        for (IDataEntityProperty property : bdType.getProperties()) {
            TreeNode fldNode;
            if (property instanceof EntryProp || (fldNode = this.buildFldTreeNode(property, bdFldNode, prefix)) == null) continue;
            this.result.getNodes().add(fldNode);
            if (!loadSubData || !(property instanceof BasedataProp)) continue;
            BasedataProp bdProp = (BasedataProp)property;
            IDataEntityType dataType = bdProp.getComplexType();
            if (loadSubBaseMeta && !(property instanceof FlexProp)) {
                try {
                    dataType = MetadataServiceHelper.getDataEntityType((String)dataType.getName());
                }
                catch (KDException ex) {
                    ex.printStackTrace();
                }
            }
            String prefixName = prefix + "." + bdProp.getName();
            this.buildBDFldRefPropNodesByNode(dataType, fldNode, prefixName, false, false);
        }
    }

    private void buildBDFldRefPropNodes(IDataEntityType bdType, TreeNode bdFldNode, String prefix, boolean loadSubBaseMeta) {
        for (IDataEntityProperty property : bdType.getProperties()) {
            if (property instanceof EntryProp) continue;
            TreeNode fldNode = new TreeNode();
            fldNode = !this.option.isIncludeHead() && !ResManager.loadKDString((String)"\u5355\u636e\u5934", (String)"EntityTreeUtil_3", (String)"fi-ai-common", (Object[])new Object[0]).equals(bdFldNode.getText()) ? this.buildFldTreeNode(property, bdFldNode, prefix, bdFldNode.getText()) : this.buildFldTreeNode(property, bdFldNode, prefix);
            if (fldNode == null) continue;
            this.result.getNodes().add(fldNode);
        }
    }

    private TreeNode buildFldTreeNode(IDataEntityProperty fldProperty, TreeNode parentNode, String prefix) {
        TreeNode fldNode = null;
        boolean isMatch = true;
        if (this.option.getFieldType() != null) {
            if (!this.option.getFieldType().isInstance(fldProperty)) {
                isMatch = false;
            }
            if (DecimalProp.class.equals(this.option.getFieldType()) && BigIntProp.class.isInstance(fldProperty)) {
                isMatch = false;
            }
        }
        DynamicProperty prop = (DynamicProperty)fldProperty;
        if (isMatch && prop != null && (this.option.isIncludeID() && "id".equalsIgnoreCase(prop.getName()) || prop.getDisplayName() != null) && StringUtils.isNotEmpty((CharSequence)fldProperty.getAlias())) {
            String fullPropName = "";
            if (this.option.isIncludeParentID()) {
                String parentId = parentNode.getId();
                if (StringUtils.isNotBlank((CharSequence)parentId)) {
                    fullPropName = parentId + "." + prop.getName();
                }
            } else {
                fullPropName = StringUtils.isBlank((CharSequence)prefix) ? prop.getName() : prefix + "." + prop.getName();
            }
            String fldNodeId = fullPropName;
            if (this.option.getExprType() == ExpressionType.DynamicText) {
                fldNodeId = "{" + fullPropName + "}";
            }
            String fldNodeName = prop.getDisplayName() == null ? prop.getName() : prop.getDisplayName().toString();
            fldNode = new TreeNode(parentNode.getId(), fldNodeId, fldNodeName);
        }
        return fldNode;
    }

    private TreeNode buildFldTreeNodeByParent(IDataEntityProperty fldProperty, String parentId, String prefix) {
        TreeNode fldNode = null;
        boolean isMatch = true;
        if (this.option.getFieldType() != null) {
            if (!this.option.getFieldType().isInstance(fldProperty)) {
                isMatch = false;
            }
            if (DecimalProp.class.equals(this.option.getFieldType()) && BigIntProp.class.isInstance(fldProperty)) {
                isMatch = false;
            }
        }
        DynamicProperty prop = (DynamicProperty)fldProperty;
        if (isMatch && prop != null && (this.option.isIncludeID() && "id".equalsIgnoreCase(prop.getName()) || prop.getDisplayName() != null) && StringUtils.isNotEmpty((CharSequence)fldProperty.getAlias())) {
            String fullPropName = "";
            if (this.option.isIncludeParentID()) {
                if (StringUtils.isNotBlank((CharSequence)parentId)) {
                    fullPropName = parentId + "." + prop.getName();
                }
            } else {
                fullPropName = StringUtils.isBlank((CharSequence)prefix) ? parentId + "#" + prop.getName() : parentId + "#" + prefix + "." + prop.getName();
            }
            String fldNodeId = fullPropName;
            if (this.option.getExprType() == ExpressionType.DynamicText) {
                fldNodeId = "{" + fullPropName + "}";
            }
            String fldNodeName = prop.getDisplayName() == null ? prop.getName() : prop.getDisplayName().toString();
            fldNode = new TreeNode(parentId, fldNodeId, fldNodeName);
        }
        return fldNode;
    }

    private TreeNode buildFldTreeNode(IDataEntityProperty fldProperty, TreeNode parentNode, String prefix, String parentName) {
        TreeNode fldNode = null;
        boolean isMatch = true;
        if (this.option.getFieldType() != null) {
            if (!this.option.getFieldType().isInstance(fldProperty)) {
                isMatch = false;
            }
            if (DecimalProp.class.equals(this.option.getFieldType()) && BigIntProp.class.isInstance(fldProperty)) {
                isMatch = false;
            }
        }
        DynamicProperty prop = (DynamicProperty)fldProperty;
        if (isMatch && prop != null && (this.option.isIncludeID() && "id".equalsIgnoreCase(prop.getName()) || prop.getDisplayName() != null) && StringUtils.isNotEmpty((CharSequence)fldProperty.getAlias())) {
            String fullPropName = "";
            if (this.option.isIncludeParentID()) {
                String parentId = parentNode.getId();
                if (StringUtils.isNotBlank((CharSequence)parentId)) {
                    fullPropName = parentId + "." + prop.getName();
                }
            } else {
                fullPropName = StringUtils.isBlank((CharSequence)prefix) ? prop.getName() : prefix + "." + prop.getName();
            }
            String fldNodeId = fullPropName;
            if (this.option.getExprType() == ExpressionType.DynamicText) {
                fldNodeId = "{" + fullPropName + "}";
            }
            String fldNodeName = "";
            if (!this.option.isIncludeHead() && !ResManager.loadKDString((String)"\u5355\u636e\u5934", (String)"EntityTreeUtil_3", (String)"fi-ai-common", (Object[])new Object[0]).equals(parentNode.getText())) {
                if (StringUtils.isNotBlank((CharSequence)parentName)) {
                    String name1 = parentName + "." + parentNode.getText() + "." + prop.getName();
                    String name2 = parentName + "." + parentNode.getText() + "." + prop.getDisplayName().toString();
                    fldNodeName = prop.getDisplayName() == null ? name1 : name2;
                } else {
                    String name1 = parentNode.getText() + "." + prop.getName();
                    String name2 = parentNode.getText() + "." + prop.getDisplayName().toString();
                    fldNodeName = prop.getDisplayName() == null ? name1 : name2;
                }
            } else {
                fldNodeName = prop.getDisplayName() == null ? prop.getName() : prop.getDisplayName().toString();
            }
            fldNode = new TreeNode(parentNode.getId(), fldNodeId, fldNodeName);
        }
        return fldNode;
    }
}

