/*
 * Decompiled with CFR 0.152.
 */
package kd.fi.ai.util;

import java.io.Serializable;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import kd.bos.dataentity.metadata.IDataEntityProperty;
import kd.bos.dataentity.metadata.IDataEntityType;
import kd.bos.dataentity.metadata.clr.DataEntityPropertyCollection;
import kd.bos.dataentity.metadata.dynamicobject.DynamicObjectType;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.dataentity.serialization.SerializationUtils;
import kd.bos.dataentity.utils.StringUtils;
import kd.bos.entity.MainEntityType;
import kd.bos.entity.botp.CRCondition;
import kd.bos.entity.botp.CRFormula;
import kd.bos.entity.filter.FilterCondition;
import kd.bos.entity.filter.SimpleFilterRow;
import kd.bos.entity.property.EntryProp;
import kd.bos.entity.property.SubEntryProp;
import kd.bos.form.IFormView;
import kd.bos.form.IPageCache;
import kd.bos.servicehelper.MetadataServiceHelper;
import kd.fi.ai.AbstractVchTplAsst;
import kd.fi.ai.AbstractVchTplItemMap;
import kd.fi.ai.ExpressionType;
import kd.fi.ai.VchFormulaFilterSetRow;
import kd.fi.ai.VchFormulaFilterset;
import kd.fi.ai.VchReturnData;
import kd.fi.ai.VchTplAcccounts;
import kd.fi.ai.VchTplAccount;
import kd.fi.ai.VchTplAcctFactorMap;
import kd.fi.ai.VchTplAccts;
import kd.fi.ai.VchTplAgrs;
import kd.fi.ai.VchTplAgrss;
import kd.fi.ai.VchTplAsst;
import kd.fi.ai.VchTplAsstDimFactorSource;
import kd.fi.ai.VchTplCashflow;
import kd.fi.ai.VchTplComAssist;
import kd.fi.ai.VchTplDc;
import kd.fi.ai.VchTplDcs;
import kd.fi.ai.VchTplExpression;
import kd.fi.ai.VchTplMainAsst;
import kd.fi.ai.VchTplMeasureUnit;
import kd.fi.ai.VchTplRate;
import kd.fi.ai.VchTplVoucherType;
import kd.fi.ai.VchTplVoucherTypes;
import kd.fi.ai.util.AiEventMetaUtil;

public class EntityFieldUtil {
    public static final String KEY_BUTTON_CLICK = "ai_button_key";
    public static final String KEY_VCHTEMPEDIT_ROWINDEX = "ai_row_index";
    protected static final Map<String, Map<String, List<String>>> localCahce = new HashMap<String, Map<String, List<String>>>(16);
    protected static final Map<String, String> numberlocalCahce = new HashMap<String, String>(16);
    private static final Set<String> escapeValidateGroupSet = new HashSet<String>(6){
        {
            this.add("ai_condition-condition");
            this.add("ai_expiredate-fvoucherdatedesc");
            this.add("ai_expression-fvchtypedesc");
            this.add("ai_expiredate-fbizDatedesc");
            this.add("ai_expression-freferencedesc");
            this.add("ai_expression-fmatchfieldname");
        }
    };
    public static final String formulaPattern = "(?<=\\{)(.+?)(?=\\})";

    public static String getEntryNameByPropName(IDataEntityType entityType, String propName) {
        Map<String, List<String>> entryFieldMap = EntityFieldUtil.getEntryFields(entityType);
        if (null == entryFieldMap || entryFieldMap.isEmpty()) {
            return null;
        }
        for (Map.Entry<String, List<String>> entryField : entryFieldMap.entrySet()) {
            if (!entryField.getValue().contains(propName)) continue;
            return entryField.getKey();
        }
        return null;
    }

    public static String getEntryDisplayName(IDataEntityType entityType, String name) {
        if (null == entityType) {
            return null;
        }
        if (!numberlocalCahce.containsKey(name)) {
            for (IDataEntityProperty property : entityType.getProperties()) {
                if (!(property instanceof EntryProp)) continue;
                EntryProp entryProp = (EntryProp)property;
                name = entryProp.getName();
                String displayName = entryProp.getDisplayName().getLocaleValue();
                numberlocalCahce.put(name, displayName);
            }
        }
        return numberlocalCahce.get(name);
    }

    public static Set<String> resolveProperties(ExpressionType type, String content) {
        if (type == null) {
            return null;
        }
        if (StringUtils.isEmpty((CharSequence)content)) {
            return null;
        }
        if (ExpressionType.Formula.getValue() == type.getValue()) {
            return EntityFieldUtil.formulaResolveProperties(content);
        }
        if (ExpressionType.AiFormula.getValue() == type.getValue()) {
            return EntityFieldUtil.aiFormulaResolveProperties(content);
        }
        return null;
    }

    private static Set<String> aiFormulaResolveProperties(String content) {
        HashSet<String> ret = new HashSet<String>();
        String[] props = StringUtils.split((String)content, (String)" ");
        for (int i = 0; i < props.length; ++i) {
            if (!StringUtils.isNotEmpty((CharSequence)props[i])) continue;
            ret.add(props[i]);
        }
        return ret;
    }

    private static Set<String> formulaResolveProperties(String content) {
        HashSet<String> ret = new HashSet<String>();
        Pattern compile = Pattern.compile(formulaPattern);
        Matcher matcher = compile.matcher(content);
        while (matcher.find()) {
            ret.add(matcher.group());
        }
        return ret;
    }

    private static Map<String, List<String>> getEntryFields(IDataEntityType entityType) {
        HashMap<String, List<String>> ret;
        if (null == entityType) {
            return null;
        }
        String cacheKey = entityType.getName();
        if (localCahce.containsKey(cacheKey)) {
            ret = localCahce.get(cacheKey);
        } else {
            ret = new HashMap();
            for (IDataEntityProperty property : entityType.getProperties()) {
                if (!(property instanceof EntryProp)) continue;
                EntryProp entryProp = (EntryProp)property;
                String entryName = entryProp.getName();
                DynamicObjectType entryType = entryProp.getDynamicCollectionItemPropertyType();
                DataEntityPropertyCollection properites = entryType.getProperties();
                if (properites == null || properites.isEmpty()) continue;
                for (IDataEntityProperty subProperty : properites) {
                    if (subProperty instanceof SubEntryProp) {
                        SubEntryProp subEntryProp = (SubEntryProp)subProperty;
                        DynamicObjectType subEntryType = subEntryProp.getDynamicCollectionItemPropertyType();
                        DataEntityPropertyCollection subProperites = subEntryType.getProperties();
                        if (subProperites == null || subProperites.isEmpty()) continue;
                        for (IDataEntityProperty subProperty2 : subProperites) {
                            if ("id".equalsIgnoreCase(subProperty2.getName()) || "seq".equalsIgnoreCase(subProperty2.getName())) continue;
                            ret.computeIfAbsent(entryName, p -> new ArrayList()).add(subProperty2.getName());
                        }
                        continue;
                    }
                    if ("id".equalsIgnoreCase(subProperty.getName()) || "seq".equalsIgnoreCase(subProperty.getName())) continue;
                    ret.computeIfAbsent(entryName, p -> new ArrayList()).add(subProperty.getName());
                }
            }
            localCahce.put(cacheKey, ret);
        }
        return ret;
    }

    /*
     * Enabled aggressive block sorting
     */
    public static VchReturnData validateDiffEntry(Object exprObj, String currentFormId, String entitynumber, String cacheValue) {
        ExpressionType type;
        String expression;
        MainEntityType entityType;
        VchReturnData returnData;
        block37: {
            Serializable vchTplAsst;
            String exprObjStr;
            block45: {
                StringBuilder sbExpression;
                String sourceType;
                block46: {
                    block44: {
                        String exprObjStr2;
                        String typeName;
                        block43: {
                            block42: {
                                Serializable vchAcctObj;
                                block41: {
                                    block40: {
                                        block39: {
                                            block38: {
                                                CRFormula crExprObj;
                                                block36: {
                                                    returnData = new VchReturnData();
                                                    if (exprObj == null) {
                                                        returnData.setStatus(true);
                                                        return returnData;
                                                    }
                                                    entityType = EntityFieldUtil.getEntityType(entitynumber);
                                                    expression = "";
                                                    type = null;
                                                    if (!(exprObj instanceof VchTplExpression)) break block36;
                                                    VchTplExpression vchExprObj = (VchTplExpression)exprObj;
                                                    exprObjStr = SerializationUtils.toJsonString((Object)vchExprObj);
                                                    returnData.setDataStr(exprObjStr);
                                                    expression = vchExprObj.getExpression();
                                                    type = ExpressionType.Formula;
                                                    break block37;
                                                }
                                                if (!(exprObj instanceof CRFormula)) break block38;
                                                typeName = exprObj.getClass().getName();
                                                if ("kd.bos.entity.botp.CRFormula".equals(typeName)) {
                                                    crExprObj = (CRFormula)exprObj;
                                                    exprObjStr2 = SerializationUtils.toJsonString((Object)crExprObj);
                                                    returnData.setDataStr(exprObjStr2);
                                                    expression = crExprObj.getExpression();
                                                    type = ExpressionType.AiFormula;
                                                    break block37;
                                                } else if ("kd.bos.entity.botp.CRCondition".equals(typeName)) {
                                                    crExprObj = (CRCondition)exprObj;
                                                    exprObjStr2 = SerializationUtils.toJsonString((Object)crExprObj);
                                                    returnData.setDataStr(exprObjStr2);
                                                    expression = EntityFieldUtil.getCRConditionExpression((CRCondition)crExprObj);
                                                    type = ExpressionType.Formula;
                                                }
                                                break block37;
                                            }
                                            if (!(exprObj instanceof VchTplAccts)) break block39;
                                            vchAcctObj = (VchTplAccts)exprObj;
                                            exprObjStr = SerializationUtils.toJsonString((Object)vchAcctObj);
                                            returnData.setDataStr(exprObjStr);
                                            sourceType = ((VchTplAccts)vchAcctObj).getSourcetype();
                                            if ("mapping".equals(sourceType)) {
                                                List<VchTplAcctFactorMap> factors = ((VchTplAccts)vchAcctObj).getFactorMaps();
                                                sbExpression = new StringBuilder();
                                                if (factors != null && !factors.isEmpty()) {
                                                    for (VchTplAcctFactorMap fact : factors) {
                                                        String[] fieldKey = StringUtils.split((String)fact.getSourceFieldKey(), (String)".");
                                                        for (int i = 0; i < fieldKey.length; ++i) {
                                                            sbExpression.append('{');
                                                            sbExpression.append(fieldKey[i]);
                                                            sbExpression.append('}');
                                                        }
                                                    }
                                                    expression = sbExpression.toString();
                                                }
                                                type = ExpressionType.Formula;
                                                break block37;
                                            } else if ("exp".equals(sourceType)) {
                                                expression = ((VchTplAccts)vchAcctObj).getExp();
                                                type = ExpressionType.AiFormula;
                                            }
                                            break block37;
                                        }
                                        if (!(exprObj instanceof VchTplMeasureUnit)) break block40;
                                        VchTplMeasureUnit vchMeasureUnitObj = (VchTplMeasureUnit)exprObj;
                                        exprObjStr = SerializationUtils.toJsonString((Object)vchMeasureUnitObj);
                                        returnData.setDataStr(exprObjStr);
                                        sourceType = vchMeasureUnitObj.getSourcetype();
                                        if ("bill".equals(sourceType)) {
                                            expression = vchMeasureUnitObj.getSourcefield();
                                            type = ExpressionType.AiFormula;
                                        }
                                        break block37;
                                    }
                                    if (!(exprObj instanceof VchTplDcs)) break block41;
                                    VchTplDcs vchDcObj = (VchTplDcs)exprObj;
                                    exprObjStr = SerializationUtils.toJsonString((Object)vchDcObj);
                                    returnData.setDataStr(exprObjStr);
                                    expression = EntityFieldUtil.getVchTplDcExpression(vchDcObj);
                                    type = ExpressionType.Formula;
                                    break block37;
                                }
                                if (!(exprObj instanceof VchTplAcccounts)) break block42;
                                vchAcctObj = (VchTplAcccounts)exprObj;
                                exprObjStr = SerializationUtils.toJsonString((Object)vchAcctObj);
                                returnData.setDataStr(exprObjStr);
                                expression = EntityFieldUtil.getVchAcctExpression((VchTplAcccounts)vchAcctObj);
                                type = ExpressionType.Formula;
                                break block37;
                            }
                            if (!(exprObj instanceof VchTplAgrss)) break block43;
                            VchTplAgrss vchAsstObj = (VchTplAgrss)exprObj;
                            exprObjStr = SerializationUtils.toJsonString((Object)vchAsstObj);
                            returnData.setDataStr(exprObjStr);
                            expression = EntityFieldUtil.getVchAsstExpression(vchAsstObj);
                            type = ExpressionType.Formula;
                            break block37;
                        }
                        if (!(exprObj instanceof AbstractVchTplAsst)) break block44;
                        typeName = exprObj.getClass().getName();
                        if ("kd.fi.ai.VchTplAsst".equals(typeName)) {
                            VchTplAsst vchTplAsst2 = (VchTplAsst)exprObj;
                            exprObjStr2 = SerializationUtils.toJsonString((Object)vchTplAsst2);
                            returnData.setDataStr(exprObjStr2);
                            expression = EntityFieldUtil.getVchTplAsstExpression(vchTplAsst2);
                        } else if ("kd.fi.ai.VchTplMainAsst".equals(typeName)) {
                            VchTplMainAsst vchTplMainAsst = (VchTplMainAsst)exprObj;
                            exprObjStr2 = SerializationUtils.toJsonString((Object)vchTplMainAsst);
                            returnData.setDataStr(exprObjStr2);
                            expression = EntityFieldUtil.getVchTplAsstDimFactorExpression(vchTplMainAsst);
                        }
                        type = ExpressionType.Formula;
                        break block37;
                    }
                    if (!(exprObj instanceof VchTplCashflow)) break block45;
                    vchTplAsst = (VchTplCashflow)exprObj;
                    exprObjStr = SerializationUtils.toJsonString((Object)vchTplAsst);
                    returnData.setDataStr(exprObjStr);
                    sourceType = ((VchTplCashflow)vchTplAsst).getSourcetype();
                    if (!"exp".equals(sourceType)) break block46;
                    expression = ((VchTplCashflow)vchTplAsst).getExp();
                    type = ExpressionType.AiFormula;
                    break block37;
                }
                if ("mapping".equals(sourceType)) {
                    String fieldKey = ((VchTplCashflow)vchTplAsst).getSourcefield();
                    if (StringUtils.isNotEmpty((CharSequence)fieldKey)) {
                        sbExpression = new StringBuilder();
                        String[] fields = StringUtils.split((String)fieldKey, (String)".");
                        for (int i = 0; i < fields.length; ++i) {
                            sbExpression.append('{');
                            sbExpression.append(fields[0]);
                            sbExpression.append('}');
                        }
                        expression = sbExpression.toString();
                        type = ExpressionType.Formula;
                    }
                    break block37;
                } else if (!"commonmapping".equals(sourceType)) {
                    // empty if block
                }
                break block37;
            }
            if (exprObj instanceof String) {
                String inputStr = (String)exprObj;
                returnData.setDataStr(inputStr);
                String[] fieldArr = StringUtils.split((String)inputStr, (String)".");
                StringBuilder sbExpression = new StringBuilder();
                for (int i = 0; i < fieldArr.length; ++i) {
                    sbExpression.append('{');
                    sbExpression.append(fieldArr[i]);
                    sbExpression.append('}');
                }
                expression = sbExpression.toString();
                type = ExpressionType.Formula;
            } else if (exprObj instanceof VchTplVoucherTypes) {
                vchTplAsst = (VchTplVoucherTypes)exprObj;
                exprObjStr = SerializationUtils.toJsonString((Object)vchTplAsst);
                returnData.setDataStr(exprObjStr);
                expression = EntityFieldUtil.getVchGroupSetExpression((VchTplVoucherTypes)vchTplAsst);
                type = ExpressionType.Formula;
            } else if (exprObj instanceof VchTplRate) {
                VchTplRate vchTplRate = (VchTplRate)exprObj;
                exprObjStr = SerializationUtils.toJsonString((Object)vchTplRate);
                returnData.setDataStr(exprObjStr);
                if (StringUtils.isNotEmpty((CharSequence)vchTplRate.getExp())) {
                    expression = vchTplRate.getExp();
                }
                type = ExpressionType.Formula;
            } else if (exprObj instanceof VchFormulaFilterset) {
                VchFormulaFilterset vchFormulaFilterset = (VchFormulaFilterset)exprObj;
                exprObjStr = SerializationUtils.toJsonString((Object)vchFormulaFilterset);
                returnData.setDataStr(exprObjStr);
                expression = EntityFieldUtil.getVchFormulaFilterset(vchFormulaFilterset, entityType);
                type = ExpressionType.Formula;
            } else if (exprObj instanceof VchTplComAssist) {
                VchTplComAssist vchTplComAssist = (VchTplComAssist)exprObj;
                exprObjStr = SerializationUtils.toJsonString((Object)vchTplComAssist);
                returnData.setDataStr(exprObjStr);
                type = ExpressionType.Formula;
            }
        }
        returnData.setFormId(currentFormId);
        Set<String> properties = EntityFieldUtil.resolveProperties(type, expression);
        if (properties == null || properties.isEmpty()) {
            returnData.setStatus(true);
            return returnData;
        }
        HashMap entryMap = new HashMap();
        properties.forEach(prop -> {
            String entryName = EntityFieldUtil.getEntryNameByPropName((IDataEntityType)entityType, prop);
            if (StringUtils.isNotEmpty((CharSequence)entryName)) {
                entryMap.computeIfAbsent(entryName, p -> new ArrayList()).add(prop);
            }
        });
        if (!escapeValidateGroupSet.contains(currentFormId)) {
            if (entryMap.size() > 1) {
                returnData.setMessage(ResManager.loadKDString((String)"\u6458\u8981\u53d6\u503c\u8868\u8fbe\u5f0f\u4e2d\u5df2\u914d\u7f6e\u7684\u5b57\u6bb5\u5b58\u5728\u8de8\u5206\u5f55\u7684\u60c5\u51b5\uff0c\u8bf7\u68c0\u67e5", (String)"EntityFieldUtil_0", (String)"fi-ai-common", (Object[])new Object[0]));
                returnData.setStatus(true);
                return returnData;
            }
            if (entryMap.size() == 1) {
                String currentEntryName = (String)entryMap.keySet().iterator().next();
                if (StringUtils.isNotEmpty((CharSequence)cacheValue)) {
                    Set<String> values = EntityFieldUtil.formulaResolveProperties(cacheValue);
                    for (String curValue : values) {
                        String[] cacheValueArr = StringUtils.split((String)curValue, (String)":");
                        String formId = cacheValueArr[0];
                        String entryName = cacheValueArr[1];
                        if (formId.equals(currentFormId) || StringUtils.equals((CharSequence)currentEntryName, (CharSequence)entryName)) continue;
                        String displayName = EntityFieldUtil.getEntryDisplayName((IDataEntityType)entityType, entryName);
                        String currentDisplayName = EntityFieldUtil.getEntryDisplayName((IDataEntityType)entityType, currentEntryName);
                        returnData.setStatus(true);
                        returnData.setMessage(String.format(ResManager.loadKDString((String)"\u8868\u8fbe\u5f0f\u4e2d\u914d\u7f6e\u7684\u5206\u5f55\uff1a\u201c%1$s\u201d\u548c\u5df2\u914d\u7f6e\u7684\u5206\u5f55\uff1a\u201c%2$s\u201d\u4e0d\u4e00\u81f4\uff0c\u8bf7\u68c0\u67e5\u3002", (String)"EntityFieldUtil_1", (String)"fi-ai-common", (Object[])new Object[0]), currentDisplayName, displayName));
                        return returnData;
                    }
                }
                returnData.setEntryName(currentEntryName);
            }
        }
        returnData.setStatus(true);
        return returnData;
    }

    private static String getVchFormulaFilterset(VchFormulaFilterset vchFormulaFilterset, MainEntityType entityType) {
        if (vchFormulaFilterset == null) {
            return null;
        }
        List<VchFormulaFilterSetRow> items = vchFormulaFilterset.getItems();
        StringBuilder sbExpression = new StringBuilder();
        for (VchFormulaFilterSetRow vchFormulaFilterSetRow : items) {
            VchTplExpression vcHExpression = vchFormulaFilterSetRow.getFieldExp();
            String formula = vcHExpression.buildFullFormula(entityType);
            if (StringUtils.isNotEmpty((CharSequence)formula)) {
                sbExpression.append('{');
                sbExpression.append(formula);
                sbExpression.append('}');
            }
            if (!StringUtils.isNotEmpty((CharSequence)(formula = (vcHExpression = vchFormulaFilterSetRow.getFilterSet()).buildFullFormula(entityType)))) continue;
            sbExpression.append('{');
            sbExpression.append(formula);
            sbExpression.append('}');
        }
        return sbExpression.toString();
    }

    private static String getCRConditionExpression(CRCondition crExprObj) {
        if (crExprObj == null) {
            return null;
        }
        StringBuilder sbExpression = new StringBuilder();
        FilterCondition filterCondition = crExprObj.getFilterCondition();
        if (filterCondition != null) {
            List rows = filterCondition.getFilterRow();
            for (SimpleFilterRow row : rows) {
                if (!StringUtils.isNotEmpty((CharSequence)row.getFieldName())) continue;
                String[] fieldArr = StringUtils.split((String)row.getFieldName(), (String)".");
                sbExpression.append('{');
                sbExpression.append(fieldArr[0]);
                sbExpression.append('}');
            }
        }
        if (StringUtils.isNotEmpty((CharSequence)crExprObj.getExpression())) {
            String[] props = StringUtils.split((String)crExprObj.getExpression(), (String)" ");
            for (int i = 0; i < props.length; ++i) {
                if (!StringUtils.isNotEmpty((CharSequence)props[i])) continue;
                sbExpression.append('{');
                sbExpression.append(props[i]);
                sbExpression.append('}');
            }
        }
        return sbExpression.toString();
    }

    private static String getVchTplAsstDimFactorExpression(VchTplMainAsst vchTplMainAsst) {
        List<AbstractVchTplItemMap> items;
        String[] fieldArr;
        if (vchTplMainAsst == null) {
            return null;
        }
        StringBuilder sbExpression = new StringBuilder();
        List<VchTplAsstDimFactorSource> facts = vchTplMainAsst.getAsstFactors();
        if (facts != null && !facts.isEmpty()) {
            for (VchTplAsstDimFactorSource fact : facts) {
                if (StringUtils.isEmpty((CharSequence)fact.getSourceFieldKey())) continue;
                fieldArr = StringUtils.split((String)fact.getSourceFieldKey(), (String)".");
                for (int i = 0; i < fieldArr.length; ++i) {
                    sbExpression.append('{');
                    sbExpression.append(fieldArr[i]);
                    sbExpression.append('}');
                }
            }
        }
        if ((items = vchTplMainAsst.getItemClassMaps()) != null && !items.isEmpty()) {
            for (AbstractVchTplItemMap item : items) {
                if (StringUtils.isNotEmpty((CharSequence)item.getSourceFieldKey())) {
                    fieldArr = StringUtils.split((String)item.getSourceFieldKey(), (String)".");
                    for (int i = 0; i < fieldArr.length; ++i) {
                        sbExpression.append('{');
                        sbExpression.append(fieldArr[i]);
                        sbExpression.append('}');
                    }
                }
                if (!StringUtils.isNotEmpty((CharSequence)item.getExp())) continue;
                sbExpression.append('{');
                sbExpression.append(item.getExp());
                sbExpression.append('}');
            }
        }
        return sbExpression.toString();
    }

    private static String getVchTplAsstExpression(VchTplAsst vchTplAsst) {
        List<VchTplAsstDimFactorSource> factors;
        String[] fieldArr;
        String fieldKey;
        if (vchTplAsst == null) {
            return null;
        }
        StringBuilder sbExpression = new StringBuilder();
        List<AbstractVchTplItemMap> tplItems = vchTplAsst.getItemClassMaps();
        if (tplItems != null && !tplItems.isEmpty()) {
            for (AbstractVchTplItemMap tplItem : tplItems) {
                fieldKey = tplItem.getSourceFieldKey();
                if (!StringUtils.isNotEmpty((CharSequence)fieldKey)) continue;
                fieldArr = StringUtils.split((String)fieldKey, (String)".");
                for (int i = 0; i < fieldArr.length; ++i) {
                    sbExpression.append('{');
                    sbExpression.append(fieldArr[i]);
                    sbExpression.append('}');
                }
            }
        }
        if ((factors = vchTplAsst.getAsstFactors()) != null && !factors.isEmpty()) {
            for (VchTplAsstDimFactorSource fact : factors) {
                fieldKey = fact.getSourceFieldKey();
                if (!StringUtils.isNotEmpty((CharSequence)fieldKey)) continue;
                fieldArr = StringUtils.split((String)fieldKey, (String)".");
                for (int i = 0; i < fieldArr.length; ++i) {
                    sbExpression.append('{');
                    sbExpression.append(fieldArr[i]);
                    sbExpression.append('}');
                }
            }
        }
        return sbExpression.toString();
    }

    private static String getVchTplDcExpression(VchTplDcs vchDcObj) {
        if (vchDcObj == null) {
            return null;
        }
        List<VchTplDc> vchTplDcs = vchDcObj.getItems();
        StringBuilder sbExpression = new StringBuilder();
        for (VchTplDc dyVchTplDc : vchTplDcs) {
            VchTplExpression vcHExpression = dyVchTplDc.getFilterSet();
            FilterCondition filterCondition = vcHExpression.getFilterCondition();
            if (filterCondition == null) continue;
            List rows = filterCondition.getFilterRow();
            for (SimpleFilterRow row : rows) {
                if (!StringUtils.isNotEmpty((CharSequence)row.getFieldName())) continue;
                String[] fieldArr = StringUtils.split((String)row.getFieldName(), (String)".");
                for (int i = 0; i < fieldArr.length; ++i) {
                    sbExpression.append('{');
                    sbExpression.append(fieldArr[i]);
                    sbExpression.append('}');
                }
            }
        }
        return sbExpression.toString();
    }

    private static String getVchAcctExpression(VchTplAcccounts vchAcctObj) {
        if (vchAcctObj == null) {
            return null;
        }
        List<VchTplAccount> vchAcctDcs = vchAcctObj.getItems();
        StringBuilder sbExpression = new StringBuilder();
        for (VchTplAccount dyVchTplAcct : vchAcctDcs) {
            VchTplExpression vcHExpression = dyVchTplAcct.getFilterSet();
            FilterCondition filterCondition = vcHExpression.getFilterCondition();
            if (filterCondition == null) continue;
            List rows = filterCondition.getFilterRow();
            for (SimpleFilterRow row : rows) {
                if (!StringUtils.isNotEmpty((CharSequence)row.getFieldName())) continue;
                String[] fieldArr = StringUtils.split((String)row.getFieldName(), (String)".");
                for (int i = 0; i < fieldArr.length; ++i) {
                    sbExpression.append('{');
                    sbExpression.append(fieldArr[i]);
                    sbExpression.append('}');
                }
            }
        }
        return sbExpression.toString();
    }

    private static String getVchAsstExpression(VchTplAgrss vchAsstObj) {
        if (vchAsstObj == null) {
            return null;
        }
        List<VchTplAgrs> vchAssts = vchAsstObj.getItems();
        StringBuilder sbExpression = new StringBuilder();
        for (VchTplAgrs vchTplAgrs : vchAssts) {
            VchTplExpression vcHExpression = vchTplAgrs.getFilterSet();
            FilterCondition filterCondition = vcHExpression.getFilterCondition();
            if (filterCondition == null) continue;
            List rows = filterCondition.getFilterRow();
            for (SimpleFilterRow row : rows) {
                if (!StringUtils.isNotEmpty((CharSequence)row.getFieldName())) continue;
                String[] fieldArr = StringUtils.split((String)row.getFieldName(), (String)".");
                for (int i = 0; i < fieldArr.length; ++i) {
                    sbExpression.append('{');
                    sbExpression.append(fieldArr[i]);
                    sbExpression.append('}');
                }
            }
        }
        return sbExpression.toString();
    }

    private static String getVchGroupSetExpression(VchTplVoucherTypes vchDcObj) {
        if (vchDcObj == null) {
            return null;
        }
        List<VchTplVoucherType> vchTplDcs = vchDcObj.getItems();
        StringBuilder sbExpression = new StringBuilder();
        for (VchTplVoucherType dyVchTplDc : vchTplDcs) {
            VchTplExpression vcHExpression = dyVchTplDc.getFilterSet();
            FilterCondition filterCondition = vcHExpression.getFilterCondition();
            if (filterCondition == null) continue;
            List rows = filterCondition.getFilterRow();
            for (SimpleFilterRow row : rows) {
                if (!StringUtils.isNotEmpty((CharSequence)row.getFieldName())) continue;
                String[] fieldArr = StringUtils.split((String)row.getFieldName(), (String)".");
                for (int i = 0; i < fieldArr.length; ++i) {
                    sbExpression.append('{');
                    sbExpression.append(fieldArr[i]);
                    sbExpression.append('}');
                }
            }
        }
        return sbExpression.toString();
    }

    public static void putPageCache(IPageCache pageCache, String cacheKey, VchReturnData retData) {
        String oldCacheValue = pageCache.get(cacheKey);
        StringBuilder sbNewCacheValue = new StringBuilder();
        HashSet<String> values = new HashSet<String>();
        if (StringUtils.isNotEmpty((CharSequence)oldCacheValue)) {
            values.addAll(EntityFieldUtil.formulaResolveProperties(oldCacheValue));
        }
        values.removeIf(p -> p.contains(retData.getFormId()));
        values.forEach(p -> {
            sbNewCacheValue.append('{');
            sbNewCacheValue.append((String)p);
            sbNewCacheValue.append('}');
        });
        if (StringUtils.isNotEmpty((CharSequence)retData.getEntryName())) {
            sbNewCacheValue.append('{');
            sbNewCacheValue.append(retData.getFormId());
            sbNewCacheValue.append(':');
            sbNewCacheValue.append(retData.getEntryName());
            sbNewCacheValue.append('}');
        }
        pageCache.put(cacheKey, sbNewCacheValue.toString());
    }

    public static void clearPageCache(IPageCache pageCache, String cacheKey, VchReturnData retData) {
        String oldCacheValue = pageCache.get(cacheKey);
        HashSet<String> values = new HashSet<String>();
        if (StringUtils.isNotEmpty((CharSequence)oldCacheValue)) {
            values.addAll(EntityFieldUtil.formulaResolveProperties(oldCacheValue));
        }
        String newCacheKey = retData.getFormId();
        values.removeIf(p -> p.contains(newCacheKey));
        if (values.isEmpty()) {
            pageCache.remove(cacheKey);
        } else {
            StringBuilder sbNewValue = new StringBuilder();
            values.forEach(p -> {
                sbNewValue.append('{');
                sbNewValue.append((String)p);
                sbNewValue.append('}');
            });
            pageCache.put(cacheKey, sbNewValue.toString());
        }
    }

    public static String getCacheValueFromFormParameter(IFormView view) {
        Object objEntryName = view.getFormShowParameter().getCustomParam("ai_vchtemplatecachekey");
        return objEntryName == null ? null : objEntryName.toString();
    }

    private static MainEntityType getEntityType(String entitynumber) {
        try {
            return AiEventMetaUtil.getEntityType(Long.valueOf(entitynumber));
        }
        catch (Exception exc) {
            return MetadataServiceHelper.getDataEntityType((String)entitynumber);
        }
    }
}

